package com.ebike.openservices.oprmgmt.service;

import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyEntity;
import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyVo;
import com.ebike.openservices.oprmgmt.entity.CardServiceRateDto;
import com.ebike.openservices.oprmgmt.entity.CardServiceRateVo;

import java.util.List;

/**
 * @author liumu
 * @date 2021-07-15 09:37
 * 个性卡（定制卡）账务相关
 */
public interface CardService {

    /**
     * 获取充电卡提现申请列表
     *
     * @param orgNo
     * @param cardId
     * @param phone
     * @param startDate
     * @param endDate
     * @param page
     * @param size
     * @return
     */
    List<CardAcctWithdrawApplyVo> queryWithApply(String orgNo,
                                                 String cardId,
                                                 String phone,
                                                 String startDate,
                                                 String endDate,
                                                 Integer page,
                                                 Integer size);

    /**
     * 获取充电卡提现申请列表计数
     *
     * @param orgNo
     * @param cardId
     * @param phone
     * @param startDate
     * @param endDate
     * @return
     */
    Integer queryWithApplyCount(String orgNo,
                                String cardId,
                                String phone,
                                String startDate,
                                String endDate);

    /**
     * 通过id获取提现申请
     * @param id
     * @return
     */
    CardAcctWithdrawApplyEntity queryWithdrawApplyById(Long id);

    /**
     * 更新充电卡提现审核状态
     */
    void updateWithdrawStatus(CardAcctWithdrawApplyEntity bean);

    /**
     * 充电卡服务费设置列表
     * @param subburo
     * @return
     */
    List<CardServiceRateVo> queryCardServiceRate(String subburo,Integer page,Integer size);

    /**
     * 充电卡服务费设置列表计数
     * @return
     */
    Integer queryCardServiceRateCount();

    /**
     * 更新充电卡服务费率
     * @param param
     */
    void updateCardServiceRate(CardServiceRateDto param);


}
