package com.ebike.openservices.oprmgmt.service;

import com.ebike.openservices.oprmgmt.entity.vo.ChargingTrendAnalysisCarVo;
import com.ebike.openservices.oprmgmt.request.ChargingTrendAnalysisCarRequest;

import java.util.List;
import java.util.Map;

/**
 * 充电趋势分析（电动汽车）
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-08-03
 */
public interface ChargingTrendAnalysisCarService {

    /**
     * 获取充电汽车电站名称下拉列表
     */
    List<ChargingTrendAnalysisCarVo> getChargingStationNameList(ChargingTrendAnalysisCarRequest request);

    /**
     * 充电趋势曲线
     */
    Map<String, Object> getChargingTrendAnalysisCarCure(ChargingTrendAnalysisCarRequest request);

    /**
     * 获取有电站的汽车省份
     */
    List<Map<String, Object>> getChargePrinceCarList(String orgNo);
}
