package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.entity.DisasterPreventionVo;
import com.ebike.openservices.oprmgmt.entity.EbikeLogChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.request.DisasterSetUpRequest;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Map;

/**
 * @author liu
 * 防灾应急
 */
public interface DisasterPreventionService {

    List<DisasterPreventionVo> getDisasterPreventionList(Map params, Sorter sorter, Pager pager);

    int getDisasterPreventionCount(Map params);

    List<EbikeLogChargeDeviceExtparamDo> getLogList(Map params, Sorter sorter, Pager pager);

    int getLogCount(Map params);

    List<Map<String,Object>> getProvinceList();

    List<Map<String,Object>> getCityList(String level, String parentid);

    List<Map<String,Object>> getDistrictList(String level, String parentid);

    Map<String, Object> getUserMobileByUserNo(String userNo);

    int setUpDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequest);

    int removeDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequest);

    int insertSms(Map<String,String> map);

    int getCheckCode(String codeValue, String userMobile);

    int updateCodeStatus(String codeValue);

    int getChangeOrderCount(String stationId);

}
