package com.ebike.openservices.oprmgmt.service;

import com.ebike.openservices.oprmgmt.request.PowerChargeListParam;
import com.ebike.openservices.oprmgmt.request.PowerChargeStatRequest;
import com.ebike.openservices.oprmgmt.response.PowerChargeResponse;
import com.ebike.openservices.oprmgmt.response.PowerChargeStatResponse;

import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/3
 */
public interface PowerChargeService {

    /**
     * 按集团客户统计电量电费列表
     *
     * @param param
     * @param isPage
     * @return
     */
    List<PowerChargeResponse> listStation(PowerChargeListParam param, Boolean isPage);

    /**
     * 按集团客户统计电量电费总数
     *
     * @param param
     * @return
     */
    long listStationTotal(PowerChargeListParam param);

    /**
     * 电量电费总数据统计
     *
     * @param param
     * @return
     */
    PowerChargeStatResponse getPowerChargeStat(PowerChargeStatRequest param);

    /**
     * 查找电站下的所有订单充电电量明细
     *
     * @param stationId
     * @return
     */
    List<String> listChargeEconsDetailByStationId(Long stationId);
}
