package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.dto.PageResponse;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.request.*;

import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/14
 */
public interface PowerStationSafeguardService {

    /**
     * 电站维护列表
     *
     * @param param
     * @param pager
     * @return
     */
    PageResponse<ListPowerStationSafeguardVO> listPowerStationSafeguard(ListPowerStationSafeguardParam param, Pager pager);

    /**
     * 添加电站
     *
     * @param param
     * @return
     */
    int insertPowerStation(InsertPowerStationParam param);

    /**
     * 编辑设备（电动汽车充电桩）
     * @param param
     * @return
     */
    int updateChargingPile(UpdateChargingPileParam param);

    /**
     * 编辑电动汽车充电枪
     *
     * @param param
     * @return
     */
    int updateChargingGun(UpdateChargingGunParam param);

    /**
     * 电动汽车充电站详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardVO getDetailPowerStationSafeguardById(Long id);

    /**
     * 电动汽车充电桩详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardChargingPileVO getPowerStationSafeguardChargingPileById(Long id);

    /**
     * 电动汽车充电枪详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardChargingGunVO getPowerStationSafeguardChargingGunById(Long id);

    /**
     * 删除电动汽车充电站
     *
     * @param id
     * @return
     */
    void deletePowerStationById(Long id);

    /**
     * 生成充电站编号
     *
     * @return
     */
    String getPowerStationNo();

    /**
     * 编辑电站
     *
     * @param param
     * @return
     */
    int updatePowerStation(UpdatePowerStationParam param);

    /**
     * 电站树
     *
     * @param orgNo
     * @return
     */
    Object treePowerStation(String orgNo);

}
