package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.request.PowerStationRequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author zhouyi
 * @className PowerStationService
 * @data 2021/4/15 19:00
 **/
public interface PowerStationService {

    /**
     * 功能描述  电站信息列表查询
     * @author zhouyi
     * @return java.util.Map<java.lang.String,java.lang.Object>
     * @data 2021/4/15
     * @param param
     */
    Map<String,Object> getPowerStation(PowerStationRequestParam param);

    /**
     * 功能描述 充电站统一视图——变电站基本信息
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationEssentialInformationVo
     * @data 2021/4/16
     * @param id
     */
    Map<String,Object> getPowerStationEssentialInformation(Long id,Integer current);

    /**
     * 功能描述 充电站统一视图——收益分配
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationIncomeDistributionVo
     * @data 2021/4/16
     * @param id
     */
    Map<String,Object> getPowerStationIncomeDistribution(Long id,Integer current);

    /**
     * 功能描述 充电站统一视图——电桩信息
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingPileInformationVo>
     * @data 2021/4/22
     * @param id
     */
    List<ChargingPileInformationVo> getChargingPileInformation(Long id);

    /**
     * 功能描述 充电站统一视图——电枪列表
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingGunInformationVo>
     * @data 2021/4/22
     * @param id
     */
    List<ChargingGunInformationVo> getChargingGunInformation(Long id);
}
