package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.entity.po.CardCustomPurchaseApplyRelacs;
import com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo;
import com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo;
import com.ebike.openservices.oprmgmt.entity.vo.StationVo;
import com.ebike.openservices.oprmgmt.request.RechargeCardRequest;

import java.util.List;
import java.util.Map;

/**
 * @author zhouyi
 * @className RechargeCardsService
 * @data 2021/7/15 16:05
 * @Description TODO
 **/
public interface RechargeCardsService {
    /***
     * @Description TODO 充电卡模糊查询
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo>
     * @data 2021/7/15
     * @param request
     */
    Map<String,Object> listRechargeCardVo(RechargeCardRequest request);

   /***
    * @Description TODO 充电卡订单模糊查询
    * @author zhouyi
    * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo>
    * @data 2021/7/15
    * @param batch
    * @param phoneNo
    */
   Map<String,Object> listRechargeCardOrder(String batch,String phoneNo,String orgNo,Integer current);

    /***
     * @Description TODO  查询 已关联  未关联  电站
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.StationVo>
     * @data 2021/7/15
     * @param id
     * @param orgNo
     */
    Map<String,Object> listStation(Long id,String orgNo,String stationName,String stationAddr,String type);


    /***
     * @Description TODO 解除关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param id
     * @param stationIdStr
     */
    Integer removeAssociated(Long id,String stationIdStr);

    /***
     * @Description TODO  创建关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param stationIdStr
     */
    Integer createAssociated(Long purchaseApplyId,String stationIdStr,String orgNo);

    /***
     * @Description TODO 退款记录
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo>
     * @data 2021/7/19
     * @param id
     * @param current
     */
    Map<String,Object> getRefundRecord(String id,Integer current,String startDate,String endDate);
}
