package com.ebike.openservices.oprmgmt.service;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.entity.TmplBillingDo;
import com.ebike.openservices.oprmgmt.request.TmplBillingRequest;

import java.util.List;

/**
 * 充电汽车项目-->计费模板维护
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-04-13
 */
public interface TmplBillingService {
    /**
     * 查询--计费模板维护列表
     */
    List<TmplBillingDo> getTmplBillingDoList(TmplBillingRequest params, Sorter sorter, Pager pager);

    Integer getTmplBillingDoCount(TmplBillingRequest params);

    /**
     * 新增计费模板
     */
    void insertTmplBilling(TmplBillingRequest params);

    /**
     * 修改计费模板
     */
    void updateTmplBilling(TmplBillingRequest params);

    /**
     * 删除计费模板
     */
    void deleteTmplBilling(TmplBillingRequest params);

    /**
     *
     * @return
     */
    TmplBillingDo getMaxTmplNo();

    /**
     * 获取模板详情
     *
     * @param tmplId
     * @return
     */
    String queryTmplInfoById(String tmplId);
}
