/*
 * Decompiled with CFR 0.152.
 */
package com.ebike.openservices.oprmgmt.dto;

import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = 9051966969490803705L;
    private int code;
    private String msg;
    private T data;

    public static Response buildSuccess() {
        return Response.buildSuccess(null);
    }

    public static <T> Response<T> buildSuccess(T data) {
        return new Response<T>().setCode(200).setMsg("\u8bf7\u6c42\u6210\u529f").setData(data);
    }

    public static Response buildSuccess(int code, String msg) {
        return new Response().setCode(code).setMsg(msg);
    }

    public static Response buildFailure() {
        return new Response().setCode(ErrorCodeEnum.ERROR.getCode()).setMsg(ErrorCodeEnum.ERROR.getMsg());
    }

    public static Response buildFailure(int code, String msg) {
        return new Response().setCode(code).setMsg(msg);
    }

    protected Response(ResponseBuilder<T, ?, ?> b) {
        this.code = ((ResponseBuilder)b).code;
        this.msg = ((ResponseBuilder)b).msg;
        this.data = ((ResponseBuilder)b).data;
    }

    public static <T> ResponseBuilder<T, ?, ?> builder() {
        return new ResponseBuilderImpl();
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public Response<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public Response<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public Response<T> setData(T data) {
        this.data = data;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public Response(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Response() {
    }

    private static final class ResponseBuilderImpl<T>
    extends ResponseBuilder<T, Response<T>, ResponseBuilderImpl<T>> {
        private ResponseBuilderImpl() {
        }

        @Override
        protected ResponseBuilderImpl<T> self() {
            return this;
        }

        @Override
        public Response<T> build() {
            return new Response(this);
        }
    }

    public static abstract class ResponseBuilder<T, C extends Response<T>, B extends ResponseBuilder<T, C, B>> {
        private int code;
        private String msg;
        private T data;

        protected abstract B self();

        public abstract C build();

        public B code(int code) {
            this.code = code;
            return this.self();
        }

        public B msg(String msg) {
            this.msg = msg;
            return this.self();
        }

        public B data(T data) {
            this.data = data;
            return this.self();
        }

        public String toString() {
            return "Response.ResponseBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

