package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.vo.ListEarningsShareChargeStationVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListSelfSupportChargeStationVO;
import com.ebike.openservices.oprmgmt.request.ListEarningsShareChargeStationParam;
import com.ebike.openservices.oprmgmt.request.ListSelfSupportChargeStationParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
public interface BillingSchemeSettingDao {

    /**
     * 自营充电站列表
     *
     * @param param
     * @param pager
     * @return
     */
    List<ListSelfSupportChargeStationVO> listSelfSupportChargeStation(@Param("param") ListSelfSupportChargeStationParam param,@Param("pager") Pager pager);

    /**
     * 自营充电站列表总数
     *
     * @param param
     * @return
     */
    long listSelfSupportChargeStationTotal(@Param("param") ListSelfSupportChargeStationParam param);

    /**
     * 获取手机号在同一个电站下的数量
     *
     * @param chargingStationId
     * @param phone
     * @return
     */
    int countOperEvChargingStationBillingUserList(@Param("chargingStationId") Long chargingStationId, @Param("phone") String phone);

    /**
     * 获取车辆vin码在同一个电站下的数量
     *
     * @param chargingStationId
     * @param vin
     * @return
     */
    int countOperEvChargingStationBillingEvcarList(@Param("chargingStationId") Long chargingStationId, @Param("vin") String vin);

    /**
     * 收益分享充电站列表
     *
     * @param param
     * @param pager
     * @return
     */
    List<ListEarningsShareChargeStationVO> listEarningsShareChargeStation(@Param("param") ListEarningsShareChargeStationParam param, @Param("pager") Pager pager);

    /**
     * 收益分享充电站列表（总数）
     *
     * @param param
     * @return
     */
    long listEarningsShareChargeStationTotal(@Param("param") ListEarningsShareChargeStationParam param);
}
