package com.ebike.openservices.oprmgmt.dao;

import com.ebike.openservices.oprmgmt.entity.CarRegisterExamineVo;
import com.ebike.openservices.oprmgmt.entity.OpenIdVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author liumu
 * @date 2021/4/16 16:26
 * 汽车充电桩-运营商注册审核
 */
public interface CarRegisterCheckServiceDao {

    /**
     * 根据用户手机号码获取openid
     *
     * @param phone
     * @return
     */
    List<OpenIdVo> selectOpenidByPhone(String phone);

    /**
     * 通过openId获取openId对应名称
     *
     * @param openId    openId
     * @return
     */
    String selectOpenIdNameByOpenId(String openId);

    /**
     * 添加运营商档案
     *
     * @param bean
     */
    void insertEbikeOrgopr(CarRegisterExamineVo bean);

    /**
     * 更新运营商注册信息表
     *
     * @param verifyResult      审核结果：W – 等待审核；S – 审核通过；F – 审核不通过；
     * @param verifyRemark      审核备注
     * @param orgoprNo          运营商编号（单位编号）
     * @param verifier          审核人
     * @param orgoprRegId       运营商注册标识
     */
    void updateEbikeOrgoprReginfo(@Param("verifyResult") String verifyResult,
                                  @Param("verifyRemark") String verifyRemark,
                                  @Param("orgoprNo") String orgoprNo,
                                  @Param("verifier") String verifier,
                                  @Param("orgoprRegId") String orgoprRegId);

    /**
     * 取出档案的openId（json）
     * @param id        记录id
     * @return
     */
    String selectOpenId(String id);

    /**
     * 更新档案openId
     *
     * @param id            档案主键
     * @param jsonStr       包含openId和openId对应名称的json字符串
     */
    void updateOpenId(
        @Param("id")String id,
        @Param("jsonStr") String jsonStr);

}
