package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo;
import com.ebike.openservices.oprmgmt.request.CardAuditRequest;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * @param
 * @ClassName CardAuditDao
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/7/14 16:03
 * @Version 1.0
 **/
@Mapper
public interface CardAuditDao {
    /***
     * @Description TODO  充电卡审核查询
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo>
     * @data 2021/7/14
     * @param request
     */
    List<CardAuditVo> listCard(@Param("request")CardAuditRequest request, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);
    /***
     * @Description TODO 获取数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/15
     * @param request
     */
    Integer getTotalPage(@Param("request")CardAuditRequest request);
    /***
     * @Description TODO  根据id查询充电卡信息
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo
     * @data 2021/7/14
     * @param id
     */
    CardAuditVo getCardById(@Param("id")Long id);
    /***
     * @Description TODO  查询工本费
     * @author zhouyi
     * @return java.math.BigDecimal
     * @data 2021/7/15
     */
    BigDecimal getPurchaseApplyCardCost();

    /***
     * @Description TODO  更新审核状态
     * @author zhouyi
     * @return int
     * @data 2021/7/15
     * @param auditStatus 审核状态;0 - 待审核；1 - 审核通过；2 - 审核退回；3 - 审核拒绝；
     * @param auditDesc   审核说明
     */
    int updateAuditStatus(@Param("auditStatus")Integer auditStatus,@Param("auditDesc")String auditDesc,@Param("id")Long id);

    /***
     * @Description TODO  更新待审核的  单价  和  总费用
     * @author zhouyi
     * @return int
     * @data 2021/7/15
     * @param price
     * @param totalMoney
     */
    int updateCard(@Param("price")BigDecimal price,@Param("totalMoney")BigDecimal totalMoney,@Param("id")Long id);
}
