package com.ebike.openservices.oprmgmt.dao;

import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyEntity;
import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyVo;
import com.ebike.openservices.oprmgmt.entity.CardServiceRateVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author liumu
 * @date 2021-07-15 10:42
 * 个性卡（定制卡）账务相关
 */
public interface CardDao {

    /**
     * 获取充电卡提现申请列表
     *
     * @param orgNo
     * @param cardId
     * @param phone
     * @param startDate
     * @param endDate
     * @param page
     * @param size
     * @return
     */
    List<CardAcctWithdrawApplyVo> selectWithApply(@Param("orgNo")String orgNo,
                                                  @Param("cardId") String cardId,
                                                  @Param("phone") String phone,
                                                  @Param("startDate") String startDate,
                                                  @Param("endDate") String endDate,
                                                  @Param("page") Integer page,
                                                  @Param("size") Integer size);

    /**
     * 获取充电卡提现申请列表计数
     *
     * @param orgNo
     * @param cardId
     * @param phone
     * @param startDate
     * @param endDate
     * @return
     */
    Integer selectWithApplyCount(@Param("orgNo")String orgNo,
                                 @Param("cardId") String cardId,
                                 @Param("phone") String phone,
                                 @Param("startDate") String startDate,
                                 @Param("endDate") String endDate);

    /**
     * 通过id获取提现申请
     * @param id
     * @return
     */
    CardAcctWithdrawApplyEntity selectWithdrawApplyById(Long id);

    /**
     * 更新充电卡提现审核状态
     */
    void updateWithdrawStatus(CardAcctWithdrawApplyEntity bean);

    /**
     * 充电卡服务费设置列表
     * @param subburo
     * @return
     */
    List<CardServiceRateVo> selectCardServiceRate(@Param("subburo") String subburo,
                                                  @Param("page") Integer page,
                                                  @Param("size") Integer size);

    /**
     * 充电卡服务费设置列表计数
     * @return
     */
    Integer selectCardServiceRateCount();

    /**
     * 更新充电卡服务费率
     *
     * @param subburo
     * @param rate
     */
    void updateCardServiceRate(@Param("subburo") String subburo,@Param("rate") String rate);
}
