package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.jdbc.mybatis.QueryMapper;
import com.ebike.openservices.oprmgmt.entity.DisasterPreventionVo;
import com.ebike.openservices.oprmgmt.request.DisasterSetUpRequest;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 防灾应急
 * @author Liu
 * @date 2019-04-29
 */

public interface DisasterPreventionDao extends QueryMapper<DisasterPreventionVo,String> {

    List<Map<String,Object>> getProvinceList();

    List<Map<String,Object>> getCityList(@Param("level") String level, @Param("parentid") String parentid);

    List<Map<String,Object>> getDistrictList(@Param("level") String level, @Param("parentid") String parentid);

    Map<String, Object> getUserMobileByUserNo(@Param("userNo") String userNo);

    int insertSms(Map<String,String> map);

    int getCheckCode(@Param("codeValue") String codeValue, @Param("userMobile") String userMobile);

    int updateCodeStatus(@Param("codeValue") String codeValue);

    int getChangeOrderCount(@Param("stationId") String stationId);

}
