package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.jdbc.mybatis.BaseMapper;
import com.ebike.openservices.oprmgmt.entity.ModalVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgDayVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgMonthVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgYear;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainChargingPileInfoVo;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainOrderInfoVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 运营概况
 *
 * @author Liu
 * @date 2019-04-22
 */
public interface EbikeMainDao extends BaseMapper<Map<String, Object>, Map<String, Object>> {

    List<Map<String, Object>> getDqcdjl(Map<String, Object> params);

    /**
     * 定时刷新时查找10条当前充电数据  倒叙排
     */
    List<EbikeMainOrderInfoVo> getDqcdjl2(Map<String, Object> params);

    /**
     * 今日已完成的次数（自行车）
     */
    Integer getFinishCount(Map<String, Object> params);

    /**
     * 今日已完成的次数（汽车）
     */
    Integer getFinishCarCount(Map<String, Object> params);

    /**
     * 今日充电中的次数（自行车）
     */
    Integer getChargingCount(Map<String, Object> params);

    /**
     * 今日充电中的次数（汽车）
     */
    Integer getChargingCarCount(Map<String, Object> params);

    Map<String, Object> getZs(Map<String, Object> params);

    List<Map<String, Object>> getYs(Map<String, Object> params);

    List<Map<String, String>> getQgCdzb(Map<String, Object> params);

    /**
     * 充电自行车的 每月/每年，充电趋势的变化(包括充电收入，充电次数)
     */
    List<Map<String, Object>> getCdqs(Map<String, Object> params);

    /**
     * 充电汽车的 每月/每年，充电趋势的变化(包括充电收入，充电次数)
     */
    List<Map<String, Object>> getCdqsCar(Map<String, Object> params);

    List<Map<String, Object>> getJkInfo(Map<String, Object> m);

    Map<String, Object> getDevInfo(Map<String, Object> m);

    List<Map<String, Object>> getPlugInfo(Map<String, Object> m);

    List<Map<String, String>> getDqcdzList(Map<String, Object> m);

    /**
     * @Description: 以下是新增代码
     * @Param: [param]
     * @returns: java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @Author: 杨德志
     * @Date: 2020/7/1 16:17
     */

    List<Map<String, String>> getChargingRevenue(Map<String, Object> param);

    //插座段子的异常
    List<ModalVo> getDeviceAbnormal(Map<String, Object> param);

    /**
     * 负荷曲线的日月年
     */

    List<StatPowerOrgDayVo> getPowerOrgDay(Map<String, Object> param);

    List<StatPowerOrgDayVo> getPowerOrgDayVo(Map<String, Object> param);

    List<StatPowerOrgMonthVo> getPowerOrgMonthVo(Map<String, Object> param);

    List<StatPowerOrgYear> getPowerOrgYear(@Param("dataTime") String dataTime, @Param("orgNo") String orgNo);


    List<StatPowerOrgMonthVo> getPowerOrgMonth(@Param("dataTime") String dataTime, @Param("orgNo") String orgNo);

    List<StatPowerOrgYear> getPowerOrg(@Param("dataTime") String dataTime, @Param("orgNo") String orgNo);

    /**
     * 地图中电站详情信息
     */
    EbikeMainChargingPileInfoVo getChargingPileInfo(String chargingPileNo);

    /**
     * 获取充电枪列表信息
     */
    List<EbikeMainChargingPileInfoVo> getChargingGunList(String chargingPileId);
}
