package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfo;
import com.ebike.openservices.oprmgmt.entity.vo.ListSelfSupportChargeStationBillingInfoVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
public interface OperEvChargingStationBillingInfoDao {

    /**
     * 保存计费方案信息
     *
     * @param param
     * @return
     */
    int insertOperEvChargingStationBillingInfo(@Param("param") OperEvChargingStationBillingInfo param);

    /**
     * 查询（单个）
     *
     * @param id
     * @return
     */
    OperEvChargingStationBillingInfo selectById(@Param("id") Long id);

    /**
     * 查找当前电站有几个已生效的计费模板
     *
     * @param chargingStationId
     * @return
     */
    int countSchemeByStationId(@Param("chargingStationId") Long chargingStationId);

    /**
     * 根据计费模板id修改
     *
     * @param param
     * @return
     */
    int updateById(@Param("param") OperEvChargingStationBillingInfo param);

    /**
     * 根据电站id查找计费方案列表
     *
     * @param chargingStationId
     * @return
     */
    List<ListSelfSupportChargeStationBillingInfoVO> listSelfSupportChargeStationBillingInfo(@Param("chargingStationId") Long chargingStationId);

    /**
     * 计费方案的适用用户列表
     *
     * @param id
     * @param pager
     * @return
     */
    List<Map<String, Object>> listChargingStationBillingUser(@Param("id") Long id, @Param("pager") Pager pager);

    /**
     * 计费方案的适用用户列表（总数）
     * @param id
     * @return
     */
    long countChargingStationBillingUserTotal(@Param("id") Long id);

    /**
     * 计费方案修改之后的适用用户列表
     *
     * @param id
     * @param pager
     * @return
     */
    List<Map<String, Object>> listChargingStationBillingUserAfter(@Param("id") Long id, @Param("pager") Pager pager);

    /**
     * 计费方案修改之后的适用用户列表（总数）
     *
     * @param id
     * @return
     */
    long countChargingStationBillingUserAfterTotal(@Param("id") Long id);

    /**
     * 根据电站id、计费模板id查找
     *
     * @param chargingStationId
     * @param billingTmplId
     * @return
     */
    OperEvChargingStationBillingInfo existFromStation(@Param("chargingStationId") Long chargingStationId,@Param("billingTmplId") Long billingTmplId);

    /**
     * 计费方案设置的适用车辆列表
     *
     * @param id
     * @param pager
     * @return
     */
    List<Map<String, Object>> listChargingStationBillingCar(@Param("id") Long id, @Param("pager")  Pager pager);

    /**
     * 计费方案设置的适用车辆列表（总数）
     *
     * @param id
     * @return
     */
    long countChargingStationBillingCarTotal(@Param("id") Long id);

    /**
     * 计费方案设置的适用车辆（修改之后）
     * @param id
     * @param pager
     * @return
     */
    List<Map<String, Object>> listChargingStationBillingCarAfter(@Param("id") Long id, @Param("pager")  Pager pager);

    /**
     * 计费方案设置的适用车辆（修改之后）（总数）
     * @param id
     * @return
     */
    long countChargingStationBillingCarAfterTotal(@Param("id") Long id);
}
