package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfoLog;
import com.ebike.openservices.oprmgmt.entity.vo.ListChargingStationBillingInfoLogVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * 电动汽车充电站计费方案操作日志
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
public interface OperEvChargingStationBillingInfoLogDao {

    /**
     * 新增
     *
     * @param param
     * @return
     */
    int insert(@Param("param") OperEvChargingStationBillingInfoLog param);

    /**
     * 充电站计费方案操作日志列表
     *
     * @param stationBillingInfoId
     * @param pager
     * @return
     */
    List<ListChargingStationBillingInfoLogVO> listChargingStationBillingInfoLog(@Param("stationBillingInfoId") Long stationBillingInfoId, @Param("pager") Pager pager);

    /**
     * 充电站计费方案操作日志列表（总数）
     *
     * @param stationBillingInfoId
     * @return
     */
    long countChargingStationBillingInfoLogTotal(@Param("stationBillingInfoId") Long stationBillingInfoId);
}
