package com.ebike.openservices.oprmgmt.dao;

import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfoTbc;
import com.ebike.openservices.oprmgmt.request.IsAgreeBillingSchemeParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 电动汽车充电站计费方案待确认信息（利益相关方）
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
public interface OperEvChargingStationBillingInfoTbcDao {

    /**
     * 电动汽车充电站利益相关方分配待确认信息（利益相关方）
     *
     * @param param
     * @return
     */
    int insert(@Param("param") OperEvChargingStationBillingInfoTbc param);

    /**
     * 更新计费方案待确认信息状态（利益相关方）
     *
     * @param param
     * @return
     */
    int isAgreeBillingScheme(@Param("param") IsAgreeBillingSchemeParam param);

    /**
     * 根据电站id查找所有共享人是否确认信息
     *
     * @param chargingStationId
     * @return
     */
    List<OperEvChargingStationBillingInfoTbc> selectList(@Param("chargingStationId") Long chargingStationId);
}
