package com.ebike.openservices.oprmgmt.dao;

import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationStakeholderDistInfo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 电动汽车充电站利益相关方分配信息
 *
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/16
 */
public interface OperEvChargingStationStakeholderDistInfoDao {

    /**
     * 获取电站关联的收益共享人数
     *
     * @param chargingStationId
     * @return
     */
    int countEarningsSharePersonByStationId(@Param("chargingStationId") Long chargingStationId);

    /**
     * 根据条件查询多条记录
     *
     * @param param
     * @return
     */
    List<OperEvChargingStationStakeholderDistInfo> selectList(@Param("param") Map<String, Object> param);
}
