package com.ebike.openservices.oprmgmt.dao;

import com.ebike.openservices.oprmgmt.request.PowerChargeListParam;
import com.ebike.openservices.oprmgmt.request.PowerChargeStatRequest;
import com.ebike.openservices.oprmgmt.response.PowerChargeResponse;
import com.ebike.openservices.oprmgmt.response.PowerChargeStatResponse;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/3
 */
public interface PowerChargeDao {

    /**
     * 按集团客户统计电量电费列表
     *
     * @param param
     * @param isPage
     * @return
     */
    List<PowerChargeResponse> listStation(@Param("param") PowerChargeListParam param, @Param("isPage") Boolean isPage);

    /**
     * 查找电站下的所有订单充电电量明细
     *
     * @param stationId
     * @return
     */
    List<String> listChargeEconsDetailByStationId(@Param("stationId") Long stationId);

    /**
     * 按集团客户统计电量电费总数
     *
     * @param param
     * @return
     */
    long listStationTotal(@Param("param") PowerChargeListParam param);

    /**
     * 电量电费总数据统计
     *
     * @param param
     * @return
     */
    PowerChargeStatResponse getPowerChargeStat(@Param("param") PowerChargeStatRequest param);
}
