package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.request.PowerStationRequestParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @param
 * @ClassName PowerStationDao   电站信息查询
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/15 15:49
 * @Version 1.0
 **/
@Mapper
public interface PowerStationDao {
    /**
     * 功能描述   电站信息查询列表
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.PowerStationVo>
     * @data 2021/4/15
     * @param param
     */
    List<PowerStationVo> getPowerStation(@Param("param")PowerStationRequestParam param, @Param("pager")Pager pager);
    /**
     * 功能描述  电站信息列表数据总数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/4/16
     * @param param
     */
    Integer getPowerStationTotal(@Param("param")PowerStationRequestParam param);

    /**
     * 功能描述  充电站统一视图——基本信息
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationEssentialInformationVo
     * @data 2021/4/16
     * @param id
     */
    List<PowerStationEssentialInformationVo> getPowerStationEssentialInformation(@Param("id")Long id,@Param("pager")Pager pager);


    /**
     * 功能描述   充电站统一视图——基本信息数据总数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/4/19
     * @param id
     */
    Integer getPowerStationEssentialInformationToTal(@Param("id")Long id);

    /**
     * 功能描述 充电站统一视图——收益分配
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationIncomeDistributionVo
     * @data 2021/4/16
     * @param id
     */
    List<PowerStationIncomeDistributionVo> getPowerStationIncomeDistribution(@Param("id")Long id,@Param("pager")Pager pager);

    /**
     * 功能描述 充电站统一视图——收益分配数据总数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/4/19
     * @param id
     */
    Integer getPowerStationIncomeDistributionTotal(@Param("id")Long id);


    Integer getChargingPileTotal(@Param("id")Long id);

    /**
     * 功能描述 充电站统一视图——电桩详情
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingPileInformationVo>
     * @data 2021/4/22
     * @param id
     */
    List<ChargingPileInformationVo> getChargingPileInformation(@Param("id")Long id);

    /**
     * 功能描述 充电站统一视图——电枪列表
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingGunInformationVo>
     * @data 2021/4/22
     * @param id
     */
    List<ChargingGunInformationVo> getChargingGunInformation(@Param("id")Long id);



}
