package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStation;
import com.ebike.openservices.oprmgmt.entity.po.OperEvChargingStationBillingInfo;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardChargingGunVO;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardChargingPileVO;
import com.ebike.openservices.oprmgmt.entity.vo.DetailPowerStationSafeguardVO;
import com.ebike.openservices.oprmgmt.entity.vo.ListPowerStationSafeguardVO;
import com.ebike.openservices.oprmgmt.request.ListPowerStationSafeguardParam;
import com.ebike.openservices.oprmgmt.request.UpdateChargingGunParam;
import com.ebike.openservices.oprmgmt.request.UpdateChargingPileParam;
import com.ebike.openservices.oprmgmt.request.UpdatePowerStationParam;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/13
 */
public interface PowerStationSafeguardDao {

    /**
     * 电站维护列表
     *
     * @param param
     * @param pager
     * @return
     */
    List<ListPowerStationSafeguardVO> listPowerStationSafeguard(@Param("param") ListPowerStationSafeguardParam param, @Param("pager") Pager pager);

    /**
     * 电站维护列表总数
     *
     * @param param
     * @return
     */
    long listPowerStationSafeguardTotal(@Param("param") ListPowerStationSafeguardParam param);

    /**
     * 添加电站
     *
     * @param param
     * @return
     */
    int insertOperEvChargingStation(@Param("param") OperEvChargingStation param);

    /**
     * 添加电动汽车充电站与计费模板的关联
     *
     * @param param
     * @return
     */
    int insertOperEvChargingStationBillingInfo(@Param("param") OperEvChargingStationBillingInfo param);

    /**
     * 编辑设备（电动汽车充电桩）
     *
     * @param param
     * @return
     */
    int updateChargingPile(@Param("param") UpdateChargingPileParam param);

    /**
     * 编辑电动汽车充电枪
     *
     * @param param
     * @return
     */
    int updateChargingGun(@Param("param") UpdateChargingGunParam param);

    /**
     * 电动汽车充电站详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardVO getDetailPowerStationSafeguardById(@Param("id") Long id);

    /**
     * 电动汽车充电桩详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardChargingPileVO getPowerStationSafeguardChargingPileById(@Param("id") Long id);

    /**
     * 电动汽车充电枪详情
     *
     * @param id
     * @return
     */
    DetailPowerStationSafeguardChargingGunVO getPowerStationSafeguardChargingGunById(@Param("id") Long id);

    /**
     * 删除电动汽车充电站
     *
     * @param id
     * @return
     */
    int deletePowerStationById(@Param("id") Long id);

    /**
     * 获取最新充电站编号
     *
     * @return
     */
    String getPowerStationNo();

    /**
     * 修改电站
     *
     * @param param
     * @return
     */
    int updateById(@Param("param") UpdatePowerStationParam param);

    /**
     * 根据电站id获取关联电桩数量
     *
     * @param id
     * @return
     */
    long countChargingPileByStationId(@Param("id") Long id);

    /**
     * 根据电站id获取关联电枪数量
     *
     * @param id
     * @return
     */
    long countChargingGunByStationId(@Param("id") Long id);

    /**
     * 查找所有的adcode
     *
     * @return
     */
    List<Map<String, String>> listAdCode();

    /**
     * 查出所有的电站树节点
     *
     * @param orgNo
     * @return
     */
    List<Map<String, String>> listTreePowerStation(@Param("orgNo") String orgNo);
}
