package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.entity.po.CardCustomPurchaseApplyRelacs;
import com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo;
import com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo;
import com.ebike.openservices.oprmgmt.entity.vo.StationVo;
import com.ebike.openservices.oprmgmt.request.RechargeCardRequest;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @param
 * @ClassName RechargeCardsDao
 * @Description TODO  运营商端 充电卡相关接口
 * @Author zhouyi
 * @Data 2021/7/15 15:10
 * @Version 1.0
 **/
@Mapper
public interface RechargeCardsDao {
     /***
      * @Description TODO 充电卡管理模糊查询
      * @author zhouyi
      * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo>
      * @data 2021/7/15
      * @param request
      */
    List<RechargeCardVo> listRechargeCardVo(@Param("param")RechargeCardRequest request, @Param("sorter")Sorter sorter, @Param("pager")Pager pager);

    /***
     * @Description TODO  获取充电卡管理数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param request
     */
    Integer getTotalPage(@Param("param")RechargeCardRequest request);
    /***
     * @Description TODO  获取总余额
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo
     * @data 2021/7/15
     */
    RechargeCardVo getBalance(@Param("orgNo")String orgNo);

    /***
     * @Description TODO 获取总充值
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo
     * @data 2021/7/19
     * @param orgNo
     */
    RechargeCardVo getIncome(@Param("orgNo")String orgNo);

   /***
    * @Description TODO  充电卡订单  模糊查询
    * @author zhouyi
    * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RechargeCardVo>
    * @data 2021/7/15
    * @param batch
    * @param phoneNo
    */
    List<RechargeCardVo> listRechargeCardOrder(@Param("batch")String batch,@Param("phoneNo")String phoneNo,@Param("orgNo")String orgNo,@Param("sorter")Sorter sorter,@Param("pager")Pager pager);

    /***
     * @Description TODO  获取充电卡订单数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param batch
     * @param phoneNo
     */
    Integer getOrderTotalPage(@Param("batch")String batch,@Param("phoneNo")String phoneNo,@Param("orgNo")String orgNo);
    /***
     * @Description TODO  查询充电卡下已关联的电站
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.StationVo>
     * @data 2021/7/15
     * @param id
     */
    List<StationVo> listStationAssociated(@Param("id")Long id,
                                         @Param("stationName")String stationName,
                                         @Param("stationAddr")String stationAddr
                                       /*  @Param("sorter")Sorter sorter,
                                         @Param("pager")Pager pager*/);

    /***
     * @Description TODO  获取已关联的电站数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param id
     * @param stationName
     */
    Integer getStationAssociatedTotalPage(@Param("id")Long id,
                                          @Param("stationName")String stationName,
                                          @Param("stationAddr")String stationAddr);

    /***
     * @Description TODO  查询充电卡下未关联的电站
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.StationVo>
     * @data 2021/7/15
     * @param orgNo
     */
    List<StationVo> listStation(@Param("orgNo")String orgNo,
                                @Param("stationName")String stationName,
                                @Param("stationAddr")String stationAddr
                               /* @Param("sorter")Sorter sorter,
                                @Param("pager")Pager pager*/);

    /***
     * @Description TODO  获取未关联的电站数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/16
     * @param orgNo
     * @param stationName
     */
    Integer getStationTotalPage(@Param("orgNo")String orgNo,
                                          @Param("stationName")String stationName,
                                          @Param("stationAddr")String stationAddr);
    /***
     * @Description TODO  创建关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/15
     */
    Integer createAssociated(CardCustomPurchaseApplyRelacs relacs);

    /***
     * @Description TODO  解除关联
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/15
     * @param id 运营商定制充电卡申请标识
     * @param stationId  电站标识
     */
    Integer removeAssociated(@Param("id") Long id,@Param("stationId") Long stationId);

    /***
     * @Description TODO  退款记录
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.RefundRecordVo>
     * @data 2021/7/19
     * @param id
     */
    List<RefundRecordVo> getRefundRecord(@Param("id")String id,
                                         @Param("startDate")String startDate,
                                         @Param("endDate")String endDate,
                                         @Param("sorter")Sorter sorter,
                                         @Param("pager")Pager pager);

    /***
     * @Description TODO 退款记录数据总条数
     * @author zhouyi
     * @return java.lang.Integer
     * @data 2021/7/19
     * @param id
     */
    Integer getRefundTotalPage(@Param("id")String id,@Param("startDate")String startDate,
                               @Param("endDate")String endDate);

}
