package com.ebike.openservices.oprmgmt.dao;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.easesource.data.jdbc.mybatis.QueryMapper;
import com.ebike.openservices.oprmgmt.entity.TmplBillingDo;
import com.ebike.openservices.oprmgmt.request.TmplBillingRequest;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 充电汽车项目-->计费模板维护
 *
 * @author liulianglin
 * @version 1.0.0
 * @since 2021-04-13
 */
public interface TmplBillingDao extends QueryMapper<TmplBillingDo, String> {
    /**
     * 查询--计费模板维护列表
     */
    List<TmplBillingDo> getTmplBillingDoList(@Param("params") TmplBillingRequest params, @Param("sorter") Sorter sorter, @Param("pager") Pager pager);

    Integer getTmplBillingDoCount(@Param("params") TmplBillingRequest params);

    /**
     * 新增计费模板
     */
    void insertTmplBilling(TmplBillingRequest params);

    /**
     * 删除计费模板
     */
    void deleteTmplBilling(TmplBillingRequest params);

    /**
     * 根据模板id查看是否被充电站关联的
     */
    int getCountByTmplId(Long billingTmplId);

    /**
     * 获取最大的计费模板编号
     */
    TmplBillingDo getMaxTmplNo();

    /**
     * 获取模板详情
     *
     * @param tmplId
     * @return
     */
    String selectTmplInfoById(String tmplId);

}
