package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeFlszDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

//import cn.cc.cisp.logging.CispLogger;
//import cn.yunrui.chargebike.asset.dao.ChargeFlszDao;
//import cn.yunrui.chargebike.asset.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.TaskNoRule;
//import cn.yunrui.common.util.UUID;
@Repository
public class ChargeFlszDaoImpl extends AbstractEbikeBaseJdbcDao implements ChargeFlszDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeFlszDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, Object>> querySchemInfo(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");

            sql.append(" and b.closingPeriod=?", map.get("sclosingPeriod"));

            sql.append(" and b.schemeName like ?", "%" + map.get("schemeName") + "%");

            sql.append(" and b.isReturn=?", map.get("isReturn"));
            sql.append(" and schemeType=?", map.get("schemeType"));
            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? ) ", subburo);
            sql.append(" and b.valid='T' ");
            sql.append("order by b.createTime asc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", starts);
                sql.append(" , 10 ");
            }

            logger.debug(sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                (rs, rownum) -> {
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("schemeId", rs.getString("schemeId"));
                    map1.put("schemeNo", rs.getString("schemeNo"));
                    map1.put("schemeType", rs.getString("schemeType"));
                    map1.put("unitPrice1", rs.getDouble("unitPrice1"));
                    map1.put("unitPrice2", rs.getDouble("unitPrice2"));
                    map1.put("unitPrice3", rs.getDouble("unitPrice3"));
                    map1.put("unitPrice4", rs.getDouble("unitPrice4"));
                    map1.put("stepPower1", rs.getInt("stepPower1"));
                    map1.put("stepPower2", rs.getInt("stepPower2"));
                    map1.put("stepPower3", rs.getInt("stepPower3"));
                    map1.put("stepPower4", rs.getInt("stepPower4"));
                    map1.put("schemeName", rs.getString("schemeName"));
                    map1.put("minCharge", rs.getDouble("minCharge"));
                    map1.put("isReturn", rs.getString("isReturn"));
                    map1.put("schemeDetails", rs.getObject("schemeDetails"));

                    if (rs.getInt("closingPeriod") == 0) {
                        map1.put("closingPeriod", "");
                    } else {
                        map1.put("closingPeriod", rs.getInt("closingPeriod"));
                    }
                    return map1;
                });
            logger.debug(">>>>>>>>>>>>getSchemeInfo<<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            return list;

        }
        return list;
    }

    @Override
    public List<Map<String, Object>> selectSchemInfo(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");

            sql.append(" and b.closingPeriod=?", map.get("sclosingPeriod"));

            sql.append(" and b.schemeName like ?", "%" + map.get("schemeName") + "%");

            sql.append(" and b.isReturn=?", map.get("isReturn"));

            sql.append(" and b.schemeType=?", map.get("schemeType"));


            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? ", subburo);
            sql.append(" or b.SUBBURO = '000000000')");
            sql.append(" and b.valid='T' ");
            sql.append("order by b.schemeNo asc ");
            if (start == 1) {
                sql.append(" limit 0,5 ");
            } else {
                int starts = (start - 1) * 5;
                int end = start * 10;
                sql.append(" limit ? ", starts);
                sql.append(" , 5 ");
            }

            logger.debug(sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                (rs, rownum) -> {
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("schemeId", rs.getString("schemeId"));
                    map1.put("schemeNo", rs.getString("schemeNo"));
                    if ("01".equals(rs.getString("schemeType"))) {
                        map1.put("schemeType", "计时");
                    } else if ("03".equals(rs.getString("schemeType"))) {
                        map1.put("schemeType", "计次");
                    } else if ("02".equals(rs.getString("schemeType"))) {
                        map1.put("schemeType", "计电量");
                    } else {
                        map1.put("schemeType", "计电量+计时（阶梯功率）");
                    }


                    String powerAndPrice1 = "";
                    if ("03".equals(rs.getString("schemeType"))) {
                        powerAndPrice1 = rs.getDouble("unitPrice1") + "元/次";
                    } else if ("05".equals(rs.getString("schemeType"))) {
                        Object schemeDetails = rs.getObject("schemeDetails");
                        String elecCost = JSONUtil.parseObj(schemeDetails).getStr("elec_cost");
                        powerAndPrice1 = "电度电价：" + elecCost + "元/小时，服务费：" + " 0 W" + "～" + rs.getInt("stepPower1") + " W " + " ： "
                            + rs.getDouble("unitPrice1") + " 元/小时 ，"
                            + rs.getInt("stepPower1") + " W " + "～"
                            + rs.getInt("stepPower2") + " W ： "
                            + rs.getDouble("unitPrice2") + " 元/小时 ，"
                            + rs.getInt("stepPower2") + " W " + "～"
                            + rs.getInt("stepPower3") + " W ： "
                            + rs.getDouble("unitPrice3") + " 元/小时 ，"
                            + rs.getInt("stepPower3") + " W " + "～" + " ∞ " + " ： "
                            + rs.getDouble("unitPrice4") + " 元/小时";
                    } else {
                        powerAndPrice1 = " 0 W" + "～" + String.valueOf(rs.getInt("stepPower1")) + " W " + " ： "
                            + rs.getDouble("unitPrice1") + " 小时/元 ，"
                            + rs.getInt("stepPower1") + " W " + "～"
                            + rs.getInt("stepPower2") + " W ： "
                            + rs.getDouble("unitPrice2") + " 小时/元 ，"
                            + rs.getInt("stepPower2") + " W " + "～"
                            + rs.getInt("stepPower3") + " W ： "
                            + rs.getDouble("unitPrice3") + " 小时/元 ，"
                            + rs.getInt("stepPower3") + " W " + "～" + " ∞ " + " ： "
                            + rs.getDouble("unitPrice4") + " 小时/元";
                    }
                    map1.put("schemeInfo", powerAndPrice1);
                    map1.put("schemeName", rs.getString("schemeName"));
                    map1.put("minCharge", rs.getDouble("minCharge"));
                    map1.put("isReturn", rs.getString("isReturn"));
                    map1.put("schemeDetails", rs.getObject("schemeDetails"));
                    if (rs.getInt("closingPeriod") == 0) {
                        map1.put("closingPeriod", "");
                    } else {
                        map1.put("closingPeriod", rs.getInt("closingPeriod"));
                    }
                    return map1;
                });
            logger.debug(">>>>>>>>>>>>getSchemeInfo<<<<<<<<<<<<<<" + sql);
        } catch (Exception ex) {
            return list;

        }
        return list;
    }

    @Override
    public int selectSchemCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme a where 1=1 ");
            sql.append(" and ( a.SUBBURO = ?", subburo);
            sql.append(" or a.BURO = ? ", subburo);
            sql.append(" or a.SUBBURO = '000000000')");
            sql.append(" and a.closingPeriod=?", map.get("sclosingPeriod"));
            sql.append(" and a.schemeName like ?", "%" + map.get("schemeName") + "%");
            sql.append(" and a.isReturn=?", map.get("isReturn"));
            sql.append(" and a.schemeType=?", map.get("schemeType"));
            sql.append(" and a.valid='T' ");
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryChargeflList(String subburo, Map<String, String> map, int start,
                                                       int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_billingscheme b where 1=1");

            sql.append(" and b.schemeType=?", map.get("schemeType"));

            sql.append(" and b.schemeName like ?", "%" + map.get("schemeName") + "%");

            sql.append(" and b.isReturn=?", map.get("isReturn"));

            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? ", subburo);
            sql.append(" or b.SUBBURO = '000000000')", subburo);
            sql.append(" and b.valid='T' ");
            sql.append("order by b.schemeNo");
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", start);
                sql.append(" , ? ", limit);

            }
            logger.debug(sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            return list;

        }
        return list;

    }

    public int getflCount(String subburo, Map<String, String> map) {

        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme b where 1=1");

            sql.append(" and b.schemeType=?", map.get("schemeType"));

            sql.append(" and b.schemeName like ?", "%" + map.get("schemeName") + "%");

            sql.append(" and b.isReturn=?", map.get("isReturn"));

            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? ", subburo);
            sql.append(" or b.SUBBURO = '000000000')");
            sql.append(" and b.valid='T' ");

            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int querySchemCount(String subburo, Map<String, String> map) {

        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("select count(1) from ebike.ebike_billingscheme a where 1=1 ");
            sql.append(" and ( a.SUBBURO=?", subburo);
            sql.append(" or a.BURO=? )", subburo);
            sql.append(" and a.closingPeriod=?", map.get("sclosingPeriod"));
            sql.append(" and a.schemeName like ?", "%" + map.get("schemeName") + "%");
            sql.append(" and a.isReturn=?", map.get("isReturn"));
            sql.append(" and schemeType=?", map.get("schemeType"));
            sql.append(" and a.valid='T' ");
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public boolean deleteflMode(String ids) {

        logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        int results = 0;
        try {
            SqlParamsBuilder sql = new SqlParamsBuilder();
            sql.append("update ebike.ebike_billingscheme set valid='F' where 1=1");
            sql.append(" and schemeId in (?) ", ids, ",");
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public Map<String, Object> getflModeDataById(String id) {

        Map<String, Object> map = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select * from ebike.ebike_billingscheme where 1=1");
            sql.append(id, " and schemeId=?");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), new ChargeflRowMapper());
        } catch (Exception ex) {

            ex.printStackTrace();
            return map;
        }
        if (list != null && list.size() > 0) {
            return list.get(0);
        } else {
            return map;
        }

    }

    class ChargeflRowMapper implements RowMapper<Map<String, Object>> {
        public Map<String, Object> mapRow(final ResultSet rs,
                                          final int rownum) throws SQLException {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("schemeId", rs.getString("schemeId"));
            map.put("schemeNo", rs.getString("schemeNo"));
            map.put("schemeType", rs.getString("schemeType"));
            map.put("unitPrice1", rs.getDouble("unitPrice1"));
            map.put("unitPrice2", rs.getDouble("unitPrice2"));
            map.put("unitPrice3", rs.getDouble("unitPrice3"));
            map.put("schemeName", rs.getString("schemeName"));
            map.put("minCharge", rs.getDouble("minCharge"));
            map.put("isReturn", rs.getString("isReturn"));
            logger.debug("............schemeType.................." + rs.getString("schemeType"));
            return map;
        }
    }

    @Override
    public boolean addScheme(Map<String, String> map, String subburo, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String uuid = UuidUtils.generateUuidString();
        try {
            if ("01".equals(map.get("billingType"))) {
                if (!"".equals(map.get("addClosingPeriod"))) {
                    sql.append("insert into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,valid,creator,createTime)");

                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = ebikeJdbcTemplate.update(
                        sql.getSql(),
                        new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "01", map.get("unitPrice1")
                            , map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1")
                            , map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge")
                            , map.get("addIsReturn"), map.get("addClosingPeriod"), "T", orgName, new Date()
                        });
                } else {
                    sql.append("insert into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,valid,creator,createTime)");

                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = ebikeJdbcTemplate.update(
                        sql.getSql(),
                        new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "01", map.get("unitPrice1")
                            , map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1")
                            , map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge")
                            , map.get("addIsReturn"), "T", orgName, new Date()
                        });
                }
            } else if ("02".equals(map.get("billingType"))) {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,minCharge,unitPrice1,closingPeriod,schemeDetails,");
                sql.append("isReturn,valid,creator,createTime)");

                sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                results = ebikeJdbcTemplate.update(
                    sql.getSql(),
                    new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "02", map.get("minCharge"), map.get("unitPrice"), map.get("addClosingPeriod"), map.get("schemeDetails"), "Y", "T", orgName, new Date()
                    });
            } else if ("05".equals(map.get("billingType"))) {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,schemeDetails,valid,creator,createTime)");

                sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                results = ebikeJdbcTemplate.update(
                    sql.getSql(),
                    new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "05", map.get("unitPrice1")
                        , map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1")
                        , map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge")
                        , map.get("addIsReturn"), map.get("addClosingPeriod"), map.get("schemeDetails"), "T", orgName, new Date()
                    });
            } else {
                sql.append("insert into ebike.ebike_billingscheme");
                sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,");
                sql.append("isReturn,valid,creator,createTime)");

                sql.append("values(?,?,?,?,?,?,?,?,?,?,?)");
                results = ebikeJdbcTemplate.update(
                    sql.getSql(),
                    new Object[]{uuid, map.get("billingNo"), map.get("schemeName"), subburo, subburo, "03", map.get("unitPrice"), "N", "T", orgName, new Date()
                    });
            }
            logger.debug(" ========insertFl=========" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean modifyScheme(Map<String, String> map, String subburo, String orgName) {

        Map<String, Object> maps = getScheInfoById(map.get("schemeId"));
        logger.debug(">>>>>>>>getScheInfoById><<<<<<<<<<<<<" + maps.toString());
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            if ("01".equals(map.get("billingType"))) {
                if (!"".equals(map.get("addClosingPeriod"))) {
                    logger.debug(">>>>>>>>>>>>>>modifyScheme1<<<<<<<<<<<" + subburo);
                    sql.append("replace into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,closingPeriod,valid,creator,createTime,updater,updateTime)");
                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = ebikeJdbcTemplate.update(
                        sql.getSql(),
                        new Object[]{map.get("schemeId"), map.get("billingNo"), map.get("schemeName"), subburo, subburo, map.get("billingType"), map.get("unitPrice1")
                            , map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1")
                            , map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge")
                            , map.get("addIsReturn"), map.get("addClosingPeriod"), "T", maps.get("creator"), maps.get("createTime"), orgName, new Date()
                        });
                } else {
                    sql.append("replace into ebike.ebike_billingscheme");
                    sql.append("(schemeId,schemeNo,schemeName,buro,subburo,schemeType,unitPrice1,unitPrice2,unitPrice3,unitPrice4,stepCount");
                    sql.append(" ,stepPower1,stepPower2,stepPower3,minCharge,isReturn,valid,creator,createTime,updater,updateTime)");

                    sql.append("values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                    results = ebikeJdbcTemplate.update(
                        sql.getSql(),
                        new Object[]{map.get("schemeId"), map.get("billingNo"), map.get("schemeName"), subburo, subburo, map.get("billingType"), map.get("unitPrice1")
                            , map.get("unitPrice2"), map.get("unitPrice3"), map.get("unitPrice4"), 4, map.get("stepPower1")
                            , map.get("stepPower2"), map.get("stepPower3"), map.get("minCharge")
                            , map.get("addIsReturn"), "T", maps.get("creator"), maps.get("createTime"), orgName, new Date()
                        });
                }
            } else if ("02".equals(map.get("billingType"))) {
                sql.append("  update ebike.ebike_billingscheme set schemeType='02' ");
                sql.append(" ,isReturn='Y' ");
                sql.append(" ,schemeName =?", map.get("schemeName"));
                sql.append(" ,closingPeriod =?", map.get("addClosingPeriod"));
                sql.append(",updater=? ", orgName);
                sql.append(" ,unitPrice1=? ", map.get("unitPrice"));
                sql.append(" ,minCharge=? ", map.get("minCharge"));
                sql.append(" ,schemeDetails=? ", map.get("schemeDetails"));
                sql.append(" ,updateTime=? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", map.get("schemeId"));
                results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            } else if ("05".equals(map.get("billingType"))) {
                sql.append("  update ebike.ebike_billingscheme set schemeType = '05' ");
                sql.append(" ,isReturn='Y' ");
                sql.append(" ,schemeName =?", map.get("schemeName"));
                sql.append(" ,closingPeriod =?", map.get("addClosingPeriod"));
                sql.append(",updater=? ", orgName);
                sql.append(" ,unitPrice1=? ", map.get("unitPrice1"));
                sql.append(" ,unitPrice2=? ", map.get("unitPrice2"));
                sql.append(" ,unitPrice3=? ", map.get("unitPrice3"));
                sql.append(" ,unitPrice4=? ", map.get("unitPrice4"));
                sql.append(" ,stepPower1=? ", map.get("stepPower1"));
                sql.append(" ,stepPower2=? ", map.get("stepPower2"));
                sql.append(" ,stepPower3=? ", map.get("stepPower3"));
                sql.append(" ,minCharge=? ", map.get("minCharge"));
                sql.append(" ,schemeDetails=? ", map.get("schemeDetails"));
                sql.append(" ,updateTime=? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", map.get("schemeId"));
                results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            } else {
                sql.append("  update ebike.ebike_billingscheme set schemeType='03',unitPrice2=0.00,unitPrice3=0.00,unitPrice4=0.00,stepCount=null, stepPower1=null,stepPower2=null,minCharge=null,closingPeriod=null");
                sql.append(" ,stepPower3=null,minCharge=0.00,isReturn='N',closingPeriod=null ");
                sql.append(" ,schemeName =?", map.get("schemeName"));
                sql.append(",updater=? ", orgName);
                sql.append(" ,unitPrice1=? ", map.get("unitPrice"));
                sql.append(" ,updateTime=? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                sql.append(" where 1=1 ");
                sql.append(" and schemeId=? ", map.get("schemeId"));
                results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            }
            logger.debug(" ========modifyScheme=========" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public Map<String, Object> getScheInfoById(String id) {

        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append("select creator,createTime,subburo from ebike.ebike_billingscheme b where 1=1");
            sql.append(" and schemeId=?", id);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    public boolean updateFl(String id, String schemeNo, String subburo, String schemeName, String schemeType, String isReturn, double unitPrice1, double unitPrice2, double unitPrice3, double dj, double minimumCharge, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("update ebike.ebike_billingscheme set ");
            sql.append("schemeNo = ?", schemeNo);
            sql.append(" ,schemeName=?", schemeName);
            sql.append(" ,schemeType=?", schemeType);
            sql.append(" ,unitPrice1=?", String.valueOf(unitPrice1));
            sql.append(" ,unitPrice2=?", String.valueOf(unitPrice2));
            sql.append(" ,unitPrice3=?", String.valueOf(unitPrice3));
            sql.append(" ,minCharge=?", String.valueOf(minimumCharge));
            sql.append(" ,isReturn=?", isReturn);
            sql.append(" ,updater=?", name);
            sql.append(" ,updateTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
            sql.append(" where 1=1 ");
            sql.append(" and  schemeId=?", id);
            sql.append(" and ( buro=?", subburo);
            sql.append(" or subburo=? )", subburo);
            results = ebikeJdbcTemplate.update(
                sql.getSql(), sql.getParams());
            logger.debug(" ========UpdateFl=========" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public String getbh(String subburo, String schemeType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String flawNo = "";
        try {
            sql.append("select max(cast(SUBSTRING(schemeNo,4)  as SIGNED INTEGER )) from ebike.ebike_billingscheme where 1=1 and  schemeNo not in ('FREE') ");
            sql.append(" and ( subburo=?", subburo);
            sql.append(" or buro = ? )", subburo);
            String maxFlawNo = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            logger.debug(">>>>>>>>>>>>>maxFlawNo<<<<<<<<<<<<<<" + maxFlawNo);
            if (maxFlawNo == null || "".equals(maxFlawNo)) {
                if (StrUtil.equals(schemeType, "01")) {
                    flawNo = "JS-000001";
                } else if (StrUtil.equals(schemeType, "02")) {
                    flawNo = "JL-000001";
                } else if (StrUtil.equals(schemeType, "05")) {
                    flawNo = "JP-000001";
                } else {
                    flawNo = "JC-000001";
                }
                logger.debug(">>>>>>>>>>>>>flawNo<<<<<<<<<<<<<<" + flawNo);
            } else {
                if (StrUtil.equals(schemeType, "01")) {
                    flawNo = getNewEquipmentNo("JS-", maxFlawNo);
                } else if (StrUtil.equals(schemeType, "02")) {
                    flawNo = getNewEquipmentNo("JL-", maxFlawNo);
                } else if (StrUtil.equals(schemeType, "05")) {
                    flawNo = getNewEquipmentNo("JP-", maxFlawNo);
                } else {
                    flawNo = getNewEquipmentNo("JC-", maxFlawNo);
                }

                logger.debug(">>>>>>>>>>>>>flawNo1111<<<<<<<<<<<<<<" + flawNo);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return flawNo;
        }
        return flawNo;
    }

    public static String getNewEquipmentNo(String equipmentType, String equipmentNo) {
        String newEquipmentNo = "000001";
        if (equipmentNo != null && !equipmentNo.isEmpty()) {
            int newEquipment = Integer.parseInt(equipmentNo) + 1;
            newEquipmentNo = String.format(equipmentType + "%06d", newEquipment);
        }
        return newEquipmentNo;
    }

    //	public  String getNextStr(String string){
//		String returnStr = "";
//		String titlle="";
//		int No=0;
//		String a[]=string.split("-");
//		for(int i=0;i<a.length;i++)
//		{
//			if(!"JF".equals(a[i]))
//			{
//				No=Integer.parseInt(a[i])+1;
//			}else{
//				titlle=a[i];
//			}
//		}
//		returnStr=titlle+"-"+String.valueOf(No);
//		return returnStr;
//	}
    public String getCostNextStr(String string) {
        String returnStr = "";
        String titlle = "";
        int no = 0;
        String a[] = string.split("-");
        for (int i = 0; i < a.length; i++) {
            if (!"DJ".equals(a[i])) {
                no = Integer.parseInt(a[i]) + 1;
            } else {
                titlle = a[i];
            }
        }
        returnStr = titlle + "-" + String.valueOf(no);
        return returnStr;
    }

    private void getNextIndex(char[] chars, int cIndex) {
        char value = chars[cIndex];
        if (value == '9') {
            chars[cIndex] = '9';
            if (cIndex >= 1) {
                getNextIndex(chars, cIndex - 1);
            }
        } else {
            chars[cIndex]++;
        }
    }

    @Override
    public List<Map<String, Object>> queryStationflList(String subburo, Map<String, String> map, int start, int limit) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append("select  a.ID, a.stationNo,b.NAME,c.chargedeviceNo,b.STATUS,c.plugCount,d.schemeName,d.schemeId");
            sql.append(" from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
            sql.append(" and a.stationNo like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and b.NAME like ?", "%" + map.get("name") + "%");
            sql.append(" and ( b.SUBBURO=?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            if ("01".equals(map.get("devflsz"))) {
                sql.append(" and d.schemeId is not null");
            } else if ("02".equals(map.get("devflsz"))) {
                sql.append(" and d.schemeId is null");
            }
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", start);
                sql.append(" , ? ", limit);
            }

            logger.debug(sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            return list;

        }
        return list;
    }

    @Override
    public int getChargeStationflCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_bs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_billingscheme d on (f.schemeId=d.schemeId) where 1=1 ");
            sql.append(" and a.stationNo like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and b.NAME like ?", "%" + map.get("name") + "%");
            sql.append(" and ( b.SUBBURO=?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            if ("01".equals(map.get("devflsz"))) {
                sql.append(" and f.schemeId is not null");
            } else if ("02".equals(map.get("devflsz"))) {
                sql.append(" and f.schemeId is null");
            }
            logger.debug(">>>>>>>>>>>>>>>>>>>>>>getChargeStationflCount<<<<<<<<<<<<<<<<<<<<<<<" + sql.toString());
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean addflsz(String schemeId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {

            sql.append("replace into ebike.ebike_cs_bs_rela ");
            sql.append("(chargestationId,schemeId,effTime)");
            sql.append("values(?,?,?)");
            results = ebikeJdbcTemplate.update(
                sql.getSql(),
                new Object[]{stationId, schemeId,
                    new Date()});
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public boolean checkSchemeId(String schemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append("select count(1) from ebike.ebike_csbs_info  where 1=1  and  (schemeId in (?) ", schemeId, ",");
            sql.append(" or newSchemeId in (?)) ", schemeId, ",");
            result = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>>>>>>>>>>>>checkSchemeId<<<<<<<<<<<<<<<<<" + result);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (result > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public List<Map<String, Object>> queryStationCostList(String subburo, Map<String, String> map, int start, int limit) {

        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.ID, a.stationNo,b.NAME,c.chargedeviceNo,b.STATUS,c.plugCount,d.costSchemeId,d.costSchemeName ");
            sql.append(" from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_cs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_costscheme d on (f.costSchemeId=d.costSchemeId) where 1=1  ");
            sql.append(" and b.STATUS = ?", map.get("devStatus"));
            sql.append(" and c.chargedeviceNo like ?", "%" + map.get("devNo") + "%");
            sql.append(" and ( b.SUBBURO=?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            if ("01".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is not null");
            } else if ("02".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is null");
            }
            if (start != -1 && limit != -1) {
                sql.append(" limit ? ", start);
                sql.append(" , ? ", limit);
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            return list;

        }
        return list;

    }

    @Override
    public int getStationCostCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from cisp_dev.dev_ebikechargestation a left join cisp_dev.dev_powersystemresource b on a.id=b.id");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.id=c.chargestationId ");
            sql.append(" left join ebike.ebike_cs_cs_rela f on (f.chargestationId=a.ID) left JOIN ebike.ebike_costscheme d on (f.costSchemeId=d.costSchemeId) where 1=1  ");
            sql.append(" and b.STATUS = ?", map.get("devStatus"));
            sql.append(" and c.chargedeviceNo like ?", "%" + map.get("devNo") + "%");
            sql.append(" and ( b.SUBBURO=?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            if ("01".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is not null");
            } else if ("02".equals(map.get("cost"))) {
                sql.append(" and f.costSchemeId is null");
            }
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            return 0;

        }
    }

    @Override
    public List<Map<String, Object>> queryCostList(String subburo, Map<String, String> map) {

        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.costSchemeId, a.costSchemeNo,a.costSchemeName,a.costUnitPrice");
            sql.append(" from ebike.ebike_costscheme a where 1=1 ");
            sql.append(" and a.costSchemeNo like ?", "%" + map.get("costNo") + "%");
            sql.append(" and a.costSchemeName like ?", "%" + map.get("costName") + "%");
            sql.append(" and ( a.SUBBURO = ?", subburo);
            sql.append(" or a.BURO = ? ", subburo);
            if ("0".equals(map.get("flag"))) {
                sql.append(" or a.SUBBURO = '000000000')");
            } else {
                sql.append(" ) ");
            }
            sql.append(" and a.valid='T' ");
            sql.append(" order by a.costSchemeNo");
            logger.debug(">>>>>>>>>>queryCostList111<<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>queryCostList<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            return list;

        }
        return list;

    }

    @Override
    public int getCostCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_costscheme a where 1=1 ");
            sql.append(" and a.costSchemeNo like ?", "%" + map.get("costNo") + "%");
            sql.append(" and a.costSchemeName like ?", "%" + map.get("costName") + "%");
            sql.append(" and ( a.SUBBURO = ?", subburo);
            sql.append(" or a.BURO = ? ", subburo);
            sql.append(" or a.SUBBURO = '10')");
            sql.append(" and a.valid='T' ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            return 0;

        }
    }

    @Override
    public String getCostbh(String subburo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
//    	TaskNoRule taskNoRule = new TaskNoRule();
        int flowNum = 0;
        String flawNo = "";
        try {


            sql.append("select max(cast(SUBSTRING(costSchemeNo,4)  as SIGNED INTEGER )) from ebike.ebike_costscheme where 1=1  and  costSchemeNo!='INIT' ");
            sql.append(" and ( subburo = ?", subburo);
            sql.append(" or buro = ? )", subburo);
            String maxFlawNo = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            logger.debug(">>>>>>>>>>>>>maxFlawNo<<<<<<<<<<<<<<" + maxFlawNo);
            if (maxFlawNo == null || "".equals(maxFlawNo)) {
                flawNo = "DJ-000001";
                logger.debug(">>>>>>>>>>>>>flawNo<<<<<<<<<<<<<<" + flawNo);
            } else {
                //String maxFlawNos[]=maxFlawNo.split("-");
                flawNo = getNewEquipmentNo("DJ-", maxFlawNo);
                logger.debug(">>>>>>>>>>>>>flawNo1111<<<<<<<<<<<<<<" + flawNo);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return flawNo;
        }
        return flawNo;
    }

    @Override
    public boolean addStationCost(String costSchemeId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" replace into ebike.ebike_cs_cs_rela ");
            sql.append("(chargestationId,costSchemeId,effTime)");
            sql.append("values(?,?,?)");
            results = ebikeJdbcTemplate.update(
                sql.getSql(),
                new Object[]{stationId, costSchemeId,
                    new Date()});
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean insertCost(String id, String costSchemeNo, String subburo, String costSchemeName,
                              double costUnitPrice, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("insert into ebike.ebike_costscheme");
            sql.append("(costSchemeId,buro,subburo,costSchemeNo,costSchemeName,costUnitPrice,creator,createTime)");
            sql.append("values(?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(
                sql.getSql(),
                new Object[]{id, subburo,
                    subburo, costSchemeNo, costSchemeName, costUnitPrice, name, new Date()});
            logger.debug(" ========UpdateFl=========" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean updateCost(String id, String costSchemeNo, String subburo, String costSchemeName,
                              double costUnitPrice, String name) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("update ebike.ebike_costscheme set ");
            sql.append(" buro=? ", subburo);
            sql.append(" ,subburo=? ", subburo);
            sql.append(" ,costSchemeNo=? ", costSchemeNo);
            sql.append(" ,costSchemeName=? ", costSchemeName);
            sql.append(" ,costUnitPrice=? ", String.valueOf(costUnitPrice));
            sql.append(" ,updater=? ", name);
            sql.append(" ,updateTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DOT_AND_COLON));
            sql.append(" where costSchemeId=? ", id);
            results = ebikeJdbcTemplate.update(
                sql.getSql(), sql.getParams());
            logger.debug(" ========UpdateFl=========" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean checkCostExist(String costSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append("select count(1) from ebike.ebike_cs_cs_rela c where 1=1 and costSchemeId in (?)", costSchemeId, ",");
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean delCost(String costSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        if (costSchemeId == null || "".equals(costSchemeId)) {
            return false;
        }
        try {
            sql.append(" update ebike.ebike_costscheme set valid='F' where 1=1");
            sql.append(" and costSchemeId in (?)", costSchemeId, ",");
            ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteflById(String ids) {
        logger.debug("ids========================" + ids);
        if (ids == null || "".equals(ids)) {
            return false;
        }
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" delete from ebike.ebike_cs_bs_rela  where chargestationId in (?) ", ids, ",");
        if (logger.isDebugEnabled()) {
            logger.debug(">>>>>>>>>>>>>>>>>>deleopperson<<<<<<<<<<<<<<<<<=" + sql.toString());
        }
        try {
            ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean checkNoExist(String schNo, String subburo) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_billingscheme where 1=1 ");
            sql.append(" and schemeNo=? ", schNo);
            sql.append(" and ( SUBBURO=?", subburo);
            sql.append(" or BURO = ? )", subburo);
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>>>>>checkNoExist<<<<<<<<<<<<<<<<<<<<<<" + results);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean checkCostNoExist(String costNo, String subburo) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_costscheme where 1=1 ");
            sql.append(" and costSchemeNo=? ", costNo);
            sql.append(" and ( SUBBURO=?", subburo);
            sql.append(" or BURO = ? )", subburo);
            results = (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>>>>>checkNoExist<<<<<<<<<<<<<<<<<<<<<<" + results);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean addCost(String uuid, String stationId, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_cscs_info(cscsId,chargestationId,cscsStatus,costSchemeId,effTime)");
            sql.append(" values(?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    uuid, stationId, "00", "INIT", new Date()
                });
            results = addCostInfo(uuid, stationId);
            results = updateOpLog(uuid, orgName, "10", "00");
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public int addCostInfo(String uuid, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_cs_cs_rela(chargestationId,costSchemeId,effTime)");
            sql.append(" values(?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    stationId, uuid, new Date()
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public boolean addCsbsInfo(String uuid, String schemeId, String stationId, String orgName) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_csbs_info(csbsId,chargestationId,csbsType,csbsStatus,schemeId,effTime)");
            sql.append(" values(?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    uuid, stationId, "00", "00", schemeId, new Date()
                });
            results = addcsbsOpLog(uuid, "10", "00", orgName);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public int addcsbsOpLog(String csbsId, String logType, String csshdsStatus, String operator) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            return ebikeJdbcTemplate.update(sql.getSql(), new Object[]{
                csbsId, logType, new Date(), csshdsStatus, operator
            });

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int updateOpLog(String cscsId, String orgName, String logType, String status) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        int count = 0;
        try {
            sql.append(" insert into ebike.ebike_log_cscs_info(cscsId,logType,logTime,cscsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    cscsId, logType, new Date(), status, orgName,
                });

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> queryBathInfos(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.stationNo,a.ID,a.STATIONADDR,d.status,d.NAME,b.CHARGEDEVICENO,c.schemeId,c.schemeName ");
            sql.append("  from cisp_dev.dev_ebikechargestation  a  ");
            sql.append(" left join  ebike.ebike_csbs_info e on ( e.chargestationId=a.ID and e.csbsType='00')  ");
            sql.append("  left join ebike.ebike_billingscheme c  on e.schemeId=c.schemeId ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
            sql.append("  left join cisp_dev.dev_powersystemresource d on d.ID=a.ID where 1=1  ");
            sql.append(" and a.id NOT IN (select chargestationId from ebike.ebike_cssh_distscheme) ");
            sql.append(" and a.stationNo like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and d.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and d.status=?", map.get("status"));
            sql.append(" and ( d.SUBBURO = ?", subburo);
            sql.append(" or d.BURO = ? ) ", subburo);
            sql.append(" group by a.stationNo  ");
            sql.append(" order by d.createDate desc ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", starts);
                sql.append(" , 10 ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("schemeId", rs.getString("schemeId"));
                        map.put("ID", rs.getLong("ID"));
                        map.put("stationAddr", rs.getString("STATIONADDR"));
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("stationName", rs.getString("NAME"));
                        map.put("status", rs.getString("status"));
                        map.put("deviceNo", rs.getString("CHARGEDEVICENO"));
                        map.put("schemeName", rs.getString("schemeName"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>>>queryBathInfos<<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            return list;

        }
        return list;
    }

    /***
     * @Description TODO  汽车批量计费设置查询
     * @author zhouyi
     * @return java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @data 2021/8/3
     * @param subburo
     * @param map
     * @param start
     */
    @Override
    public List<Map<String, Object>> queryBathCarInfos(String subburo, Map<String, String> map, int start) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" SELECT a.id AS stationId,a.charging_station_name AS stationName,a.charging_station_addr AS stationAddr,");
            sql.append("CASE a.charging_station_status when 1 then '初始'  when 2 then '待运'  when 3 then '运行'  when 4 then '暂停'  when 9 then '退运' END AS stationStatus,");
            sql.append("CASE a.charging_station_type when 1 then '公共' when 2 then '个人' when 11 then '公交(专用)' when 12 then '环卫(专用)' when 13 then '物流(专用)' when 14 then '出租车(专用)' when 99 then '其他' END AS stationType,");
            sql.append("GROUP_CONCAT( DISTINCT(c.charging_pile_no) ORDER BY c.charging_pile_no ASC ) AS chargingPileNo,");
            sql.append("e.tmpl_name AS tmplName,f.schemeId,d.billing_tmpl_id AS tmplId,e.billing_interval AS billingInterval, ");
            sql.append("e.billing_params ->> '$.price_service' AS priceService,");
            sql.append("e.billing_params ->> '$.price_rate_type' AS priceRateType,e.billing_params AS billingParams,e.tmpl_no AS tmplNo,");
            sql.append("CASE e.billing_model when '1' THEN '本地计费' WHEN 2 THEN '主站计费' END AS billingModel");
            sql.append("  FROM oper_ev_charging_station a  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr b ON b.subburo = a.org_no  ");
            sql.append("  LEFT JOIN ebike.ebike_billingscheme f ON f.subburo = a.org_no ");
            sql.append("  LEFT JOIN dev_ev_charging_pile c ON a.id = c.charging_station_id ");
            sql.append("  LEFT JOIN oper_ev_charging_station_billing_info d ON a.id = d.charging_station_id  ");
            sql.append("LEFT JOIN tmpl_billing e ON e.id = d.billing_tmpl_id WHERE 1=1");
            sql.append(" and a.charging_station_addr like ?", "%" + map.get("stationAddr") + "%");
            sql.append(" and a.charging_station_name like ?", "%" + map.get("stationName") + "%");
            sql.append(" and a.charging_station_status=?", map.get("status"));
            sql.append(" and  a.org_no = ?", subburo);
            sql.append(" group by a.id  ");
            if (start == 1) {
                sql.append(" limit 0,10 ");
            } else {
                int starts = (start - 1) * 10;
                int end = start * 10;
                sql.append(" limit ? ", starts);
                sql.append(" , 10 ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("tmplId", rs.getString("tmplId"));
                        map.put("schemeId", rs.getString("schemeId"));
                        map.put("stationId", rs.getString("stationId"));
                        map.put("stationType", rs.getString("stationType"));
                        map.put("stationAddr", rs.getString("stationAddr"));
                        map.put("stationName", rs.getString("stationName"));
                        map.put("status", rs.getString("stationStatus"));
                        map.put("chargingPileNo", rs.getString("chargingPileNo"));
                        map.put("tmplName", rs.getString("tmplName"));
                        map.put("priceRateType", rs.getString("priceRateType"));
                        map.put("billingParams", rs.getString("billingParams"));
                        map.put("tmplNo", rs.getString("tmplNo"));
                        map.put("billingModel", rs.getString("billingModel"));
                        map.put("priceService", rs.getString("priceService"));
                        map.put("billingInterval", rs.getString("billingInterval"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>>>queryBathCarInfos<<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            return list;

        }
        return list;
    }

    @Override
    public int queryBathCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select sum(count) from (  select count(1)  as count from cisp_dev.dev_ebikechargestation  a  ");
            sql.append(" left join  ebike.ebike_csbs_info e on ( e.chargestationId=a.ID and e.csbsType='00') ");
            sql.append("  left join ebike.ebike_billingscheme c  on e.schemeId=c.schemeId ");
            //sql.append("  left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
            sql.append("  left join cisp_dev.dev_powersystemresource d on d.ID=a.ID where 1=1  ");
            sql.append(" and a.id NOT IN (select chargestationId from ebike.ebike_cssh_distscheme) ");
            sql.append(" and a.stationNo like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and d.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and d.status=?", map.get("status"));
            sql.append(" and ( d.SUBBURO = ?", subburo);
            sql.append(" or d.BURO = ? ) ", subburo);
            sql.append(" group by a.stationNo  ) n");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            return 0;

        }
    }

    @Override
    public int queryBathCarCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" SELECT COUNT(1) FROM (");
            sql.append(" SELECT a.id AS stationId,a.charging_station_no AS stationNo,a.charging_station_name AS stationName,a.charging_station_addr AS stationAddr,");
            sql.append("CASE a.charging_station_status when 1 then '初始'  when 2 then '待运'  when 3 then '运行'  when 4 then '暂停'  when 9 then '退运' END AS stationStatus,");
            sql.append("CASE a.charging_station_type when 1 then '公共' when 2 then '个人' when 11 then '公交(专用)' when 12 then '环卫(专用)' when 13 then '物流(专用)' when 14 then '出租车(专用)' when 99 then '其他' END AS stationType,");
            sql.append("GROUP_CONCAT( c.charging_pile_no ORDER BY c.charging_pile_no ASC ) AS chargingPileNo,");
            sql.append("e.tmpl_name AS tmplName,f.schemeId");
            sql.append("  FROM oper_ev_charging_station a  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr b ON b.subburo = a.org_no  ");
            sql.append("  LEFT JOIN ebike.ebike_billingscheme f ON f.subburo = a.org_no ");
            sql.append("  LEFT JOIN dev_ev_charging_pile c ON a.id = c.charging_station_id ");
            sql.append("  LEFT JOIN oper_ev_charging_station_billing_info d ON a.id = d.charging_station_id  ");
            sql.append("LEFT JOIN tmpl_billing e ON e.id = d.billing_tmpl_id WHERE 1=1");
            sql.append(" and a.charging_station_no like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and a.charging_station_name like ?", "%" + map.get("stationName") + "%");
            sql.append(" and a.charging_station_status=?", map.get("status"));
            sql.append(" and  a.org_no = ?", subburo);
            sql.append(" group by a.id) AS g ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            return 0;

        }
    }

    @Override
    public Map<String, Object> getSchemeInfoById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> maps = new HashMap<String, Object>();
        try {
            sql.append(" select *  from ebike.ebike_billingscheme where 1=1  ");
            sql.append(" and schemeId=? ", id);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("schemeId", rs.getString("schemeId"));
                        map.put("schemeNo", rs.getString("schemeNo"));
                        map.put("schemeType", rs.getString("schemeType"));
                        map.put("unitPrice1", rs.getDouble("unitPrice1"));
                        map.put("unitPrice2", rs.getDouble("unitPrice2"));
                        map.put("unitPrice3", rs.getDouble("unitPrice3"));
                        map.put("unitPrice4", rs.getDouble("unitPrice4"));
                        map.put("stepPower1", rs.getInt("stepPower1"));
                        map.put("stepPower2", rs.getInt("stepPower2"));
                        map.put("stepPower3", rs.getInt("stepPower3"));
                        map.put("stepPower4", rs.getInt("stepPower4"));
                        map.put("schemeName", rs.getString("schemeName"));
                        map.put("minCharge", rs.getDouble("minCharge"));
                        if ("Y".equals(rs.getString("isReturn"))) {
                            map.put("isReturn", "预付可退");
                        } else {
                            map.put("isReturn", "预付不退");
                        }

                        map.put("closingPeriod", rs.getInt("closingPeriod"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>>>getSchemeInfoById<<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            return maps;

        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    @Override
    public int modifyStationScheme(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //String [] ids=stationIds.split(",");
        //logger.debug(">>>>>>>>>>><stationIds<<<<<<<<<<<<<"+Long.valueOf(stationIds));
        int results = 0;
        try {
            sql.append(" update ebike.ebike_csbs_info  SET ");
            sql.append(" schemeId= ? ", schemeId);
            sql.append(" where 1=1 and csbsType='00'");
            sql.append(" and chargestationId in (?) ", stationIds, ",");
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            logger.debug(">>>>>>modifyStationScheme+result><<<<<<<<<<<<" + results);
            results = updateScheInfo(schemeId, stationIds);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int modifyCarStationScheme(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //String [] ids=stationIds.split(",");
        //logger.debug(">>>>>>>>>>><stationIds<<<<<<<<<<<<<"+Long.valueOf(stationIds));
        int results = 0;
        try {
            sql.append(" update ebike.oper_ev_charging_station_billing_info  SET ");
            sql.append(" billing_tmpl_id= ? ", schemeId);
            sql.append(" where 1=1");
            sql.append(" and charging_station_id in (?) ", stationIds, ",");
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            logger.debug(">>>>>>modifyStationScheme+result><<<<<<<<<<<<" + results);
            results = updateScheInfo(schemeId, stationIds);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int updateScheInfo(String schemeId, String stationIds) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //String [] ids=stationIds.split(",");
        int results = 0;
        try {
            sql.append(" update ebike.ebike_cs_bs_rela  SET  ");
            sql.append(" schemeId =? ", schemeId);
            sql.append("  where 1=1 ");
            sql.append(" and chargestationId in (?) ", stationIds, ",");
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}
