package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeRevDao;
import com.ebike.openservices.oprmgmt.util.EbikeCommonUtil;
import com.ebike.openservices.oprmgmt.util.YunRuiCommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.*;

//import cn.cc.cisp.code.util.CodeUtil;
//import cn.cc.cisp.logging.CispLogger;
//import cn.yunrui.chargebike.asset.dao.ChargeRevDao;
//import cn.yunrui.chargebike.asset.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.YunRuiCommonUtil;

@Repository
public class ChargeRevDaoImpl extends AbstractEbikeBaseJdbcDao implements ChargeRevDao {

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeRevDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    @Override
    public List<Map<String, String>> getstakeholderList(String subbro) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, String>> list = new ArrayList<Map<String, String>>();
        try {
            sql.append("select DISTINCT(a.stakeholderOrgNo),c.ORG_NAME as 'stakeholderName' from ebike.ebike_cssh_distscheme a ");
            sql.append("  left join cisp_sys.bp_org c on (a.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            sql.append(" and a.orgoprOrgNo= ?", subbro);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, String>>() {
                    public Map<String, String> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, String> map = new HashMap<String, String>();
                        map.put("stakeholderId", rs.getString("stakeholderOrgNo"));
                        map.put("stakeholderName", rs.getString("stakeholderName"));
                        return map;
                    }
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getRevenueInMeter(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                /**
                 * 全部
                 */
                sql.append("select * from (");
                sql.append(" select 1 as type, u.chargeUserType, a.chargeOpenTime,a.chargeRecordId,a.chargeFinishTime,a.income,a.cost,a.profit,b.stationNo,c.chargedeviceNo,d.chargeplugNo,b.ID,f.NAME,f.status, ");
                sql.append("  a.serviceMoney as 'serviceCharge',IFNULL(e.distMoney, a.income - a.serviceMoney) AS distMoney , IFNULL(convert((a.cost/a.income)*100,decimal(15,2)) ,0.00)as costRatio,a.coinMoney,  ");
                sql.append(" 0.00 AS elecTotal,");
                sql.append(" 0.00 AS tmplService ");
                sql.append("  from ebike.ebike_chargerecord_his a inner join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");

                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);

                sql.append(" union all ");

                sql.append(" select 2 as type, u.chargeUserType,a.charge_open_success_time as chargeOpenTime,a.id as chargeRecordId,a.charge_finish_time as chargeFinishTime,a.charge_income as income, ");
                sql.append(" a.charge_econs_total as cost,(a.charge_income - a.platform_service_money) as profit,b.charging_station_no as stationNo,c.charging_pile_no as chargedeviceNo,");
                sql.append(" d.charging_gun_no as chargeplugNo,b.ID,b.charging_station_name as name,b.charging_station_status as status,");
                sql.append(" a.platform_service_money AS serviceCharge,nullif(1,1) AS distMoney,");
                sql.append(" IFNULL( CONVERT ( ( a.charge_econs_total / a.charge_income ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS costRatio,a.coin_money as coinMoney, ");
                sql.append(" a.charge_expense_total as elecTotal, ");
                sql.append(" a.charge_expense_service as tmplService ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" inner join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" where true ");
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
                sql.append(" ) as whole order by  chargeFinishTime DESC ");


            } else if ("2".equals(type)) {
                /**
                 * 自行车
                 */
                sql.append(" select 1 as type, u.chargeUserType, a.chargeOpenTime,a.chargeRecordId,a.chargeFinishTime,a.income,a.cost,a.profit,b.stationNo,c.chargedeviceNo,d.chargeplugNo,b.ID,f.NAME,f.status, ");
                sql.append("  a.serviceMoney as 'serviceCharge',IFNULL(e.distMoney, a.income - a.serviceMoney) AS distMoney , IFNULL(convert((a.cost/a.income)*100,decimal(15,2)) ,0.00)as costRatio,a.coinMoney,  ");
                sql.append(" 0.00 AS elecTotal,");
                sql.append(" 0.00 AS tmplService ");
                sql.append("  from ebike.ebike_chargerecord_his a inner join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");

                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);
                sql.append(" order by  a.chargeFinishTime DESC ");
            } else if ("3".equals(type)) {
                /**
                 * 汽车
                 */
                sql.append(" select 2 as type, u.chargeUserType,a.charge_open_success_time as chargeOpenTime,a.id as chargeRecordId,a.charge_finish_time as chargeFinishTime,a.charge_income as income, ");
                sql.append(" a.charge_econs_total as cost,(a.charge_income - a.platform_service_money) as profit,b.charging_station_no as stationNo,c.charging_pile_no as chargedeviceNo,");
                sql.append(" d.charging_gun_no as chargeplugNo,b.ID,b.charging_station_name as name,b.charging_station_status as status,");
                sql.append(" a.platform_service_money AS serviceCharge,nullif(1,1) AS distMoney,");
                sql.append(" IFNULL( CONVERT ( ( a.charge_econs_total / a.charge_income ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS costRatio,a.coin_money as coinMoney, ");
                sql.append(" a.charge_expense_total as elecTotal, ");
                sql.append(" a.charge_expense_service as tmplService ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" inner join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" where true ");
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
                sql.append(" order by  a.charge_finish_time DESC ");
            }
            logger.debug(sql.getSql());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("type", rs.getString("type"));
                        map.put("chargeUserType", rs.getString("chargeUserType"));
                        map.put("chargeOpenTime", rs.getTimestamp("chargeOpenTime"));
                        map.put("chargeFinishTime", rs.getTimestamp("chargeFinishTime"));
                        map.put("income", rs.getDouble("income"));
                        map.put("cost", rs.getDouble("cost"));
                        map.put("profit", rs.getDouble("profit"));
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                        map.put("chargeplugNo", rs.getString("chargeplugNo"));
                        map.put("ID", rs.getLong("ID"));
//					 map.put("RetentionMoney", rs.getDouble("RetentionMoney"));
                        map.put("NAME", rs.getString("NAME"));
                        map.put("chargeRecordId", rs.getString("chargeRecordId"));
                        map.put("status", rs.getString("status"));
                        map.put("serviceCharge", rs.getDouble("serviceCharge"));
                        map.put("distMoney", rs.getDouble("distMoney"));
                        map.put("costRatio", rs.getDouble("costRatio"));
                        map.put("coinMoney", rs.getDouble("coinMoney"));
                        map.put("elecTotal",rs.getDouble("elecTotal"));
                        map.put("tmplService",rs.getDouble("tmplService"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>getRevenueInMeter<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getRevenueCount(String subbro, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                /**
                 * 全部
                 */
                sql.append("select sum(whole.total) from (");
                sql.append(" select count(1) as total ");
                sql.append("  from ebike.ebike_chargerecord_his a inner join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");

                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);

                sql.append("union all");

                sql.append(" select count(1) ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" inner join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" where true ");
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
                sql.append(") as whole");
            } else if ("2".equals(type)) {
                /**
                 * 自行车
                 */
                sql.append(" select count(1) ");
                sql.append("  from ebike.ebike_chargerecord_his a inner join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");

                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);
            } else if ("3".equals(type)) {
                /**
                 * 汽车
                 */
                sql.append(" select count(1) ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" inner join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" where true ");
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
            }
            logger.debug(sql.getSql());
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> getAccount(String subbro, Map<String, String> map) {
        Map<String, Object> maps = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                sql.append("select");
                sql.append(" sum(whole.tincome) as tincome, ");
                sql.append(" sum(whole.tcost) as tcost, ");
                sql.append(" sum(whole.tprofit) as tprofit, ");
                sql.append(" sum(whole.coinMoney) as coinMoney, ");
                sql.append(" sum(whole.distMoney) as distMoney ");
                sql.append("from (");

                sql.append(" select sum(a.income) as tincome,IFNULL(convert((sum(a.cost)/sum(a.income))*100,decimal(15,2)) ,0.00) as tcost,sum(a.profit) as tprofit,sum(a.coinMoney) as coinMoney,sum( IFNULL(e.distMoney, a.income - a.serviceMoney) ) AS distMoney ");
                sql.append("  from ebike.ebike_chargerecord_his a left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append("and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);
                sql.append(" and a.chargeOpenFlag ='0'");

                sql.append(" union all ");

                sql.append(" select sum(a.charge_income) as tincome, ");
                sql.append(" '0.00' as tcost, ");
                sql.append(" '0.00' as tprofit, ");
                sql.append(" sum(a.coin_money) as coinMoney, ");
                sql.append(" '0.00' as distMoney ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" left join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.ebike_chargeuser u on u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.id ");
                sql.append(" where true ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
                sql.append(" and (a.charge_status = 1 or a.charge_status = 11) ");
                sql.append(") as whole;");
            } else if ("2".equals(type)) {
                sql.append(" select sum(a.income) as 'tincome',IFNULL(convert((sum(a.cost)/sum(a.income))*100,decimal(15,2)) ,0.00) as 'tcost',sum(a.profit) as 'tprofit',sum(a.coinMoney) as coinMoney,sum( IFNULL(e.distMoney, a.income - a.serviceMoney) ) AS distMoney ");
                sql.append("  from ebike.ebike_chargerecord_his a left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID  ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID ");
                sql.append("  left join cisp_dev.dev_powersystemresource f on b.ID=f.ID");
                sql.append("  left join ebike.ebike_chargerecord_incomedetail e on (a.chargeRecordId=e.chargeRecordId and f.SUBBURO=e.distUserId) ");
                sql.append("  left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId where 1=1  ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append("and a.chargePayMode=? ", map.get("payType"));
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and ( f.SUBBURO = ?", subbro);
                sql.append(" or f.BURO = ? )", subbro);
                sql.append(" and a.chargeOpenFlag ='0'");
            } else if ("3".equals(type)) {
                sql.append(" select sum(a.charge_income) as tincome, ");
                sql.append(" '0.00' as tcost, ");
                sql.append(" '0.00' as tprofit, ");
                sql.append(" sum(a.coin_money) as coinMoney, ");
                sql.append(" '0.00' as distMoney ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" left join ebike.dev_ev_charging_gun d on a.charging_gun_id = d.id ");
                sql.append(" left join ebike.ebike_chargeuser u on u.chargeUserId = a.charge_user_id ");
                sql.append(" left join ebike.oper_ev_charging_station b on a.charging_station_id = b.id ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.id ");
                sql.append(" where true ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and d.org_no = ? ", subbro);
                sql.append(" and (a.charge_status = 1 or a.charge_status = 11) ");
            }

            logger.debug(sql.getSql());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), new ChargeflRowMapper());
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list != null && list.size() > 0) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    class ChargeflRowMapper implements RowMapper<Map<String, Object>> {
        public Map<String, Object> mapRow(final ResultSet rs,
                                          final int rownum) throws SQLException {
            Map<String, Object> map = new HashMap<String, Object>();
//			    	String unitPr2="0.0000";
//			    	String unitPr1="0.0000";
//			    	BigDecimal cost = new BigDecimal(unitPr1);
//			    	BigDecimal tcome = new BigDecimal(unitPr2);
//			    	logger.debug(unitPr1);
            double tincome = 0.00;
            double tcost = 0.00;
            double tprofit = 0.00;
            logger.debug(">>>>>>>>>>>>1<<<<<<<<<<<<<<<" + rs.getString("tincome"));
            logger.debug(">>>>>>>>>>>>2<<<<<<<<<<<<<<<" + rs.getString("tcost"));
            logger.debug(">>>>>>>>>>>>3<<<<<<<<<<<<<<<" + rs.getString("tprofit"));
            if (rs.getString("tincome") == null) {
                tincome = 0.00;
            } else {
                BigDecimal tincom = new BigDecimal(YunRuiCommonUtil.nullToEmpty(rs.getString("tincome")));
                tincome = tincom.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }
            if (rs.getString("tprofit") == null) {
                tprofit = 0.00;
            } else {
                BigDecimal tprofi = new BigDecimal(YunRuiCommonUtil.nullToEmpty(rs.getString("tprofit")));
                tprofit = tprofi.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }
            if (rs.getString("tcost") == null) {
                tcost = 0.00;

            } else {
                BigDecimal tcos = new BigDecimal(YunRuiCommonUtil.nullToEmpty(rs.getString("tcost")));
                tcost = tcos.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();
            }


            map.put("tincome", String.valueOf(tincome));
            map.put("tcost", String.valueOf(tcost));
            map.put("tprofit", String.valueOf(tprofit));
            map.put("coinMoney", rs.getDouble("coinMoney"));
            map.put("distMoney", rs.getDouble("distMoney"));
            return map;
        }

    }


    @Override
    public Map<String, Object> getSumInfo(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> maps = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //电站类型：1-全部；2-自行车；3-汽车
        String type = map.get("type");
        try {
            if ("1".equals(map.get("date"))) {
                /**
                 * 日查询
                 */
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append(" select ");
                    sql.append(" sum(whole.tcost) as tcost,sum(whole.tincome) as tincome,sum(whole.tprofit) as tprofit, ");
                    sql.append(" sum(whole.coinChargeIncome) as coinChargeIncome,sum(whole.coinChargeCost) as coinChargeCost, ");
                    sql.append(" sum(whole.coinChargeProfit) as coinChargeProfit,sum(whole.chargeIncomeByOpr) as chargeIncomeByOpr, ");
                    sql.append(" sum(whole.chargeIncomeBySh) as chargeIncomeBySh,sum(whole.csrefundMoney) as csrefundMoney, ");
                    sql.append(" sum(whole.csrefundMoneyByOpr) as csrefundMoneyByOpr,sum(whole.chargeCnt) as chargeCnt, ");
                    sql.append(" sum(whole.coinChargeCnt) as coinChargeCnt,sum(whole.csrefundCnt) as csrefundCnt ");
                    sql.append(" from ( ");
                    sql.append(" SELECT sum(tt.chargeCost) AS 'tcost',sum(tt.chargeIncome) AS 'tincome',sum(tt.chargeProfit) AS 'tprofit',sum(tt.coinChargeIncome) AS coinChargeIncome,");
                    sql.append(" sum(tt.coinChargeCost) AS coinChargeCost,sum(tt.coinChargeProfit) AS coinChargeProfit,sum(tt.chargeIncomeByOpr) AS chargeIncomeByOpr, ");
                    sql.append(" sum(tt.chargeIncomeBySh) AS chargeIncomeBySh,sum(tt.csrefundMoney) AS csrefundMoney,sum(tt.csrefundMoneyByOpr) AS csrefundMoneyByOpr,");
                    sql.append(" sum(tt.chargeCnt) AS chargeCnt,sum(tt.coinChargeCnt) AS coinChargeCnt,sum(tt.csrefundCnt) AS csrefundCnt  ");
                    sql.append(" FROM ( select f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney,f.chargeIncomeByOpr AS chargeIncomeByOpr,");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome AS coinChargeIncome,");
                    sql.append(" f.chargeIncomeBySh,f.chargeCost,f.chargeProfit,f.coinChargeCost,f.coinChargeProfit,");
                    sql.append(" f.csrefundMoney,f.csrefundMoneyByOpr,f.csrefundCnt ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId  ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' and f.maincls = '1'");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.ID ) tt ");

                    sql.append(" union all ");

                    sql.append(" select sum( tt.chargeCost ) AS tcost,sum( tt.chargeIncome ) AS tincome, sum( tt.chargeProfit ) AS tprofit,");
                    sql.append(" sum( tt.coinChargeIncome ) AS coinChargeIncome,sum( tt.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( tt.coinChargeProfit ) AS coinChargeProfit,sum( tt.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( tt.chargeIncomeBySh ) AS chargeIncomeBySh,sum( tt.csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( tt.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( tt.chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( tt.coinChargeCnt ) AS coinChargeCnt,sum( tt.csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt, ");
                    sql.append(" f.lastCoinChargeFinishTime,f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" f.chargeIncomeBySh,f.chargeCost,f.chargeProfit,f.coinChargeCost,f.coinChargeProfit, ");
                    sql.append(" f.csrefundMoney,f.csrefundMoneyByOpr,f.csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId   ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON  h.chargestationId = a.ID  ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append("  GROUP BY a.ID ) tt ");

                    sql.append(" ) as whole ");

                } else if ("2".equals(type)) {
                    //自行车
                    sql.append(" SELECT sum(tt.chargeCost) AS 'tcost',sum(tt.chargeIncome) AS 'tincome',sum(tt.chargeProfit) AS 'tprofit',sum(tt.coinChargeIncome) AS coinChargeIncome,");
                    sql.append(" sum(tt.coinChargeCost) AS coinChargeCost,sum(tt.coinChargeProfit) AS coinChargeProfit,sum(tt.chargeIncomeByOpr) AS chargeIncomeByOpr, ");
                    sql.append(" sum(tt.chargeIncomeBySh) AS chargeIncomeBySh,sum(tt.csrefundMoney) AS csrefundMoney,sum(tt.csrefundMoneyByOpr) AS csrefundMoneyByOpr,");
                    sql.append(" sum(tt.chargeCnt) AS chargeCnt,sum(tt.coinChargeCnt) AS coinChargeCnt,sum(tt.csrefundCnt) AS csrefundCnt  ");
                    sql.append(" FROM ( select f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney,f.chargeIncomeByOpr AS chargeIncomeByOpr,");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome AS coinChargeIncome,");
                    sql.append(" f.chargeIncomeBySh,f.chargeCost,f.chargeProfit,f.coinChargeCost,f.coinChargeProfit,");
                    sql.append(" f.csrefundMoney,f.csrefundMoneyByOpr,f.csrefundCnt ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId  ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' and f.maincls = '1'");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.ID ) tt ");
                } else if ("3".equals(type)) {
                    //汽车
                    sql.append(" select sum( tt.chargeCost ) AS tcost,sum( tt.chargeIncome ) AS tincome, sum( tt.chargeProfit ) AS tprofit,");
                    sql.append(" sum( tt.coinChargeIncome ) AS coinChargeIncome,sum( tt.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( tt.coinChargeProfit ) AS coinChargeProfit,sum( tt.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( tt.chargeIncomeBySh ) AS chargeIncomeBySh,sum( tt.csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( tt.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( tt.chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( tt.coinChargeCnt ) AS coinChargeCnt,sum( tt.csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt, ");
                    sql.append(" f.lastCoinChargeFinishTime,f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" f.chargeIncomeBySh,f.chargeCost,f.chargeProfit,f.coinChargeCost,f.coinChargeProfit, ");
                    sql.append(" f.csrefundMoney,f.csrefundMoneyByOpr,f.csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId   ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON  h.chargestationId = a.ID  ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append("  GROUP BY a.ID ) tt ");
                }
            } else if ("2".equals(map.get("date"))) {
                /**
                 * 月统计
                 */
                if ("1".equals(type)) {
                    //全部
                    sql.append(" select whole.tcost AS tcost,sum( whole.tincome ) AS tincome,sum( whole.tprofit ) AS tprofit, ");
                    sql.append(" sum( whole.coinChargeIncome ) AS coinChargeIncome,sum( whole.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( whole.coinChargeProfit ) AS coinChargeProfit,sum( whole.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( whole.chargeIncomeBySh ) AS chargeIncomeBySh,sum( whole.csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( whole.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( whole.chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( whole.coinChargeCnt ) AS coinChargeCnt,sum( whole.csrefundCnt ) AS csrefundCnt from (");

                    sql.append(" select sum(tcost) as 'tcost' ,sum(tincome) as 'tincome' ,sum(tprofit) as 'tprofit' ,  ");
                    sql.append(" sum(coinChargeIncome)  as coinChargeIncome,sum(coinChargeCost) as coinChargeCost,sum(coinChargeProfit) as coinChargeProfit ");
                    sql.append("  ,sum(chargeIncomeByOpr) as chargeIncomeByOpr,sum(chargeIncomeBySh) as chargeIncomeBySh,sum(csrefundMoney) as csrefundMoney,sum(csrefundMoneyByOpr) as csrefundMoneyByOpr  ");
                    sql.append(" ,sum(chargeCnt) as chargeCnt,sum(coinChargeCnt ) as coinChargeCnt,sum(csrefundCnt) as csrefundCnt  ");
                    sql.append(" from ( select IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as tcost ,ROUND(f.chargeIncome,2) as tincome, ROUND(f.chargeProfit,2) as tprofit ");
                    sql.append(" ,ROUND(f.coinChargeIncome,2)  as coinChargeIncome,ROUND(sum(f.coinChargeCost),2)  as coinChargeCost, ROUND(f.coinChargeProfit,2)  as coinChargeProfit ");
                    sql.append(" ,ROUND(f.chargeIncomeByOpr,2)  as chargeIncomeByOpr,ROUND(f.chargeIncomeBySh,2) as chargeIncomeBySh,f.csrefundMoney  as csrefundMoney ,f.csrefundMoneyByOpr as csrefundMoneyByOpr ");
                    sql.append(" ,f.chargeCnt as chargeCnt,f.coinChargeCnt as coinChargeCnt,f.csrefundCnt as csrefundCnt  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f on ( f.chargestationId=a.ID");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);

                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" where f.maincls = '1' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append(" GROUP BY a.STATIONNO ) n ");

                    sql.append(" union all ");

                    sql.append(" select sum( tcost ) AS tcost,sum( tincome ) AS tincome,sum( tprofit ) AS tprofit, ");
                    sql.append(" sum( coinChargeIncome ) AS coinChargeIncome,sum( coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( coinChargeProfit ) AS coinChargeProfit,sum( chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( chargeIncomeBySh ) AS chargeIncomeBySh,sum( csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( coinChargeCnt ) AS coinChargeCnt,sum( csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS tcost, ");
                    sql.append(" ROUND( f.chargeIncome, 2 ) AS tincome,ROUND( f.chargeProfit, 2 ) AS tprofit, ");
                    sql.append(" ROUND( f.coinChargeIncome, 2 ) AS coinChargeIncome,ROUND( sum( f.coinChargeCost ), 2 ) AS coinChargeCost, ");
                    sql.append(" ROUND( f.coinChargeProfit, 2 ) AS coinChargeProfit,ROUND( f.chargeIncomeByOpr, 2 ) AS chargeIncomeByOpr, ");
                    sql.append(" ROUND( f.chargeIncomeBySh, 2 ) AS chargeIncomeBySh,f.csrefundMoney AS csrefundMoney, ");
                    sql.append(" f.csrefundMoneyByOpr AS csrefundMoneyByOpr,f.chargeCnt AS chargeCnt, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.csrefundCnt AS csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( f.chargestationId=a.ID ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);

                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON  h.chargestationId = a.ID  ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) n ");

                    sql.append(" ) as whole ");
                } else if ("2".equals(type)) {
                    //自行车
                    sql.append(" select sum(tcost) as 'tcost' ,sum(tincome) as 'tincome' ,sum(tprofit) as 'tprofit' ,  ");
                    sql.append(" sum(coinChargeIncome)  as coinChargeIncome,sum(coinChargeCost) as coinChargeCost,sum(coinChargeProfit) as coinChargeProfit ");
                    sql.append("  ,sum(chargeIncomeByOpr) as chargeIncomeByOpr,sum(chargeIncomeBySh) as chargeIncomeBySh,sum(csrefundMoney) as csrefundMoney,sum(csrefundMoneyByOpr) as csrefundMoneyByOpr  ");
                    sql.append(" ,sum(chargeCnt) as chargeCnt,sum(coinChargeCnt ) as coinChargeCnt,sum(csrefundCnt) as csrefundCnt  ");
                    sql.append(" from ( select IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as tcost ,ROUND(f.chargeIncome,2) as tincome, ROUND(f.chargeProfit,2) as tprofit ");
                    sql.append(" ,ROUND(f.coinChargeIncome,2)  as coinChargeIncome,ROUND(sum(f.coinChargeCost),2)  as coinChargeCost, ROUND(f.coinChargeProfit,2)  as coinChargeProfit ");
                    sql.append(" ,ROUND(f.chargeIncomeByOpr,2)  as chargeIncomeByOpr,ROUND(f.chargeIncomeBySh,2) as chargeIncomeBySh,f.csrefundMoney  as csrefundMoney ,f.csrefundMoneyByOpr as csrefundMoneyByOpr ");
                    sql.append(" ,f.chargeCnt as chargeCnt,f.coinChargeCnt as coinChargeCnt,f.csrefundCnt as csrefundCnt  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f on ( f.chargestationId=a.ID");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);

                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" where f.maincls = '1' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append(" GROUP BY a.STATIONNO ) n ");
                } else if ("3".equals(type)) {
                    //汽车
                    sql.append(" select sum( tcost ) AS tcost,sum( tincome ) AS tincome,sum( tprofit ) AS tprofit, ");
                    sql.append(" sum( coinChargeIncome ) AS coinChargeIncome,sum( coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( coinChargeProfit ) AS coinChargeProfit,sum( chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( chargeIncomeBySh ) AS chargeIncomeBySh,sum( csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( coinChargeCnt ) AS coinChargeCnt,sum( csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS tcost, ");
                    sql.append(" ROUND( f.chargeIncome, 2 ) AS tincome,ROUND( f.chargeProfit, 2 ) AS tprofit, ");
                    sql.append(" ROUND( f.coinChargeIncome, 2 ) AS coinChargeIncome,ROUND( sum( f.coinChargeCost ), 2 ) AS coinChargeCost, ");
                    sql.append(" ROUND( f.coinChargeProfit, 2 ) AS coinChargeProfit,ROUND( f.chargeIncomeByOpr, 2 ) AS chargeIncomeByOpr, ");
                    sql.append(" ROUND( f.chargeIncomeBySh, 2 ) AS chargeIncomeBySh,f.csrefundMoney AS csrefundMoney, ");
                    sql.append(" f.csrefundMoneyByOpr AS csrefundMoneyByOpr,f.chargeCnt AS chargeCnt, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.csrefundCnt AS csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( f.chargestationId=a.ID ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);

                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON  h.chargestationId = a.ID  ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) n ");
                }
            } else if ("3".equals(map.get("date"))) {
                /**
                 * 年查询
                 */
                if ("1".equals(type)) {
                    //全部
                    sql.append(" select sum( whole.tcost ) AS tcost,sum( whole.tincome ) AS tincome,sum( whole.tprofit ) AS tprofit, ");
                    sql.append(" sum( whole.coinChargeIncome ) AS coinChargeIncome,sum( whole.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( whole.coinChargeProfit ) AS coinChargeProfit,sum( whole.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( whole.chargeIncomeBySh ) AS chargeIncomeBySh,sum( whole.csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( whole.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( whole.chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( whole.coinChargeCnt ) AS coinChargeCnt,sum( whole.csrefundCnt ) AS csrefundCnt from ( ");

                    sql.append(" select sum(tcost) as 'tcost' ,sum(tincome) as 'tincome' ,sum(tprofit) as 'tprofit' ,  ");
                    sql.append(" sum(coinChargeIncome)  as coinChargeIncome,sum(coinChargeCost) as coinChargeCost,sum(coinChargeProfit) as coinChargeProfit ");
                    sql.append("  ,sum(chargeIncomeByOpr) as chargeIncomeByOpr,sum(chargeIncomeBySh) as chargeIncomeBySh,sum(csrefundMoney) as csrefundMoney,sum(csrefundMoneyByOpr) as csrefundMoneyByOpr  ");
                    sql.append(" ,sum(chargeCnt) as chargeCnt,sum(coinChargeCnt ) as coinChargeCnt,sum(csrefundCnt) as csrefundCnt  ");
                    sql.append(" from ( select IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as tcost ,ROUND(f.chargeIncome,2) as tincome, ROUND(f.chargeProfit,2) as tprofit ");
                    sql.append(" ,ROUND(f.coinChargeIncome,2)  as coinChargeIncome,ROUND(sum(f.coinChargeCost),2)  as coinChargeCost, ROUND(f.coinChargeProfit,2)  as coinChargeProfit ");
                    sql.append(" ,ROUND(f.chargeIncomeByOpr,2)  as chargeIncomeByOpr,ROUND(f.chargeIncomeBySh,2) as chargeIncomeBySh,f.csrefundMoney  as csrefundMoney ,f.csrefundMoneyByOpr as csrefundMoneyByOpr ");
                    sql.append(" ,f.chargeCnt as chargeCnt,f.coinChargeCnt as coinChargeCnt,f.csrefundCnt as csrefundCnt  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID  ");
                    sql.append(" and f.statYear = ?)", map.get("startTime"));
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) ");
                    sql.append(" where f.maincls = '1' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append(" GROUP BY a.STATIONNO ) n ");

                    sql.append(" union all ");

                    sql.append(" select sum( tcost ) AS tcost,sum( tincome ) AS tincome,sum( tprofit ) AS tprofit, ");
                    sql.append(" sum( coinChargeIncome ) AS coinChargeIncome,sum( coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( coinChargeProfit ) AS coinChargeProfit,sum( chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( chargeIncomeBySh ) AS chargeIncomeBySh,sum( csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( coinChargeCnt ) AS coinChargeCnt,sum( csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS tcost, ");
                    sql.append(" ROUND( f.chargeIncome, 2 ) AS tincome,ROUND( f.chargeProfit, 2 ) AS tprofit, ");
                    sql.append(" ROUND( f.coinChargeIncome, 2 ) AS coinChargeIncome,ROUND( sum( f.coinChargeCost ), 2 ) AS coinChargeCost, ");
                    sql.append(" ROUND( f.coinChargeProfit, 2 ) AS coinChargeProfit,ROUND( f.chargeIncomeByOpr, 2 ) AS chargeIncomeByOpr, ");
                    sql.append(" ROUND( f.chargeIncomeBySh, 2 ) AS chargeIncomeBySh,f.csrefundMoney AS csrefundMoney, ");
                    sql.append(" f.csrefundMoneyByOpr AS csrefundMoneyByOpr,f.chargeCnt AS chargeCnt, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.csrefundCnt AS csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID   ");
                    sql.append(" and f.statYear = ?)", map.get("startTime"));
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) n ");
                    sql.append(" ) as whole ");
                } else if ("2".equals(type)) {
                    //自行车
                    sql.append(" select sum(tcost) as 'tcost' ,sum(tincome) as 'tincome' ,sum(tprofit) as 'tprofit' ,  ");
                    sql.append(" sum(coinChargeIncome)  as coinChargeIncome,sum(coinChargeCost) as coinChargeCost,sum(coinChargeProfit) as coinChargeProfit ");
                    sql.append("  ,sum(chargeIncomeByOpr) as chargeIncomeByOpr,sum(chargeIncomeBySh) as chargeIncomeBySh,sum(csrefundMoney) as csrefundMoney,sum(csrefundMoneyByOpr) as csrefundMoneyByOpr  ");
                    sql.append(" ,sum(chargeCnt) as chargeCnt,sum(coinChargeCnt ) as coinChargeCnt,sum(csrefundCnt) as csrefundCnt  ");
                    sql.append(" from ( select IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as tcost ,ROUND(f.chargeIncome,2) as tincome, ROUND(f.chargeProfit,2) as tprofit ");
                    sql.append(" ,ROUND(f.coinChargeIncome,2)  as coinChargeIncome,ROUND(sum(f.coinChargeCost),2)  as coinChargeCost, ROUND(f.coinChargeProfit,2)  as coinChargeProfit ");
                    sql.append(" ,ROUND(f.chargeIncomeByOpr,2)  as chargeIncomeByOpr,ROUND(f.chargeIncomeBySh,2) as chargeIncomeBySh,f.csrefundMoney  as csrefundMoney ,f.csrefundMoneyByOpr as csrefundMoneyByOpr ");
                    sql.append(" ,f.chargeCnt as chargeCnt,f.coinChargeCnt as coinChargeCnt,f.csrefundCnt as csrefundCnt  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID  ");
                    sql.append(" and f.statYear = ?)", map.get("startTime"));
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) ");
                    sql.append(" where f.maincls = '1' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append(" GROUP BY a.STATIONNO ) n ");
                } else if ("3".equals(type)) {
                    //汽车
                    sql.append(" select sum( tcost ) AS tcost,sum( tincome ) AS tincome,sum( tprofit ) AS tprofit, ");
                    sql.append(" sum( coinChargeIncome ) AS coinChargeIncome,sum( coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( coinChargeProfit ) AS coinChargeProfit,sum( chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( chargeIncomeBySh ) AS chargeIncomeBySh,sum( csrefundMoney ) AS csrefundMoney, ");
                    sql.append(" sum( csrefundMoneyByOpr ) AS csrefundMoneyByOpr,sum( chargeCnt ) AS chargeCnt, ");
                    sql.append(" sum( coinChargeCnt ) AS coinChargeCnt,sum( csrefundCnt ) AS csrefundCnt from ( ");
                    sql.append(" select IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS tcost, ");
                    sql.append(" ROUND( f.chargeIncome, 2 ) AS tincome,ROUND( f.chargeProfit, 2 ) AS tprofit, ");
                    sql.append(" ROUND( f.coinChargeIncome, 2 ) AS coinChargeIncome,ROUND( sum( f.coinChargeCost ), 2 ) AS coinChargeCost, ");
                    sql.append(" ROUND( f.coinChargeProfit, 2 ) AS coinChargeProfit,ROUND( f.chargeIncomeByOpr, 2 ) AS chargeIncomeByOpr, ");
                    sql.append(" ROUND( f.chargeIncomeBySh, 2 ) AS chargeIncomeBySh,f.csrefundMoney AS csrefundMoney, ");
                    sql.append(" f.csrefundMoneyByOpr AS csrefundMoneyByOpr,f.chargeCnt AS chargeCnt, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.csrefundCnt AS csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID   ");
                    sql.append(" and f.statYear = ?)", map.get("startTime"));
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where f.maincls = '2' AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) n ");
                }
            } else if ("4".equals(map.get("date"))) {
                /**
                 * 自定义时间段查询
                 */
                if ("1".equals(type)) {
                    //全部
                    sql.append(" select sum( whole.tcost ) AS tcost,sum( whole.tincome ) AS tincome, ");
                    sql.append(" sum( whole.tprofit ) AS tprofit,sum( whole.coinChargeIncome ) AS coinChargeIncome, ");
                    sql.append(" sum( whole.coinChargeCost ) AS coinChargeCost,sum( whole.coinChargeProfit ) AS coinChargeProfit, ");
                    sql.append(" sum( whole.chargeIncomeByOpr ) AS chargeIncomeByOpr,sum( whole.chargeIncomeBySh ) AS chargeIncomeBySh, ");
                    sql.append(" sum( whole.csrefundMoney ) AS csrefundMoney,sum( whole.csrefundMoneyByOpr ) AS csrefundMoneyByOpr, ");
                    sql.append(" sum( whole.chargeCnt ) AS chargeCnt,sum( whole.coinChargeCnt ) AS coinChargeCnt,sum( whole.csrefundCnt ) AS csrefundCnt ");
                    sql.append(" from ( ");

                    sql.append(" SELECT sum(tt.chargeCost) AS 'tcost',sum(tt.chargeIncome) AS 'tincome',sum(tt.chargeProfit) AS 'tprofit',sum(tt.coinChargeIncome) AS coinChargeIncome,");
                    sql.append(" sum(tt.coinChargeCost) AS coinChargeCost,sum(tt.coinChargeProfit) AS coinChargeProfit,sum(tt.chargeIncomeByOpr) AS chargeIncomeByOpr, ");
                    sql.append(" sum(tt.chargeIncomeBySh) AS chargeIncomeBySh,sum(tt.csrefundMoney) AS csrefundMoney,sum(tt.csrefundMoneyByOpr) AS csrefundMoneyByOpr,");
                    sql.append(" sum(tt.chargeCnt) AS chargeCnt,sum(tt.coinChargeCnt) AS coinChargeCnt,sum(tt.csrefundCnt) AS csrefundCnt from ( ");
                    sql.append(" select  n.chargeCost ,n.chargeIncome,n.chargeProfit,n.coinChargeIncome, n.coinChargeCost , ");
                    sql.append(" n.coinChargeProfit ,n.chargeIncomeByOpr ,n.chargeIncomeBySh, ");
                    sql.append(" n.csrefundMoney,n.csrefundMoneyByOpr, n.chargeCnt, n.coinChargeCnt,n.csrefundCnt ");
                    sql.append("  from cisp_dev.dev_ebikechargestation a  left join  ");
                    sql.append(" ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome,  ");
                    sql.append(" sum( f.chargeProfit ) AS chargeProfit,sum( f.coinChargeIncome ) AS coinChargeIncome,sum( f.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( f.coinChargeProfit ) AS coinChargeProfit,sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( f.chargeIncomeBySh ) AS chargeIncomeBySh,sum( f.csrefundMoney ) AS csrefundMoney,sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,  ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.csrefundCnt ) AS csrefundCnt  ");
                    sql.append(" from  cisp_dev.dev_ebikechargestation a  LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) n  on n.id=a.ID  ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where true ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.ID  ) tt  ");

                    sql.append(" union all ");

                    sql.append(" select sum( tt.chargeCost ) AS tcost,sum( tt.chargeIncome ) AS tincome, ");
                    sql.append(" sum( tt.chargeProfit ) AS tprofit,sum( tt.coinChargeIncome ) AS coinChargeIncome, ");
                    sql.append(" sum( tt.coinChargeCost ) AS coinChargeCost,sum( tt.coinChargeProfit ) AS coinChargeProfit, ");
                    sql.append(" sum( tt.chargeIncomeByOpr ) AS chargeIncomeByOpr,sum( tt.chargeIncomeBySh ) AS chargeIncomeBySh, ");
                    sql.append(" sum( tt.csrefundMoney ) AS csrefundMoney,sum( tt.csrefundMoneyByOpr ) AS csrefundMoneyByOpr, ");
                    sql.append(" sum( tt.chargeCnt ) AS chargeCnt,sum( tt.coinChargeCnt ) AS coinChargeCnt,sum( tt.csrefundCnt ) AS csrefundCnt ");
                    sql.append(" from ( select n.chargeCost,n.chargeIncome,n.chargeProfit,n.coinChargeIncome,n.coinChargeCost, ");
                    sql.append(" n.coinChargeProfit,n.chargeIncomeByOpr,n.chargeIncomeBySh,n.csrefundMoney,n.csrefundMoneyByOpr, ");
                    sql.append(" n.chargeCnt,n.coinChargeCnt,n.csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" LEFT JOIN ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome, ");
                    sql.append(" sum( f.chargeProfit ) AS chargeProfit,sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                    sql.append(" sum( f.coinChargeCost ) AS coinChargeCost,sum( f.coinChargeProfit ) AS coinChargeProfit, ");
                    sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr,sum( f.chargeIncomeBySh ) AS chargeIncomeBySh, ");
                    sql.append(" sum( f.csrefundMoney ) AS csrefundMoney,sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr, ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.csrefundCnt ) AS csrefundCnt ");
                    sql.append(" from ebike.oper_ev_charging_station a LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) n  on n.id=a.ID  ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) WHERE true ");
                    sql.append(" AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append("  GROUP BY a.ID  ) tt  ");

                    sql.append(" ) as whole ");
                } else if ("2".equals(type)) {
                    //自行车
                    sql.append(" SELECT sum(tt.chargeCost) AS 'tcost',sum(tt.chargeIncome) AS 'tincome',sum(tt.chargeProfit) AS 'tprofit',sum(tt.coinChargeIncome) AS coinChargeIncome,");
                    sql.append(" sum(tt.coinChargeCost) AS coinChargeCost,sum(tt.coinChargeProfit) AS coinChargeProfit,sum(tt.chargeIncomeByOpr) AS chargeIncomeByOpr, ");
                    sql.append(" sum(tt.chargeIncomeBySh) AS chargeIncomeBySh,sum(tt.csrefundMoney) AS csrefundMoney,sum(tt.csrefundMoneyByOpr) AS csrefundMoneyByOpr,");
                    sql.append(" sum(tt.chargeCnt) AS chargeCnt,sum(tt.coinChargeCnt) AS coinChargeCnt,sum(tt.csrefundCnt) AS csrefundCnt from ( ");
                    sql.append(" select  n.chargeCost ,n.chargeIncome,n.chargeProfit,n.coinChargeIncome, n.coinChargeCost , ");
                    sql.append(" n.coinChargeProfit ,n.chargeIncomeByOpr ,n.chargeIncomeBySh, ");
                    sql.append(" n.csrefundMoney,n.csrefundMoneyByOpr, n.chargeCnt, n.coinChargeCnt,n.csrefundCnt ");
                    sql.append("  from cisp_dev.dev_ebikechargestation a  left join  ");
                    sql.append(" ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome,  ");
                    sql.append(" sum( f.chargeProfit ) AS chargeProfit,sum( f.coinChargeIncome ) AS coinChargeIncome,sum( f.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( f.coinChargeProfit ) AS coinChargeProfit,sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( f.chargeIncomeBySh ) AS chargeIncomeBySh,sum( f.csrefundMoney ) AS csrefundMoney,sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr,  ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.csrefundCnt ) AS csrefundCnt  ");
                    sql.append(" from  cisp_dev.dev_ebikechargestation a  LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) n  on n.id=a.ID  ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where true ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.ID  ) tt  ");
                } else if ("3".equals(type)) {
                    //汽车
                    sql.append(" select sum( tt.chargeCost ) AS tcost,sum( tt.chargeIncome ) AS tincome, ");
                    sql.append(" sum( tt.chargeProfit ) AS tprofit,sum( tt.coinChargeIncome ) AS coinChargeIncome, ");
                    sql.append(" sum( tt.coinChargeCost ) AS coinChargeCost,sum( tt.coinChargeProfit ) AS coinChargeProfit, ");
                    sql.append(" sum( tt.chargeIncomeByOpr ) AS chargeIncomeByOpr,sum( tt.chargeIncomeBySh ) AS chargeIncomeBySh, ");
                    sql.append(" sum( tt.csrefundMoney ) AS csrefundMoney,sum( tt.csrefundMoneyByOpr ) AS csrefundMoneyByOpr, ");
                    sql.append(" sum( tt.chargeCnt ) AS chargeCnt,sum( tt.coinChargeCnt ) AS coinChargeCnt,sum( tt.csrefundCnt ) AS csrefundCnt ");
                    sql.append(" from ( select n.chargeCost,n.chargeIncome,n.chargeProfit,n.coinChargeIncome,n.coinChargeCost, ");
                    sql.append(" n.coinChargeProfit,n.chargeIncomeByOpr,n.chargeIncomeBySh,n.csrefundMoney,n.csrefundMoneyByOpr, ");
                    sql.append(" n.chargeCnt,n.coinChargeCnt,n.csrefundCnt from ebike.oper_ev_charging_station a ");
                    sql.append(" LEFT JOIN ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome, ");
                    sql.append(" sum( f.chargeProfit ) AS chargeProfit,sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                    sql.append(" sum( f.coinChargeCost ) AS coinChargeCost,sum( f.coinChargeProfit ) AS coinChargeProfit, ");
                    sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr,sum( f.chargeIncomeBySh ) AS chargeIncomeBySh, ");
                    sql.append(" sum( f.csrefundMoney ) AS csrefundMoney,sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr, ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.csrefundCnt ) AS csrefundCnt ");
                    sql.append(" from ebike.oper_ev_charging_station a LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) n  on n.id=a.ID  ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) WHERE true ");
                    sql.append(" AND a.charging_station_status = '3' ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append("  GROUP BY a.ID  ) tt  ");
                }
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("tincome", rs.getDouble("tincome"));
                        map.put("tcost", rs.getDouble("tcost"));
                        map.put("tprofit", rs.getDouble("tprofit"));
                        map.put("coinChargeIncome", rs.getDouble("coinChargeIncome"));
                        map.put("coinChargeCost", rs.getDouble("coinChargeCost"));
                        map.put("coinChargeProfit", rs.getDouble("coinChargeProfit"));
                        map.put("chargeIncomeByOpr", rs.getDouble("chargeIncomeByOpr"));
                        map.put("chargeIncomeBySh", rs.getDouble("chargeIncomeBySh"));
                        map.put("csrefundMoney", rs.getDouble("csrefundMoney"));
                        map.put("csrefundMoneyByOpr", rs.getDouble("csrefundMoneyByOpr"));
                        map.put("chargeCnt", rs.getInt("chargeCnt"));
                        map.put("coinChargeCnt", rs.getInt("coinChargeCnt"));
                        map.put("csrefundCnt", rs.getInt("csrefundCnt"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>>>>>>>>>getSumInfo>>>>><<<<<<<<<<" + sql.getSql());
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    @Override
    public List<Map<String, Object>> queryShareData(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String type = map.get("type");
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            if ("1".equals(type)) {
                /**
                 * 全部
                 */
                sql.append(" select * from (");
                sql.append("select 1 as type, u.chargeUserType, a.chargeOpenTime,a.chargeRecordId,a.chargeFinishTime,a.income,b.stationNo,c.chargedeviceNo,d.chargeplugNo,b.ID,f.NAME,f.status");
                sql.append(" ,a.serviceMoney as 'serviceCharge',k.distMoney,IFNULL(convert((a.cost/a.income)*100,decimal(15,2)) ,0.00)as costRatio,k.distRatio,a.coinMoney,");
                sql.append(" 0.00 AS elecTotal,");
                sql.append(" 0.00 AS tmplService");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" inner join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append("and a.chargePayMode=? ", map.get("payType"));
                sql.append(" GROUP BY a.chargeRecordId ");

                sql.append(" union all ");

                sql.append(" select 2 as type, u.chargeUserType,a.charge_open_success_time as chargeOpenTime,a.id as chargeRecordId,a.charge_finish_time as chargeFinishTime,");
                sql.append(" a.charge_income as income,b.charging_station_no as stationNo,c.charging_pile_no as chargedeviceNo,");
                sql.append(" d.charging_gun_no as chargeplugNo,b.id,b.charging_station_name as name,");
                sql.append(" b.charging_station_status as status,a.platform_service_money AS serviceCharge,k.distMoney,");
                sql.append(" '0.00' AS costRatio,");
                sql.append(" a.charge_expense_total as elecTotal, ");
                sql.append(" a.charge_expense_service as tmplService, ");
                sql.append(" k.distRatio,a.coin_money as coinMoney from ebike.order_ev_charging_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" LEFT JOIN ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId");
                sql.append(" inner join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" left join ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.ID ");
                sql.append("LEFT JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId )");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" GROUP BY a.id");
                sql.append(" ) as whole order by  whole.chargeFinishTime DESC");
            } else if ("2".equals(type)) {
                /**
                 * 自行车
                 */
                sql.append("select 1 as type, u.chargeUserType, a.chargeOpenTime,a.chargeRecordId,a.chargeFinishTime,a.income,b.stationNo,c.chargedeviceNo,d.chargeplugNo,b.ID,f.NAME,f.status");
                sql.append(" ,a.serviceMoney as 'serviceCharge',k.distMoney,IFNULL(convert((a.cost/a.income)*100,decimal(15,2)) ,0.00)as costRatio,k.distRatio,a.coinMoney,");
                sql.append(" 0.00 AS elecTotal,");
                sql.append(" 0.00 AS tmplService");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" inner join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append("and a.chargePayMode=? ", map.get("payType"));
                sql.append(" GROUP BY a.chargeRecordId  order by  a.chargeFinishTime DESC ");
            } else if ("3".equals(type)) {
                /**
                 * 汽车
                 */
                sql.append(" select 2 as type, u.chargeUserType,a.charge_open_success_time as chargeOpenTime,a.id as chargeRecordId,a.charge_finish_time as chargeFinishTime,");
                sql.append(" a.charge_income as income,b.charging_station_no as stationNo,c.charging_pile_no as chargedeviceNo,");
                sql.append(" d.charging_gun_no as chargeplugNo,b.id,b.charging_station_name as name,");
                sql.append(" b.charging_station_status as status,a.platform_service_money AS serviceCharge,k.distMoney,");
                sql.append(" '0.00' AS costRatio,");
                sql.append(" a.charge_expense_total as elecTotal, ");
                sql.append(" a.charge_expense_service as tmplService, ");
                sql.append(" k.distRatio,a.coin_money as coinMoney from ebike.order_ev_charging_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" LEFT JOIN ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId");
                sql.append(" inner join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" left join ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.ID ");
                sql.append("LEFT JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId )");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" GROUP BY a.id  order by  a.charge_finish_time DESC ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("type", rs.getString("type"));
                        map.put("chargeUserType", rs.getString("chargeUserType"));
                        map.put("chargeOpenTime", rs.getTimestamp("chargeOpenTime"));
                        map.put("chargeFinishTime", rs.getTimestamp("chargeFinishTime"));
                        map.put("income", rs.getDouble("income"));
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                        map.put("chargeplugNo", rs.getString("chargeplugNo"));
                        map.put("ID", rs.getLong("ID"));
                        map.put("NAME", rs.getString("NAME"));
                        map.put("chargeRecordId", rs.getString("chargeRecordId"));
                        map.put("status", rs.getString("status"));
                        map.put("serviceCharge", rs.getDouble("serviceCharge"));
                        map.put("distMoney", rs.getDouble("distMoney"));
                        map.put("costRatio", rs.getDouble("costRatio"));
                        map.put("coinMoney", rs.getDouble("coinMoney"));
                        map.put("distRatio", rs.getDouble("distRatio"));
                        map.put("elecTotal",rs.getDouble("elecTotal"));
                        map.put("tmplService",rs.getDouble("tmplService"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>queryShareData<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryShareCount(String subbro, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        SqlParamsBuilder sql2 = new SqlParamsBuilder();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                /**
                 * 全部
                 */
                sql.append("select sum(whole.idCount) from (");

                sql.append(" select count(a.chargeRecordId) as idCount ");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" inner join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append("and a.chargePayMode=? ", map.get("payType"));

                sql.append(" union all ");

                sql.append(" select count(a.id) as idCount ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" LEFT JOIN ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId");
                sql.append(" inner join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" left join ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.ID ");
                sql.append("LEFT JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId )");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(") as whole;");
            } else if ("2".equals(type)) {
                /**
                 * 自行车
                 */
                sql.append(" select count(a.chargeRecordId) ");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.chargeUserId");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" inner join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                if (map.get("chargeUserType") != null) {
                    if (Integer.valueOf(map.get("chargeUserType")) == 10) {
                        sql.append(" AND  (u.chargeUserType = '10'or  u.chargeUserType = '30')");
                    } else {
                        sql.append(" and u.chargeUserType = ?", map.get("chargeUserType"));
                    }
                }
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append("and a.chargePayMode=? ", map.get("payType"));
            } else if ("3".equals(type)) {
                /**
                 * 汽车
                 */
                sql.append(" select count(a.id) ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" LEFT JOIN ebike.ebike_chargeuser u ON u.chargeUserId = a.charge_user_id ");
                sql.append(" LEFT JOIN ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId");
                sql.append(" inner join ebike.oper_ev_charging_station b on a.charging_station_id = b.ID ");
                sql.append(" left join ebike.dev_ev_charging_pile c on a.charging_pile_id = c.ID ");
                sql.append(" left join ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.ID ");
                sql.append("LEFT JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId )");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and b.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("start_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("end_day"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subbro);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
            }
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryRefundData(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  f.stationNo,f.id,b.name,c.chargedeviceNo,d.plugSn,a.csrefundTime,a.csrefundMoney,a.chargeRecordId,h.csrefundMoney as yyscsrefundMoney  ");
            sql.append(" from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on g.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID  ");
            sql.append("  left  join ebike.ebike_chargerecord_incomedetail h on a.chargeRecordId=h.chargeRecordId  where 1=1 ");
            sql.append(" and b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S' ");
            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            logger.debug(">>>>>>>>>>>>queryRefundData<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>queryRefundData<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryRefundCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on g.chargestationId=f.ID ");
            sql.append("  left join cisp_sys.bp_org e on (g.stakeholderOrgNo=e.ORG_NO) ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID ");
            sql.append("  left  join ebike.ebike_chargerecord_incomedetail h on a.chargeRecordId=h.chargeRecordId  where 1=1 ");
            sql.append(" and  b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S' ");
            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? )", subburo);

            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public List<Map<String, Object>> queryShareRefundData(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  f.stationNo,f.id,b.name,c.chargedeviceNo,d.plugSn,a.csrefundTime,a.csrefundMoney,a.chargeRecordId,e.csrefundMoney as shareCsrefundMoney  ");
            sql.append(" from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_chargerecord_incomedetail e on a.chargeRecordId=e.chargeRecordId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID  ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on (g.chargestationId=f.ID and g.stakeholderOrgNo=e.distUserId) where 1=1  ");
            sql.append(" and b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S' and g.csshdsStatus='00' ");
            sql.append(" and g.stakeholderOrgNo = ?", subburo);
            logger.debug(">>>>>>>>>>>>queryRefundData<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>queryShareRefundData<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryShareRefundCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_chargerecord_incomedetail e on a.chargeRecordId=e.chargeRecordId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID  ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on (g.chargestationId=f.ID and g.stakeholderOrgNo=e.distUserId) where 1=1  ");
            sql.append(" and b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S' and g.csshdsStatus='00' ");
            sql.append(" and g.stakeholderOrgNo = ?", subburo);
            logger.debug(">>>>>>>>>>>>queryRefundData<<<<<<<<<<<" + sql.toString());
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> getRefundTotal(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> maps = new HashMap<String, Object>();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  IFNULL(sum(a.csrefundMoney),0.00) as csrefundMoney ,IFNULL(sum(h.csrefundMoney),0.00) as yyscsrefundMoney  ");
            sql.append(" from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on g.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID  ");
            sql.append("  left  join ebike.ebike_chargerecord_incomedetail h on a.chargeRecordId=h.chargeRecordId  where 1=1 ");
            sql.append(" and b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S' ");
            sql.append(" and ( b.SUBBURO = ?", subburo);
            sql.append(" or b.BURO = ? )", subburo);
            logger.debug(">>>>>>>>>>>>queryRefundData<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>queryRefundData<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }


    @Override
    public Map<String, Object> getShareAccount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> maps = new HashMap<String, Object>();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String type = map.get("type");
        try {
            if ("1".equals(type)) {
                sql.append(" select sum(whole.coinMoney) as coinMoney, ");
                sql.append(" sum(whole.income) as income, ");
                sql.append(" sum(whole.distMoney) as distMoney, ");
                sql.append(" sum(whole.tcost) as tcost ");
                sql.append(" from (");
                sql.append(" select  IFNULL(sum(a.coinMoney),0.00) as coinMoney ,IFNULL(sum(a.income),0.00) as income,IFNULL(sum(k.distMoney),0.00)  distMoney, ");
                sql.append(" IFNULL(convert((sum(a.cost)/sum(a.income))*100,decimal(15,2)) ,0.00) as 'tcost' ");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append("   left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append("  left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("devNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("plugNo") + "%");
                sql.append(" and  k.distUserId=? ", subburo);
                sql.append("and a.chargePayMode=? ", map.get("payType"));

                sql.append(" union all ");

                sql.append(" select ifnull(sum( a.coin_money ),0.00) AS coinMoney, ");
                sql.append(" ifnull(sum( a.charge_income ),0.00) AS income, ");
                sql.append(" ifnull(sum( k.distMoney ),0.00) distMoney, ");
                sql.append(" '0.00' AS tcost  ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" left join ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId ");
                sql.append(" left JOIN ebike.oper_ev_charging_station f ON a.charging_station_id = f.id ");
                sql.append(" left JOIN ebike.dev_ev_charging_pile c ON a.charging_pile_id = c.id ");
                sql.append(" left JOIN ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.id ");
                sql.append(" left JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId ) ");
                sql.append(" left JOIN ebike.ebike_chargeuser g ON a.charge_user_id = g.chargeUserId  ");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subburo);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));

                sql.append(") as whole");
            } else if ("2".equals(type)) {
                sql.append(" select  IFNULL(sum(a.coinMoney),0.00) as coinMoney ,IFNULL(sum(a.income),0.00) as income,IFNULL(sum(k.distMoney),0.00)  distMoney, ");
                sql.append(" IFNULL(convert((sum(a.cost)/sum(a.income))*100,decimal(15,2)) ,0.00) as 'tcost' ");
                sql.append(" from ebike.ebike_chargerecord_his a ");
                sql.append(" left join    ebike.ebike_chargerecord_incomedetail k  on a.chargeRecordId=k.chargeRecordId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource f on a.chargestationId=f.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargestation b on a.chargestationId=b.ID  ");
                sql.append("   left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
                sql.append("  left join cisp_dev.dev_ebikechargeplug d on a.chargeplugId=d.ID   ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on  (a.chargestationId=h.chargestationId and   h.stakeholderOrgNo=k.distUserId) ");
                sql.append(" left join ebike.ebike_chargeuser g on  a.chargeUserId=g.chargeUserId  where 1=1 and h.csshdsStatus='00' ");
                sql.append(" and c.chargedeviceNo like ?", "%" + map.get("devNo") + "%");
                sql.append(" and f.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.chargeFinishTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.chargeFinishTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.chargeplugNo like ?", "%" + map.get("plugNo") + "%");
                sql.append(" and  k.distUserId=? ", subburo);
                sql.append("and a.chargePayMode=? ", map.get("payType"));
                sql.append(" order by  a.chargeFinishTime DESC ");
            } else if ("3".equals(type)) {
                sql.append(" select ifnull(sum( a.coin_money ),0.00) AS coinMoney, ");
                sql.append(" ifnull(sum( a.charge_income ),0.00) AS income, ");
                sql.append(" ifnull(sum( k.distMoney ),0.00) distMoney, ");
                sql.append(" '0.00' AS tcost  ");
                sql.append(" from ebike.order_ev_charging_his a ");
                sql.append(" left join ebike.ebike_chargerecord_incomedetail k ON a.id = k.chargeRecordId ");
                sql.append(" left JOIN ebike.oper_ev_charging_station f ON a.charging_station_id = f.id ");
                sql.append(" left JOIN ebike.dev_ev_charging_pile c ON a.charging_pile_id = c.id ");
                sql.append(" left JOIN ebike.dev_ev_charging_gun d ON a.charging_gun_id = d.id ");
                sql.append(" left JOIN ebike.ebike_cssh_distscheme h ON ( a.charging_station_id = h.chargestationId AND h.stakeholderOrgNo = k.distUserId ) ");
                sql.append(" left JOIN ebike.ebike_chargeuser g ON a.charge_user_id = g.chargeUserId  ");
                sql.append(" where true ");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and f.charging_station_no like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and a.charge_finish_time >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and a.charge_finish_time <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.charging_gun_no like ?", "%" + map.get("chargeplugNo") + "%");
                sql.append(" and  k.distUserId=? ", subburo);
                sql.append(" and a.charge_pay_type=? ", map.get("payType"));
                sql.append(" order by  a.charge_finish_time DESC ");
            }
            logger.debug(sql.getSql());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>getShareAccount<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    @Override
    public Map<String, Object> getShareRefundTotal(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> maps = new HashMap<String, Object>();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  IFNULL(sum(a.csrefundMoney),0.00) as csrefundMoney ,IFNULL(sum(e.csrefundMoney),0.00) as yyscsrefundMoney  ");
            sql.append(" from ebike.ebike_chargerecord_his a  left join cisp_dev.dev_ebikechargestation f on a.chargestationId=f.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.chargedeviceId=c.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargeplug d  on a.chargeplugId=d.ID ");
            sql.append("  left join ebike.ebike_chargerecord_incomedetail e on a.chargeRecordId=e.chargeRecordId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  f.ID=b.ID  ");
            sql.append("  left join ebike.ebike_cssh_distscheme g on (g.chargestationId=f.ID and g.stakeholderOrgNo=e.distUserId) where 1=1  ");
            sql.append(" and b.name like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  c.chargedeviceNo like ? ", "%" + map.get("devNo") + "%");
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')>=? ",map.get("startDay"));
//			sql.append(" and date_format(a.csrefundTime,'%Y-%m-%d')<=? ",map.get("endDay"));
            sql.append(" and a.csrefundTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            sql.append(" and a.csrefundTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            //sql.append(map.get("stakeholder")," and g.stakeholderOrgNo = ? ");
            sql.append(" and d.plugSn=? ", map.get("plugNo"));
            sql.append(" and a.isCsRefund='Y' and a.csrefundResult='S'  and g.csshdsStatus='00' ");
            sql.append(" and g.stakeholderOrgNo = ?", subburo);
            logger.debug(">>>>>>>>>>>>queryRefundData<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>getShareRefundTotal<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    @Override
    public List<Map<String, Object>> queryRevenueCountInMeter(String subbro,
                                                              Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String type = map.get("type");
        try {
            /**
             * 日统计查询
             */
            if ("1".equals(map.get("date"))) {
                logger.debug(">>>>>>>>>>>>>>>>>>>map.getDate<<<<<<<<<<<<<<<" + map.get("date"));
                logger.debug(">>>>>>>>>>>>>>>>>>>map.Time<<<<<<<<<<<<<<<" + map.get("startTime"));
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append(" select * from ( ");
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId  ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( distinct b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull(round(oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100,2),0.00) as CostRatio,");
                    sql.append(" oo.elecTotal AS elecTotal,");
                    sql.append(" oo.tmplService AS tmplService");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(o.charge_finish_time) = 1 )");
                    } else {
                        sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') = ? ", map.get("startTime"));
                    }
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and  a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) as whole");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId  ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( distinct b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull(round(oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100,2),0.00) as CostRatio,");
                    sql.append(" oo.elecTotal AS elecTotal,");
                    sql.append(" oo.tmplService AS tmplService");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId ");
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                    } else {
                        sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                        sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(o.charge_finish_time) = 1 )");
                    } else {
                        sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') = ? ", map.get("startTime"));
                    }
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and  a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                }
            }
            if ("2".equals(map.get("date"))) {
                /**
                 * 月统计查询
                 */
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc ) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f on (f.chargestationId=a.ID   ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);
                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull( round( oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100, 2 ), 0.00 ) AS CostRatio, ");
                    sql.append(" oo.elecTotal AS elecTotal, ");
                    sql.append(" oo.tmplService AS tmplService  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( a.ID = f.chargestationId ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);
                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m') =?", map.get("startTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc ) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f on (f.chargestationId=a.ID   ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);
                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull( round( oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100, 2 ), 0.00 ) AS CostRatio, ");
                    sql.append(" oo.elecTotal AS elecTotal, ");
                    sql.append(" oo.tmplService AS tmplService  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( a.ID = f.chargestationId ");
                    if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                        String[] time = map.get("startTime").split("-");
                        String startTime = time[0] + time[1];
                        sql.append(" and f.statMonth=? )", startTime);
                    } else {
                        sql.append(" and f.statMonth=? )", map.get("startTime"));
                    }
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m') =?", map.get("startTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                }
            }
            if ("3".equals(map.get("date"))) {
                /**
                 * 年统计查询
                 */
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f on (f.chargestationId=a.ID  ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" )");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull( round( oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100, 2 ), 0.00 ) AS CostRatio, ");
                    sql.append(" oo.elecTotal AS elecTotal, ");
                    sql.append(" oo.tmplService AS tmplService  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( a.ID = f.chargestationId ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" )");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y') =?", map.get("startTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney , ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f on (f.chargestationId=a.ID  ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" )");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull( round( oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100, 2 ), 0.00 ) AS CostRatio, ");
                    sql.append(" oo.elecTotal AS elecTotal, ");
                    sql.append(" oo.tmplService AS tmplService  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( a.ID = f.chargestationId ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" )");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y') =?", map.get("startTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                }
            }
            if ("4".equals(map.get("date"))) {
                /**
                 * 自定义时间查询
                 */
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append(" select * from ( ");
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,f.lastChargeFinishTime as lastChargeFinishTime,f.chargeCnt,round(f.chargeIncome,2) as chargeIncome,round(f.chargeServiceMoney,2) as chargeServiceMoney , ");
                    sql.append(" round(f.chargeIncomeByOpr,2) as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,round(f.coinChargeIncome,2) as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append("  from cisp_dev.dev_ebikechargestation a  left join  ");
                    sql.append(" ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome,  ");
                    sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome,sum( f.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.chargeServiceMoney ) AS chargeServiceMoney  , max(f.lastChargeFinishTime) as lastChargeFinishTime,max(f.lastCoinChargeFinishTime) as lastCoinChargeFinishTime");
                    sql.append(" from  cisp_dev.dev_ebikechargestation a  LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) f  on f.id=a.ID  ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( distinct b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull(round(oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100,2),0.00) as CostRatio,");
                    sql.append(" oo.elecTotal AS elecTotal,");
                    sql.append(" oo.tmplService AS tmplService");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId ");
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') >= ? ", map.get("startTime"));
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') <= ? ", map.get("endTime"));
                    sql.append(" )left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') >= ? ", map.get("startTime"));
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') <= ? ", map.get("endTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and  a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ) as whole ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append(" select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                    sql.append(" d.name,f.lastChargeFinishTime as lastChargeFinishTime,f.chargeCnt,round(f.chargeIncome,2) as chargeIncome,round(f.chargeServiceMoney,2) as chargeServiceMoney , ");
                    sql.append(" round(f.chargeIncomeByOpr,2) as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,round(f.coinChargeIncome,2) as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio, ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio, ");
                    sql.append(" 0.00 AS elecTotal,");
                    sql.append(" 0.00 AS tmplService");
                    sql.append("  from cisp_dev.dev_ebikechargestation a  left join  ");
                    sql.append(" ( select a.ID AS ID,sum( f.chargeCost ) AS chargeCost,sum( f.chargeIncome ) AS chargeIncome,  ");
                    sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome,sum( f.coinChargeCost ) AS coinChargeCost, ");
                    sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                    sql.append(" sum( f.chargeCnt ) AS chargeCnt,sum( f.coinChargeCnt ) AS coinChargeCnt,sum( f.chargeServiceMoney ) AS chargeServiceMoney  , max(f.lastChargeFinishTime) as lastChargeFinishTime,max(f.lastCoinChargeFinishTime) as lastCoinChargeFinishTime");
                    sql.append(" from  cisp_dev.dev_ebikechargestation a  LEFT JOIN  ebike.stat_chargestation_day f on (a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append("  ) GROUP BY a.ID ) f  on f.id=a.ID  ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                    sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                    sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                    sql.append(" and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and ( d.SUBBURO = ?", subbro);
                    sql.append(" or d.BURO = ? )", subbro);
                    sql.append("  GROUP BY a.id ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( distinct b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,IFNULL( c.ORG_NAME, '独享' ) AS 'stakeholderName', ");
                    sql.append(" a.charging_station_name as name,max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                    sql.append(" f.chargeCnt,f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" f.chargeIncomeByOpr AS chargeIncomeByOpr,f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" ifnull(round(oo.elecTotal / ( oo.elecTotal + oo.tmplService ) * 100,2),0.00) as CostRatio,");
                    sql.append(" oo.elecTotal AS elecTotal,");
                    sql.append(" oo.tmplService AS tmplService");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId ");
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') >= ? ", map.get("startTime"));
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') <= ? ", map.get("endTime"));
                    sql.append(" )left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.id ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" LEFT JOIN cisp_sys.bp_org c ON ( h.stakeholderOrgNo = c.ORG_NO ) ");
                    sql.append(" left join ( ");
                    sql.append(" select o.charging_station_id, ");
                    sql.append(" sum( o.charge_expense_total ) AS elecTotal, ");
                    sql.append(" sum( o.charge_expense_service ) AS tmplService ");
                    sql.append(" from ebike.order_ev_charging_his as o ");
                    sql.append(" where o.org_no = ?", subbro);
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') >= ? ", map.get("startTime"));
                    sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') <= ? ", map.get("endTime"));
                    sql.append(" group by o.charging_station_id ");
                    sql.append(" ) as oo on oo.charging_station_id = a.id ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and  a.org_no = ?", subbro);
                    sql.append(" GROUP BY a.id ");
                }
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>queryRevenueCountInMeter>>>>><<<<<<<<<<" + sql.getSql());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getQueryRevenueCount(String subbro, Map<String, String> map) {
        //List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_day f on (f.chargestationId=a.ID   ");
                if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                    sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                } else {
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                }
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            } else if ("2".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_month f on (f.chargestationId=a.ID   ");
                if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                    String[] time = map.get("startTime").split("-");
                    String startTime = time[0] + time[1];
                    sql.append(" and f.statMonth=? ", startTime);
                } else {
                    sql.append(" and f.statMonth=? ", map.get("startTime"));
                }
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            } else if ("3".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID   ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");

            } else {
                sql.append(" select count(1) from  ( select count(DISTINCT (a.STATIONNO)) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_day f on (f.chargestationId=a.ID   ");
//				sql.append(" and date_format(f.statDate,'%Y-%m-%d') >=?",map.get("startTime"));
//				sql.append(" and date_format(f.statDate,'%Y-%m-%d') <=? ",map.get("endTime"));
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            }
            sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
            sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
            sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and ( d.SUBBURO = ?", subbro);
            sql.append(" or d.BURO = ? )", subbro);
            sql.append(" and d.STATUS='20' ");
            sql.append(" GROUP BY a.STATIONNO) k ");
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryDeviceRevenue(String subbro,
                                                        Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                logger.debug(">>>>>>>>>>>>>>>>>>>map.getDate<<<<<<<<<<<<<<<" + map.get("date"));
                logger.debug(">>>>>>>>>>>>>>>>>>>map.Time<<<<<<<<<<<<<<<" + map.get("startTime"));

                sql.append(" select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit,  ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(f.csrefundMoney) as csrefundMoney,sum(f.csrefundMoneyByOpr) as csrefundMoneyByOpr ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append("  left join ebike.stat_chargedevice_day  f   on (a.ID=f.chargedeviceId  ");
                if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                    sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                } else {
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                }
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");

                sql.append("union all");

                sql.append(" select ");
                sql.append(" a.ID, ");
                sql.append(" a.charging_pile_no as chargedeviceNo, ");
                sql.append(" a.charging_pile_status as status, ");
                sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                sql.append(" f.chargeCnt, ");
                sql.append(" f.chargeIncome, ");
                sql.append(" a.charging_gun_count as chargeCnt, ");
                sql.append(" c.opStatus, ");
                sql.append(" f.chargeCost, ");
                sql.append(" f.chargeProfit, ");
                sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                sql.append(" sum( f.coinChargeCnt ) AS coinChargeCnt, ");
                sql.append(" f.lastCoinChargeFinishTime, ");
                sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                sql.append(" IFNULL( CONVERT ( ( sum( f.coinChargeCost ) / sum( f.coinChargeIncome ) ) * 100, DECIMAL ( 15, 2 ) ),0.00 ) AS CoinRatio, ");
                sql.append(" sum( f.csrefundCnt ) AS csrefundCnt, ");
                sql.append(" ifnull(round(oo.elecTotal / (oo.elecTotal + oo.tmplService) * 100,2),0.00) as CostRatio, ");
                sql.append(" sum( f.chargeServiceMoney ) AS chargeServiceMoney, ");
                sql.append(" sum( f.csrefundMoney ) AS csrefundMoney, ");
                sql.append(" sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr ");
                sql.append(" from ebike.dev_ev_charging_pile a ");
                sql.append(" left join ebike.stat_chargedevice_day f ON ( a.id = f.chargedeviceId AND date_format( f.statDate, '%Y-%m-%d' ) = ?)",map.get("startTime"));
                sql.append(" left join ebike.ebike_chargedevice_ops c ON a.id = c.chargedeviceId  ");
                sql.append(" left join ( ");
                sql.append(" select o.charging_pile_id,sum(o.charge_expense_service) as tmplService,sum(o.charge_expense_total) as elecTotal ");
                sql.append(" from order_ev_charging_his as o ");
                sql.append(" where o.org_no = ?",subbro);
                sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') = ?",map.get("startTime"));
                sql.append(" group by o.charging_pile_id ");
                sql.append(" ) as oo on (a.id = oo.charging_pile_id) ");
                sql.append(" where a.charging_station_id = ?", map.get("id"));
                sql.append(" group by a.id; ");

            }
            if ("2".equals(map.get("date"))) {

                sql.append("  select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit, ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(f.csrefundMoney) as csrefundMoney,sum(f.csrefundMoneyByOpr) as csrefundMoneyByOpr ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append("  left join ebike.stat_chargedevice_month f on (f.chargedeviceId=a.ID   ");
                if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                    String[] time = map.get("startTime").split("-");
                    String startTime = time[0] + time[1];
                    sql.append(" and f.statMonth=? ", startTime);

                } else {
                    sql.append(" and f.statMonth=? ", map.get("startTime"));
                }

                sql.append(" )");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");

                sql.append(" union all ");

                sql.append(" select ");
                sql.append(" a.ID, ");
                sql.append(" a.charging_pile_no as chargedeviceNo, ");
                sql.append(" a.charging_pile_status as status, ");
                sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                sql.append(" f.chargeCnt, ");
                sql.append(" f.chargeIncome, ");
                sql.append(" a.charging_gun_count as chargeCnt, ");
                sql.append(" c.opStatus, ");
                sql.append(" f.chargeCost, ");
                sql.append(" f.chargeProfit, ");
                sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                sql.append(" sum( f.coinChargeCnt ) AS coinChargeCnt, ");
                sql.append(" f.lastCoinChargeFinishTime, ");
                sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                sql.append(" IFNULL( CONVERT ( ( sum( f.coinChargeCost ) / sum( f.coinChargeIncome ) ) * 100, DECIMAL ( 15, 2 ) ),0.00 ) AS CoinRatio, ");
                sql.append(" sum( f.csrefundCnt ) AS csrefundCnt, ");
                sql.append(" ifnull(round(oo.elecTotal / (oo.elecTotal + oo.tmplService) * 100,2),0.00) as CostRatio, ");
                sql.append(" sum( f.chargeServiceMoney ) AS chargeServiceMoney, ");
                sql.append(" sum( f.csrefundMoney ) AS csrefundMoney, ");
                sql.append(" sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr ");
                sql.append(" from ebike.dev_ev_charging_pile a ");
                sql.append(" left join ebike.stat_chargedevice_month f ON (a.id = f.chargedeviceId and f.statMonth = ?)",map.get("startTime").replace("-",""));
                sql.append(" left join ebike.ebike_chargedevice_ops c ON a.id = c.chargedeviceId  ");
                sql.append(" left join ( ");
                sql.append(" select o.charging_pile_id,sum(o.charge_expense_service) as tmplService,sum(o.charge_expense_total) as elecTotal ");
                sql.append(" from order_ev_charging_his as o ");
                sql.append(" where o.org_no = ?",subbro);
                sql.append(" and date_format(o.charge_finish_time,'%Y-%m') = ?",map.get("startTime"));
                sql.append(" group by o.charging_pile_id ");
                sql.append(" ) as oo on (a.id = oo.charging_pile_id) ");
                sql.append(" where a.charging_station_id = ?", map.get("id"));
                sql.append(" group by a.id; ");

            }
            if ("3".equals(map.get("date"))) {
                sql.append("  select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit, ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(f.csrefundMoney) as csrefundMoney,sum(f.csrefundMoneyByOpr) as csrefundMoneyByOpr ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append(" left join ebike.stat_chargedevice_year f on (f.chargedeviceId=a.ID  ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" )");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");

                sql.append(" union all ");

                sql.append(" select ");
                sql.append(" a.ID, ");
                sql.append(" a.charging_pile_no as chargedeviceNo, ");
                sql.append(" a.charging_pile_status as status, ");
                sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                sql.append(" f.chargeCnt, ");
                sql.append(" f.chargeIncome, ");
                sql.append(" a.charging_gun_count as chargeCnt, ");
                sql.append(" c.opStatus, ");
                sql.append(" f.chargeCost, ");
                sql.append(" f.chargeProfit, ");
                sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                sql.append(" sum( f.coinChargeCnt ) AS coinChargeCnt, ");
                sql.append(" f.lastCoinChargeFinishTime, ");
                sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                sql.append(" IFNULL( CONVERT ( ( sum( f.coinChargeCost ) / sum( f.coinChargeIncome ) ) * 100, DECIMAL ( 15, 2 ) ),0.00 ) AS CoinRatio, ");
                sql.append(" sum( f.csrefundCnt ) AS csrefundCnt, ");
                sql.append(" ifnull(round(oo.elecTotal / (oo.elecTotal + oo.tmplService) * 100,2),0.00) as CostRatio, ");
                sql.append(" sum( f.chargeServiceMoney ) AS chargeServiceMoney, ");
                sql.append(" sum( f.csrefundMoney ) AS csrefundMoney, ");
                sql.append(" sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr ");
                sql.append(" from ebike.dev_ev_charging_pile a ");
                sql.append(" left join ebike.stat_chargedevice_year f ON (a.id = f.chargedeviceId and f.statYear = ?)",map.get("startTime"));
                sql.append(" left join ebike.ebike_chargedevice_ops c ON a.id = c.chargedeviceId  ");
                sql.append(" left join ( ");
                sql.append(" select o.charging_pile_id,sum(o.charge_expense_service) as tmplService,sum(o.charge_expense_total) as elecTotal ");
                sql.append(" from order_ev_charging_his as o ");
                sql.append(" where o.org_no = ?",subbro);
                sql.append(" and date_format(o.charge_finish_time,'%Y') = ?",map.get("startTime"));
                sql.append(" group by o.charging_pile_id ");
                sql.append(" ) as oo on (a.id = oo.charging_pile_id) ");
                sql.append(" where a.charging_station_id = ?", map.get("id"));
                sql.append(" group by a.id; ");
            }
            if ("4".equals(map.get("date"))) {
                sql.append("  select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,sum(f.chargeCnt) as  chargeCnt ,sum(f.chargeIncome) as  chargeIncome ,a.plugcount,c.opStatus,sum(f.chargeCost) as chargeCost  ,sum(f.chargeProfit) as chargeProfit, ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(f.csrefundMoney) as csrefundMoney,sum(f.csrefundMoneyByOpr) as csrefundMoneyByOpr ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append("  left join ebike.stat_chargedevice_day f on (f.chargedeviceId=a.ID ");
//				sql.append(" and date_format(f.statDate,'%Y-%m-%d') >=?",map.get("startTime"));
//				sql.append(" and date_format(f.statDate,'%Y-%m-%d') <=? ",map.get("endTime"));
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" )");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");

                sql.append(" union all ");

                sql.append(" select ");
                sql.append(" a.ID, ");
                sql.append(" a.charging_pile_no as chargedeviceNo, ");
                sql.append(" a.charging_pile_status as status, ");
                sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, ");
                sql.append(" f.chargeCnt, ");
                sql.append(" f.chargeIncome, ");
                sql.append(" a.charging_gun_count as chargeCnt, ");
                sql.append(" c.opStatus, ");
                sql.append(" f.chargeCost, ");
                sql.append(" f.chargeProfit, ");
                sql.append(" sum( f.chargeIncomeByOpr ) AS chargeIncomeByOpr, ");
                sql.append(" sum( f.coinChargeCnt ) AS coinChargeCnt, ");
                sql.append(" f.lastCoinChargeFinishTime, ");
                sql.append(" sum( f.coinChargeIncome ) AS coinChargeIncome, ");
                sql.append(" IFNULL( CONVERT ( ( sum( f.coinChargeCost ) / sum( f.coinChargeIncome ) ) * 100, DECIMAL ( 15, 2 ) ),0.00 ) AS CoinRatio, ");
                sql.append(" sum( f.csrefundCnt ) AS csrefundCnt, ");
                sql.append(" ifnull(round(oo.elecTotal / (oo.elecTotal + oo.tmplService) * 100,2),0.00) as CostRatio, ");
                sql.append(" sum( f.chargeServiceMoney ) AS chargeServiceMoney, ");
                sql.append(" sum( f.csrefundMoney ) AS csrefundMoney, ");
                sql.append(" sum( f.csrefundMoneyByOpr ) AS csrefundMoneyByOpr ");
                sql.append(" from ebike.dev_ev_charging_pile a ");
                sql.append(" left join ebike.stat_chargedevice_day f ON ( a.id = f.chargedeviceId AND date_format( f.statDate, '%Y-%m-%d' ) >= ?",map.get("startTime"));
                sql.append("AND date_format( f.statDate, '%Y-%m-%d' ) <= ?)",map.get("endTime"));
                sql.append(" left join ebike.ebike_chargedevice_ops c ON a.id = c.chargedeviceId  ");
                sql.append(" left join ( ");
                sql.append(" select o.charging_pile_id,sum(o.charge_expense_service) as tmplService,sum(o.charge_expense_total) as elecTotal ");
                sql.append(" from order_ev_charging_his as o ");
                sql.append(" where o.org_no = ?",subbro);
                sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') >= ?",map.get("startTime"));
                sql.append(" and date_format(o.charge_finish_time,'%Y-%m-%d') <= ?",map.get("endTime"));
                sql.append(" group by o.charging_pile_id ");
                sql.append(" ) as oo on (a.id = oo.charging_pile_id) ");
                sql.append(" where a.charging_station_id = ?", map.get("id"));
                sql.append(" group by a.id; ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>queryRevenueCountInMeter>>>>><<<<<<<<<<" + sql.getSql());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryShareDeviceRevenue(String subburo, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                sql.append(" select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit,  ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(stat.csrefundMoney)  as SharecsrefundMoney,sum(f.csrefundMoney) as csrefundMoney,sum(stat.chargeIncome) as chargeIncomes ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append("  left join ebike.stat_chargedevice_day  f   on (a.ID=f.chargedeviceId  ");
                if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                    sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                } else {
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                }
                sql.append(" left join ebike.stat_sh_chargedevice_day stat on (  a.ID=stat.chargedeviceId  ");
                sql.append(" and date_format(stat.statDate,'%Y-%m-%d') =?", map.get("startTime"));
                sql.append(" ) ");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");
            }
            if ("2".equals(map.get("date"))) {

                sql.append("  select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit, ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(stat.csrefundMoney)  as SharecsrefundMoney,sum(f.csrefundMoney) as csrefundMoney,sum(stat.chargeIncome) as chargeIncomes   ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append("  left join ebike.stat_chargedevice_month f on (f.chargedeviceId=a.ID   ");
                if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                    String[] time = map.get("startTime").split("-");
                    String startTime = time[0] + time[1];
                    sql.append(" and f.statMonth=? ", startTime);

                } else {
                    sql.append(" and f.statMonth=? ", map.get("startTime"));
                }

                sql.append(" )");
                sql.append(" left join ebike.stat_sh_chargedevice_month stat on a.ID=stat.chargedeviceId  ");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");
            }
            if ("3".equals(map.get("date"))) {
                sql.append("  select a.ID,a.chargedeviceNo,b.status,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome,a.plugcount,c.opStatus,f.chargeCost,f.chargeProfit, ");
                sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,sum(f.csrefundCnt) as csrefundCnt, ");
                sql.append(" IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio,sum(f.chargeServiceMoney)  as  chargeServiceMoney,sum(stat.csrefundMoney)  as SharecsrefundMoney,sum(f.csrefundMoney) as csrefundMoney,sum(stat.chargeIncome) as chargeIncomes   ");
                sql.append("  from cisp_dev.dev_ebikechargedevice a left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append(" left join ebike.stat_chargedevice_year f on (f.chargedeviceId=a.ID  ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" )");
                sql.append(" left join ebike.stat_sh_chargedevice_year stat on a.ID=stat.chargedeviceId  ");
                sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId where 1=1  ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");
            }
            if ("4".equals(map.get("date"))) {
                sql.append(" select n.id,n.chargedeviceNo,n. STATUS,max(f.lastChargeFinishTime) as lastChargeFinishTime,sum(f.chargeCnt) as chargeCnt ,sum(f.chargeIncome) as chargeIncome ,n.plugcount,sum(f.chargeCost) as chargeCost ,sum(f.chargeProfit) as chargeProfit ,   ");
                sql.append(" sum(f.chargeIncomeByOpr) AS chargeIncomeByOpr,sum(f.coinChargeCnt) AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                sql.append(" sum(f.coinChargeIncome) AS coinChargeIncome,sum(f.csrefundCnt) AS csrefundCnt, ");
                sql.append(" IFNULL(CONVERT ((sum(f.chargeCost) / sum(f.chargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS CostRatio, ");
                sql.append(" sum(f.chargeServiceMoney) AS chargeServiceMoney,SharecsrefundMoney,sum(f.csrefundMoney) AS csrefundMoney, n.chargeIncomes  ");
                sql.append(" from  cisp_dev.dev_ebikechargedevice a left join   ebike.stat_chargedevice_day f ON (a.ID = f.chargedeviceId   ");
				/*sql.append(" and date_format(f.statDate,'%Y-%m-%d') >=?",map.get("startTime"));
				sql.append(" and date_format(f.statDate,'%Y-%m-%d') <=? ",map.get("endTime"));*/
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" ) ");
                sql.append(" left join ( SELECT  sum(stat.chargeIncome) AS chargeIncomes,sum(stat.csrefundMoney) AS shareCsrefundMoney,  ");
                sql.append(" a.plugcount as plugcount ,a.id AS id,a.chargedeviceNo AS chargedeviceNo,  ");
                sql.append(" b. STATUS AS STATUS,b. NAME AS NAME    ");
                sql.append(" FROM  cisp_dev.dev_ebikechargedevice a LEFT JOIN cisp_dev.dev_powersystemresource b ON a.ID = b.ID  ");
                sql.append("  left join ebike.stat_sh_chargedevice_day  stat  on ( a.Id=stat.chargedeviceId    ");
//				sql.append(" and date_format(stat.statDate,'%Y-%m-%d') >=?",map.get("startTime"));
//				sql.append(" and date_format(stat.statDate,'%Y-%m-%d') <=? ",map.get("endTime"));
                sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" ) where 1=1 ");
                sql.append(" and a.chargestationId=? ", map.get("id"));
                sql.append(" group by a.ID ");
                sql.append(" ) n on a.ID=n.id where 1=1  ");
            }


            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>queryShareDeviceRevenue>>>>><<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryShareStatistics(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String type = map.get("type");
        try {
            /**
             * 日统计查询
             */
            if ("1".equals(map.get("date"))) {
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                }
            }
            /**
             * 月统计查询
             */
            if ("2".equals(map.get("date"))) {
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_month  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_month stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as chargeIncome,f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_month  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS chargeIncome,f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_month f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_month stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statMonth = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                }
            }
            /**
             * 年统计查询
             */
            if ("3".equals(map.get("date"))) {
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as 'chargeIncome',f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_year  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS 'chargeIncome',f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_year stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append("  select 1 as type, a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,f.chargeCnt,f.chargeIncome as 'chargeIncome',f.chargeServiceMoney as chargeServiceMoney,stat.chargeIncome as chargeIncomes,    ");
                    sql.append(" f.chargeIncomeByOpr as  chargeIncomeByOpr ,f.coinChargeCnt as coinChargeCnt,f.lastCoinChargeFinishTime,f.coinChargeIncome as coinChargeIncome ,  ");
                    sql.append(" IFNULL(convert((f.coinChargeCost/f.coinChargeIncome)*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append(" IFNULL(convert((f.chargeCost/f.chargeIncome)*100,decimal(15,2)) ,0.00) as CostRatio  ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f  on ( a.ID=f.chargestationId ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                    sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append("  left join ebike.stat_sh_chargestation_year  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" GROUP BY a.STATIONNO ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS 'chargeIncome',f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_year f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_year stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statYear = ?", map.get("startTime"));
                    sql.append(" ) ");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                }
            }
            /**
             * 自定义时间区间查询
             */
            if ("4".equals(map.get("date"))) {
                if ("1".equals(type)) {
                    /**
                     * 全部
                     */
                    sql.append("  select 1 as type,a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,  ");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,sum(f.chargeCnt) as 'chargeCnt',sum(f.chargeIncome) as 'chargeIncome',sum(f.chargeServiceMoney) as chargeServiceMoney,sum(stat.chargeIncome) as chargeIncomes,");
                    sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append("  IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio   ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId   ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" 	left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append(" left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20'  ");
                    sql.append(" and h.stakeholderOrgNo= ?", subbro);
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like  ?", "%" + map.get("stationNo") + "%");
                    sql.append("  group by a.ID ");

                    sql.append(" union all ");

                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS 'chargeIncome',f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                } else if ("2".equals(type)) {
                    /**
                     * 自行车
                     */
                    sql.append("  select 1 as type,a.stationNo,a.id,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,  ");
                    sql.append(" d.NAME,max(f.lastChargeFinishTime) as lastChargeFinishTime,sum(f.chargeCnt) as 'chargeCnt',sum(f.chargeIncome) as 'chargeIncome',sum(f.chargeServiceMoney) as chargeServiceMoney,sum(stat.chargeIncome) as chargeIncomes,");
                    sql.append(" sum(f.chargeIncomeByOpr) as  chargeIncomeByOpr ,sum(f.coinChargeCnt) as coinChargeCnt,f.lastCoinChargeFinishTime,sum(f.coinChargeIncome) as coinChargeIncome , ");
                    sql.append(" IFNULL(convert((sum(f.coinChargeCost)/sum(f.coinChargeIncome))*100,decimal(15,2)) ,0.00) as CoinRatio,  ");
                    sql.append("  IFNULL(convert((sum(f.chargeCost)/sum(f.chargeIncome))*100,decimal(15,2)) ,0.00) as CostRatio   ");
                    sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId   ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                    sql.append(" 	left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                    sql.append(" left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                    sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20'  ");
                    sql.append(" and h.stakeholderOrgNo= ?", subbro);
                    sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and d.name like  ?", "%" + map.get("stationNo") + "%");
                    sql.append("  group by a.ID ");
                } else if ("3".equals(type)) {
                    /**
                     * 汽车
                     */
                    sql.append(" select 2 as type, a.charging_station_no as stationNo,a.id, ");
                    sql.append(" GROUP_CONCAT( b.charging_pile_no ORDER BY b.charging_pile_no ASC ) AS chargedeviceNo, ");
                    sql.append(" a.charging_station_status as status,a.charging_station_name as name, ");
                    sql.append(" max( f.lastChargeFinishTime ) AS lastChargeFinishTime, f.chargeCnt,");
                    sql.append(" f.chargeIncome AS 'chargeIncome',f.chargeServiceMoney AS chargeServiceMoney, ");
                    sql.append(" stat.chargeIncome AS chargeIncomes,f.chargeIncomeByOpr AS chargeIncomeByOpr, ");
                    sql.append(" f.coinChargeCnt AS coinChargeCnt,f.lastCoinChargeFinishTime, ");
                    sql.append(" f.coinChargeIncome AS coinChargeIncome, ");
                    sql.append(" IFNULL( CONVERT ( ( f.coinChargeCost / f.coinChargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CoinRatio, ");
                    sql.append(" IFNULL( CONVERT ( ( f.chargeCost / f.chargeIncome ) * 100, DECIMAL ( 15, 2 ) ), 0.00 ) AS CostRatio  ");
                    sql.append(" from ebike.oper_ev_charging_station a ");
                    sql.append(" left join ebike.stat_chargestation_day f on ( a.ID = f.chargestationId  ");
                    sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" left join ebike.dev_ev_charging_pile b on b.charging_station_id = a.ID ");
                    sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON ( a.Id = stat.chargestationId  ");
                    sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                    sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                    sql.append(" )");
                    sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON ( h.chargestationId = a.ID ) ");
                    sql.append(" where true ");
                    sql.append(" and b.charging_pile_no like ?", "%" + map.get("chargedeviceNo") + "%");
                    sql.append(" and a.charging_station_name like ?", "%" + map.get("stationNo") + "%");
                    sql.append(" and h.stakeholderOrgNo =? ", subbro);
                    sql.append(" group by a.charging_station_no ");
                }
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>queryShareStatistics>>>>><<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryShareStatisticsCount(String subbro, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ( select count(1) from ebike.ebike_cssh_distscheme h     ");
            sql.append(" left join cisp_dev.dev_powersystemresource d  on h.chargestationId=d.ID    ");
            sql.append(" INNER JOIN cisp_dev.dev_ebikechargestation  a on a.id=h.chargestationId  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
            sql.append(" where 1=1 and d.STATUS='20' and h.csshdsStatus='00'   ");
            sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
            sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and h.stakeholderOrgNo= ?", subbro);
            sql.append(" GROUP BY a.id) n ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> getShareProfit(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> maps = new HashMap<String, Object>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        logger.debug("dasdasdsadas");
        try {

            if ("1".equals(map.get("date"))) {
                logger.debug(">>>>>>>>>>>>>>>>>>>map.getDate<<<<<<<<<<<<<<<" + map.get("date"));
                logger.debug(">>>>>>>>>>>>>>>>>>>map.Time<<<<<<<<<<<<<<<" + map.get("startTime"));

                sql.append(" SELECT IFNULL(CONVERT ((sum(f.chargeCost) / sum(f.chargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS tcost,   ");
                sql.append(" IFNULL(ROUND(sum(f.chargeIncome), 2),0.00) AS tincome,ROUND(sum(f.chargeProfit), 2) AS tprofit, ");
                sql.append("  IFNULL(ROUND(sum(f.coinChargeIncome), 2),0.00) AS coinChargeIncome,  ");
                sql.append("  IFNULL(CONVERT ((sum(f.coinChargeCost) / sum(f.coinChargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS coinChargeCost, ");
                sql.append("  ROUND(sum(f.coinChargeProfit), 2) AS coinChargeProfit,ROUND(sum(f.chargeIncomeByOpr), 2) AS chargeIncomeByOpr,  ");
                sql.append(" ROUND(sum(f.chargeIncomeBySh), 2) AS chargeIncomeBySh,IFNULL(sum(f.csrefundMoney), 0.00) AS csrefundMoney,  ");
                sql.append(" IFNULL(stat.chargeIncome, 0.00) AS chargeIncome,IFNULL(stat.csrefundMoney,0.00) AS shareCsrefundMoney,   ");
                sql.append(" IFNULL(sum(f.chargeCnt), 0) AS chargeCnt,sum(f.coinChargeCnt) AS coinChargeCnt,IFNULL(sum(f.csrefundCnt), 0) AS csrefundCnt   ");
                sql.append("  FROM  ebike.stat_chargestation_day f ");
                sql.append(" LEFT JOIN cisp_dev.dev_ebikechargestation a on a.Id = f.chargestationId ");
                sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource d ON d.ID = a.ID ");
                sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON a.Id = stat.chargestationId ");
                sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON (h.chargestationId = a.ID) WHERE 1 = 1 ");
                sql.append(" AND d. STATUS = '20' AND h.csshdsStatus = '00' ");
                sql.append(" and h.stakeholderOrgNo= ?", subbro);
                sql.append(" and f.statDate=?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and d.name like ? ", "%" + map.get("stationNo") + "%");
            }
            if ("2".equals(map.get("date"))) {

                sql.append(" SELECT IFNULL(CONVERT ((sum(f.chargeCost) / sum(f.chargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS tcost,   ");
                sql.append(" IFNULL(ROUND(sum(f.chargeIncome), 2),0.00) AS tincome,ROUND(sum(f.chargeProfit), 2) AS tprofit, ");
                sql.append("  IFNULL(ROUND(sum(f.coinChargeIncome), 2),0.00) AS coinChargeIncome,  ");
                sql.append("  IFNULL(CONVERT ((sum(f.coinChargeCost) / sum(f.coinChargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS coinChargeCost, ");
                sql.append("  ROUND(sum(f.coinChargeProfit), 2) AS coinChargeProfit,ROUND(sum(f.chargeIncomeByOpr), 2) AS chargeIncomeByOpr,  ");
                sql.append(" ROUND(sum(f.chargeIncomeBySh), 2) AS chargeIncomeBySh,IFNULL(sum(f.csrefundMoney), 0.00) AS csrefundMoney,  ");
                sql.append(" IFNULL(stat.chargeIncome, 0.00) AS chargeIncome,IFNULL(stat.csrefundMoney,0.00) AS shareCsrefundMoney,   ");
                sql.append(" IFNULL(sum(f.chargeCnt), 0) AS chargeCnt,sum(f.coinChargeCnt) AS coinChargeCnt,IFNULL(sum(f.csrefundCnt), 0) AS csrefundCnt   ");
                sql.append("  FROM  ebike.stat_chargestation_month f ");
                sql.append(" LEFT JOIN cisp_dev.dev_ebikechargestation a on a.Id = f.chargestationId ");
                sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource d ON d.ID = a.ID ");
                sql.append(" LEFT JOIN ebike.stat_sh_chargestation_month stat ON a.Id = stat.chargestationId ");
                sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON (h.chargestationId = a.ID) WHERE 1 = 1 ");
                sql.append(" AND d. STATUS = '20' AND h.csshdsStatus = '00' ");
                sql.append(" and h.stakeholderOrgNo= ?", subbro);
                sql.append(" and f.statMonth= ?", map.get("startTime"));
                sql.append(" and d.name like ? ", "%" + map.get("stationNo") + "%");
            }
            if ("3".equals(map.get("date"))) {
                sql.append(" SELECT IFNULL(CONVERT ((sum(f.chargeCost) / sum(f.chargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS tcost,   ");
                sql.append(" IFNULL(ROUND(sum(f.chargeIncome), 2),0.00) AS tincome,ROUND(sum(f.chargeProfit), 2) AS tprofit, ");
                sql.append("  IFNULL(ROUND(sum(f.coinChargeIncome), 2),0.00) AS coinChargeIncome,  ");
                sql.append("  IFNULL(CONVERT ((sum(f.coinChargeCost) / sum(f.coinChargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS coinChargeCost, ");
                sql.append("  ROUND(sum(f.coinChargeProfit), 2) AS coinChargeProfit,ROUND(sum(f.chargeIncomeByOpr), 2) AS chargeIncomeByOpr,  ");
                sql.append(" ROUND(sum(f.chargeIncomeBySh), 2) AS chargeIncomeBySh,IFNULL(sum(f.csrefundMoney), 0.00) AS csrefundMoney,  ");
                sql.append(" IFNULL(stat.chargeIncome, 0.00) AS chargeIncome,IFNULL(stat.csrefundMoney,0.00) AS shareCsrefundMoney,   ");
                sql.append(" IFNULL(sum(f.chargeCnt), 0) AS chargeCnt,sum(f.coinChargeCnt) AS coinChargeCnt,IFNULL(sum(f.csrefundCnt), 0) AS csrefundCnt   ");
                sql.append("  FROM  ebike.stat_chargestation_year f ");
                sql.append(" LEFT JOIN cisp_dev.dev_ebikechargestation a on a.Id = f.chargestationId ");
                sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource d ON d.ID = a.ID ");
                sql.append(" LEFT JOIN ebike.stat_sh_chargestation_year stat ON a.Id = stat.chargestationId ");
                sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON (h.chargestationId = a.ID) WHERE 1 = 1 ");
                sql.append(" AND d. STATUS = '20' AND h.csshdsStatus = '00' ");
                sql.append(" and h.stakeholderOrgNo= ?", subbro);
                sql.append(" and f.statYear= ?", map.get("startTime"));
                sql.append(" and d.name like ? ", "%" + map.get("stationNo") + "%");

            }
            if ("4".equals(map.get("date"))) {
                sql.append(" SELECT IFNULL(CONVERT ((sum(f.chargeCost) / sum(f.chargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS tcost,   ");
                sql.append(" IFNULL(ROUND(sum(f.chargeIncome), 2),0.00) AS tincome,ROUND(sum(f.chargeProfit), 2) AS tprofit, ");
                sql.append("  IFNULL(ROUND(sum(f.coinChargeIncome), 2),0.00) AS coinChargeIncome,  ");
                sql.append("  IFNULL(CONVERT ((sum(f.coinChargeCost) / sum(f.coinChargeIncome)) * 100,DECIMAL (15, 2)),0.00) AS coinChargeCost, ");
                sql.append("  ROUND(sum(f.coinChargeProfit), 2) AS coinChargeProfit,ROUND(sum(f.chargeIncomeByOpr), 2) AS chargeIncomeByOpr,  ");
                sql.append(" ROUND(sum(f.chargeIncomeBySh), 2) AS chargeIncomeBySh,IFNULL(sum(f.csrefundMoney), 0.00) AS csrefundMoney,  ");
                sql.append(" IFNULL(stat.chargeIncome, 0.00) AS chargeIncome,IFNULL(stat.csrefundMoney,0.00) AS shareCsrefundMoney,   ");
                sql.append(" IFNULL(sum(f.chargeCnt), 0) AS chargeCnt,sum(f.coinChargeCnt) AS coinChargeCnt,IFNULL(sum(f.csrefundCnt), 0) AS csrefundCnt   ");
                sql.append("  FROM  ebike.stat_chargestation_day f ");
                sql.append(" LEFT JOIN cisp_dev.dev_ebikechargestation a on a.Id = f.chargestationId ");
                sql.append(" LEFT JOIN cisp_dev.dev_powersystemresource d ON d.ID = a.ID ");
                sql.append(" LEFT JOIN ebike.stat_sh_chargestation_day stat ON a.Id = stat.chargestationId ");
                sql.append(" LEFT JOIN ebike.ebike_cssh_distscheme h ON (h.chargestationId = a.ID) WHERE 1 = 1 ");
                sql.append(" AND d. STATUS = '20' AND h.csshdsStatus = '00' ");
                sql.append(" and h.stakeholderOrgNo= ?", subbro);
                sql.append(" and f.statDate>= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and d.name like ? ", "%" + map.get("stationNo") + "%");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>getShareProfit>>>>><<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }
    }

    @Override
    public List<Map<String, Object>> stationTrend(String id, String dateFlag, String startDay, String endDay) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        final String flag = dateFlag;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("3".equals(dateFlag)) {
                String startMonth = startDay + "01";
                String endMonth = "";
                Calendar cal = Calendar.getInstance();
                int months = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                if (year == Integer.parseInt(startDay)) {

                    if (months < 10) {
                        endMonth = startDay + "0" + String.valueOf(months);
                    } else {
                        endMonth = startDay + String.valueOf(months);
                    }

                } else {
                    endMonth = startDay + "12";
                }
                sql.append(" SELECT  od.statMonth,od.chargeCnt,od.chargePlugCnt,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome  FROM ");
                sql.append(" ( SELECT statMonth,chargeCnt,chargePlugCnt,chargeIncome,coinChargeCnt,coinChargeIncome   FROM ebike.stat_chargestation_month WHERE 1=1  ");
                sql.append(" and statMonth>=? ", startMonth);
                sql.append("  and  statMonth<=? ", endMonth);
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statMonth ");
                if (year == Integer.parseInt(startDay)) {
                    for (int i = 0; i < months; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", month);
                        }

                    }
                } else {
                    for (int i = 0; i < 12; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", month);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statMonth ");
                sql.append(" ORDER BY od.statMonth ASC ");
            } else if ("2".equals(dateFlag)) {
                Calendar calendar = Calendar.getInstance();
                //获得当前时间的月份，月份从0开始所以结果要加1
                int month1 = calendar.get(Calendar.MONTH) + 1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                int day = EbikeCommonUtil.getDaysOfMonth(sdf.parse(startDay));
                int month = EbikeCommonUtil.getMonth(sdf.parse(startDay));
                String startDays = startDay + "-01";
                String endDays = startDay + "-" + String.valueOf(day);
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargePlugCnt,od.chargeIncome,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome   FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargePlugCnt,chargeIncome,coinChargeCnt,coinChargeIncome   FROM ebike.stat_chargestation_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDays);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDays);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statDate ");
                if (month == month1) {
                    logger.debug(">>>>>>month<<<<<" + month);
                    logger.debug(">>>>>>month1<<<<<" + month1);
                    for (int i = 0; i < calendar.get(Calendar.DATE) - 1; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", date);
                        }

                    }
                } else {
                    for (int i = 0; i < day; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", date);
                        }

                    }
                }

                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");


            } else {
                SimpleDateFormat forDate = new SimpleDateFormat("yyyy-MM-dd");
                int days = EbikeCommonUtil.differentDaysByMillisecond(forDate.parse(startDay), forDate.parse(endDay));
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargePlugCnt,od.chargeIncome,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargePlugCnt,chargeIncome,coinChargeCnt,coinChargeIncome  FROM ebike.stat_chargestation_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDay);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDay);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statDate ");
                String satrtDays = startDay;
                for (int i = 0; i < days; i++) {
                    if (i == 0) {
                        sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", satrtDays);
                    }
                    if (0 < i && i < 10) {

                        Date ss = forDate.parse(satrtDays);
                        Date a = EbikeCommonUtil.addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", dateString);
                    } else {
                        Date ss = forDate.parse(satrtDays);
                        Date a = EbikeCommonUtil.addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0,0) ", dateString);
                    }

                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        if ("3".equals(flag)) {
                            map.put("statDate", rs.getString("statMonth"));
                        } else {
                            map.put("statDate", rs.getDate("statDate").toString());
                        }
                        map.put("chargeCnt", rs.getInt("chargeCnt"));
                        map.put("chargeIncome", rs.getDouble("chargeIncome"));
                        map.put("chargePlugCnt", rs.getInt("chargePlugCnt"));
                        map.put("coinChargeCnt", rs.getInt("coinChargeCnt"));
                        map.put("coinChargeIncome", rs.getDouble("coinChargeIncome"));
                        return map;

                    }
                });
            logger.debug(">>>>>>>>><getTrendData<<<<<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> devTrend(String id, String dateFlag, String startDay, String endDay) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        final String flag = dateFlag;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("3".equals(dateFlag)) {
                String startMonth = startDay + "01";
                String endMonth = "";
                Calendar cal = Calendar.getInstance();
                int months = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                if (year == Integer.parseInt(startDay)) {

                    if (months < 10) {
                        endMonth = startDay + "0" + String.valueOf(months);
                    } else {
                        endMonth = startDay + String.valueOf(months);
                    }

                } else {
                    endMonth = startDay + "12";
                }
                sql.append(" SELECT  od.statMonth,od.chargeCnt,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome  FROM ");
                sql.append(" ( SELECT statMonth,chargeCnt,chargeIncome,coinChargeCnt,coinChargeIncome   FROM ebike.stat_chargedevice_month WHERE 1=1  ");
                sql.append(" and statMonth>=? ", startMonth);
                sql.append("  and  statMonth<=? ", endMonth);
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statMonth ");
                if (year == Integer.parseInt(startDay)) {
                    for (int i = 0; i < months; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        }

                    }
                } else {
                    for (int i = 0; i < 12; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statMonth ");
                sql.append(" ORDER BY od.statMonth ASC ");
            } else if ("2".equals(dateFlag)) {
                Calendar calendar = Calendar.getInstance();
                //获得当前时间的月份，月份从0开始所以结果要加1
                int month1 = calendar.get(Calendar.MONTH) + 1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                int day = EbikeCommonUtil.getDaysOfMonth(sdf.parse(startDay));
                int month = EbikeCommonUtil.getMonth(sdf.parse(startDay));
                String startDays = startDay + "-01";
                String endDays = startDay + "-" + String.valueOf(day);
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargeIncome,coinChargeCnt,coinChargeIncome   FROM ebike.stat_chargedevice_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDays);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDays);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statDate ");
                if (month == month1) {
                    for (int i = 0; i < calendar.get(Calendar.DATE) - 1; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        }

                    }
                } else {
                    for (int i = 0; i < day; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");


            } else {
                SimpleDateFormat forDate = new SimpleDateFormat("yyyy-MM-dd");
                int days = EbikeCommonUtil.differentDaysByMillisecond(forDate.parse(startDay), forDate.parse(endDay));
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargeIncome,od.coinChargeCnt,od.coinChargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargeIncome,coinChargeCnt,coinChargeIncome   FROM ebike.stat_chargedevice_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDay);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDay);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statDate ");
                String satrtDays = startDay;
                for (int i = 0; i < days; i++) {
                    if (i == 0) {
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", satrtDays);
                    }
                    if (0 < i && i < 10) {

                        Date ss = forDate.parse(satrtDays);
                        Date a = EbikeCommonUtil.addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", dateString);
                    } else {
                        Date ss = forDate.parse(satrtDays);
                        Date a = EbikeCommonUtil.addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", dateString);
                    }

                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        if ("3".equals(flag)) {
                            map.put("statDate", rs.getString("statMonth"));
                        } else {
                            map.put("statDate", rs.getDate("statDate").toString());
                        }
                        map.put("chargeCnt", rs.getInt("chargeCnt"));
                        map.put("chargeIncome", rs.getDouble("chargeIncome"));
                        map.put("coinChargeCnt", rs.getInt("coinChargeCnt"));
                        map.put("coinChargeIncome", rs.getDouble("coinChargeIncome"));
                        return map;

                    }
                });
            logger.debug(">>>>>>>>><getTrendData<<<<<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }


    @Override
    public List<Map<String, Object>> queryRefundSticInit(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                logger.debug(">>>>>>>>>>>>>>>>>>>map.getDate<<<<<<<<<<<<<<<" + map.get("date"));
                logger.debug(">>>>>>>>>>>>>>>>>>>map.Time<<<<<<<<<<<<<<<" + map.get("startTime"));

                sql.append(" select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',");
                sql.append(" d.NAME,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,f.csrefundMoneyByOpr  as  csrefundMoneyByOpr ");

                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on (a.ID=f.chargestationId  ");
                if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                    sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                } else {
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                }
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                sql.append(" and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and ( d.SUBBURO = ?", subbro);
                sql.append(" or d.BURO = ? )", subbro);
                sql.append(" GROUP BY a.STATIONNO ");
            }
            if ("2".equals(map.get("date"))) {

                sql.append("select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo) as chargedeviceNo, d.status,IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',d.NAME,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,f.csrefundMoneyByOpr  as  csrefundMoneyByOpr  ");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f on (f.chargestationId=a.ID   ");
                if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                    String[] time = map.get("startTime").split("-");
                    String startTime = time[0] + time[1];
                    sql.append(" and f.statMonth=? ", startTime);

                } else {
                    sql.append(" and f.statMonth=? ", map.get("startTime"));
                }
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                sql.append(" and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and ( d.SUBBURO = ?", subbro);
                sql.append(" or d.BURO = ? )", subbro);
                sql.append(" GROUP BY a.STATIONNO ");
            }
            if ("3".equals(map.get("date"))) {
                sql.append("select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo) as chargedeviceNo,d.status, IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',d.NAME,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,f.csrefundMoneyByOpr  as  csrefundMoneyByOpr  ");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f on (f.chargestationId=a.ID  ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                sql.append(" and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and ( d.SUBBURO = ?", subbro);
                sql.append(" or d.BURO = ? )", subbro);
                sql.append(" GROUP BY a.STATIONNO ");
            }
            if ("4".equals(map.get("date"))) {
                sql.append(" select  a.stationNo  as stationNo ,a.ID as ID,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo ,d.status AS status , IFNULL(c.ORG_NAME,'独享') as 'stakeholderName',d.NAME as NAME,  ");
                sql.append(" n.csrefundCnt,n.csrefundMoney ,n.csrefundMoneyByOpr  ");
                sql.append("  from cisp_dev.dev_ebikechargestation a  left join  ");
                sql.append(" ( select a.ID as ID,");
                sql.append(" sum(f.csrefundCnt) as csrefundCnt,sum(f.csrefundMoney) as csrefundMoney,sum(f.csrefundMoneyByOpr)  as  csrefundMoneyByOpr  ");
                sql.append(" from  cisp_dev.dev_ebikechargestation a  LEFT JOIN  ebike.stat_chargestation_day f on  (a.ID = f.chargestationId  ");
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append("   ) GROUP BY a.ID ) n  on n.id=a.ID  ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
                sql.append(" and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and ( d.SUBBURO = ?", subbro);
                sql.append(" or d.BURO = ? )", subbro);
                sql.append("  GROUP BY a.ID   ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>>>>>>>>>queryRefundSticInit>>>>><<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }


    @Override
    public int queryRefundSticInitCount(String subbro, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_day f on (f.chargestationId=a.ID   ");
                if ("".equals(map.get("startTime")) || map.get("startTime") == null) {
                    sql.append(" and TO_DAYS(NOW( ) ) - TO_DAYS(f.statDate) = 1 )");
                } else {
                    sql.append(" and date_format(f.statDate,'%Y-%m-%d') = ? )", map.get("startTime"));
                }
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            } else if ("2".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_month f on (f.chargestationId=a.ID   ");
                if (map.get("startTime") != null || !"".equals(map.get("startTime"))) {
                    String[] time = map.get("startTime").split("-");
                    String startTime = time[0] + time[1];
                    sql.append(" and f.statMonth=? ", startTime);
                } else {
                    sql.append(" and f.statMonth=? ", map.get("startTime"));
                }
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            } else if ("3".equals(map.get("date"))) {
                sql.append(" select count(1) from  ( select count(1) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_year f on ( f.chargestationId=a.ID   ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");

            } else {
                sql.append(" select count(1) from  ( select count(DISTINCT (a.STATIONNO)) from cisp_dev.dev_ebikechargestation a left join ebike.stat_chargestation_day f on (f.chargestationId=a.ID   ");
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID)");
                sql.append(" left join cisp_sys.bp_org c on (h.stakeholderOrgNo=c.ORG_NO) where 1=1 ");
            }
            sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
            sql.append(" and h.stakeholderOrgNo = ?", map.get("stakeholderId"));
            sql.append(" and d.name like  ?", "%" + map.get("stationNo") + "%");
            sql.append(" and ( d.SUBBURO = ?", subbro);
            sql.append(" or d.BURO = ? )", subbro);
            sql.append(" and d.STATUS='20' ");
            sql.append(" GROUP BY a.STATIONNO) k ");
            return (Integer) ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryShareRefundStic(String subbro, Map<String, String> map) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            if ("1".equals(map.get("date"))) {
                sql.append(" select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                sql.append(" d.NAME ,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,stat.csrefundMoney  as SharecsrefundMoney");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId ");
                sql.append(" and f.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" ) ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                sql.append(" and stat.statDate = ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" ) ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and h.stakeholderOrgNo =? ", subbro);
                sql.append(" GROUP BY a.STATIONNO ");
            }

            if ("2".equals(map.get("date"))) {

                sql.append("select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo, d.status,");
                sql.append(" d.NAME ,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,stat.csrefundMoney  as SharecsrefundMoney ");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_month f  on ( a.ID=f.chargestationId ");
                sql.append(" and f.statMonth = ?", map.get("startTime"));
                sql.append(" ) ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.stat_sh_chargestation_month  stat  on ( a.Id=stat.chargestationId ");
                sql.append(" and stat.statMonth = ?", map.get("startTime"));
                sql.append(" ) ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and h.stakeholderOrgNo =? ", subbro);
                sql.append(" GROUP BY a.STATIONNO ");

            }
            if ("3".equals(map.get("date"))) {
                sql.append("select a.stationNo,a.ID,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo,d.status,");
                sql.append(" d.NAME ,f.csrefundCnt as csrefundCnt,f.csrefundMoney as csrefundMoney,stat.csrefundMoney  as SharecsrefundMoney ");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_year f  on ( a.ID=f.chargestationId ");
                sql.append(" and f.statYear = ?", map.get("startTime"));
                sql.append(" ) ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID   ");
                sql.append(" left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append("  left join ebike.stat_sh_chargestation_year  stat  on ( a.Id=stat.chargestationId ");
                sql.append(" and stat.statYear = ?", map.get("startTime"));
                sql.append(" ) ");
                sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20' ");
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
                sql.append(" and h.stakeholderOrgNo =? ", subbro);

                sql.append(" GROUP BY a.STATIONNO ");


            }
            if ("4".equals(map.get("date"))) {
                sql.append(" select a.stationNo as stationNo, a.id  as id ,GROUP_CONCAT( b.chargedeviceNo order by b.chargedeviceNo asc) as chargedeviceNo ,d.STATUS as status ,d.NAME  as NAME,sum(stat.csrefundMoney) as shareCsrefundMoney, ");
                sql.append(" sum(f.csrefundCnt) as csrefundCnt ,sum(f.csrefundMoney) as  csrefundMoney");
                sql.append(" from cisp_dev.dev_ebikechargestation  a left join ebike.stat_chargestation_day f  on ( a.ID=f.chargestationId   ");
                sql.append(" and f.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and f.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" )");
                sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
                sql.append(" 	left join cisp_dev.dev_powersystemresource d on d.ID=a.ID  ");
                sql.append(" left join ebike.stat_sh_chargestation_day  stat  on ( a.Id=stat.chargestationId ");
                sql.append(" and stat.statDate >= ?", DateConvertUtils.convertFromString(map.get("startTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and stat.statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endTime"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" )");
                sql.append(" left join ebike.ebike_cssh_distscheme h on (h.chargestationId=a.ID) where 1=1  and h.csshdsStatus='00' and d.STATUS='20'  ");
                sql.append(" and h.stakeholderOrgNo= ?", subbro);
                sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
                sql.append(" and d.name like  ?", "%" + map.get("stationNo") + "%");
                sql.append("  group by a.ID ");
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs,
                                                      final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("chargedeviceNo", rs.getString("chargedeviceNo"));
                        //map.put("status", CodeUtil.getCodeName(ChargeBikeConstant.CODETYPE_Asset_YXZT, rs.getString("status")));
                        map.put("status", rs.getString("status"));
                        map.put("csrefundCnt", rs.getInt("csrefundCnt"));
                        map.put("ID", rs.getLong("ID"));
                        map.put("NAME", rs.getString("NAME"));
                        map.put("csrefundMoney", rs.getDouble("csrefundMoney"));
                        map.put("SharecsrefundMoney", rs.getDouble("SharecsrefundMoney"));
                        return map;
                    }
                });
            logger.debug(">>>>>>>>>>>>>>>>>>queryShareRefundStic>>>>><<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int shareRefundSticCount(String subbro, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ( select count(1) from ebike.ebike_cssh_distscheme h     ");
            sql.append(" left join cisp_dev.dev_powersystemresource d  on h.chargestationId=d.ID    ");
            sql.append(" INNER JOIN cisp_dev.dev_ebikechargestation  a on a.id=h.chargestationId  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice b on b.chargestationId=a.ID  ");
            sql.append(" where 1=1 and d.STATUS='20' and h.csshdsStatus='00'   ");
            sql.append(" and b.chargedeviceNo like ?", "%" + map.get("chargedeviceNo") + "%");
            sql.append(" and d.name like ?", "%" + map.get("stationNo") + "%");
            sql.append(" and h.stakeholderOrgNo= ?", subbro);
            sql.append(" GROUP BY a.id) n ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }
}












