package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import javax.annotation.Resource;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeTrendDao;
import com.ebike.openservices.oprmgmt.util.EbikeCommonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;


@Repository
public class ChargeTrendDaoImpl extends AbstractEbikeBaseJdbcDao implements ChargeTrendDao {

    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public ChargeTrendDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    //private static final CispLogger logger = CispLogger.getLogger(ChargeTrendDaoImpl.class);
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List<Map<String, Object>> getTrendData(String subburo, String dateFlag, String startDay, String endDay, String sRange, String flag) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        final String flags = dateFlag;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("3".equals(dateFlag)) {

                String startMonth = startDay + "01";
                String endMonth = "";
                Calendar cal = Calendar.getInstance();
                int months = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                if (year == Integer.parseInt(startDay)) {

                    if (months < 10) {
                        endMonth = startDay + "0" + String.valueOf(months);
                    } else {
                        endMonth = startDay + String.valueOf(months);
                    }

                } else {
                    endMonth = startDay + "12";
                }
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.plugPtsCnt,od.chargeIncome,od.plugOnlineCnt  FROM ");
                sql.append(" ( SELECT b.statMonth as statDate ,b.chargeCnt,b.chargeIncome,b.plugOnlineCnt,b.plugPtsCnt  from ebike.stat_adcode_month b WHERE 1=1  ");
                sql.append(" and b.statMonth>=? ", startMonth);
                sql.append("  and  b.statMonth<=? ", endMonth);
                sql.append("  and b.adcode=? ", sRange);
                sql.append("  and b.maincls=? ", 1);
                if ("1".equals(flag)) {
                    sql.append(" and b.subburo=? ", subburo);
                }
                sql.append(" GROUP BY b.statMonth ");
                if (year == Integer.parseInt(startDay)) {
                    for (int i = 0; i < months; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        }

                    }
                } else {
                    for (int i = 0; i < 12; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", month);
                        }

                    }
                }

                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            } else if ("2".equals(dateFlag)) {
                Calendar calendar = Calendar.getInstance();
                //获得当前时间的月份，月份从0开始所以结果要加1
                int month1 = calendar.get(Calendar.MONTH) + 1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                int day = getDaysOfMonth(sdf.parse(startDay));
                int month = getMonth(sdf.parse(startDay));
                String startDays = startDay + "-01";
                String endDays = startDay + "-" + String.valueOf(day);
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.plugPtsCnt,od.chargeIncome,od.plugOnlineCnt  FROM ");
                sql.append(" ( select  a.statDate,a.chargeCnt,a.chargeIncome,a.plugOnlineCnt,a.plugPtsCnt from ebike.stat_adcode_day a where 1=1  ");
                sql.append(" and a.statDate>=STR_TO_DATE( ?,'%Y-%m-%d') ", startDays);
                sql.append("  and a.statDate<=STR_TO_DATE( ?,'%Y-%m-%d') ", endDays);
                sql.append("  and a.adcode=? ", sRange);
                sql.append("  and a.maincls=? ", 1);
                if ("1".equals(flag)) {
                    sql.append(" and a.subburo=? ", subburo);
                }
                sql.append(" GROUP BY a.statDate ");
                if (month == month1) {
                    logger.debug(">>>>>>month<<<<<" + month);
                    logger.debug(">>>>>>month1<<<<<" + month1);
                    for (int i = 0; i < calendar.get(Calendar.DATE) - 1; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        }

                    }
                } else {
                    for (int i = 0; i < day; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0,0) ", date);
                        }
                    }
                }

                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            } else {
                logger.debug(">>>>>>>>>endDay<,,,,,,,,," + endDay);
                logger.debug(">>>>>>>>>endDay<,,,,,,,,," + startDay);
                SimpleDateFormat forDate = new SimpleDateFormat("yyyy-MM-dd");
                int days = differentDaysByMillisecond(forDate.parse(startDay), forDate.parse(endDay));
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.plugPtsCnt,od.chargeIncome,od.plugOnlineCnt  FROM ");
                sql.append(" ( select  a.statDate,a.chargeCnt,a.chargeIncome,a.plugOnlineCnt,a.plugPtsCnt from ebike.stat_adcode_day a where 1=1  ");
                sql.append(" and a.statDate>=STR_TO_DATE( ?,'%Y-%m-%d') ", startDay);
                sql.append("   and a.statDate<=STR_TO_DATE( ?,'%Y-%m-%d') ", endDay);
                sql.append("  and a.adcode=? ", sRange);
                sql.append("  and a.maincls=? ", 1);
                if ("1".equals(flag)) {
                    sql.append(" and a.subburo=? ", subburo);
                }
                sql.append(" GROUP BY a.statDate ");
                String satrtDays = startDay;
                logger.debug(">>>>>>>trendDay<<<<<<<<" + days);
                for (int i = 0; i < days; i++) {
                    if (i == 0) {
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", satrtDays);
                    }
                    if (0 < i && i < 10) {

                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", dateString);
                    } else {
                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0,0) ", dateString);
                    }

                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            }

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>><getTrendData<<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getStationInfo(String subburo, String stationNo, String stationName,
                                                    String devNo, String flag) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.ID,a.STATIONNO,GROUP_CONCAT(b.CHARGEDEVICENO order by b.CHARGEDEVICENO asc) as CHARGEDEVICENO,c.`STATUS`,b.ID as 'deviceId',c.NAME from cisp_dev.dev_ebikechargestation a ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice  b on a.ID=b.CHARGESTATIONID ");
            sql.append(" left JOIN cisp_dev.dev_powersystemresource c on a.ID=c.ID where 1=1 ");
            if ("1".equals(flag)) {
                sql.append(" and c.SUBBURO=? ", subburo);
            }
            sql.append("  and a.STATIONNO like ? ", "%" + stationNo + "%");
            sql.append(" and c.NAME like ? ", "%" + stationName + "%");
            sql.append(" b.CHARGEDEVICENO like ?", "%" + devNo + "%");
            sql.append(" GROUP BY a.ID ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int getStationCount(String subburo, String stationNo, String stationName, String devNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from (select count(1) from cisp_dev.dev_ebikechargestation a ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice  b on a.ID=b.CHARGESTATIONID ");
            sql.append(" left JOIN cisp_dev.dev_powersystemresource c on a.ID=c.ID where 1=1 ");
            sql.append(subburo, " and c.SUBBURO=? ");
            sql.append("  and a.STATIONNO like ? ", "%" + stationNo + "%");
            sql.append(" and c.NAME like ? ", "%" + stationName + "%");
            sql.append(" b.CHARGEDEVICENO like ?", "%" + devNo + "%");
            sql.append(" GROUP BY a.ID ) n ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    @Override
    public List<Map<String, Object>> getDeviceInfo(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.ID,a.CHARGEDEVICENO,b.`STATUS`,a.PLUGCOUNT,c.opStatus from cisp_dev.dev_ebikechargedevice a ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID    ");
            sql.append(" left join ebike.ebike_chargedevice_ops c on a.ID=c.chargedeviceId  where 1=1 ");
            sql.append(" and a.CHARGESTATIONID=? ", id);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> stationTrend(String id, String dateFlag, String startDay, String endDay) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        final String flag = dateFlag;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("3".equals(dateFlag)) {
                String startMonth = startDay + "01";
                String endMonth = "";
                Calendar cal = Calendar.getInstance();
                int months = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                if (year == Integer.parseInt(startDay)) {

                    if (months < 10) {
                        endMonth = startDay + "0" + String.valueOf(months);
                    } else {
                        endMonth = startDay + String.valueOf(months);
                    }

                } else {
                    endMonth = startDay + "12";
                }
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargePlugCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statMonth as statDate ,chargeCnt,chargePlugCnt,chargeIncome  FROM ebike.stat_chargestation_month WHERE 1=1  ");
                sql.append(" and statMonth>=? ", startMonth);
                sql.append("  and  statMonth<=? ", endMonth);
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statMonth ");
                if (year == Integer.parseInt(startDay)) {
                    for (int i = 0; i < months; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", month);
                        }

                    }
                } else {
                    for (int i = 0; i < 12; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", month);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            } else if ("2".equals(dateFlag)) {
                Calendar calendar = Calendar.getInstance();
                //获得当前时间的月份，月份从0开始所以结果要加1
                int month1 = calendar.get(Calendar.MONTH) + 1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                int day = getDaysOfMonth(sdf.parse(startDay));
                int month = getMonth(sdf.parse(startDay));
                String startDays = startDay + "-01";
                String endDays = startDay + "-" + String.valueOf(day);
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargePlugCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargePlugCnt,chargeIncome  FROM ebike.stat_chargestation_day WHERE 1=1  ");
//					sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDays);
//					sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDays);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statDate ");
                if (month == month1) {
                    logger.debug(">>>>>>month<<<<<" + month);
                    logger.debug(">>>>>>month1<<<<<" + month1);
                    for (int i = 0; i < calendar.get(Calendar.DATE) - 1; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", date);
                        }

                    }
                } else {
                    for (int i = 0; i < day; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0,0) ", date);
                        }

                    }
                }

                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");


            } else {
                SimpleDateFormat forDate = new SimpleDateFormat("yyyy-MM-dd");
                int days = differentDaysByMillisecond(forDate.parse(startDay), forDate.parse(endDay));
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargePlugCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargePlugCnt,chargeIncome  FROM ebike.stat_chargestation_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDay);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDay);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargestationId=?", id);
                sql.append(" GROUP BY statDate ");
                String satrtDays = startDay;
                for (int i = 0; i < days; i++) {
                    if (i == 0) {
                        sql.append(" UNION (SELECT  ?,0,0,0) ", satrtDays);
                    }
                    if (0 < i && i < 10) {

                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0) ", dateString);
                    } else {
                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0,0) ", dateString);
                    }

                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>><getTrendData<<<<<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> devTrend(String id, String dateFlag, String startDay, String endDay) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        final String flag = dateFlag;
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            if ("3".equals(dateFlag)) {
                String startMonth = startDay + "01";
                String endMonth = "";
                Calendar cal = Calendar.getInstance();
                int months = cal.get(Calendar.MONTH) + 1;
                int year = cal.get(Calendar.YEAR);
                if (year == Integer.parseInt(startDay)) {

                    if (months < 10) {
                        endMonth = startDay + "0" + String.valueOf(months);
                    } else {
                        endMonth = startDay + String.valueOf(months);
                    }

                } else {
                    endMonth = startDay + "12";
                }
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statMonth as 'statDate',chargeCnt,chargeIncome  FROM ebike.stat_chargedevice_month WHERE 1=1  ");
                sql.append(" and statMonth>=? ", startMonth);
                sql.append("  and  statMonth<=? ", endMonth);
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statMonth ");
                if (year == Integer.parseInt(startDay)) {
                    for (int i = 0; i < months; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", month);
                        }

                    }
                } else {
                    for (int i = 0; i < 12; i++) {
                        if (i < 9) {
                            String month = startDay + "0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", month);
                        } else {
                            String month = startDay + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", month);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            } else if ("2".equals(dateFlag)) {
                Calendar calendar = Calendar.getInstance();
                //获得当前时间的月份，月份从0开始所以结果要加1
                int month1 = calendar.get(Calendar.MONTH) + 1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
                int day = getDaysOfMonth(sdf.parse(startDay));
                int month = getMonth(sdf.parse(startDay));
                String startDays = startDay + "-01";
                String endDays = startDay + "-" + String.valueOf(day);
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargeIncome  FROM ebike.stat_chargedevice_day WHERE 1=1  ");
//					sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDays);
//					sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDays);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDays, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statDate ");
                if (month == month1) {
                    for (int i = 0; i < calendar.get(Calendar.DATE) - 1; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", date);
                        }

                    }
                } else {
                    for (int i = 0; i < day; i++) {
                        if (i < 9) {
                            String date = startDay + "-0" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", date);
                        } else {
                            String date = startDay + "-" + String.valueOf(i + 1);
                            sql.append(" UNION (SELECT  ?,0,0) ", date);
                        }

                    }
                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");


            } else {
                SimpleDateFormat forDate = new SimpleDateFormat("yyyy-MM-dd");
                int days = differentDaysByMillisecond(forDate.parse(startDay), forDate.parse(endDay));
                sql.append(" SELECT  od.statDate,od.chargeCnt,od.chargeIncome  FROM ");
                sql.append(" ( SELECT statDate,chargeCnt,chargeIncome  FROM ebike.stat_chargedevice_day WHERE 1=1  ");
//				sql.append(" and DATE_FORMAT(statDate,'%Y-%m-%d')>=? ",startDay);
//				sql.append("  and DATE_FORMAT(statDate,'%Y-%m-%d')<=? ",endDay);
                sql.append(" and statDate >= ?", DateConvertUtils.convertFromString(startDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
                sql.append(" and statDate <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(endDay, DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
                sql.append(" and chargedeviceId=?", id);
                sql.append(" GROUP BY statDate ");
                String satrtDays = startDay;
                for (int i = 0; i < days; i++) {
                    if (i == 0) {
                        sql.append(" UNION (SELECT  ?,0,0) ", satrtDays);
                    }
                    if (0 < i && i < 10) {

                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0) ", dateString);
                    } else {
                        Date ss = forDate.parse(satrtDays);
                        Date a = addDay(ss, 1);//调取方法  天数+1
                        String dateString = forDate.format(a);
                        satrtDays = dateString;
                        sql.append(" UNION (SELECT  ?,0,0) ", dateString);
                    }

                }
                sql.append(" ) AS od ");
                sql.append(" GROUP BY od.statDate ");
                sql.append(" ORDER BY od.statDate ASC ");
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>><getTrendData<<<<<<<<<<<<<" + sql.toString());

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getChargePrinceList(String subburo, String flag) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select f.province as id ,f.adfullname as name from ebike.code_adcode f  where 1=1 and f.adlevel='1' and  f.province in ");
        sql.append(" ( SELECT t.province FROM  cisp_dev.dev_ebikechargestation a left join  ebike.code_adcode  t  on t.adcode=a.ADCODE ");
        sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID where 1=1 ");
        if ("1".equals(flag)) {
            sql.append(" and b.SUBBURO=? ) ", subburo);
        } else {
            sql.append(" ) ");
        }
        try {
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    public int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int) ((date2.getTime() - date1.getTime()) / (1000 * 3600 * 24));
        return days;
    }

    public int getDaysOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getActualMaximum(Calendar.DAY_OF_MONTH);
    }

    public int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(Calendar.MONTH) + 1;
        return month;
    }

    @Override
    public List<Map<String, Object>> getCityList(int level, String parentid, String flag, String subburo) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select f.city,f.adfullname from ebike.code_adcode f  where 1=1 and f.adlevel='2' and  f.city in ");
        sql.append(" ( SELECT t.city FROM cisp_dev.dev_ebikechargestation a left join  ebike.code_adcode  t on t.adcode=a.ADCODE ");
        sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID where 1=1 ");
        if ("1".equals(flag)) {
            sql.append(" and b.SUBBURO=? ) ", subburo);
        } else {
            sql.append(" ) ");
        }
        sql.append(" and f.province=? ", parentid);
        try {
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getCountyList(int level, String parentid, String flag, String subburo) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select f.district as id ,f.adfullname as name from ebike.code_adcode f  where 1=1 and f.adlevel='3' and  f.district in ");
        sql.append(" ( SELECT t.district FROM cisp_dev.dev_ebikechargestation a left join  ebike.code_adcode  t on t.adcode=a.ADCODE ");
        sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID where 1=1 ");
        if ("1".equals(flag)) {
            sql.append(" and b.SUBBURO=? ) ", subburo);
        } else {
            sql.append(" ) ");
        }
        sql.append(" and f.city=? ", parentid);
        try {
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception e) {
            e.printStackTrace();
            return list;
        }
        return list;
    }

    public Date addDay(Date date, int num) {
        Calendar startDT = Calendar.getInstance();
        startDT.setTime(date);
        startDT.add(Calendar.DATE, num);
        return startDT.getTime();
    }
}
