package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.ExcelDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ExcelDaoImpl extends AbstractEbikeBaseJdbcDao implements ExcelDao {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Qualifier("ebikeJdbcTemplate")
	private final JdbcTemplate ebikeJdbcTemplate;

	@Autowired
	public ExcelDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
		this.ebikeJdbcTemplate = ebikeJdbcTemplate;
	}

	@Override
	public Map<String, String> importExcel(String stationId,String csbsId,String uuid){
		        //1.创建工作薄
                //上传时查询用户重复电话，此方法查询当前电站所有未失效的计费模板的名单Id
		        Map<String,String> map=new HashMap<String,String>();
		        List<Map<String,String>> userlist=selectUserId(stationId,csbsId);
		        logger.debug(">>>>>>>>>>>>>>>list.size><<<<<<<<<<<<<<"+JsonConvertUtils.convertToString(userlist));
                String userId="";
                String phone="";
                String count="";
                if(userlist!=null&&userlist.size()>0)
                {
                	for(int i=0;i<userlist.size();i++)
                	{
						logger.debug(">>>>>>>>>>>>csbsUsersListId<<<<<<<<<<<<<<"+userlist.get(i).get("csbsUsersListId"));
                		if(!"".equals(userlist.get(i).get("csbsUsersListId"))&&userlist.get(i).get("csbsUsersListId")!=null)
                		{
                		  userId=userlist.get(i).get("csbsUsersListId")+","+userId;
                		}
                		if(!"".equals(userlist.get(i).get("newCsbsUsersListId"))&&userlist.get(i).get("newCsbsUsersListId")!=null)
                		{
							logger.debug(">>>>>>>>>>>>newCsbsUsersListId<<<<<<<<<<<<<<"+userlist.get(i).get("csbsUsersListId"));
							logger.debug("new aaa");
                			userId=userlist.get(i).get("newCsbsUsersListId")+","+userId;
                		}
                	}

                	userId=userId+uuid;
                	logger.debug(">>>>>><userId<<<<<<<<<"+userId);
					logger.debug(">>>>>>>userId<<<<<<<<<"+userId);
                	//此方法是查询出重复的电话号码 以及重复的个数
                	List<Map<String,Object>> phonelist=selectPhone(userId);

                    logger.debug(" phonelist ",JsonConvertUtils.convertToString(phonelist));

                	if(phonelist!=null&&phonelist.size()>0)
                	{
                		for(int i=0;i<phonelist.size();i++)
                		{
                			if(!"".equals(phonelist.get(i).get("csbsUserMobile"))&&!"null".equals(phonelist.get(i).get("csbsUserMobile"))&&phonelist.get(i).get("csbsUserMobile")!=null)
                			{
                				phone=phone+phonelist.get(i).get("csbsUserMobile")+",";//重复的电话号码
                			}

                			count=phonelist.get(i).get("count").toString();

                		}
                		logger.debug(">>>>>><phone<<<<<<<<<"+phone);
                		logger.debug(">>>>>><count<<<<<<<<<"+count);
                	}
                }

	       		 map.put("uid",uuid);
	       		 map.put("phone",phone);
       	      try {
       	      	  return map;
       	      } catch (Exception  e) {
       	      	  e.printStackTrace();
				  return map;
       	      }
	}

	 @Override
	 public int addMobilePhone(String uuid,String phone)
	 {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 try{
			  sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,csbsUserMobile,createTime) ");
			  sql.append(" values(?,?,?)");
			  return ebikeJdbcTemplate.update(sql.getSql(),
					  new Object[]{
						 uuid,phone,new Date()
					  });
		 }catch(Exception ex)
		 {
			 ex.printStackTrace();
			 return 0;
		 }
	 }
     //查询所有未失效的用户类表id
	 public List<Map<String,String>> selectUserId(String stationId,String csbsId)
	 {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String,String>>  list=new ArrayList<Map<String,String>>();
		 try{
			  sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10'   ");
			  sql.append(" and b.chargestationId=?",stationId);
			  if(!"".equals(csbsId))
			  {
				  sql.append(" and b.csbsId!=? ",csbsId);
			  }
			  list= ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
					  new RowMapper<Map<String,String>>(){
				  public Map<String,String> mapRow(final ResultSet rs,final int rownum) throws SQLException
				  {
					  Map<String,String>  map=new HashMap<String,String>();
					  map.put("csbsUsersListId", rs.getString("csbsUsersListId"));
					  map.put("newCsbsUsersListId", rs.getString("newCsbsUsersListId"));
					  return map;
				  }

			  });
//			  if(list.size()>0||list!=null)
//			  {
//				  for(int i=0;i<list.size();i++)
//				  {
//					  List<Map<String,String>> results=selectUserInfo(list.get(i).get("csbsUsersListId"));
//					  if(list.size()<=0||list==null)
//					  {
//						  int result=deleteUserPhone(list.get(i).get("csbsUsersListId"));
//					  }
//				  }
//			  }
			  logger.debug(">>>>>>>>>>>>>selectUserId<<<<<<<<<<<<<<<"+sql.toString());
		 }catch(Exception ex)
		 {
			 ex.printStackTrace();
			 return list;
		 }
		 return list;
	 }
	 public int deleteUserPhone(String csbsUsersListId)
	 {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 try{
			 sql.append(" delete from ebike.ebike_csbs_info_fu_userlist  where 1=1 ");
	    	 sql.append(" and csbsUsersListId in(?)",csbsUsersListId);
	    	 return ebikeJdbcTemplate.update(sql.getSql(),sql.getParams());
		 }catch(Exception ex)
		 {
			 ex.printStackTrace();
			 return 0;
		 }
	 }
	 public List<Map<String,String>> selectUserInfo(String csbsUsersListId)
	 {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String,String>>  list=new ArrayList<Map<String,String>>();
		 try{
			  sql.append(" select b.csbsUserMobile from ebike.ebike_csbs_info_userlist b  where 1=1  ");
			  sql.append(csbsUsersListId," and b.csbsUsersListId=?");
			  list= ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
					  new RowMapper<Map<String,String>>(){
				  public Map<String,String> mapRow(final ResultSet rs,final int rownum) throws SQLException
				  {
					  Map<String,String>  map=new HashMap<String,String>();
					  map.put("csbsUserMobile", rs.getString("csbsUserMobile"));
					  return map;
				  }

			  });
		 }catch(Exception ex)
		 {
			 ex.printStackTrace();
			 return list;
		 }
		 return list;
	 }

	 //查出同一电站下的所有电话
	 public List<Map<String,Object>> selectPhone(String userId)
	 {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String,Object>>  list=new ArrayList<Map<String,Object>>();
		 logger.debug(" vselectPhone " +userId);
		 try{
			  sql.append(" select a.csbsUserMobile,count(1) as count  from ebike.ebike_csbs_info_fu_userlist  a where 1=1  ");
			  sql.append("  and a.csbsUsersListId in (?)",userId,",");
			  sql.append("  GROUP BY a.csbsUserMobile  having count>1  ");
			  list= ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
					  new RowMapper<Map<String,Object>>(){
				  public Map<String,Object> mapRow(final ResultSet rs,final int rownum) throws SQLException
				  {
					  Map<String,Object>  map=new HashMap<String,Object>();
					  map.put("csbsUserMobile", rs.getString("csbsUserMobile"));
					  map.put("count", rs.getInt("count"));
					  return map;
				  }

			  });
			  logger.debug(">>>>>>>>>>>>>selectPhone<<<<<<<<<<<<<<<"+sql.toString());
		 }catch(Exception ex)
		 {
			 ex.printStackTrace();
			 return list;
		 }
		 return list;
	 }
	 public int addRepeatData(String csbsUserMobile,String uuid)
	 {
		    SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,repateMobile)");
				sql.append(" values(?,?)");
				return ebikeJdbcTemplate.update(sql.getSql(),new Object[]{
						uuid,csbsUserMobile
				});

			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
	 }

}

