package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.easesource.commons.util.ObjectUtils;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.InShareDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

//import cn.cc.cisp.code.util.CodeUtil;
//import cn.yunrui.bikeaccount.dao.InShareDao;
//import cn.yunrui.bikeaccount.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.UUID;
//import cn.yunrui.common.util.YunRuiDateUtil;

@Repository
public class InShareDaoImpl extends AbstractEbikeBaseJdbcDao implements InShareDao {
    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public InShareDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List<Map<String, Object>> partnerQuery(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  b.orgoprType,b.orgoprName,b.orgoprCredNo,b.subburo,a.csshdsStatus,a.incomeRatio,a.costRatio, ");
            sql.append(" a.newIncomeRatio,a.newCostRatio,a.csshDistSchemeId from ebike.ebike_cssh_distscheme  a ");
            sql.append(" left join ebike.ebike_orgopr b on a.stakeholderOrgNo=b.subburo where 1=1  ");
            sql.append(" and a.chargestationId=? ", stationId);
            sql.append("  and a.csshdsStatus!='10' ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper
//		    		 new RowMapper<Map<String,Object>>(){
//		    	public Map<String,Object> mapRow(final ResultSet rs,final int rownum) throws SQLException
//		    	{
//		    		Map<String,Object> map=new HashMap<String,Object>();
//		    		map.put("csshDistSchemeId", rs.getString("csshDistSchemeId"));
//		    		map.put("orgoprType", CodeUtil.getCodeName(ChargeBikeConstant.ORGOPR_TYPE, rs.getString("orgoprType")));
//		    		map.put("orgoprName", rs.getString("orgoprName"));
//		    		map.put("subburo", rs.getString("subburo"));
//		    		map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
//		    		map.put("csshdsStatus", CodeUtil.getCodeName(ChargeBikeConstant.CSBS_STATUS, rs.getString("csshdsStatus")));
//		    		map.put("incomeRatio", rs.getDouble("incomeRatio"));
//		    		map.put("costRatio", rs.getDouble("costRatio"));
//		    		map.put("newIncomeRatio", rs.getDouble("newIncomeRatio"));
//		    		map.put("newCostRatio", rs.getDouble("newCostRatio"));
//		    		return map;
//		    	}
//		    }
            );
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;

    }

    @Override
    public List<Map<String, Object>> incomeStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        //自行车充电站状态
        String bikeStatus = map.get("status");
        try {
            //自行车充电站
            //旧版备份
//            sql.append(" select oo.orgoprName as operatorsOrgName, a.ID,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc ) as deviceNo, GROUP_CONCAT(DISTINCT(e.orgoprName)) as orgName ");
//            sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
//            sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
//            sql.append(" from cisp_dev.dev_ebikechargestation a  ");
//            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
//            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
//            sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
//            sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
//            sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
//            sql.append("  left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
//            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
//            sql.append(" and oo.subburo = ? ", map.get("operatorsOrg"));
//            sql.append(" and a.stationAddr like ? ", "%" + map.get("stationAddr") + "%");
//            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
//            sql.append(" and b.STATUS=?", map.get("status"));
//            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
//            sql.append(" and b.SUBBURO=?", subburo);
//            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");

            //旧版基础上去掉operatorsOrgName（汽车充电站中没有这个字段）
            //电桩类型  1——自行车 2——汽车 3-全部
            String type=map.get("type");
            if(type==null || type.equals("")){
                type="3";
            }
            if("1".equals(type)){
                sql.append(" select '电动自行车电桩' pileType,oo.orgoprName as operatorsOrgName,a.id,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc ) as deviceNo, GROUP_CONCAT(DISTINCT(e.orgoprName)) as orgName ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append(" from cisp_dev.dev_ebikechargestation a  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
                sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
                //sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
                sql.append(" and oo.subburo = ? ", map.get("operatorsOrg"));
                sql.append(" and a.stationAddr like ? ", "%" + map.get("stationAddr") + "%");
                sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
                sql.append(" and b.STATUS=?", map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
                sql.append(" and b.SUBBURO=?", subburo);
                sql.append(" and b.CLASSNAME='EBikeChargeStation'");

            }
            if("2".equals(type)){
                sql.append(" select '电动汽车电桩' pileType, b.orgoprName as operatorsOrgName, a.id,a.charging_station_no as stationNo,a.charging_station_addr as stationAddr,a.charging_station_status as status, a.charging_station_name as name, GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc ) AS deviceNo, ");
                sql.append(" b.orgoprName as orgName, b.serviceRate as serviceRate ");
                sql.append(" from oper_ev_charging_station as a  ");
                sql.append(" left join ebike.ebike_orgopr b on b.subburo = a.org_no ");
                sql.append(" left join dev_ev_charging_pile c on c.charging_station_id = a.id ");
                sql.append(" where true ");
                sql.append(" and  a.charging_station_name like ?", "%" + map.get("stationName") + "%");
                sql.append(" and c.charging_pile_no like ? ", "%" + map.get("deviceNo") + "%");
                sql.append(" and a.org_no = ?", subburo);
            }
            if("3".equals(type)) {
                sql.append(" select '电动自行车电桩' pileType, oo.orgoprName as operatorsOrgName,a.id,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc ) as deviceNo, GROUP_CONCAT(DISTINCT(e.orgoprName)) as orgName ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append(" from cisp_dev.dev_ebikechargestation a  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
                sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
                sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
                //sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
                sql.append(" and oo.subburo = ? ", map.get("operatorsOrg"));
                sql.append(" and a.stationAddr like ? ", "%" + map.get("stationAddr") + "%");
                sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
                sql.append(" and b.STATUS=?", map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
                sql.append(" and b.SUBBURO=?", subburo);
                sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");

                sql.append(" union all  ");

                //汽车充电站
                sql.append(" select '电动汽车电桩' pileType, b.orgoprName as operatorsOrgName,a.id,a.charging_station_no as stationNo,a.charging_station_addr as stationAddr,a.charging_station_status as status, a.charging_station_name as name, GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc ) AS deviceNo, ");
                sql.append(" b.orgoprName as orgName, b.serviceRate as serviceRate ");
                sql.append(" from oper_ev_charging_station as a  ");
                sql.append(" left join ebike.ebike_orgopr b on b.subburo = a.org_no ");
                sql.append(" left join dev_ev_charging_pile c on c.charging_station_id = a.id ");
                sql.append(" where true ");
                sql.append(" and  a.charging_station_name like ?", "%" + map.get("stationName") + "%");
                sql.append(" and c.charging_pile_no like ? ", "%" + map.get("deviceNo") + "%");
                sql.append(" and a.org_no = ?", subburo);
            }
            /**
             * 数据库中汽车充电站的状态和自行车充电站状态定义的不一致，此处根据自行的状态传参
             */
            //未投运
            if ("10".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '1' or a.charging_station_status = '2' ");
                //在运
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '3' ");
                //退运
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and a.charging_station_status = '9' ");
            }
            sql.append(" GROUP BY a.ID ");

            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("operatorsOrgName", rs.getString("operatorsOrgName"));
                        map.put("ID", rs.getLong("ID"));
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("SName", rs.getString("NAME"));
                        map.put("stationAddr", rs.getString("stationAddr"));
                        // map.put("status", CodeUtil.getCodeName(ChargeBikeConstant.CODETYPE_Asset_YXZT,rs.getString("STATUS")));
                        map.put("deviceNo", rs.getString("deviceNo"));
                        map.put("orgName", rs.getString("orgName"));
                        map.put("csServiceRate", rs.getDouble("serviceRate"));
                        map.put("pileType", rs.getString("pileType"));
                        //汽车充电站状态转义（前端使用的自行车状态值）
                        String resultStatus = rs.getString("STATUS");
                        String finalStatus = null;
                        if("1".equals(resultStatus) || "2".equals(resultStatus)){
                            finalStatus = "10";
                        }else if("3".equals(resultStatus)){
                            finalStatus = "20";
                        }else if("9".equals(resultStatus)){
                            finalStatus = "40";
                        }
                        map.put("status", (finalStatus == null)? resultStatus : finalStatus);
                        return map;
                    }
                }
            );
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryIncomeCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ( select count(1) from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
            sql.append(" left  join ebike.ebike_cssh_distscheme  d on a.ID=d.chargestationId  ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
            sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
            sql.append(" left join ebike.ebike_orgopr e on (d.stakeholderOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1 ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and oo.subburo = ? ", map.get("operatorsOrg"));
            sql.append(" and a.stationAddr like ? ", "%" + map.get("stationAddr") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and b.SUBBURO=?", subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation'   GROUP BY a.ID   ) f  ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    @Override
    public int queryIncomeCountForCar(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //自行车充电站状态
        String bikeStatus = map.get("status");
        try {
            sql.append("select count(1) from");
            sql.append("(select a.charging_station_name,c.charging_pile_no,a.charging_station_status,a.org_no from oper_ev_charging_station as a left join dev_ev_charging_pile c ON c.charging_station_id = a.id group by a.id) bb");
            sql.append(" where true ");
            sql.append(" and bb.charging_station_name like ? ", "%" + map.get("stationName") + "%");
            sql.append(" and bb.charging_pile_no like ? ", "%" + map.get("deviceNo") + "%");
            //sql.append(" and bb.charging_station_status = ?", map.get("status"));
            sql.append(" and bb.org_no = ?", subburo);
            /**
             * 数据库中汽车充电站的状态和自行车充电站状态定义的不一致，此处根据自行的状态传参
             */
            //未投运
            if ("10".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '1' or bb.charging_station_status = '2' ");
                //在运
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '3' ");
                //退运
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and bb.charging_station_status = '9' ");
            }
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public String checkYysExist(String orgoprType, String orgoprName, String orgoprCredNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        String subburo = "";
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr  a where 1=1  ");
            sql.append(" and a.orgoprType=? ", orgoprType);
            sql.append(" and a.orgoprName=? ", orgoprName);
            sql.append(" and a.orgoprCredNo=? ", orgoprCredNo);
            result = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        if (result == 0) {
            subburo = "0";
        } else {
            subburo = getSubburo(orgoprType, orgoprName, orgoprCredNo);
        }
        return subburo;
    }

    public String getSubburo(String orgoprType, String orgoprName, String orgoprCredNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String result = "";
        try {
            sql.append(" select subburo from ebike.ebike_orgopr  a where 1=1  ");
            sql.append(" and a.orgoprType=? ", orgoprType);
            sql.append(" and a.orgoprName=? ", orgoprName);
            sql.append(" and a.orgoprCredNo=? ", orgoprCredNo);
            result = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return result;
    }

    @Override
    public int checkSameName(String stationId, String stakeholderOrgNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_cssh_distscheme  a where 1=1  ");
            sql.append(" and a.chargestationId=? ", stationId);
            sql.append(" and a.stakeholderOrgNo=? ", stakeholderOrgNo);
            sql.append(" and a.csshdsStatus!='10' ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int profitAdd(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String uuid = UuidUtils.generateUuidString();
        String acostRatio = ObjectUtils.toStringDefaultEmpty(map.get("acostRatio"));
        String loginfo = "营收金额*" + map.get("aincomeRatio") + "%+" + "电费成本*"
            + map.get("acostRatio") + "%";
        try {
            sql.append(" insert into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId, ");
            sql.append(" orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,effTime )");
            sql.append(" values(?,?,?,?,?,?,?,?) ");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    uuid, map.get("stationId"), map.get("subburo"), map.get("stakeholderOrgNo"), "01"
                    , Double.valueOf(map.get("aincomeRatio")), !acostRatio.equals("") ? Double.parseDouble(acostRatio) : 0,
                    new Date()
                });
            results = addDistschemeTbc(uuid, map.get("stakeholderOrgNo"), map.get("orgName"));
            results = addDistschemeLog(uuid, map.get("orgName"), "10", loginfo, "01");
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    public int addDistschemeTbc(String uuid, String stakeholderOrgNo, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" replace into ebike.ebike_cssh_distscheme_tbc(csshDistSchemeId,stakeholderOrgNo, ");
            sql.append(" creator,createTime,confirmFlag )");
            sql.append(" values(?,?,?,?,?) ");
            return ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    uuid, stakeholderOrgNo, orgName, new Date(), "0"
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int addDistschemeLog(String csshDistSchemeId, String orgName, String logType, String logInfo, String csshdsStatus) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();

        try {
            sql.append(" insert into ebike.ebike_log_cssh_distscheme(csshDistSchemeId, ");
            sql.append(" logType,logTime,logValue,csshdsStatus,operator)");
            sql.append(" values(?,?,?,?,?,?) ");
            return ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    csshDistSchemeId, logType, new Date(), logInfo, csshdsStatus,
                    orgName
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public Map<String, Object> checkIncome(String stationId) {
        double results = 0.00;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select sum(incomeRatio) as incomeRatios from (select IFNULL(sum(incomeRatio)+sum(newIncomeRatio),0) as incomeRatio from ebike.ebike_cssh_distscheme where 1=1  ");
            sql.append(" and chargestationId=?", Long.valueOf(stationId));
            sql.append(" and csshdsStatus!='10') p ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>incomeRatios<<<<<<<<<" + list.get(0).toString());
            return list.get(0);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list.get(0);
        }
    }

    @Override
    public Map<String, Object> checkCost(String stationId) {
        double results = 0.00;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select sum(costRatio) as costRatios from (select IFNULL(sum(costRatio)+sum(newCostRatio),0)  as costRatio from ebike.ebike_cssh_distscheme where 1=1 ");
            sql.append(" and chargestationId=?", Long.valueOf(stationId));
            sql.append(" and csshdsStatus!='10') p");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>checkCost<<<<<<<<<" + list.get(0).toString());
            return list.get(0);

        } catch (Exception ex) {
            ex.printStackTrace();
            return list.get(0);
        }
    }

    @Override
    public int profitModify(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String acostRatio = "0.0";
        String aincomeRatio = "0.0";
        String loginfo = "营收金额*" + map.get("incomeRatio") + "%+" + "电费成本*"
            + map.get("costRatio") + "%(更改前)" + "营收金额*" + map.get("aincomeRatio") + "%+" + "电费成本*"
            + map.get("acostRatio") + "%(更改后)";
        try {
            if (!"".equals(map.get("acostRatio"))) {
                acostRatio = ObjectUtils.toStringDefaultEmpty(map.get("acostRatio"));
            }
            if (!"".equals(map.get("aincomeRatio"))) {
                aincomeRatio = map.get("aincomeRatio");
            }
            sql.append(" replace into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId,orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,newIncomeRatio,newCostRatio,effTime) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("csshDistSchemeId"), map.get("stationId"), map.get("subburo"), map.get("stakeholderOrgNo"), "02", Double.valueOf(map.get("incomeRatio")), Double.valueOf(map.get("costRatio")), Double.valueOf(aincomeRatio)
                    , !acostRatio.equals("") ? Double.parseDouble(acostRatio) : 0, new Date()
                });
            results = addDistschemeTbc(map.get("csshDistSchemeId"), map.get("stakeholderOrgNo"), map.get("orgName"));
            results = addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), "20", loginfo, "02");
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public boolean stopProfit(Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {

            sql.append(" update ebike.ebike_cssh_distscheme set csshdsStatus='03' where 1=1 ");
            sql.append(" and csshDistSchemeId=?", map.get("csshDistSchemeId"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = addDistschemeTbc(map.get("csshDistSchemeId"), map.get("stakeholderOrgNo"), map.get("orgName"));
            results = addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), "30", "终止", "03");
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public List<Map<String, Object>> queryOperationInfo(String csshDistSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csshDistSchemeId,a.logType,a.logTime,a.logValue,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
            sql.append(" from ebike.ebike_log_cssh_distscheme a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csshDistSchemeId=?", csshDistSchemeId);
            sql.append(" order by  a.logTime desc ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper
//		    		 new RowMapper<Map<String,Object>>(){
//		    	public Map<String,Object> mapRow(final ResultSet rs,final int rownum) throws SQLException
//		    	{
//		    		Map<String,Object> map=new HashMap<String,Object>();
//		    		map.put("csshDistSchemeId", rs.getString("csshDistSchemeId"));
//		    		map.put("logType", CodeUtil.getCodeName(ChargeBikeConstant.CSBC_OP, rs.getString("logType")));
//		    		map.put("logTime", rs.getTimestamp("logTime"));
//		    		map.put("userName", rs.getString("userName"));
//		    		map.put("orgName", rs.getString("orgName"));
//		    		map.put("logValue", rs.getString("logValue"));
//		    		return map;
//		    	}
//			}
            );
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int operationCount(String csshDistSchemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_log_cssh_distscheme a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csshDistSchemeId=?", csshDistSchemeId);
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryIShareStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String bikeStatus = map.get("status");
        //1 自行车   2 汽车  3 全部
        String type = map.get("type");

        try {
            if(type==null || "".equals(type)){
                type="3";
            }
            if("1".equals(type)){
                sql.append(" select  '电动自行车电桩' pileType,a.id,a.stationNo,a.stationAddr,b.status,b.name,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
                sql.append(" d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo  ");
                //sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
                sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
                sql.append("  from ebike.ebike_cssh_distscheme  d ");
                sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
                sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
                sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
                sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
                sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
                sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
                sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
                sql.append(" and b.STATUS=?", map.get("status"));
                sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
                sql.append(" and d.stakeholderOrgNo=?", subburo);
                sql.append(" and a.stationNo is not null ");
                //sql.append(" and b.CLASSNAME='EBikeChargeStation' and d.csshdsStatus!='10' GROUP BY a.ID  ");
                sql.append(" and d.csshdsStatus!='10' GROUP BY a.ID  ");

            }
            if("2".equals(type)){
                sql.append(" select '电动汽车电桩' pileType,s.id,s.charging_station_no stationNo,s.charging_station_addr stationAddr,s.charging_station_status status, ");
                sql.append( "s.charging_station_name name,GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc )  deviceNo,");
                sql.append( "d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo,o.serviceRate ");
                sql.append( "from ebike_cssh_distscheme d ");
                sql.append( "left join oper_ev_charging_station s on s.id = d.chargestationId ");
                sql.append( "left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
                sql.append( "left join ebike_orgopr o on o.subburo = s.org_no ");
                sql.append( "where true ");
                sql.append(" and  s.charging_station_name like ?", "%" + map.get("stationName") + "%");
                sql.append(" and c.charging_pile_no like ?", "%" + map.get("deviceNo") + "%");
                sql.append(" and d.stakeholderOrgNo=?", subburo);
                sql.append( "and s.charging_station_no is not null ");

                /**
                 * 数据库中汽车充电站的状态和自行车充电站状态定义的不一致，此处根据自行的状态传参
                 */
                //未投运
                if ("10".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
                    //在运
                } else if ("20".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '3' ");
                    //退运
                } else if ("40".equals(bikeStatus)) {
                    sql.append(" and s.charging_station_status = '9' ");
                }
                sql.append( "and d.csshdsStatus!='10' GROUP BY s.ID ");
            }
            if("3".equals(type)){


            sql.append(" select  '电动自行车电桩' pileType,a.id,a.stationNo,a.stationAddr,b.status,b.name,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
            sql.append(" d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo  ");
            //sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
            sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
            sql.append("  from ebike.ebike_cssh_distscheme  d ");
            sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
            sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            /**
             * 由于自行车充电站和汽车充电站是两张不同的表且此查询都是以收益分享表为主表关联电站表查询电站信息，
             * 如果是自行车收益分享，应该剔除汽车的关联查询；
             * 同样的如果是汽车收益分享，也应剔除自行车的关联查询，避免后续步骤中stationNo的空指针异常,
             * 如果恰巧汽车充电站和自行车充电站id重复，当前设计下会导致查询结果错误
             */
            sql.append(" and a.stationNo is not null ");
            //sql.append(" and b.CLASSNAME='EBikeChargeStation' and d.csshdsStatus!='10' GROUP BY a.ID  ");
            sql.append(" and d.csshdsStatus!='10' GROUP BY a.ID  ");

            sql.append(" union all ");

            //汽车充电站数据
            sql.append(" select '电动汽车电桩' pileType,s.id,s.charging_station_no stationNo,s.charging_station_addr stationAddr,s.charging_station_status status, ");
            sql.append( "s.charging_station_name name,GROUP_CONCAT( DISTINCT ( c.charging_pile_no ) order by c.charging_pile_no asc )  deviceNo,");
            sql.append( "d.costRatio,d.incomeRatio,d.newCostRatio,d.csshdsStatus,d.newIncomeRatio,d.csshDistSchemeId,d.stakeholderOrgNo,d.orgoprOrgNo,o.serviceRate ");
            sql.append( "from ebike_cssh_distscheme d ");
            sql.append( "left join oper_ev_charging_station s on s.id = d.chargestationId ");
            sql.append( "left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
            sql.append( "left join ebike_orgopr o on o.subburo = s.org_no ");
            sql.append( "where true ");
            sql.append(" and  s.charging_station_name like ?", "%" + map.get("stationName") + "%");
            sql.append(" and c.charging_pile_no like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            /**
             * 由于自行车充电站和汽车充电站是两张不同的表且此查询都是以收益分享表为主表关联电站表查询电站信息，
             * 如果是自行车收益分享，应该剔除汽车的关联查询；
             * 同样的如果是汽车收益分享，也应剔除自行车的关联查询，避免后续步骤中stationNo的空指针异常,
             * 如果恰巧汽车充电站和自行车充电站id重复，当前设计下会导致查询结果错误
             */
            sql.append( "and s.charging_station_no is not null ");

            /**
             * 数据库中汽车充电站的状态和自行车充电站状态定义的不一致，此处根据自行的状态传参
             */
            //未投运
            if ("10".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
                //在运
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '3' ");
                //退运
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '9' ");
            }
            sql.append( "and d.csshdsStatus!='10' GROUP BY s.ID ");

            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rownum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();

                        map.put("ID", rs.getLong("ID"));
                        map.put("stationNo", rs.getString("stationNo"));
                        map.put("SName", rs.getString("NAME"));
                        map.put("stationAddr", rs.getString("stationAddr"));
                        logger.debug(">>>>>>>>vstatus<<<<<<<<<" + map.get("status"));
                        map.put("deviceNo", rs.getString("deviceNo"));
                        map.put("costRatio", rs.getDouble("costRatio"));
                        map.put("incomeRatio", rs.getDouble("incomeRatio"));
                        map.put("newCostRatio", rs.getDouble("newCostRatio"));
                        map.put("newIncomeRatio", rs.getDouble("newIncomeRatio"));
                        map.put("csshdsStatus", rs.getString("csshdsStatus"));
                        map.put("csshDistSchemeId", rs.getString("csshDistSchemeId"));
                        map.put("orgoprOrgNo", rs.getString("orgoprOrgNo"));
                        map.put("stakeholderOrgNo", rs.getString("stakeholderOrgNo"));
                        map.put("csServiceRate", rs.getDouble("serviceRate"));
                        map.put("pileType", rs.getString("pileType"));
                        //汽车充电站状态转义（前端使用的自行车状态值）
                        String resultStatus = rs.getString("STATUS");
                        String finalStatus = null;
                        if("1".equals(resultStatus) || "2".equals(resultStatus)){
                            finalStatus = "10";
                        }else if("3".equals(resultStatus)){
                            finalStatus = "20";
                        }else if("9".equals(resultStatus)){
                            finalStatus = "40";
                        }
                        map.put("status", (finalStatus == null)? resultStatus : finalStatus);
                        return map;
                    }
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryPrifitCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select count(1) from (select count(1) ");
            sql.append("  from ebike.ebike_cssh_distscheme  d ");
            sql.append("  left  join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
            sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1  ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation' and d.csshdsStatus!='10'  GROUP BY a.ID) f ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    @Override
    public int queryPrifitCountForCar(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        //自行车充电站状态
        String bikeStatus = map.get("status");
        try {
            sql.append(" select count(1) ");
            sql.append( "from ebike_cssh_distscheme d ");
            sql.append( "left join oper_ev_charging_station s on s.id = d.chargestationId ");
            sql.append( "left join dev_ev_charging_pile c on c.charging_station_id = s.id ");
            sql.append( "left join ebike_orgopr o on o.subburo = s.org_no ");
            sql.append( "where true ");
            sql.append(" and  s.charging_station_name like ?", "%" + map.get("stationName") + "%");
            sql.append(" and c.charging_pile_no like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            /**
             * 由于自行车充电站和汽车充电站是两张不同的表且此查询都是以收益分享表为主表关联电站表查询电站信息，
             * 如果是自行车收益分享，应该剔除汽车的关联查询；
             * 同样的如果是汽车收益分享，也应该剔除自行车的关联查询，避免后续步骤中stationNo的空指针异常
             */
            sql.append( "and s.charging_station_no is not null ");

            /**
             * 数据库中汽车充电站的状态和自行车充电站状态定义的不一致，此处根据自行的状态传参
             */
            //未投运
            if ("10".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '1' or s.charging_station_status = '2' ");
                //在运
            } else if ("20".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '3' ");
                //退运
            } else if ("40".equals(bikeStatus)) {
                sql.append(" and s.charging_station_status = '9' ");
            }
            sql.append( "and d.csshdsStatus!='10'  ");

            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean incomeOp(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String csshdsStatus = "";
        try {

            if ("12".equals(map.get("logType")) || "31".equals(map.get("logType"))) {
                csshdsStatus = "10";
            } else {
                csshdsStatus = "00";
            }
            sql.append(" update ebike.ebike_cssh_distscheme_tbc set ");
            sql.append(" confirmFlag=?", map.get("confirmFlag"));
            sql.append(" ,confirmer=?", map.get("orgName"));
            sql.append(" ,confirmTime=? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
            sql.append(" where 1=1 ");
            sql.append(" and csshDistSchemeId=?", map.get("csshDistSchemeId"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = distscheme(map, csshdsStatus);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public int distscheme(Map<String, String> map, String csshdsStatus1) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String income = map.get("incomeRatio");
        String newincome = "0.0";
        String cost = map.get("costRatio");
        String newcost = "0.0";
        String csshdsStatus = "";
        String loginfo = "";
        if ("12".equals(map.get("logType"))) {
            loginfo = "营收金额*" + map.get("incomeRatio") + "%+" + "电费成本*"
                + map.get("costRatio") + "%";
            csshdsStatus = "10";
        } else if ("31".equals(map.get("logType"))) {
            loginfo = "同意终止";
            csshdsStatus = "10";
        } else {
            loginfo = "营收金额*" + map.get("incomeRatio") + "%+" + "电费成本*"
                + map.get("costRatio") + "%(更改前)" + "营收金额*" + map.get("aincomeRatio") + "%+" + "电费成本*"
                + map.get("acostRatio") + "%(更改后)";
            csshdsStatus = "00";
        }
        logger.debug(map.get("aincomeRatio"));
        logger.debug(map.get("acostRatio"));
        logger.debug(map.get("incomeRatio"));
        logger.debug(map.get("costRatio"));
        if (!"0".equals(map.get("aincomeRatio"))) {
            logger.debug("true");
        }
        if (!"0".equals(map.get("acostRatio"))) {
            logger.debug("true");
        }

        if (!"".equals(map.get("aincomeRatio")) && "21".equals(map.get("logType"))) {
            income = map.get("aincomeRatio");
        }
        if (!"".equals(map.get("acostRatio")) && "21".equals(map.get("logType"))) {
            cost = map.get("acostRatio");
        }

        try {
            sql.append(" replace into ebike.ebike_cssh_distscheme(csshDistSchemeId,chargestationId,orgoprOrgNo,stakeholderOrgNo,csshdsStatus,incomeRatio,costRatio,effTime) ");
            sql.append(" values(?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("csshDistSchemeId"), map.get("stationId"), map.get("orgoprOrgNo"), map.get("stakeholderOrgNo"), csshdsStatus, Double.valueOf(income)
                    , Double.valueOf(cost), new Date()
                });
            results = addDistschemeLog(map.get("csshDistSchemeId"), map.get("orgName"), map.get("logType"), loginfo, csshdsStatus1);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }
}
