package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.RateSetDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

//import cn.cc.cisp.code.util.CodeUtil;
//import cn.yunrui.bikeaccount.dao.RateSetDao;
//import cn.yunrui.bikeaccount.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.UUID;
//import cn.yunrui.common.util.YunRuiCommonUtil;
//import cn.yunrui.common.util.YunRuiDateUtil;

@Repository
public class RateSetDaoImpl extends AbstractEbikeBaseJdbcDao implements RateSetDao {
    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public RateSetDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public List<Map<String, Object>> queryRateStation(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(
                " select  a.ID,a.stationNo,a.stationAddr,b.STATUS  as status ,b.NAME as SName, GROUP_CONCAT(c.CHARGEDEVICENO order by c.CHARGEDEVICENO asc) as deviceNo ");
            sql.append(" from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID where 1=1 ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and  a.stationAddr like ?", "%" + map.get("stationAddr") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and b.SUBBURO=?", subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    //
    @Override
    public int queryRateCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from  (select  count(1) ");
            sql.append(" from cisp_dev.dev_ebikechargestation a  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID where 1=1 ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and  a.stationAddr like ?", "%" + map.get("stationAddr") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and b.SUBBURO=?", subburo);
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID ) n  ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    @Override
    public List<Map<String, Object>> queryRateModel(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csbsId,a.csbsType,a.csbsStatus,a.csbsUsersListId,a.newCsbsUsersListId,a.newSchemeId,a.csbsDesc,b.schemeId,b.schemeName,b.unitPrice1,b.schemeType, ");
            sql.append("  b.unitPrice2,b.unitPrice4,b.stepPower1,b.stepPower2,b.stepPower3,b.closingPeriod  ");
            sql.append(
                " ,b.unitPrice3,b.minCharge,b.isReturn,b.schemeType, b.schemeDetails,c.schemeName as 'cschemeName',c.unitPrice1 as 'cunitPrice1',  ");
            sql.append(
                " c.unitPrice2 as 'cunitPrice2',c.unitPrice3 as 'cunitPrice3',c.unitPrice4 as 'cunitPrice4',c.minCharge as 'cminCharge', ");
            sql.append(
                "  c.stepPower1  as 'cstepPower1',c.stepPower2 as 'cstepPower2',c.stepPower3 as 'cstepPower3',c.closingPeriod as 'cclosingPeriod', ");
            sql.append(
                "  c.isReturn as 'cisReturn',c.schemeType as 'cschemeType' from ebike.ebike_csbs_info a left join ebike.ebike_billingscheme b on a.schemeId=b.schemeId  ");
            sql.append(" LEFT JOIN ebike.ebike_billingscheme c on a.newSchemeId=c.schemeId  where 1=1 ");
            sql.append(" and a.chargestationId=? ", stationId);
            sql.append("  order by field(a.csbsType,'00','01')  asc , field(a.csbsStatus,'00','01','02','03','10') asc,a.effTime desc  ");
            logger.debug(">>>>>>>>>>>queryRateModel<<<<<<<<<<<<<<" + sql);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), (rs, rownum) -> {
                Map<String, Object> map = new HashMap<>();
                map.put("csbsId", rs.getString("csbsId"));
                map.put("csbsType", rs.getString("csbsType"));
                map.put("csbsStatus", rs.getString("csbsStatus"));
                map.put("csbsUsersListId", rs.getString("csbsUsersListId"));
                map.put("newCsbsUsersListId", rs.getString("newCsbsUsersListId"));
                map.put("schemeId", rs.getString("schemeId"));
                map.put("newSchemeId", rs.getString("newSchemeId"));
                //map.put("schemeName", );
                //map.put("cschemeName", rs.getString("cschemeName"));
                map.put("csbsDesc", rs.getString("csbsDesc"));
                map.put("schemeType", rs.getString("schemeType"));
                //计费详情
                String schemeDetails = rs.getString("schemeDetails");
                map.put("schemeDetails", schemeDetails);

                if (!"".equals(rs.getString("cschemeName")) && rs.getString("cschemeName") != null) {

                    String minCharge1 = "";
                    String minCharge2 = "";
                    String afterSchemeInfo = "";
                    String beformSchemeInfo = "";
                    String closingPeriod1 = "";
                    String closingPeriod2 = "";
                    String isReturn = "";
                    String isReturn1 = "";
                    String schemeName = "";
                    String schemeName1 = "";
                    if ("Y".equals(rs.getString("cisReturn"))) {
                        map.put("cisReturn", "预付可退");
                    } else {
                        map.put("cisReturn", "预付不退");
                    }
                    if ("03".equals(rs.getString("cschemeType"))) {
                        afterSchemeInfo = "(计次) " + String.valueOf(rs.getInt("cunitPrice1")) + " 元/次 ";
                        minCharge1 = " 无 (更改后)";
                        closingPeriod1 = " 无 (更改后)";
                        isReturn = " 预付不退 (更改后)";


                    } else {
                        afterSchemeInfo = " (计时) 0 W" + "～" + String.valueOf(rs.getInt("cstepPower1")) + " W " + " ： "
                            + String.valueOf(rs.getDouble("cunitPrice1")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("cstepPower1")) + " W " + "～"
                            + String.valueOf(rs.getInt("cstepPower2")) + " W ： "
                            + String.valueOf(rs.getDouble("cunitPrice2")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("cstepPower2")) + " W " + "～"
                            + String.valueOf(rs.getInt("cstepPower3")) + " W ： "
                            + String.valueOf(rs.getDouble("cunitPrice3")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("cstepPower3")) + " W " + "～" + " ∞ " + " ： "
                            + String.valueOf(rs.getDouble("cunitPrice4")) + " 小时/元。 " + "(更改后)";
                        minCharge1 = String.valueOf(rs.getDouble("cminCharge")) + "(更改后)\r\n";
                        closingPeriod1 = String.valueOf(rs.getInt("cclosingPeriod")) + "(更改后)";
                        if ("Y".equals(rs.getString("cisReturn"))) {
                            isReturn = "预付可退 (更改后)";
                        } else {
                            isReturn = "预付不退 (更改后)";
                        }
                    }
                    if ("03".equals(rs.getString("schemeType"))) {
                        beformSchemeInfo = "(计次) " + String.valueOf(rs.getInt("unitPrice1")) + " 元/次 " + "(更改前)\r\n" + ";";
                        minCharge2 = "无 （更改前）\r\n" + ";";
                        closingPeriod2 = "无 （更改前）\r\n" + ";";
                        isReturn1 = "预付不退 （更改前）\r\n" + ";";
                    } else if ("02".equals(rs.getString("schemeType"))) {
                        //计费详情
                        if (StrUtil.isNotBlank(schemeDetails)) {
                            String chargeServiceFee = JSONUtil.parseObj(schemeDetails).getStr("charge_service_fee");
                            String elecLossFee = JSONUtil.parseObj(schemeDetails).getStr("elec_loss_fee");
                            beformSchemeInfo = "（计电量）" + "电度电费：" + rs.getDouble("unitPrice1") + "元/度，"
                                + "基础服务费：" + chargeServiceFee + "元/度，" + "附加服务费：" + elecLossFee + "元/度";
                        }
                        map.put("isReturn", "预付可退");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "无");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else if ("05".equals(rs.getString("schemeType"))) {
                        String elecCost = JSONUtil.parseObj(schemeDetails).getStr("elec_cost");
                        beformSchemeInfo = "（计电量+计时（阶梯功率））电度电价：" + elecCost + "元/小时，服务费：" + " 0 W" + "～" + rs.getInt("stepPower1") + " W " + " ： "
                            + rs.getDouble("unitPrice1") + " 元/小时 ，"
                            + rs.getInt("stepPower1") + " W " + "～"
                            + rs.getInt("stepPower2") + " W ： "
                            + rs.getDouble("unitPrice2") + " 元/小时 ，"
                            + rs.getInt("stepPower2") + " W " + "～"
                            + rs.getInt("stepPower3") + " W ： "
                            + rs.getDouble("unitPrice3") + " 元/小时 ，"
                            + rs.getInt("stepPower3") + " W " + "～" + " ∞ " + " ： "
                            + rs.getDouble("unitPrice4") + " 元/小时";
                        minCharge2 = rs.getDouble("minCharge") + "（更改前）\r\n" + ";";
                        closingPeriod2 = rs.getInt("closingPeriod") + "(更改前)\r\n" + "；";
                        map.put("isReturn", "预付可退");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "无");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else {
                        beformSchemeInfo = "（计时） 0 W" + "～" + String.valueOf(rs.getInt("stepPower1")) + " W " + " ： "
                            + String.valueOf(rs.getDouble("unitPrice1")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("stepPower1")) + " W " + "～"
                            + String.valueOf(rs.getInt("stepPower2")) + " W ： "
                            + String.valueOf(rs.getDouble("unitPrice2")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("stepPower2")) + " W " + "～"
                            + String.valueOf(rs.getInt("stepPower3")) + " W ： "
                            + String.valueOf(rs.getDouble("unitPrice3")) + " 小时/元 ，"
                            + String.valueOf(rs.getInt("stepPower3")) + " W " + "～" + " ∞ " + " ： "
                            + String.valueOf(rs.getDouble("unitPrice4")) + " 小时/元。 " + "(更改前)\r\n" + ";";
                        minCharge2 = String.valueOf(rs.getDouble("minCharge")) + "（更改前）\r\n" + ";";
                        closingPeriod2 = String.valueOf(rs.getInt("closingPeriod")) + "(更改前)\r\n" + "；";
                        if ("Y".equals(rs.getString("isReturn"))) {
                            isReturn1 = "预付可退 (更改前)\r\n" + "；";
                        } else {
                            isReturn1 = "预付不退 (更改前)\r\n" + "；";
                        }
                    }
                    String powerAndPrice = beformSchemeInfo + afterSchemeInfo;
                    map.put("powerAndPrice", powerAndPrice);
                    map.put("minCharge", minCharge2 + minCharge1);
                    map.put("closingPeriod", closingPeriod2 + closingPeriod1);
                    map.put("isReturn", isReturn1 + isReturn);
                    map.put("schemeName", rs.getString("schemeName") + "(更改前)\r\n" + "；" + rs.getString("cschemeName") + " （更改后）");
                } else {

                    String powerAndPrice1 = "";
                    if ("03".equals(rs.getString("schemeType"))) {
                        powerAndPrice1 = "（计次）" + String.valueOf(rs.getDouble("unitPrice1")) + "元/次";
                        map.put("isReturn", "预付不退");
                        map.put("closingPeriod", "无");
                        map.put("minCharge", "无");
                    } else if ("02".equals(rs.getString("schemeType"))) {
                        //计费详情
                        if (StrUtil.isNotBlank(schemeDetails)) {
                            String chargeServiceFee = JSONUtil.parseObj(schemeDetails).getStr("charge_service_fee");
                            String elecLossFee = JSONUtil.parseObj(schemeDetails).getStr("elec_loss_fee");
                            powerAndPrice1 = "（计电量）" + "电度电费：" + rs.getDouble("unitPrice1") + "元/度，"
                                + "基础服务费：" + chargeServiceFee + "元/度，" + "附加服务费：" + elecLossFee + "元/度";
                        }
                        map.put("isReturn", "预付可退");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "无");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else if ("05".equals(rs.getString("schemeType"))) {
                        String elecCost = JSONUtil.parseObj(schemeDetails).getStr("elec_cost");
                        powerAndPrice1 = "（计电量+计时（阶梯功率））电度电价：" + elecCost + "元/小时，服务费：" + " 0 W" + "～" + rs.getInt("stepPower1") + " W " + " ： "
                            + rs.getDouble("unitPrice1") + " 元/小时 ，"
                            + rs.getInt("stepPower1") + " W " + "～"
                            + rs.getInt("stepPower2") + " W ： "
                            + rs.getDouble("unitPrice2") + " 元/小时 ，"
                            + rs.getInt("stepPower2") + " W " + "～"
                            + rs.getInt("stepPower3") + " W ： "
                            + rs.getDouble("unitPrice3") + " 元/小时 ，"
                            + rs.getInt("stepPower3") + " W " + "～" + " ∞ " + " ： "
                            + rs.getDouble("unitPrice4") + " 元/小时";
                        map.put("isReturn", "预付可退");
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "无");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    } else {
                        powerAndPrice1 = "（计时）0 W" + "～" + rs.getInt("stepPower1") + " W " + " ： "
                            + rs.getDouble("unitPrice1") + " 小时/元 ，"
                            + rs.getInt("stepPower1") + " W " + "～"
                            + rs.getInt("stepPower2") + " W ： "
                            + rs.getDouble("unitPrice2") + " 小时/元 ，"
                            + rs.getInt("stepPower2") + " W " + "～"
                            + rs.getInt("stepPower3") + " W ： "
                            + rs.getDouble("unitPrice3") + " 小时/元 ，"
                            + rs.getInt("stepPower3") + " W " + "～" + " ∞ " + " ： "
                            + rs.getDouble("unitPrice4") + " 小时/元";
                        if ("Y".equals(rs.getString("isReturn"))) {
                            map.put("isReturn", "预付可退");
                        } else {
                            map.put("isReturn", "预付不退");
                        }
                        if (rs.getInt("closingPeriod") == 0) {
                            map.put("closingPeriod", "无");
                        } else {
                            map.put("closingPeriod", String.valueOf(rs.getInt("closingPeriod")));
                        }
                        map.put("minCharge", String.valueOf(rs.getDouble("minCharge")));
                    }

                    map.put("powerAndPrice", powerAndPrice1);
                    map.put("schemeName", rs.getString("schemeName"));
                }
                return map;
            });
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    //
    @Override
    public int rateModelCount(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(
                " select count(1) from ebike.ebike_csbs_info a left join ebike.ebike_billingscheme b on a.csbsId=b.schemeId ");
            sql.append(" LEFT JOIN ebike.ebike_billingscheme c on a.newSchemeId=c.schemeId  where 1=1 ");
            sql.append(" and a.chargestationId=? ", stationId);
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    @Override
    public String findPhoneById(String userId) {
        // TODO Auto-generated method stub
        return null;
    }

    //
    @Override
    public String sRateAdd(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        String uuid = UuidUtils.generateUuidString();
        String phones = map.get("phoneList");
        String[] userPhones = map.get("userPhone").split(",");
        String csbsStatus = "";
        // 查询此电站是否有收益共享人 如有 csbsStatus为01,然则00
        int count = querySCountById(map.get("stationId"));
        if (count > 0) {
            csbsStatus = "01";
        } else {
            csbsStatus = "00";
        }

        try {
            sql.append(
                " insert into ebike.ebike_csbs_info(csbsId,chargestationId,csbsType,csbsStatus,csbsDesc,schemeId,csbsUsersListId,effTime)");
            sql.append(" values(?,?,?,?,?,?,?,?)");
            logger.debug("SRateAdd" + sql.toString());
            results = ebikeJdbcTemplate
                .update(sql.getSql(),
                    new Object[]{uuid, map.get("stationId"), map.get("McsbsType"), csbsStatus,
                        map.get("McsbsDesc"), map.get("MschemeId"), map.get("csbsUsersListId"),
                        count <= 0 ? new Date() : null});
            if (count <= 0) {
                if (!"".equals(map.get("csbsUsersListId"))) { // 1为沿用 0为更新 ""表示
                    if ("1".equals(map.get("updateOrinsert")) || "3".equals(map.get("updateOrinsert"))) {
                        if (!"".equals(map.get("userPhone"))) {
                            logger.debug(">>>>>>><userPhone<<<<<<<<<<<<<" + map.get("userPhone"));
                            logger.debug(">>>>>>><userPhone<<<<<<<<<<<<<" + map.get("phoneList"));
                            for (int i = 0; i < userPhones.length; i++) {
                                phones = phones.replaceAll(userPhones[i] + ",", "");
                            }
                        }
                        logger.debug(">>>>>>>>phoneList<<<<<<<<<<<<<" + phones);
                        String[] phoneList = phones.split(",");
                        for (String Phone : phoneList) {
                            results = addCsbsUser(map.get("csbsUsersListId"), Phone);
                        }
                        if ("1".equals(map.get("updateOrinsert"))) {

                            results = deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"),
                                map.get("updateOrinsert"));

                        }
                    } else {
                        results = deleteUserByPhone(map.get("userPhone"));
                        String[] phoneList = map.get("phoneList").split(",");
                        for (String phone : phoneList) {
                            results = addCsbsUser(map.get("csbsUsersListId"), phone);
                        }
                        List<Map<String, Object>> userlist = selectUserId(map.get("stationId"), uuid);
                        for (int i = 0; i < userlist.size(); i++) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                            if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                        }
                        //for (String userPhone : userPhones) {
//
//							results = deleteRepatePhone(map.get("csbsUsersListId"), userPhone,
//									map.get("updateOrinsert"));
//						}
                    }

                }
                // results=csbsOperation(map.get("stationId"),uuid,map.get("subburo"),map.get("orgName"));
            } else {
                // results=csbsOperation(map.get("stationId"),uuid,map.get("subburo"),map.get("orgName"));
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert"))) {
                        results = deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), map.get("updateOrinsert"));
                    } else if ("0".equals(map.get("updateOrinsert"))) {
                        List<Map<String, Object>> userlist = selectUserList(map.get("stationId"), uuid);
                        for (int i = 0; i < userlist.size(); i++) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                logger.debug(">>>>>>>>>SRateAdd<<<<<<<<<" + userlist.get(i).get("csbsUsersListId"));
                                results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                            if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                        }

                        for (String userPhone : userPhones) {
                            if (!"".equals(userPhone) && !"null".equals(userPhone)) {
                                results = addRepeatData(userPhone, map.get("csbsUsersListId"), map.get("updateOrinsert"));
                            }
                        }
                    } else {
                        results = updateRepeatData(map.get("csbsUsersListId"), map.get("updateOrinsert"));
                    }
                }
                for (String userPhone : userPhones) {
                    if (!"".equals(userPhone) && !"null".equals(userPhone)) {
                        results = addRepeatData(userPhone, map.get("csbsUsersListId"), map.get("updateOrinsert"));
                    } else {
                        results = updateRepeatData(map.get("csbsUsersListId"), map.get("updateOrinsert"));
                    }

                }
            }
            results = csbsOperation(map.get("stationId"), uuid, map.get("subburo"), map.get("orgName"));
            results = addcsbsOpLog(uuid, "10", "01", map.get("orgName"));
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        if (results > 0) {
            if (count > 0) {
                message = "计费模板新增操作成功，请等待共享人确认";
            } else {
                message = "计费模板设置成功,即时生效";
            }
        } else {
            message = "计费模板新增操作失败！";
        }
        return message;

    }

    public List<Map<String, Object>> selectUserId(String stationId, String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10'   ");
            sql.append(" and b.chargestationId=?", stationId);
            if (!"".equals(csbsId)) {
                sql.append(" and b.csbsId!=? ", csbsId);
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
//			  if(list.size()>0||list!=null)
//			  {
//				  for(int i=0;i<list.size();i++)
//				  {
//					  List<Map<String,String>> results=selectUserInfo(list.get(i).get("csbsUsersListId"));
//					  if(list.size()<=0||list==null)
//					  {
//						  int result=deleteUserPhone(list.get(i).get("csbsUsersListId"));
//					  }
//				  }
//			  }
            // logger.debug(">>>>>>>>>>>>>selectUserId<<<<<<<<<<<<<<<"+sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public List<Map<String, Object>> selectUserList(String stationId, String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select b.csbsUsersListId,b.newCsbsUsersListId from ebike.ebike_csbs_info b  where 1=1 and b.csbsStatus!='10' ");
            sql.append(" and b.chargestationId=?", stationId);
            if (!"".equals(csbsId)) {
                sql.append(" and b.csbsId!=? ", csbsId);
            }
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
//			  if(list.size()>0||list!=null)
//			  {
//				  for(int i=0;i<list.size();i++)
//				  {
//					  List<Map<String,String>> results=selectUserInfo(list.get(i).get("csbsUsersListId"));
//					  if(list.size()<=0||list==null)
//					  {
//						  int result=deleteUserPhone(list.get(i).get("csbsUsersListId"));
//					  }
//				  }
//			  }
            // logger.debug(">>>>>>>>>>>>>selectUserId<<<<<<<<<<<<<<<"+sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    public int querySCountById(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_cssh_distscheme  where 1=1 and ( csshdsStatus='00' or  csshdsStatus='02') ");
            sql.append(" and chargestationId=?", stationId);
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    //
    // 添加使用用户名单
    public int addCsbsUser(String csbsUsersListId, String userPhone) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" insert into ebike.ebike_csbs_info_userlist(csbsUsersListId,csbsUserMobile,createTime)");
            sql.append(" values(?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsUsersListId, userPhone, new Date()});
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    //
    @Override
    public String rateModify(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        String phones = map.get("phoneList");

        String[] userPhones = map.get("userPhone").split(",");
        int count = querySCountById(map.get("stationId"));
        logger.debug(">>>>>>>>>>>count<<<<<<<<<<<" + count);
        logger.debug(">>>>>>>>>>>count<<<<<<<<<<<" + map.get("stationId"));
        try {
            sql.append(" update ebike.ebike_csbs_info set ");
            if (count > 0) {
                sql.append(" csbsStatus='02' ");
                sql.append(",newSchemeId=?", map.get("MschemeId"));
                sql.append(",newCsbsUsersListId=?", map.get("csbsUsersListId"));
                sql.append(" ,effTime=null ");
            } else {

                sql.append(" csbsStatus='00' ");
                sql.append(",schemeId=?", map.get("MschemeId"));
                sql.append(",csbsUsersListId=?", map.get("csbsUsersListId"));
                sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
                );
            }
            sql.append(" ,csbsDesc=?", map.get("McsbsDesc"));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", map.get("csbsId"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            String updateOrinsert = map.get("updateOrinsert");
//			if ("".equals(map.get("updateOrinsert"))) {
//				updateOrinsert = "2";
//			}
            if (count <= 0) {
                if ("00".equals(map.get("csbsType"))) {
                    logger.debug("csbsType ", map.get("csbsType"));
                    int aresult = updateCsbsInfo(map.get("MschemeId"), map.get("stationId"));
                }

                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert")) || "3".equals(map.get("updateOrinsert"))) {
                        if (!"".equals(map.get("userPhone"))) {
                            for (int i = 0; i < userPhones.length; i++) {
                                phones = phones.replaceAll(userPhones[i] + ",", "");
                            }
                        }
                        String[] phoneList = phones.split(",");
                        for (String Phone : phoneList) {
                            results = addCsbsUser(map.get("csbsUsersListId"), Phone);
                        }
                        if ("1".equals(map.get("updateOrinsert"))) {
                            results = deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), updateOrinsert);
                        }
                    } else {
                        results = deleteUserByPhone(map.get("userPhone"));
                        String[] phoneList = map.get("phoneList").split(",");
                        for (String phone : phoneList) {
                            results = addCsbsUser(map.get("csbsUsersListId"), phone);
                        }
                        List<Map<String, Object>> userlist = selectUserList(map.get("stationId"), map.get("csbsId"));
                        for (int i = 0; i < userlist.size(); i++) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                            if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                        }
                    }

                }

            } else {
                if (!"".equals(map.get("csbsUsersListId"))) {
                    if ("1".equals(map.get("updateOrinsert"))) {
                        results = deleteRepatePhone(map.get("csbsUsersListId"), map.get("userPhone"), updateOrinsert);
                    } else if ("0".equals(map.get("updateOrinsert"))) {
                        List<Map<String, Object>> userlist = selectUserList(map.get("stationId"), map.get("csbsId"));
                        logger.debug(">>>>>>>>>>userlist<<<<<<<<<<<<<<<<<<<<<<" + userlist.toString());
                        for (int i = 0; i < userlist.size(); i++) {
                            if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                            if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), map.get("userPhone"),
                                    map.get("updateOrinsert"));
                            }
                        }

                        for (String userPhone : userPhones) {
                            if (!"".equals(userPhone) && !"null".equals(userPhone)) {
                                results = addRepeatData(userPhone, map.get("csbsUsersListId"), updateOrinsert);
                            }
                        }
                    } else {
                        results = updateRepeatData(map.get("csbsUsersListId"), updateOrinsert);
                    }
                }
                results = csbsOperation(map.get("stationId"), map.get("csbsId"), map.get("subburo"),
                    map.get("orgName"));

            }

            results = addcsbsOpLog(map.get("csbsId"), "20", "02", map.get("orgName"));
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        if (results > 0) {
            if (count > 0) {
                message = "计费模板修改操作成功，请等待共享人确认";
            } else {
                message = "计费模板设置成功,即时生效";
            }
        } else {
            message = "计费模板修改操作失败！";
        }
        return message;

    }

    public int addRepeatData(String csbsUserMobile, String uuid, String updateOrInsert) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_csbs_info_fu_userlist(csbsUsersListId,repateMobile,updateOrInsert)");
            sql.append(" values(?,?,?)");
            return ebikeJdbcTemplate.update(sql.getSql(), new Object[]{uuid, csbsUserMobile, updateOrInsert});

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    public int updateRepeatData(String uuid, String updateOrInsert) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" update ebike.ebike_csbs_info_fu_userlist set ");
            sql.append(" updateOrInsert=? ", updateOrInsert);
            sql.append(" where 1=1 ");
            sql.append(" and csbsUsersListId=? ", uuid);
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    @Override
    public Map<String, Object> stopRate(String csbsId, String orgName, String stationId, String subburo) {
        Map<String, Object> map = new HashMap<>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        int count = querySCountById(stationId);
        try {
            results = getSchemeCountByStationId(stationId);
            if (results <= 1) {
                message = "只有存在一个以上生效的计费方案才可以进行终止操作";
                map.put("status", 0);
                map.put("message", message);
                return map;
            }
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='03'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='10'  ");
                sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
                );
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", csbsId);
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = csbsOperation(stationId, csbsId, subburo, orgName);
            }

            results = addcsbsOpLog(csbsId, "30", "03", orgName);
        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (results > 0) {
            if (count > 0) {
                message = "计费模板终止操作成功，请等待共享人确认";

            } else {
                message = "计费模板设置成功,即时生效";
            }
            map.put("status", 1);
            map.put("message", message);
        } else {
            message = "计费模板终止操作失败！";
            map.put("status", 2);
            map.put("message", message);
        }
        return map;
    }

    //
    // 收益分享电站
    @Override
    public List<Map<String, Object>> qShareStation(String subburo, Map<String, String> map) {
        System.out.println(subburo);
        System.out.println(map);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status,b.NAME as SName, GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo  ");
            sql.append(" from ebike.ebike_cssh_distscheme d  ");
            sql.append(" left join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  b.ID=a.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and  a.stationAddr like ?", "%" + map.get("stationAddr") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID  ");
            logger.debug(">>>>>>>>>>>QShareStation<<<<<<<<<<<<<" + sql.toString());
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    //
    // 收益分享电站数量
    @Override
    public int qShareCount(String subburo, Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from  (select  count(1)");
            sql.append(" from ebike.ebike_cssh_distscheme d  ");
            sql.append(" left join cisp_dev.dev_ebikechargestation a  on a.ID=d.chargestationId ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on  b.ID=a.ID  ");
            sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  where 1=1 ");
            sql.append(" and a.stationNo like ? ", "%" + map.get("stationNo") + "%");
            sql.append(" and  b.NAME like ?", "%" + map.get("stationName") + "%");
            sql.append(" and b.STATUS=?", map.get("status"));
            sql.append(" and c.CHARGEDEVICENO like ?", "%" + map.get("deviceNo") + "%");
            sql.append(" and d.stakeholderOrgNo=?", subburo);
            sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
            sql.append(" and b.CLASSNAME='EBikeChargeStation' GROUP BY a.ID ) n  ");
            logger.debug(">>>>>>>>>>>>>>><QShareCount<<<<<<<<<<<<" + sql.toString());
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    // 获取此电站 生效的收益共享人的orgNo,
    public int csbsOperation(String stationId, String uuid, String subburo, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select stakeholderOrgNo from ebike.ebike_cssh_distscheme where 1=1 and csshdsStatus='00' ");
            sql.append(" and orgoprOrgNo=? ", subburo);
            sql.append(" and chargestationId=?", stationId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            for (int i = 0; i < list.size(); i++) {
                results = addShareConfirm(list.get(i).get("stakeholderOrgNo").toString(), uuid, orgName);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    //
    // 向计费方案新增待确认表中添加待确认信息 方便共享人以后确认
    public int addShareConfirm(String stakeholderOrgNo, String uuid, String orgName) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(
                " replace into ebike.ebike_csbs_info_tbc(csbsId,stakeholderOrgNo,creator,createTime,confirmFlag) ");
            sql.append(" values(?,?,?,?,?)");
            logger.debug(">>>>>>>>>>>>addShareConfirm<<<<<<<<<<<" + sql.toString());
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{uuid, stakeholderOrgNo, orgName, new Date(), "0"});
            logger.debug(">>>>>>>>>>>>addShareConfirm1<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    //
    @Override
    public List<Map<String, Object>> queryOperationInfo(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.csbsId,a.logType,a.logTime,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
            sql.append(
                " from ebike.ebike_log_csbs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csbsId=?", csbsId);
            sql.append(" order by  a.logTime desc ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), new RowMapper<Map<String, Object>>() {
                public Map<String, Object> mapRow(final ResultSet rs, final int rownum) throws SQLException {
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("csbsId", rs.getString("csbsId"));
                    map.put("logType", rs.getString("logType"));
                    map.put("logTime", rs.getTimestamp("logTime"));
                    map.put("userName", rs.getString("userName"));
                    map.put("orgName", rs.getString("orgName"));
                    return map;
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    //
    @Override
    public int operationCount(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(
                " select count(1) from ebike.ebike_log_csbs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
            sql.append(" and a.csbsId=?", csbsId);
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    // 添加操作日志
    public int addcsbsOpLog(String csbsId, String logType, String csshdsStatus, String operator) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            return ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{csbsId, logType, new Date(), csshdsStatus, operator});

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    public int deleteUserByPhone(String userPhone) {
        logger.debug("deleteUserByPhone" + userPhone);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" delete from ebike.ebike_csbs_info_userlist  where 1=1  ");
            sql.append(" and csbsUserMobile in (?)", userPhone, ",");
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    @Override
    public boolean checkCsbsById(String scheId, String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info where 1=1  ");
            sql.append(" and (schemeId=?", scheId);
            sql.append(" or newSchemeId=?)", scheId);
            sql.append(" and chargestationId=?", stationId);
            sql.append(" and csbsStatus!='10' ");
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;

        } else {
            return false;
        }
    }

    //
    @Override
    public boolean yysOpConfirm(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            // 更新计费方案操作表
            sql.append(" update ebike.ebike_csbs_info_tbc set ");
            sql.append(" confirmFlag=?", map.get("confirmFlag"));
            sql.append(" ,confirmer=?", map.get("orgName"));
            sql.append(" ,confirmTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", map.get("csbsId"));
            sql.append(" and stakeholderOrgNo=?", map.get("subburo"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = updateOpLog(map.get("csbsId"), map.get("orgName"), map.get("logType"));
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;

        } else {
            return false;
        }
    }

    //
    public int updateOpLog(String csbsId, String orgName, String logType) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, String> maps = new HashMap<>();
        int results = 0;
        int count = 0;
        try {
            // 新增一条操作日志
            sql.append(" insert into ebike.ebike_log_csbs_info(csbsId,logType,logTime,csbsStatus,operator)");
            sql.append(" values(?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(), new Object[]{csbsId, logType, new Date(), "00", orgName});

            count = queryConfirmInfo(csbsId, logType, "0", maps);
            logger.debug(">>>>>>>updateOpLog<<<<<<<  " + count);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    //
    // 获取计费方案运营商的确认状态  flag 为了与是否解禁 和是否禁用区分开
    //如果是解禁和禁用功能的话 flag为1 如是新增 修改 终止等确认为0
    public int queryConfirmInfo(String csbsId, String logType, String flag, Map<String, String> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int confirmFlag1 = 0;
        int confirmFlag2 = 0;
        int confirmFlag3 = 0;
        int count = 0;
        try {
            sql.append(" select confirmFlag from ebike.ebike_csbs_info_tbc  where 1=1 ");
            sql.append(" and csbsId=?", csbsId);
            List<Map<String, Object>> list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            for (int i = 0; i < list.size(); i++) {
                // confirmFlag 0代表待确认 1 代表同意，2代表不同意
                if ("0".equals(list.get(i).get("confirmFlag"))) {
                    confirmFlag1 = confirmFlag1 + 1;
                }
                if ("1".equals(list.get(i).get("confirmFlag"))) {
                    confirmFlag2 = confirmFlag2 + 1;
                }
                if ("2".equals(list.get(i).get("confirmFlag"))) {
                    confirmFlag3 = confirmFlag3 + 1;
                }
            }
            logger.debug(" queryConfirmInfo " + confirmFlag3);
            logger.debug(" queryConfirmInfo " + confirmFlag1);
            logger.debug(" queryConfirmInfo " + confirmFlag1);

            // 如果confirmFlag1==0 说明 没有待确认的了 但是不确定利益相关方是否都同意or不同意修改
            if (confirmFlag1 == 0 && flag == "0") {
                Map<String, Object> map = queryCsbcInfo(csbsId, confirmFlag2, confirmFlag3);
            } else if (confirmFlag1 == 0 && flag == "1") {
                //禁用或解禁
                int result = foriddenOrUnForidden(csbsId, confirmFlag2, confirmFlag3, maps);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return 1;
    }

    //
    public Map<String, Object> queryCsbcInfo(String csbsId, int confirmFlag2, int confirmFlag3) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> map = new HashMap<String, Object>();
        List<Map<String, Object>> list = null;
        int count = 0;
        int results = 0;
        try {
            // 首先查询计费方案关系表中的数据 为了下面更新关系表时用
            sql.append(" select schemeId,newSchemeId,newCsbsUsersListId,csbsStatus,csbsUsersListId,chargestationId,csbsType from ebike.ebike_csbs_info  where 1=1");
            sql.append(" and csbsId=?", csbsId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            SqlParamsBuilder sql2 = new SqlParamsBuilder();

            // 更新计费方案关系表
            sql2.append(" update  ebike.ebike_csbs_info set newSchemeId='',newCsbsUsersListId='' ");
            if (confirmFlag3 != 0 && "01".equals(list.get(0).get("csbsStatus")) && confirmFlag2 == 0) {
                // 新增时如果有一方不同意 在代表此方案无法通过 所以不能生效
                sql2.append(" ,csbsStatus='10' ");
            }
            if ((confirmFlag3 != 0 && "02".equals(list.get(0).get("csbsStatus")))
                || (confirmFlag3 != 0 && "03".equals(list.get(0).get("csbsStatus")))) {
                // 修改时如果由一方不同意 则该计费方案关系 还是保持在原来的生效状态
                sql2.append(" ,csbsStatus='00' ");
            }

            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                // 都同意新增或修该时
                if ("02".equals(list.get(0).get("csbsStatus"))) { // 如同意修改
                    // 则将计费模板ID更换(如果是更换计费模板的话)
                    if (!"".equals(list.get(0).get("newSchemeId")) && list.get(0).get("newSchemeId") != null) {
                        sql2.append(" ,schemeId=?", list.get(0).get("newSchemeId").toString());
                        sql2.append(" ,csbsStatus='00' ");
                    }
                    if (!"".equals(list.get(0).get("newCsbsUsersListId"))
                        && list.get(0).get("newCsbsUsersListId") != null) {
                        sql2.append(" ,csbsUsersListId=?", list.get(0).get("newCsbsUsersListId").toString());
                        sql2.append(" ,csbsStatus='00' ");
                    }

                }

                // 新增或终止的话直接修改状态即可
                if ("01".equals(list.get(0).get("csbsStatus"))) {
                    sql2.append(" ,csbsStatus='00' ");
                }
                if ("03".equals(list.get(0).get("csbsStatus"))) {
                    sql2.append(" ,csbsStatus='10' ");
                }
            }
            sql2.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
            );
            sql2.append(" where 1=1 ");
            sql2.append(" and csbsId=?", csbsId);
            count = ebikeJdbcTemplate.update(sql2.getSql(), sql2.getParams());
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                if ("00".equals(list.get(0).get("csbsType"))) {
                    // 默认直接更换计费方案ID
                    int aresult = updateCsbsInfo(list.get(0).get("newSchemeId").toString(), list.get(0).get("chargestationId").toString());
                }
                if ("01".equals(list.get(0).get("csbsStatus"))) {

                    if (!"".equals(list.get(0).get("csbsUsersListId"))) {

                        String phones = queryPhoneList(list.get(0).get("csbsUsersListId").toString());
                        logger.debug(">>>>>>>>>>>addConfirm<<<<<<<<<<<<<" + phones);
                        // 查询重复电话?
                        Map<String, String> maps = getPromptInfo(list.get(0).get("csbsUsersListId").toString());
                        logger.debug(">>>>>>>>>>maps<<<<<<<<<<<<" + maps);
                        String[] userPhones = maps.get("repateMobile").split(",");// 重复电话
                        logger.debug(">>>>>>>>>>repateMobile<<<<<<<<<<" + userPhones);
                        // 沿用1 更新2
                        if ("1".equals(maps.get("updateOrInsert")) || "3".equals(maps.get("updateOrInsert"))) {

                            for (int i = 0; i < userPhones.length; i++) {
                                if (!"9".equals(userPhones[i])) {
                                    phones = phones.replaceAll(userPhones[i] + ",", "");
                                }
                                //将重复的号码替换成""值
                                logger.debug("userPhones[i] " + userPhones[i]);
                            }
                            String[] phoneList = phones.split(",");
                            for (String phone : phoneList) {
                                if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                    results = addCsbsUser(list.get(0).get("csbsUsersListId").toString(), phone);
                                }
//								for (String userPhone : userPhones) {

                                //if (!"".equals(userPhone) && !"null".equals(userPhone)) {
                                if ("1".equals(maps.get("updateOrInsert"))) {
                                    results = deleteRepatePhone(list.get(0).get("csbsUsersListId").toString(), maps.get("repateMobile"), "0");
                                }

//								}

                            }

                        } else {
                            String[] phoneList = phones.split(",");
                            logger.debug(">>>>>>>>>>><<<<<<<<<<<<<" + map.get("userPhone"));
                            results = deleteUserByPhone(maps.get("repateMobile"));
                            for (String phone : phoneList) {
                                if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                    results = addCsbsUser(list.get(0).get("csbsUsersListId").toString(), phone);
                                }
                            }
//							for (String userPhone : userPhones) {
//								if (!"".equals(userPhone) && !"null".equals(userPhone)) {
//									//results = deleteRepatePhone(list.get(0).get("csbsUsersListId"), userPhone, "1");
//								}
//							}
                            List<Map<String, Object>> userlist = selectUserId(list.get(0).get("chargestationId").toString(), csbsId);
                            for (int i = 0; i < userlist.size(); i++) {
                                if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {

                                    results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), maps.get("repateMobile"),
                                        maps.get("updateOrinsert").toString());
                                }
                                if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                    results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), maps.get("repateMobile"),
                                        "1");
                                }
                            }

                        }
                    }
                }

                if ("02".equals(list.get(0).get("csbsStatus"))) {
                    if (!"".equals(list.get(0).get("newCsbsUsersListId"))) {

                        String phones = queryPhoneList(list.get(0).get("newCsbsUsersListId").toString());

                        logger.debug(">>>>>>>>>>phones<<<<<<<<" + phones);
                        Map<String, String> maps = getPromptInfo(list.get(0).get("newCsbsUsersListId").toString());
                        logger.debug(">>>>>>>>>>phonesmaps<<<<<<<<" + maps);
                        String[] userPhones = maps.get("repateMobile").split(",");
                        if ("1".equals(maps.get("updateOrInsert")) || "3".equals(maps.get("updateOrInsert"))) {

                            for (int i = 0; i < userPhones.length; i++) {
                                if (!"9".equals(userPhones[i])) {
                                    phones = phones.replaceAll(userPhones[i] + ",", "");
                                }
                                //将重复的号码替换成""值
                                logger.debug("userPhones[i] " + userPhones[i]);
                            }
                            String[] phoneList = phones.split(",");
                            for (String phone : phoneList) {
                                if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                    results = addCsbsUser(list.get(0).get("newCsbsUsersListId").toString(), phone);
                                }
                                if ("1".equals(maps.get("updateOrInsert"))) {
                                    results = deleteRepatePhone(list.get(0).get("csbsUsersListId").toString(), maps.get("repateMobile"), "0");
                                }

                            }
                        } else {
                            results = deleteUserByPhone(maps.get("repateMobile"));
                            String[] phoneList = phones.split(",");
                            for (String phone : phoneList) {
                                if (!"null".equals(phone) && phone != null && !"".equals(phone)) {
                                    results = addCsbsUser(list.get(0).get("newCsbsUsersListId").toString(), phone);
                                }
                            }
                            List<Map<String, Object>> userlist = selectUserId(list.get(0).get("chargestationId").toString(), csbsId);
                            for (int i = 0; i < userlist.size(); i++) {
                                if (!"".equals(userlist.get(i).get("csbsUsersListId")) && userlist.get(i).get("csbsUsersListId") != null) {
                                    results = deleteRepatePhone(userlist.get(i).get("csbsUsersListId").toString(), maps.get("repateMobile"),
                                        "1");
                                }
                                if (!"".equals(userlist.get(i).get("newCsbsUsersListId")) && userlist.get(i).get("newCsbsUsersListId") != null) {
                                    results = deleteRepatePhone(userlist.get(i).get("newCsbsUsersListId").toString(), maps.get("repateMobile"),
                                        "1");
                                }
                            }

                        }
                    }
                }
            }
            logger.debug(">>>>>>>updateOpLog212<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return map;
        }
    }

    //
    public int deleteRepatePhone(String userId, String phone, String flag) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        logger.debug(">>>>>>>>>>>>>>vdeleteRepatePhone<<<<<<<<<<<<<<" + phone);
        logger.debug(">>>>>>>>>>>>>>userId<<<<<<<<<<<<<<" + userId);
        try {
            sql.append(" delete from ebike.ebike_csbs_info_fu_userlist  where 1=1 ");
            sql.append(" and csbsUserMobile in(?)", phone);
            // sql.append(userId," and csbsUsersListId =? ");
            sql.append(" and csbsUsersListId=?", userId);
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    //
    @Override
    public String getInsertOrUpdate(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select  DISTINCT(updateOrInsert) from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", newCsbsUsersListId);
            sql.append(" and  LENGTH(updateOrInsert)>0 ");
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }

    }

    @Override
    public List<Map<String, Object>> getPromptData(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(
                " select repateMobile,updateOrInsert from ebike.ebike_csbs_info_fu_userlist where 1=1  and LENGTH(repateMobile)>0 ");
            sql.append(" and csbsUsersListId=?", newCsbsUsersListId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    //获取重复手机号码
    public Map<String, String> getPromptInfo(String newCsbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String userPhone = "";
        String updateOrInsert = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, String> map = new HashMap<String, String>();
        map.put("repateMobile", "");
        map.put("updateOrInsert", "");
        logger.debug("newCsbsUsersListId " + newCsbsUsersListId);
        try {
            sql.append(
                " select IFNULL(repateMobile,'9') as repateMobile,IFNULL(updateOrInsert,'4') as updateOrInsert from ebike.ebike_csbs_info_fu_userlist where 1=1  ");
            sql.append(" and csbsUsersListId=?", newCsbsUsersListId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), new RowMapper<Map<String, Object>>() {
                public Map<String, Object> mapRow(final ResultSet rs, final int rownum) throws SQLException {
                    Map<String, Object> map = new HashMap<String, Object>();
                    map.put("repateMobile", rs.getString("repateMobile"));
                    map.put("updateOrInsert", rs.getString("updateOrInsert"));
                    return map;
                }
            });
            for (int i = 0; i < list.size(); i++) {
                userPhone = userPhone + list.get(i).get("repateMobile") + ",";
                updateOrInsert = list.get(i).get("updateOrInsert").toString();
            }
            logger.debug("userPhone " + userPhone);
        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        map.put("repateMobile", userPhone);
        map.put("updateOrInsert", updateOrInsert);
        return map;
    }

    //
    public String queryPhoneList(String userId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUserMobile  from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", userId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);
            logger.debug(">>>>>>>>>>queryPhoneList<<<<<<<<<" + list.toString());
            for (int i = 0; i < list.size(); i++) {
                phoneList = phoneList + list.get(i).get("csbsUserMobile") + ",";
            }

        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return phoneList;
    }

    //
    @Override
    public List<Map<String, Object>> queryUserPhone(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUsersListId,csbsUserMobile from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", csbsUsersListId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryPhoneCount(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", csbsUsersListId);
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> queryNewUserPhone(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String phoneList = "";
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUsersListId,csbsUserMobile from ebike.ebike_csbs_info_fu_userlist where 1=1 and csbsUserMobile is not null ");
            sql.append(" and csbsUsersListId=?", csbsUsersListId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int newPhoneCount(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_csbs_info_fu_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", csbsUsersListId);
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);

        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    //
    public int updateCsbsInfo(String newSchemeId, String chargestationId) {
        logger.debug("updateCsbsInfo  " + newSchemeId);
        logger.debug("updateCsbsInfo21  " + chargestationId);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("update ebike.ebike_cs_bs_rela set  ");
            sql.append(" schemeId=?", newSchemeId);
            sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
            );
            sql.append(" where 1=1 ");
            sql.append(" and chargestationId=?", chargestationId);
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public List<Map<String, Object>> getUserList(String csbsUsersListId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select csbsUserMobile from ebike.ebike_csbs_info_userlist where 1=1 ");
            sql.append(" and csbsUsersListId=?", csbsUsersListId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public Map<String, Object> getStationInfoByCsbsId(String csbsId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, Object> maps = new HashMap<>();
        try {
            sql.append(" select a.id,a.stationNo,b.name,a.stationAddr from ebike.ebike_csbs_info c left join cisp_dev.dev_ebikechargestation a on c.chargestationId=a.id  ");
            sql.append(" left join cisp_dev.dev_powersystemresource b on a.id=b.id where 1=1 ");
            sql.append("  and c.csbsId=?", csbsId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(), mapRowMapper);

        } catch (Exception ex) {
            ex.printStackTrace();
            return maps;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return maps;
        }

    }

    @Override
    public Map<String, Object> forbiddens(String csbsId, String orgName, String stationId, String subburo, String schemeId) {
        Map<String, Object> map = new HashMap<>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        logger.debug("asdsadsa  " + stationId);
        int results = 0;
        String message = "";
        int count = querySCountById(stationId);
        logger.debug("count  " + count);
        try {
            results = getSchemeCountByStationId(stationId);
            if (results <= 1) {
                message = "只有存在一个以上生效的计费方案才可以进行禁用操作";
                map.put("status", 0);
                map.put("message", message);
                return map;
            }
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='03'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='10'  ");
                sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
                );
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", csbsId);
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = csbsOperation(stationId, csbsId, subburo, orgName);
                results = addcsbsOpLog(csbsId, "30", "03", orgName);
            } else {
                results = setCsbsForiddenOrUnForidden(stationId, schemeId, "T");
                results = addcsbsOpLog(csbsId, "30", "10", orgName);
            }


        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (results > 0) {
            if (count > 0) {
                message = "计费模板禁用操作成功，请等待共享人确认";
            } else {
                message = "计费模板禁用设置成功,即时生效";
            }
            map.put("status", 1);
            map.put("message", message);
        } else {

            message = "计费模板禁用操作失败！";
            map.put("status", 2);
            map.put("message", message);
        }

        return map;
    }

    @Override
    public String unForbiddens(String csbsId, String orgName, String stationId, String subburo, String schemeId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String message = "";
        int count = querySCountById(stationId);
        try {
            sql.append(" update ebike.ebike_csbs_info set  ");
            if (count > 0) {
                sql.append(" csbsStatus='04'  ");
                sql.append(" where 1=1 ");
            } else {
                sql.append(" csbsStatus='00'  ");
                sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
                );
                sql.append(" where 1=1 ");
            }
            sql.append(" and csbsId=?", csbsId);
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            if (count > 0) {
                results = csbsOperation(stationId, csbsId, subburo, orgName);
                results = addcsbsOpLog(csbsId, "40", "04", orgName);
            } else {
                results = setCsbsForiddenOrUnForidden(stationId, schemeId, "F");
                results = addcsbsOpLog(csbsId, "40", "00", orgName);
            }
            // results = addcsbsOpLog(csbsId, "30", "03", orgName);
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        if (results > 0) {
            if (count > 0) {
                message = "计费模板解禁操作成功，请等待共享人确认";
            } else {
                message = "计费模板解禁设置成功,即时生效";
            }
        } else {
            message = "计费模板解禁操作失败！";
        }
        return message;
    }

    public int setCsbsForiddenOrUnForidden(String chargestationId, String schemeId, String disabled) {
        logger.debug("updateCsbsInfo  " + schemeId);
        logger.debug("updateCsbsInfo21  " + chargestationId);
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append("update ebike.ebike_cs_bs_rela set  ");
            sql.append(" disabled=?", disabled);
            sql.append(" ,disable_time=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
            );
            sql.append(" where 1=1 ");
            sql.append(" and chargestationId=?", chargestationId);
            sql.append(" and schemeId=? ", schemeId);
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int foriddenConfirm(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            // 更新计费方案操作表
            sql.append(" update ebike.ebike_csbs_info_tbc set ");
            sql.append(" confirmFlag=?", map.get("confirmFlag"));
            sql.append(" ,confirmer=?", map.get("orgName"));
            sql.append(" ,confirmTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
            sql.append(" where 1=1 ");
            sql.append(" and csbsId=?", map.get("csbsId"));
            sql.append(" and stakeholderOrgNo=?", map.get("subburo"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
            results = queryConfirmInfo(map.get("csbsId"), "", "1", map);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    int foriddenOrUnForidden(String csbsId, int confirmFlag2, int confirmFlag3, Map<String, String> map) {
        int results = 0;
        SqlParamsBuilder sql = new SqlParamsBuilder();
        // 更新计费方案关系表
        sql.append(" update  ebike.ebike_csbs_info set ");
        if ("1".equals(map.get("flag"))) {
            if (confirmFlag3 != 0 && confirmFlag2 == 0) {
                // 解禁时如果有一方不同意 在代表此方案无法通过 所以不能生效
                sql.append(" csbsStatus='10' ");

            }
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                // 都同意的话直接修改状态即可
                sql.append(" csbsStatus='00' ");
            }
        } else {
            if (confirmFlag3 != 0 && confirmFlag2 == 0) {
                // 禁用时如果有一方不同意 在代表此方案无法通过 所以不能生效
                sql.append(" csbsStatus='00' ");
            }
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                // 都同意的话直接修改状态即可
                sql.append(" csbsStatus='10' ");
            }
        }
        sql.append(" ,effTime=?", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON)
        );
        sql.append(" where 1=1 ");
        sql.append(" and csbsId=?", csbsId);

        results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());


        if ("1".equals(map.get("flag"))) {
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                // 都同意的话直接修改状态即可
                results = setCsbsForiddenOrUnForidden(map.get("stationId"), map.get("schemeId"), "F");
                results = addcsbsOpLog(csbsId, "41", "00", map.get("orgName"));
            } else {
                results = addcsbsOpLog(csbsId, "42", "10", map.get("orgName"));
            }
        } else {
            if (confirmFlag3 == 0 && confirmFlag2 != 0) {
                // 都同意的话直接修改状态即可
                results = setCsbsForiddenOrUnForidden(map.get("stationId"), map.get("schemeId"), "T");
                results = addcsbsOpLog(csbsId, "31", "10", map.get("orgName"));
            } else {
                results = addcsbsOpLog(csbsId, "32", "00", map.get("orgName"));
            }
        }
        return results;

    }

    public int getSchemeCountByStationId(String stationId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        sql.append(" select count(1)  from ebike.ebike_csbs_info  ");
        sql.append(" where 1=1 and csbsStatus='00' ");
        sql.append(" and chargestationId=?", stationId);
        return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
    }
}
