package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import javax.annotation.Resource;

import com.easesource.commons.util.UuidUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationCostDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

//import cn.cc.cisp.code.util.CodeUtil;
//import cn.yunrui.bikeaccount.dao.StationCostDao;
//import cn.yunrui.bikeaccount.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.UUID;
//import cn.yunrui.common.util.YunRuiDateUtil;

@Repository
public class StationCostImpl extends AbstractEbikeBaseJdbcDao implements StationCostDao {

	@Qualifier("ebikeJdbcTemplate")
	private final JdbcTemplate ebikeJdbcTemplate;

	@Autowired
	public StationCostImpl(JdbcTemplate ebikeJdbcTemplate) {
		this.ebikeJdbcTemplate = ebikeJdbcTemplate;
	}
        private final Logger logger=LoggerFactory.getLogger(getClass());
		@Override
		public List<Map<String, Object>> queryCost(String subburo, Map<String, String> map) {
			List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				 sql.append("  select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status ,b.NAME as SName ,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
				 sql.append(" d.cscsStatus,d.cscsId,e.costUnitPrice,e.costSchemeName,e.costSchemeId,f.costSchemeName as 'newCostSchemeName',f.costUnitPrice  as 'newCostUnitPrice'  ");
				 sql.append(" from cisp_dev.dev_ebikechargestation a ");
				 sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
				 sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID   ");
				 sql.append("   left  join ebike.ebike_cscs_info d on a.ID=d.chargestationId   ");
				 sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId ");
				 sql.append(" left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
				 sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
				 sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
				 sql.append(" and b.STATUS=?",map.get("status"));
				 sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
				 sql.append(" and b.SUBBURO=?",subburo);
				 sql.append(" and d.cscsStatus=? ",map.get("cscsStatus"));
				 sql.append(" and e.costSchemeName like ? ","%"+map.get("costSchemeName")+"%");
				 sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
				 list=ebikeJdbcTemplate.query(sql.getSql(),sql.getParams(),mapRowMapper);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return list;
			}
			return list;
		}
//
		@Override
		public int costCount(String subburo, Map<String, String> map) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{

				 sql.append(" select count(1) from (select count(1) from cisp_dev.dev_ebikechargestation a ");
				 sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
				 sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID   ");
				 sql.append("   left  join ebike.ebike_cscs_info d on a.ID=d.chargestationId   ");
				 sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId ");
				 sql.append(" left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
				 sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
				 sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
				 sql.append(" and b.STATUS=?",map.get("status"));
				 sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
				 sql.append(" and b.SUBBURO=?",subburo);
				 sql.append(" and d.cscsStatus=? ",map.get("cscsStatus"));
				 sql.append("and  e.costSchemeName like ? ","%"+map.get("costSchemeName")+"%");
				 sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID ) g ");
				 return ebikeJdbcTemplate.queryForObject(sql.getSql(),sql.getParams(),Integer.class);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}

		}
//
		@Override
		public boolean updateCscsinfo(String csId,String stationId, String costId,String cscsStatus,String orgName ) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			int results=0;
			int count=querySCountById(stationId);
			try{
				sql.append(" update ebike.ebike_cscs_info set " );
				if(count<=0)
				{
					sql.append(" costSchemeId=?",costId);
					sql.append(" ,cscsStatus='00' ");
				}else{
					if("".equals(cscsStatus))
					{
						sql.append(" newCostSchemeId=?",costId);
						sql.append(" ,cscsStatus='02' ");
					}else{
						if("00".equals(cscsStatus))
						{
							sql.append(" costSchemeId=?",costId);
							sql.append(" ,cscsStatus='00' ");
							sql.append(" ,newCostSchemeId='' ");
						}else{
							sql.append(" cscsStatus='00' ");
							sql.append(" ,newCostSchemeId='' ");
						}

					}
				}
				sql.append(" ,effTime=date_format(?,'%Y-%m-%d %H:%i:%S') ",DateConvertUtils.convertToString(new Date(),DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
				sql.append(" where 1=1 ");
				sql.append(" and cscsId=?",csId);
				results=ebikeJdbcTemplate.update(sql.getSql(),sql.getParams());
				results=updateOpLog(csId,orgName,"20",cscsStatus);
				if(count>0)
				{
					results=csbsOperation(stationId,csId,orgName);
				}else{
					int result=updateCostInfo(costId,stationId);
				}
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return false;
			}
			if(results>0)
			{
				return true;
			}else{
				return false;
			}
		}

		@Override
		public boolean insertCscsInfo(String stationId, String costId,String orgName) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			int results=0;
			int count=querySCountById(stationId);
			String cscsStatus="";
			String costSchemeId="";
			String newCostSchemeId="";
			String uuid=UuidUtils.generateUuidString();
			if(count<=0)
			{
				cscsStatus="00";
				costSchemeId=costId;
			}else{
				cscsStatus="02";
				newCostSchemeId=costId;
			}
			try{
				sql.append(" insert into ebike.ebike_cscs_info(cscsId,chargestationId,cscsStatus,costSchemeId,newCostSchemeId,effTime) " );
				sql.append("values(?,?,?,?,?,?)");
				results=ebikeJdbcTemplate.update(sql.getSql(),
						new Object[]{
								uuid,stationId,cscsStatus,costSchemeId,newCostSchemeId,new Date()
						});
				results=updateOpLog(uuid,orgName,"01",cscsStatus);
				if(count>0)
				{
					results=csbsOperation(stationId,uuid,orgName);
				}
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return false;
			}
			if(results>0)
			{
				return true;
			}else{
				return false;
			}
		}

		public int querySCountById(String stationId)
		{
			SqlParamsBuilder sql = new SqlParamsBuilder();
			int results=0;
			try{
				sql.append(" select count(1) from ebike.ebike_cssh_distscheme  where 1=1 and csshdsStatus='00' " );
				sql.append(" and chargestationId=?",stationId);
				results=ebikeJdbcTemplate.queryForObject(sql.getSql(),sql.getParams(),Integer.class);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
			return results;
		}

		@Override
		public String queryCostCount(String stationId) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			String results="";
			int count=0;
			try{
				sql.append(" select count(1) from ebike.ebike_cscs_info  where 1=1  " );
				sql.append(" and chargestationId=?",stationId);
				count=ebikeJdbcTemplate.queryForObject(sql.getSql(),sql.getParams(),Integer.class);
				if(count>0)
				{
					results=getCscsId(stationId);
				}
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return "";
			}
			return results;
		}
		public String getCscsId(String stationId) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			String results="";
			int count=0;
			try{
				sql.append(" select cscsId from ebike.ebike_cscs_info  where 1=1  " );
				sql.append(" and chargestationId=?",stationId);
				results=ebikeJdbcTemplate.queryForObject(sql.getSql(),sql.getParams(),String.class);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return "";
			}
			return results;
		}
		public int updateOpLog(String cscsId,String orgName,String logType,String status)
		{
			SqlParamsBuilder sql = new SqlParamsBuilder();
			int results=0;
			int count=0;
			try{
				sql.append(" insert into ebike.ebike_log_cscs_info(cscsId,logType,logTime,cscsStatus,operator)");
				sql.append(" values(?,?,?,?,?)");
				results= ebikeJdbcTemplate.update(sql.getSql(),
						new Object[]{
								cscsId,logType,new Date(),status,orgName,
						});

			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
			return results;
		}
		public int addShareConfirm(String stakeholderOrgNo,String uuid,String orgName)
		{
			int results=0;
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				sql.append(" replace into ebike.ebike_cscs_info_tbc(cscsId,stakeholderOrgNo,creator,createTime,confirmFlag) ");
				sql.append(" values(?,?,?,?,?)");
				logger.debug(">>>>>>>>>>>>addShareConfirm<<<<<<<<<<<"+sql.toString());
				results=ebikeJdbcTemplate.update(sql.getSql(),
						new Object[]{
							uuid,stakeholderOrgNo,orgName,new Date(),"0"
						});
				logger.debug(">>>>>>>>>>>>addShareConfirm1<<<<<<<<<<<"+sql.toString());
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
			return results;
		}
//

		public int csbsOperation(String stationId,String uuid,String orgName)
		{
			int results=0;
			SqlParamsBuilder sql = new SqlParamsBuilder();
			List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
			try{
				sql.append(" select stakeholderOrgNo from ebike.ebike_cssh_distscheme where 1=1 and csshdsStatus='00' ");
			    sql.append(" and chargestationId=?",stationId);
			    list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);
			    for(int i=0;i<list.size();i++)
			    {
			    	results=addShareConfirm(list.get(i).get("stakeholderOrgNo").toString(),uuid,orgName);
			    }
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
			return results;
		}
//
		@Override
		public List<Map<String, Object>> costOpInfo(String cscsId) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
			try{
				sql.append(" select a.cscsId,a.logType,a.logTime,b.USER_NAME as 'userName',b.USER_ORG_NAME as 'orgName' ");
				sql.append(" from ebike.ebike_log_cscs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
				sql.append(" and a.cscsId=?",cscsId);
				sql.append(" order by  a.logTime desc ");
				list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return list;
			}
			return list;
		}
//
		@Override
		public int costOpInfoCount(String cscsId) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				sql.append(" select count(1) from ebike.ebike_log_cscs_info a left join cisp_sys.bp_user b on a.operator=b.USER_NO where 1=1 ");
				sql.append(" and a.cscsId=?",cscsId);
				return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(),Integer.class);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
		}
//
		@Override
		public List<Map<String, Object>> queryShareCost(String subburo, Map<String, String> map) {
			List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				 sql.append("  select  a.ID,a.stationNo,a.stationAddr,b.STATUS as status,b.NAME as SName,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo, ");
				 sql.append(" d.cscsStatus,d.cscsId,e.costUnitPrice,e.costSchemeName,e.costSchemeId,f.costSchemeName as 'newCostSchemeName',f.costUnitPrice  as 'newCostUnitPrice'  ");
				 sql.append("  from ebike.ebike_cssh_distscheme g ");
				 sql.append(" left join  cisp_dev.dev_ebikechargestation a on g.chargestationId=a.ID   ");
				 sql.append(" LEFT JOIN ebike.ebike_cscs_info d   on a.ID=d.chargestationId   ");
				 sql.append("   left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
				 sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
				 sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId  ");
				 sql.append("  left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
				 sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
				 sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
				 sql.append(" and b.STATUS=?",map.get("status"));
				 sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
				 sql.append(" and g.stakeholderOrgNo=?",subburo);
				 sql.append(" and d.cscsStatus=? ",map.get("cscsStatus"));
				 sql.append(" e.costSchemeName=? ","%"+map.get("costSchemeName")+"%");
				 sql.append(" and ( g.csshdsStatus='00' or g.csshdsStatus='02') ");
				 sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
				 list=ebikeJdbcTemplate.query(sql.getSql(),sql.getParams(),mapRowMapper);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return list;
			}
			return list;
		}
//
		@Override
		public int queryShareCostCount(String subburo, Map<String, String> map) {
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{

				 sql.append(" select count(1) from (select count(1) from ebike.ebike_cssh_distscheme g ");
				 sql.append(" left join  cisp_dev.dev_ebikechargestation a on g.chargestationId=a.ID   ");
				 sql.append(" LEFT JOIN ebike.ebike_cscs_info d   on a.ID=d.chargestationId   ");
				 sql.append("   left join cisp_dev.dev_powersystemresource b on a.ID=b.ID   ");
				 sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID  ");
				 sql.append(" left join ebike.ebike_costscheme e on d.costSchemeId=e.costSchemeId  ");
				 sql.append("  left join  ebike.ebike_costscheme f on d.newCostSchemeId=f.costSchemeId where 1=1 ");
				 sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
				 sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
				 sql.append(" and b.STATUS=?",map.get("status"));
				 sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
				 sql.append(" and g.stakeholderOrgNo=?",subburo);
				 sql.append(" and ( g.csshdsStatus='00' or g.csshdsStatus='02') ");
				 sql.append(" and d.cscsStatus=? ",map.get("cscsStatus"));
				 sql.append(" e.costSchemeName=? ","%"+map.get("costSchemeName")+"%");
				 sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID ) j ");
				 return ebikeJdbcTemplate.queryForObject(sql.getSql(),sql.getParams(),Integer.class);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}

		}

		@Override
		public boolean yysOpConfirm(String cscsId, String confirmFlag, String subburo, String orgName,String logType) {
			 SqlParamsBuilder sql = new SqlParamsBuilder();
		    int results=0;
		    int confirmFlag1=0;
			int confirmFlag2=0;
			int confirmFlag3=0;
			Map<String, Object> map=null;
		    try{
		    	sql.append(" update ebike.ebike_cscs_info_tbc set ");
		    	sql.append(" confirmFlag=?",confirmFlag);
		    	sql.append(",confirmer=?",orgName);
				sql.append(" ,confirmTime=date_format(?,'%Y-%m-%d %H:%i:%S') ",DateConvertUtils.convertToString(new Date(),DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
		    	sql.append(" where 1=1 ");
		    	sql.append(" and stakeholderOrgNo=?",subburo);
		    	sql.append(" and cscsId=?",cscsId);
		    	results= ebikeJdbcTemplate.update(sql.getSql(),sql.getParams());
				SqlParamsBuilder sql2 = new SqlParamsBuilder();
		    	sql2.append(" select confirmFlag from ebike.ebike_cscs_info_tbc  where 1=1 ");
				sql2.append(" and cscsId=?",cscsId);
				List<Map<String,Object>> list= ebikeJdbcTemplate.query(sql2.getSql(),sql2.getParams(),mapRowMapper);
				for(int i=0;i<list.size();i++)
				{
					if("0".equals(list.get(i).get("confirmFlag").toString()))
					{
						confirmFlag1=confirmFlag1+1;
					}
					if("1".equals(list.get(i).get("confirmFlag").toString()))
					{
						confirmFlag2=confirmFlag2+1;
					}
					if("2".equals(list.get(i).get("confirmFlag").toString()))
					{
						confirmFlag3=confirmFlag3+1;
					}
				}
				String csshdsStatus="";
				if(confirmFlag1==0)
				{
					map=updateCsbcInfo(cscsId,confirmFlag2,confirmFlag3);
					csshdsStatus="00";
				}else{
					csshdsStatus="02";
				}

				results=updateOpLog(cscsId,orgName,logType,csshdsStatus);
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return false;
			}
			if(results>0)
			{
				return true;

			}else{
				return false;
			}
		}
		public Map<String, Object> updateCsbcInfo(String cscsId,int confirmFlag2,int confirmFlag3)
		{
			SqlParamsBuilder sql = new SqlParamsBuilder();
			 Map<String,Object> map=new HashMap<String,Object>();
			 List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
			 try{
				 sql.append(" select costSchemeId,newCostSchemeId,chargestationId from ebike.ebike_cscs_info where 1=1 ");
				 sql.append(" and cscsId=?",cscsId);
				  list= ebikeJdbcTemplate.query(sql.getSql(),sql.getParams(),mapRowMapper);
				 SqlParamsBuilder sql2 = new SqlParamsBuilder();
				  if(confirmFlag2==0&&confirmFlag3!=0)
				  {
					  logger.debug(">>>>>>>>>>>confirmFlag2<<<<<<<<<<<<<<"+confirmFlag2);
					 sql2.append(" update ebike.ebike_cscs_info set newCostSchemeId='',cscsStatus='00' where 1=1  ");
					 sql2.append(" and cscsId=?",cscsId);
					 map.put("csshdsStatus", "00");
					 list.add(map);
				  }else{
					  sql2.append(" update ebike.ebike_cscs_info set newCostSchemeId='',cscsStatus='00'   ");

					  sql2.append(" ,costSchemeId=?",(String) list.get(0).get("newCostSchemeId"));
					  sql2.append(" where 1=1 ");
					  sql2.append(" and cscsId=?",cscsId);
					  map.put("csshdsStatus", "00");
					  list.add(map);
				  }
				  int result=ebikeJdbcTemplate.update(sql2.getSql(),sql2.getParams());
				  if(confirmFlag2!=0&&confirmFlag3==0)
				  {
					  int count=updateCostInfo((String) list.get(0).get("newCostSchemeId"),list.get(0).get("chargestationId").toString());
				  }
			 }catch(Exception ex)
			 {
				 ex.printStackTrace();
				 return map;
			 }
			 return list.get(0);
		}
		public int updateCostInfo(String newCostSchemeId,String stationId )
		{
			SqlParamsBuilder sql = new SqlParamsBuilder();
			try{
				sql.append("update ebike.ebike_cs_cs_rela set  ");
				sql.append(" costSchemeId=?",newCostSchemeId);
				sql.append(" ,effTime=?",DateConvertUtils.convertToString(new Date(),DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
				//sql.append(YunRuiDateUtil.utilDateToString(YunRuiDateUtil.DATEFORMATE_YYMMDDHHMMSS, new Date())," ,effTime=?");
				sql.append(" where 1=1 ");
				sql.append(" and chargestationId=?",stationId);
				return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
			}catch(Exception ex)
			{
				ex.printStackTrace();
				return 0;
			}
		}
}
