package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.StationViewDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

//import cn.cc.cisp.code.util.CodeUtil;
//import cn.yunrui.bikeaccount.dao.StationViewDao;
//import cn.yunrui.bikeaccount.util.ChargeBikeConstant;
//import cn.yunrui.common.util.SqlParaBuffer;
//import cn.yunrui.common.util.YunRuiCommonUtil;

@Repository
public class StationViewDaoImpl  extends AbstractEbikeBaseJdbcDao implements  StationViewDao {
	@Qualifier("ebikeJdbcTemplate")
	private final JdbcTemplate ebikeJdbcTemplate;

	@Autowired
	public StationViewDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
		this.ebikeJdbcTemplate = ebikeJdbcTemplate;
	}
     private final Logger logger=LoggerFactory.getLogger(getClass());
	@Override
	public List<Map<String, Object>> queryCostInfo(String stationId) {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String, Object>> list=new ArrayList<Map<String,Object>>();
		try{
			sql.append(" select a.cscsStatus,b.costSchemeNo,b.costSchemeName,b.costUnitPrice,b.costSchemeId ");
			sql.append(" from ebike.ebike_cscs_info a left join ");
			sql.append(" ebike.ebike_costscheme b on a.costSchemeId=b.costSchemeId where 1=1  ");
			sql.append(" and a.chargestationId=? ",stationId);
			list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);

		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		return list;
	}
//
	@Override
	public List<Map<String, Object>> queryShareStation(String subburo, Map<String, String> map) {
		SqlParamsBuilder sql = new SqlParamsBuilder();
		List<Map<String, Object>> list=new ArrayList<Map<String,Object>>();
		try{
			 sql.append(" select  a.ID,a.stationNo,a.stationAddr,b.STATUS,b.NAME,GROUP_CONCAT(DISTINCT(c.CHARGEDEVICENO) order by c.CHARGEDEVICENO asc) as deviceNo ");
			 sql.append(" ,e.orgoprType,e.orgoprName,e.orgoprCredNo ");
			 sql.append(" , oo.serviceRate AS orgDefServiceRate, ecc.serviceRate AS csServiceRate ");
			 sql.append("  , IFNULL(ecc.serviceRate, IFNULL(oo.serviceRate, 0.0)) AS serviceRate ");
			 sql.append(" from   ebike.ebike_cssh_distscheme  d ");
			 sql.append(" left  join cisp_dev.dev_ebikechargestation a on a.ID=d.chargestationId  ");
			 sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID  ");
			 sql.append(" left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID ");
			 sql.append(" LEFT JOIN ebike.ebike_orgopr oo ON oo.subburo = b.subburo ");
			 sql.append(" LEFT JOIN ebike.ebike_cssr_config ecc ON ecc.chargestationId = a.id  ");
			 sql.append(" left join ebike.ebike_orgopr e on (d.orgoprOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
			 sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
			 sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
			 sql.append(" and b.STATUS=?",map.get("status"));
			 sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
			 sql.append(" and e.orgoprName like ?","%"+map.get("orgName")+"%");
			 sql.append(" and d.stakeholderOrgNo=?",subburo);
			sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
			 sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID  ");
			 list=ebikeJdbcTemplate.query(sql.getSql(),sql.getParams(),
					 new RowMapper<Map<String,Object>>(){
				 public Map<String,Object> mapRow(final ResultSet rs,final int rownum) throws SQLException
				 {
				      Map<String,Object> map=new HashMap<String,Object>();

				      map.put("ID", rs.getLong("ID"));
				      map.put("stationNo", rs.getString("stationNo"));
				      map.put("SName", rs.getString("NAME"));
				      map.put("stationAddr", rs.getString("stationAddr"));
				      map.put("status", rs.getString("STATUS"));
				      map.put("deviceNo", rs.getString("deviceNo"));
				      map.put("orgoprType", rs.getString("orgoprType"));
				      map.put("orgoprName", rs.getString("orgoprName"));
				      map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
				      double csServiceRate=rs.getDouble("csServiceRate");
				      if(String.valueOf(csServiceRate)!=null&&!"".equals(String.valueOf(csServiceRate)))
				      {
				    	  map.put("csServiceRate", csServiceRate);
				      }else if("0".equals(String.valueOf(rs.getDouble("serviceRate")))){
						map.put("csServiceRate", rs.getDouble("serviceRate"));
				      }else{
						map.put("csServiceRate", rs.getDouble("orgDefServiceRate"));
				      }
				      return map;

				 }
			 });
		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		return list;
	}
//
	@Override
	public int queryShareCount(String subburo, Map<String, String> map) {
		SqlParamsBuilder sql = new SqlParamsBuilder();
		try{
			sql.append(" select count(1) from (select count(1) from   ebike.ebike_cssh_distscheme  d ");
			sql.append(" left  join cisp_dev.dev_ebikechargestation a on a.ID=d.chargestationId  ");
			sql.append(" left join cisp_dev.dev_powersystemresource b on a.ID=b.ID  ");
			sql.append("  left join cisp_dev.dev_ebikechargedevice c on a.ID=c.CHARGESTATIONID ");
			sql.append(" left join ebike.ebike_orgopr e on (d.orgoprOrgNo=e.subburo  and d.csshdsStatus!='10') where 1=1  ");
		    sql.append(" and a.stationNo like ? ","%"+map.get("stationNo")+"%");
		    sql.append(" and  b.NAME like ?","%"+map.get("stationName")+"%");
		    sql.append(" and b.STATUS=?",map.get("status"));
		    sql.append(" and c.CHARGEDEVICENO like ?","%"+map.get("deviceNo")+"%");
		    sql.append(" and e.orgoprName like ?","%"+map.get("orgName")+"%");
		    sql.append(" and d.stakeholderOrgNo=?",subburo);
			sql.append(" and ( d.csshdsStatus='00' or d.csshdsStatus='02') ");
		    sql.append(" and b.CLASSNAME='EBikeChargeStation'  GROUP BY a.ID ) g ");
		    return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(),Integer.class);
		}catch(Exception ex)
		{
			ex.printStackTrace();
			return 0;
		}
	}
	@Override
	public List<Map<String, Object>> queryRateModel(String stationId) {
		SqlParamsBuilder sql = new SqlParamsBuilder();
		List<Map<String, Object>> list=new ArrayList<Map<String,Object>>();
		try{
			 sql.append(" select a.csbsId,a.csbsType,a.csbsStatus,a.csbsUsersListId,a.newCsbsUsersListId,a.newSchemeId,a.csbsDesc,b.schemeType,b.schemeId,b.schemeName,b.unitPrice1,b.unitPrice2 ");
			 sql.append(" ,b.unitPrice3,b.minCharge,b.isReturn,a.newCsbsUsersListId ");
			 sql.append("  from ebike.ebike_csbs_info a left join ebike.ebike_billingscheme b on a.schemeId=b.schemeId where 1=1 ");
			 sql.append(" and a.chargestationId=? ",stationId);
			 sql.append(" and csbsStatus !='10' ");
			logger.debug(">>>>>>>>>>>queryRateModel<<<<<<<<<<<<<<"+sql.toString());
			 list=ebikeJdbcTemplate.query(sql.getSql(),sql.getParams(),
					 new RowMapper<Map<String,Object>>(){
				 public Map<String,Object> mapRow(final ResultSet rs,final int rownum) throws SQLException
				 {
					 Map<String,Object> map=new HashMap<String,Object>();
					 map.put("csbsId", rs.getString("csbsId"));
					 map.put("csbsType",rs.getString("csbsType"));
					 map.put("csbsStatus", rs.getString("csbsStatus"));
					 map.put("csbsUsersListId", rs.getString("csbsUsersListId"));
					 map.put("schemeId", rs.getString("schemeId"));
					 map.put("schemeName", rs.getString("schemeName"));
					 map.put("schemeType", rs.getString("schemeType"));
					 map.put("isReturn", rs.getString("isReturn"));
					 map.put("csbsDesc", rs.getString("csbsDesc"));
					 map.put("newCsbsUsersListId", rs.getString("newCsbsUsersListId"));
					 BigDecimal unitPr1 = new BigDecimal(String.valueOf(rs.getDouble("unitPrice1")));
					 BigDecimal unitPr2 = new BigDecimal( String.valueOf(rs.getDouble("unitPrice2")));
					 BigDecimal unitPr3 = new BigDecimal( String.valueOf(rs.getDouble("unitPrice3")));
					 BigDecimal minChar = new BigDecimal(String.valueOf(rs.getDouble("minCharge")));
					 BigDecimal unitPrice1=unitPr1.setScale(4,BigDecimal.ROUND_HALF_UP);
					 BigDecimal unitPrice2=unitPr2.setScale(4,BigDecimal.ROUND_HALF_UP);
					 BigDecimal unitPrice3=unitPr3.setScale(4,BigDecimal.ROUND_HALF_UP);
					 BigDecimal minCharge=minChar.setScale(4,BigDecimal.ROUND_HALF_UP);

					 String dw="";
					 String dh=",";
					 String dj="";
					 if(unitPr2.compareTo(BigDecimal.ZERO)==0&&unitPr3.compareTo(BigDecimal.ZERO)==0&&unitPr1.compareTo(BigDecimal.ZERO)==1)
					 {
						 dw="kWh(度)/元";
						 dj=unitPrice1.toString()+dw;
					  }else
					 {
						 dw="小时/元";
						 dj=unitPrice1.toString()+dw+dh+unitPrice2.toString()+dw+dh+unitPrice3.toString()+dw;
					 }
					 map.put("minCharge", minCharge.toString());
					 map.put("dj", dj);
					 return map;
				 }
			 });
		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		    return list;
	 }
	@Override
	public List<Map<String, Object>> partnerQuery(String stationId) {
		SqlParamsBuilder sql = new SqlParamsBuilder();
		List<Map<String,Object>> list=new ArrayList<Map<String,Object>>();
		try{
			sql.append(" select  b.orgoprType,b.orgoprName,b.orgoprCredNo,b.subburo,a.csshdsStatus,a.incomeRatio,a.costRatio, ");
		    sql.append(" a.csshDistSchemeId from ebike.ebike_cssh_distscheme  a ");
		    sql.append(" left join ebike.ebike_orgopr b on a.stakeholderOrgNo=b.subburo where 1=1  ");
		    sql.append(" and a.chargestationId=? ",stationId);
		    sql.append("  and a.csshdsStatus!='10' ");
		    list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);
		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		return list;

	}
//
	@Override
	public List<Map<String, Object>> querydevInfo(String stationId) {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String, Object>> list=new ArrayList<Map<String,Object>>();
		try{
			sql.append(" select a.ID,a.chargedeviceNo,a.plugCount,a.protocolType from cisp_dev.dev_ebikechargedevice a where 1=1 ");
			sql.append(" and a.chargestationId=? ",stationId);
			list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);

		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		return list;
	}
//
	@Override
	public List<Map<String, Object>> queryMeterInfo(String stationId) {
		 SqlParamsBuilder sql = new SqlParamsBuilder();
		 List<Map<String, Object>> list=new ArrayList<Map<String,Object>>();
		try{
			sql.append(" select a.meterdevice_id,a.meterdevice_no,a.comm_address,a.comm_protocol,c.chargedeviceNo,   ");
			sql.append("  CASE b.is_vaild  WHEN b.is_vaild='0'  THEN '已关联'  else '未关联' END  'is_vaild'  ");
			sql.append(" from ebike.ebike_assets_meterdevice   a  ");
			sql.append(" left join ebike.ebike_cs_mtrdev_rela_his b on a.meterdevice_id=b.meterdevice_id  ");
			sql.append("left join cisp_dev.dev_ebikechargedevice c on c.chargeStationId=b.chargestation_id where 1=1 ");
			sql.append(" and b.chargestation_id=? ",stationId);
			list=ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),mapRowMapper);

		}catch(Exception ex)
		{
			ex.printStackTrace();
			return list;
		}
		return list;
	}
	 
}
