package com.ebike.openservices.oprmgmt.jdbcdao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import javax.annotation.Resource;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.data.jdbc.SqlParamsBuilder;
import com.ebike.openservices.base.dao.AbstractEbikeBaseJdbcDao;
import com.ebike.openservices.oprmgmt.jdbcdao.YysRegisterDao;
import com.ebike.openservices.oprmgmt.util.EbikeCommonUtil;

import com.ebikecharge.openservices.cloudapi.entity.request.OrgoprCertRequest;
import com.ebikecharge.openservices.cloudapi.entity.response.OrgoprCertResponse;
import com.ebikecharge.openservices.cloudapi.service.OrgoprCertService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class YysRegisterDaoImpl extends AbstractEbikeBaseJdbcDao implements YysRegisterDao {

    @Qualifier("ebikeJdbcTemplate")
    private final JdbcTemplate ebikeJdbcTemplate;

    @Autowired
    public YysRegisterDaoImpl(JdbcTemplate ebikeJdbcTemplate) {
        this.ebikeJdbcTemplate = ebikeJdbcTemplate;
    }

    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Resource
    private OrgoprCertService orgoprCertService;

    @Override
    public boolean yysRegister(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String checkResult = "";
        if (map.get("orgoprType").equals("20")) {
            checkResult = "W";
        }
        try {
            sql.append(" insert into ebike.ebike_orgopr_reginfo(orgoprRegId,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,userNo,userName,userPassword,userMobile,bankCardNo,bankBranchLinkNo ");
            sql.append(",regTime,checkResult,verifyResult )");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("orgoprRegId"), map.get("orgoprType"), map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), map.get("userNo"),
                    map.get("userName"), map.get("userPassword"), map.get("userMobile"), map.get("bankCardNo"),
                    map.get("bankBranchLinkNo"), new Date(), checkResult, "W"
                });
            logger.debug(">>>>>>>>>>>yysRegistersds<<<<<<<<<<" + sql.toString());
            if (map.get("orgoprType").equals("20")) {
                OrgoprCertRequest req = new OrgoprCertRequest();
                req.setOrgoprType(map.get("orgoprType"));
                req.setBankBranchLinkNo(map.get("bankBranchLinkNo"));
                req.setBankCardNo(map.get("bankCardNo"));
                req.setOrgoprName(map.get("orgoprName"));
                req.setOrgoprCredNo(map.get("orgoprCredNo"));
                OrgoprCertResponse response = orgoprCertService.verify(req, true);
                results = updateOrgInfo(response.getMsg(), response.getStatus(), map.get("orgoprRegId"));
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    public int updateOrgInfo(String message, int status, String orgoprRegId) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String checkResult = "";
        try {
            if (status == 0) {
                checkResult = "S";
            } else {
                checkResult = "F";
            }
            sql.append(" update ebike.ebike_orgopr_reginfo  set ");
            sql.append(" checkResult=?", checkResult);
            sql.append(" ,checkRemark=?", message);
            if (status != 0) {
                sql.append(",verifyResult='W' ");
                sql.append(" ,verifyTime  =? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
                sql.append(" ,verifyRemark=?", message);
            }
            sql.append(" ,checkTime =? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DASH_AND_COLON));
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", orgoprRegId);
            return ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
    }

    @Override
    public int checkyysExist(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {

            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo where 1=1  ");
            //sql.append(map.get("orgoprType")," and orgoprType=?");
            //sql.append(map.get("orgoprName")," and orgoprName=?");
            sql.append(" and orgoprCredNo=?", map.get("orgoprCredNo"));
            sql.append(" and  verifyResult!='F' ");
            result = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>CheckyysExist<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return result;
    }

    @Override
    public String checkNameExist(String userNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String result = "";
        try {

            sql.append(" select IFNULL(userNo,'N') from ebike.ebike_orgopr_reginfo where 1=1  ");
            sql.append(" and userNo=?", userNo);
            sql.append(" and  verifyResult!='F' ");
            result = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
            logger.debug(">>>>>>>>>>CheckyysExist<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return result;
    }

    @Override
    public List<Map<String, Object>> queryYysInfo(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo ");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  where 1=1 ");
            sql.append(" and a.verifyResult=?", map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", map.get("orgoprType"));
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            }
            sql.append(" and a.orgoprRegId=? ", map.get("orgoprRegId"));
            sql.append(" order by a.regTime desc");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("orgoprRegId", rs.getString("orgoprRegId"));
                        map.put("orgoprType", rs.getString("orgoprType"));
                        map.put("orgoprName", rs.getString("orgoprName"));
                        map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                        map.put("userNo", rs.getString("userNo"));
                        map.put("userName", rs.getString("userName"));
                        map.put("userPassword", rs.getString("userPassword"));
                        map.put("userMobile", rs.getString("userMobile"));
                        map.put("bankCardNo", rs.getString("bankCardNo"));
                        map.put("regTime", rs.getTimestamp("regTime"));
                        map.put("verifyResult", rs.getString("verifyResult"));
                        map.put("bankBranchName", rs.getString("bankBranchName"));
                        map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                        map.put("checkRemark", rs.getString("checkRemark"));
                        map.put("verifyRemark", rs.getString("verifyRemark"));
                        map.put("checkResult", rs.getString("checkResult"));
                        map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));

                        return map;
                    }

                });
            logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryYysCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  where 1=1 ");
            sql.append(" and a.verifyResult=?", map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", map.get("orgoprType"));
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            }
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    @Override
    public List<Map<String, Object>> queryCarRegisterInfo(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo,c.wxPersonalInfo, c.subburo");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo" );
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where 1=1" );
            sql.append(" and a.verifyResult=?", map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", map.get("orgoprType"));
            if ("Y".equals(map.get("isWx"))) {
                sql.append(" and json_extract(c.wxPersonalInfo,'$.openId') is not null ");
            }
            if ("N".equals(map.get("isWx"))) {
                sql.append(" and a.verifyResult != 'W' and json_extract(c.wxPersonalInfo,'$.openId') is null ");
            }
            if (!"".equals(map.get("startDay")) && null != map.get("startDay")) {
                sql.append(" and a.regTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            }
            if (!"".equals(map.get("endDay")) && null != map.get("endDay")) {
                sql.append(" and a.regTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            }
            sql.append(" and a.orgoprRegId=? ", map.get("orgoprRegId"));
            sql.append(" order by a.regTime desc");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("orgoprRegId", rs.getString("orgoprRegId"));
                        map.put("orgoprType", rs.getString("orgoprType"));
                        map.put("orgoprName", rs.getString("orgoprName"));
                        map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                        map.put("userNo", rs.getString("userNo"));
                        map.put("userName", rs.getString("userName"));
                        map.put("userPassword", rs.getString("userPassword"));
                        map.put("userMobile", rs.getString("userMobile"));
                        map.put("bankCardNo", rs.getString("bankCardNo"));
                        map.put("regTime", rs.getTimestamp("regTime"));
                        map.put("verifyResult", rs.getString("verifyResult"));
                        map.put("bankBranchName", rs.getString("bankBranchName"));
                        map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                        map.put("checkRemark", rs.getString("checkRemark"));
                        map.put("verifyRemark", rs.getString("verifyRemark"));
                        map.put("checkResult", rs.getString("checkResult"));
                        map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                        map.put("wxPersonalInfo", rs.getString("wxPersonalInfo"));
                        map.put("subburo", rs.getString("subburo"));
                        return map;
                    }

                });
            logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> queryCarRegisterInfoById(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName,a.bankBranchLinkNo,c.wxPersonalInfo, c.subburo");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo" );
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where a.orgoprRegId = ?", map.get("orgoprRegId"));
            sql.append(" limit 1 ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("orgoprRegId", rs.getString("orgoprRegId"));
                        map.put("orgoprType", rs.getString("orgoprType"));
                        map.put("orgoprName", rs.getString("orgoprName"));
                        map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                        map.put("userNo", rs.getString("userNo"));
                        map.put("userName", rs.getString("userName"));
                        map.put("userPassword", rs.getString("userPassword"));
                        map.put("userMobile", rs.getString("userMobile"));
                        map.put("bankCardNo", rs.getString("bankCardNo"));
                        map.put("regTime", rs.getTimestamp("regTime"));
                        map.put("verifyResult", rs.getString("verifyResult"));
                        map.put("bankBranchName", rs.getString("bankBranchName"));
                        map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                        map.put("checkRemark", rs.getString("checkRemark"));
                        map.put("verifyRemark", rs.getString("verifyRemark"));
                        map.put("checkResult", rs.getString("checkResult"));
                        map.put("bankBranchLinkNo", rs.getString("bankBranchLinkNo"));
                        map.put("wxPersonalInfo", rs.getString("wxPersonalInfo"));
                        map.put("subburo", rs.getString("subburo"));
                        return map;
                    }

                });
            logger.debug(">>>>>>>>>>queryYysInfo<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return list;
        }
        return list;
    }

    @Override
    public int queryCarRegisterCount(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo ");
            sql.append(" left join ebike.ebike_orgopr c on a.orgoprNo = c.subburo where 1=1" );
            sql.append(" and a.verifyResult=?", map.get("AuditingStatus"));
            sql.append(" and a.orgoprType=?", map.get("orgoprType"));
            if ("Y".equals(map.get("isWx"))) {
                sql.append(" and json_extract(c.wxPersonalInfo,'$.openId') is not null ");
            }
            if ("N".equals(map.get("isWx"))) {
                sql.append(" and a.verifyResult != 'W' and json_extract(c.wxPersonalInfo,'$.openId') is null ");
            }
            if (!"".equals(map.get("startDay"))) {
                sql.append(" and a.regTime >= ?", DateConvertUtils.convertFromString(map.get("startDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
            }
            if (!"".equals(map.get("endDay"))) {
                sql.append(" and a.regTime <= ?", EbikeCommonUtil.addDay(DateConvertUtils.convertFromString(map.get("endDay"), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH), 1));
            }
            return ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }

    }

    @Override
    public boolean yysAuditing(Map<String, String> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" update  ebike.ebike_orgopr_reginfo set   ");
            sql.append(" verifyResult=? ", map.get("Confirmflag"));
            sql.append(" ,verifyRemark=?", map.get("verifyRemark"));
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", map.get("orgoprRegId"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean updateYysInfo(Map<String, Object> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String orgoprType = "";
        if (map.get("orgoprType").equals("法人")) {
            orgoprType = "10";
        } else {
            orgoprType = "20";
        }
        try {
            sql.append(" insert into ebike.ebike_orgopr(buro,subburo,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,valid,serviceRate,regTime,effTime ) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("burro"), map.get("burro"), orgoprType, map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), "T",
                    map.get("serviceRate"), map.get("regTime"), new Date()
                });
            boolean result = upOrgRegioInfo(map);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean updateYysInfoForCar(Map<String, Object> map) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        String orgoprType = "";
        if (map.get("orgoprType").equals("法人")) {
            orgoprType = "10";
        } else {
            orgoprType = "20";
        }
        try {
            sql.append(" insert into ebike.ebike_orgopr(buro,subburo,orgoprType,orgoprName ");
            sql.append(" ,orgoprCredNo,orgoprCredAttach,valid,serviceRate,regTime,effTime,wxPersonalInfo ) ");
            sql.append(" values(?,?,?,?,?,?,?,?,?,?,?)");
            results = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("burro"), map.get("burro"), orgoprType, map.get("orgoprName"), map.get("orgoprCredNo"), map.get("orgoprCredAttach"), "T",
                    map.get("serviceRate"), map.get("regTime"), new Date(), map.get("wxPersonalInfo")
                });
            boolean result = upOrgRegioInfo(map);
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public String getUrlById(String id) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        String url = "";
        try {
            sql.append(" select archiveAttach from  ebike.ebike_log_orgacct_withdraw  where 1=1 ");
            sql.append(" and wdapplyId=? ", id);
            url = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), String.class);
        } catch (Exception ex) {
            ex.printStackTrace();
            return url;
        }
        return url;
    }

    @Override
    public Map<String, Object> getOrg() {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select *  from ebike.param_idtable where 1=1  ");
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("keyid", rs.getString("keyid"));
                        map.put("keyvalue", rs.getInt("keyvalue"));
                        return map;
                    }

                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return map;
        }
    }

    @Override
    public int updateOrg(Map<String, Object> omap) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int result = 0;
        try {
            sql.append(" replace into  ebike.param_idtable(keyid,keyvalue) ");
            sql.append("values(?,?)");
            result = ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    omap.get("keyid"), (Integer) omap.get("keyvalue") + 1
                });
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return result;
    }

    @Override
    public Map<String, Object> getModalInfo(String orgoprRegId) {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        SqlParamsBuilder sql = new SqlParamsBuilder();
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            sql.append(" select a.orgoprRegId,a.orgoprType,a.serviceRate,a.orgoprName,a.orgoprCredNo,a.orgoprCredAttach,a.checkResult,a.checkRemark,a.verifyRemark,a.userNo,a.userName,a.userPassword ");
            sql.append(" ,a.userMobile,a.bankCardNo,a.regTime,a.verifyResult,b.bankBranchName ");
            sql.append(" from ebike.ebike_orgopr_reginfo a  ");
            sql.append(" left join ebike.code_bankbranchs b on a.bankBranchLinkNo=b.bankBranchLinkNo  WHERE 1=1  ");

            sql.append(" and a.orgoprRegId=? ", orgoprRegId);
            list = ebikeJdbcTemplate.query(sql.getSql(), sql.getParams(),
                new RowMapper<Map<String, Object>>() {
                    public Map<String, Object> mapRow(final ResultSet rs, final int rowNum) throws SQLException {
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("orgoprRegId", rs.getString("orgoprRegId"));
                        map.put("orgoprType", rs.getString("orgoprType"));
                        map.put("orgoprName", rs.getString("orgoprName"));
                        map.put("orgoprCredNo", rs.getString("orgoprCredNo"));
                        map.put("userNo", rs.getString("userNo"));
                        map.put("userName", rs.getString("userName"));
                        map.put("userPassword", rs.getString("userPassword"));
                        map.put("userMobile", rs.getString("userMobile"));
                        map.put("bankCardNo", rs.getString("bankCardNo"));
                        map.put("regTime", rs.getTimestamp("regTime"));
                        map.put("verifyResult", rs.getString("verifyResult"));
                        map.put("bankBranchName", rs.getString("bankBranchName"));
                        map.put("orgoprCredAttach", rs.getString("orgoprCredAttach"));
                        map.put("checkRemark", rs.getString("checkRemark"));
                        map.put("verifyRemark", rs.getString("verifyRemark"));
                        map.put("checkResult", rs.getString("checkResult"));
                        map.put("serviceRate", rs.getDouble("serviceRate"));
                        return map;
                    }

                });
            logger.debug(">>>>>>>>>>getModalInfo<<<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return map;
        }
        if (list.size() > 0 && list != null) {
            return list.get(0);
        } else {
            return map;
        }
    }

    @Override
    public boolean upOrgRegioInfo(Map<String, Object> maps) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        logger.debug(">>>>>>>>>>>maps<<<<<<<<<<<<<<" + maps);
        try {
            sql.append(" update ebike.ebike_orgopr_reginfo set ");
            sql.append(" verifier=?", (String) maps.get("orgName"));
            sql.append(" ,verifyResult=? ", (String) maps.get("Confirmflag"));
            sql.append(" ,orgoprNo=? ", (String) maps.get("burro"));
            sql.append(" ,verifyRemark=? ", (String) maps.get("verifyRemark"));
            sql.append(" ,verifyTime  =? ", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATETIME_WITHSPR_DOT_AND_COLON));
            if (null !=maps.get("serviceRate") && !"".equals(maps.get("serviceRate"))) {
                sql.append(" ,serviceRate=?", maps.get("serviceRate").toString());
            }
            sql.append(" where 1=1 ");
            sql.append(" and orgoprRegId=?", (String) maps.get("orgoprRegId"));
            results = ebikeJdbcTemplate.update(sql.getSql(), sql.getParams());
        } catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        if (results > 0) {
            return true;
        } else {
            return false;
        }
    }

    @Override
    public int insertSms(Map<String, String> map) {
        logger.debug(" insertSms " + JsonConvertUtils.convertToString(map));
        SqlParamsBuilder sql = new SqlParamsBuilder();
        try {
            sql.append(" insert into ebike.ebike_log_sms ");
            sql.append(" (mobile,operation_type,identify_code,status,create_time)");
            sql.append(" values(?,?,?,?,?) ");
            return ebikeJdbcTemplate.update(sql.getSql(),
                new Object[]{
                    map.get("phone"), "3", map.get("code"), map.get("status"), new Date()
                });
        } catch (Exception ex) {
            return 0;
        }
    }

    @Override
    public int getCode(String vodeValue, String userMobile) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_log_sms  where create_time >= now()-interval 10 minute ");
            sql.append(" and mobile=? ", userMobile);
            sql.append("  and identify_code=? ", vodeValue);
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>>getCode<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

    @Override
    public int checkBankNo(String bankBranchLinkNo, String bankCardNo) {
        SqlParamsBuilder sql = new SqlParamsBuilder();
        int results = 0;
        try {
            sql.append(" select count(1) from ebike.ebike_orgopr_reginfo m where 1=1  ");
//			sql.append(bankBranchLinkNo," and m.bankBranchLinkNo=? ");
            sql.append("  and m.bankCardNo=? ", bankCardNo);
            sql.append(" and m.verifyResult!='F' ");
            results = ebikeJdbcTemplate.queryForObject(sql.getSql(), sql.getParams(), Integer.class);
            logger.debug(">>>>>>>>>>>getCode<<<<<<<<<<" + sql.toString());
        } catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return results;
    }

}
