package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.data.bean.Pager;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.*;
import com.ebike.openservices.oprmgmt.dto.PageResponse;
import com.ebike.openservices.oprmgmt.entity.po.*;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.enums.ErrorCodeEnum;
import com.ebike.openservices.oprmgmt.enums.SuccessCodeEnum;
import com.ebike.openservices.oprmgmt.exception.BizException;
import com.ebike.openservices.oprmgmt.request.*;
import com.ebike.openservices.oprmgmt.service.BillingSchemeSettingService;
import com.ebike.openservices.oprmgmt.util.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/4/15
 */
@Service
public class BillingSchemeSettingServiceImpl extends AbstractEbikeBaseService implements BillingSchemeSettingService {

    /**
     * 1 - 沿用
     */
    private static final Integer IS_INSERT = 1;

    /**
     * 2 - 更新
     */
    private static final Integer IS_UPDATE = 2;

    private final BillingSchemeSettingDao billingSchemeSettingDao;

    private final OperEvChargingStationStakeholderDistInfoDao operEvChargingStationStakeholderDistInfoDao;

    private final OperEvChargingStationBillingInfoDao operEvChargingStationBillingInfoDao;

    private final OperEvChargingStationBillingInfoTbcDao operEvChargingStationBillingInfoTbcDao;

    private final OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao;

    private final OperEvChargingStationBillingUserListDao operEvChargingStationBillingUserListDao;

    private final OperEvChargingStationBillingEvcarListDao operEvChargingStationBillingEvcarListDao;

    @Autowired
    public BillingSchemeSettingServiceImpl(BillingSchemeSettingDao billingSchemeSettingDao,
                                           OperEvChargingStationStakeholderDistInfoDao operEvChargingStationStakeholderDistInfoDao,
                                           OperEvChargingStationBillingInfoDao operEvChargingStationBillingInfoDao,
                                           OperEvChargingStationBillingInfoTbcDao operEvChargingStationBillingInfoTbcDao,
                                           OperEvChargingStationBillingInfoLogDao operEvChargingStationBillingInfoLogDao,
                                           OperEvChargingStationBillingUserListDao operEvChargingStationBillingUserListDao,
                                           OperEvChargingStationBillingEvcarListDao operEvChargingStationBillingEvcarListDao) {
        this.billingSchemeSettingDao = billingSchemeSettingDao;
        this.operEvChargingStationStakeholderDistInfoDao = operEvChargingStationStakeholderDistInfoDao;
        this.operEvChargingStationBillingInfoDao = operEvChargingStationBillingInfoDao;
        this.operEvChargingStationBillingInfoTbcDao = operEvChargingStationBillingInfoTbcDao;
        this.operEvChargingStationBillingInfoLogDao = operEvChargingStationBillingInfoLogDao;
        this.operEvChargingStationBillingUserListDao = operEvChargingStationBillingUserListDao;
        this.operEvChargingStationBillingEvcarListDao = operEvChargingStationBillingEvcarListDao;
    }

    @Override
    public PageResponse<ListSelfSupportChargeStationVO> listSelfSupportChargeStation(ListSelfSupportChargeStationParam param, Pager pager) {
        List<ListSelfSupportChargeStationVO> list = billingSchemeSettingDao.listSelfSupportChargeStation(param, pager);
        long total = billingSchemeSettingDao.listSelfSupportChargeStationTotal(param);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public PageResponse<ListEarningsShareChargeStationVO> listEarningsShareChargeStation(ListEarningsShareChargeStationParam param, Pager pager) {
        List<ListEarningsShareChargeStationVO> list = billingSchemeSettingDao.listEarningsShareChargeStation(param, pager);
        long total = billingSchemeSettingDao.listEarningsShareChargeStationTotal(param);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public UploadTemplateFileVO uploadTemplateFile(UploadTemplateFileParam param) {
        //用户
        final Integer userType = 1;
        //车
        final Integer vehicleType = 2;

        //重复
        List<String> repetition = new LinkedList<>();
        //唯一
        List<String> uniqueness = new LinkedList<>();

        for (List<Object> objects : param.getList()) {
            for (Object object : objects) {
                //判断手机号不为空
                if (ObjectUtils.isNotEmpty(object) && StringUtils.isNotBlank(object.toString())) {
                    //用户（手机号）
                    if (userType.equals(param.getType())) {
                        int count = billingSchemeSettingDao.countOperEvChargingStationBillingUserList(param.getChargingStationId(), object.toString());
                        if (count > 0) {
                            //存在重复
                            repetition.add(object.toString());
                        } else {
                            //不重复
                            uniqueness.add(object.toString());
                        }
                    }
                    //车辆（vin码）
                    if (vehicleType.equals(param.getType())) {
                        int count = billingSchemeSettingDao.countOperEvChargingStationBillingEvcarList(param.getChargingStationId(), object.toString());
                        if (count > 0) {
                            //存在重复
                            repetition.add(object.toString());
                        } else {
                            //不重复
                            uniqueness.add(object.toString());
                        }
                    }
                }
            }
        }
        //第一、二条记录为标题，要删除
        uniqueness.remove(0);
        uniqueness.remove(0);
        if (userType.equals(param.getType())) {
            return UploadTemplateFileVO.builder().uniquenessPhone(uniqueness.stream().distinct().collect(Collectors.toList())).repetitionPhone(repetition.stream().distinct().collect(Collectors.toList())).build().setUniquenessVin(new ArrayList<>()).setRepetitionVin(new ArrayList<>());
        }
        if (vehicleType.equals(param.getType())) {
            return UploadTemplateFileVO.builder().uniquenessVin(uniqueness.stream().distinct().collect(Collectors.toList())).repetitionVin(repetition.stream().distinct().collect(Collectors.toList())).build().setUniquenessPhone(new ArrayList<>()).setRepetitionVin(new ArrayList<>());
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class, noRollbackFor = BizException.class)
    public void insertBillingScheme(InsertBillingSchemeParam param) {
        /*
        * 判断当前选择的计费模板是否在当前电站下已存在，如果是则不能新增
        * */
        OperEvChargingStationBillingInfo o = operEvChargingStationBillingInfoDao.existFromStation(param.getChargingStationId(), param.getBillingTmplId());
        if (ObjectUtils.isNotEmpty(o)) {
            throw new BizException(ErrorCodeEnum.BILLING_SCHEME_ID_ERROR);
        }

        //生成计费方案id
        Long billingTmplId = idGenerator.nextId();
        //生成计费方案用户id
        Long chargingUserId = null;
        //生成计费方案车辆id
        Long chargingVinId = null;

        //上传唯一的用户手机号
        if (CollectionUtils.isNotEmpty(param.getUniquenessUser())) {
            if (ObjectUtils.isEmpty(chargingUserId)) {
                chargingUserId = idGenerator.nextId();
            }
            for (String phone : param.getUniquenessUser()) {
                OperEvChargingStationBillingUserList user = OperEvChargingStationBillingUserList.builder()
                    .id(chargingUserId)
                    .chargingUserMobile(phone)
                    .chargingUserName("")
                    .creator(param.getCreator())
                    .build().defaultField();
                operEvChargingStationBillingUserListDao.insert(user);
            }
        }

        //上传唯一的车辆vin码
        if (CollectionUtils.isNotEmpty(param.getUniquenessCars())) {
            if (ObjectUtils.isEmpty(chargingVinId)) {
                chargingVinId = idGenerator.nextId();
            }
            for (String vin : param.getUniquenessCars()) {
                operEvChargingStationBillingEvcarListDao.insert(OperEvChargingStationBillingEvcarList.builder()
                    .id(chargingVinId)
                    .evcarVinCode(vin)
                    .creator(param.getCreator())
                    .build().defaultField());
            }
        }
        /*
            如果有重复手机号、车辆vin码，若是更新则删除原来的记录 2 - 更新
         */
        if (Objects.equals(param.getUpdateOrInsert(), IS_UPDATE)) {
            //用户手机号
            if (CollectionUtils.isNotEmpty(param.getRepetitionUsers())) {
                if (ObjectUtils.isEmpty(chargingUserId)) {
                    chargingUserId = idGenerator.nextId();
                }
                //删除同一电站下其他计费方案下的手机号
                for (String phone : param.getRepetitionUsers()) {
                    operEvChargingStationBillingUserListDao.deleteChargingStationUser(param.getChargingStationId(), phone);
                }
                for (String phone : param.getRepetitionUsers()) {
                    OperEvChargingStationBillingUserList user = OperEvChargingStationBillingUserList.builder()
                        .id(chargingUserId)
                        .chargingUserMobile(phone)
                        .chargingUserName("")
                        .creator(param.getCreator())
                        .build().defaultField();
                    operEvChargingStationBillingUserListDao.insert(user);
                }
            }
            //车辆vin码
            if (CollectionUtils.isNotEmpty(param.getRepetitionCars())) {
                if (ObjectUtils.isEmpty(chargingVinId)) {
                    chargingVinId = idGenerator.nextId();
                }
                //删除同一电站下其他计费方案下的车辆vin码
                for (String vin : param.getRepetitionCars()) {
                    operEvChargingStationBillingEvcarListDao.deleteChargingStationVin(param.getChargingStationId(), vin);
                }
                for (String vin : param.getRepetitionCars()) {
                    OperEvChargingStationBillingEvcarList car = OperEvChargingStationBillingEvcarList.builder()
                        .id(chargingVinId)
                        .evcarVinCode(vin)
                        .creator(param.getCreator())
                        .build().defaultField();
                    operEvChargingStationBillingEvcarListDao.insert(car);
                }
            }
        }

        //判断当前电站是否有收益共享人
        int count = operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(param.getChargingStationId());
        Integer stationBillingStatus;
        Date effTime = null;
        if (count > 0) {
            //有收益收益共享人，状态为新增待确认
            stationBillingStatus = 2;
        } else {
            //没有则状态为 生效
            stationBillingStatus = 1;
            effTime = new Date();
        }

        //保存计费方案设置
        OperEvChargingStationBillingInfo po = OperEvChargingStationBillingInfo.builder()
            .id(billingTmplId)
            .primaryOrgNo(param.getOrgNo())
            .orgNo(param.getOrgNo())
            .chargingStationId(param.getChargingStationId())
            .stationBillingType(2)
            .stationBillingStatus(stationBillingStatus)
            .stationBillingDesc(param.getStationBillingDesc())
            .billingTmplId(param.getBillingTmplId())
            .stationBillingWhiteUserlistId(chargingUserId)
            .stationBillingWhiteEvcarlistId(chargingVinId)
            .effTime(effTime)
            .creator(param.getCreator())
            .build().defaultField();
        //插入
        operEvChargingStationBillingInfoDao.insertOperEvChargingStationBillingInfo(po);

        //查找当前电站所有的收益共享人
        Map<String, Object> dictParam = new HashMap<>(1);
        dictParam.put("chargingStationId", param.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);

        if (CollectionUtils.isNotEmpty(dictList)) {
            //向计费方案新增待确认表中添加待确认信息 方便共享人以后确认
            for (OperEvChargingStationStakeholderDistInfo info : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder()
                    .id(idGenerator.nextId())
                    .primaryOrgNo(param.getOrgNo())
                    .orgNo(param.getOrgNo())
                    .stationBillingInfoId(billingTmplId)
                    .stakeholderOrgNo(info.getStakeholderOrgNo())
                    .confirmStatus(0)
                    .confirmer("")
                    .creator(param.getCreator())
                    .build().defaultField();
                operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
        }

        //添加操作日志
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
            .id(idGenerator.nextId())
            .primaryOrgNo(param.getOrgNo())
            .orgNo(param.getOrgNo())
            .stationBillingInfoId(po.getId())
            .logType(10)
            .logValue("")
            .stationBillingStatus(2)
            .creator(param.getCreator())
            .build().defaultField();
        operEvChargingStationBillingInfoLogDao.insert(log);

        if (stationBillingStatus == 1) {
            throw new BizException(SuccessCodeEnum.BILLING_SCHEME_ID_SUCCESS);
        }
        if (stationBillingStatus == 2) {
            throw new BizException(SuccessCodeEnum.BILLING_SCHEME_ADD_SHARE_SUCCESS);
        }
    }

    @Override
    public void updateBillingScheme(UpdateBillingSchemeParam param) {
        OperEvChargingStationBillingInfo info = operEvChargingStationBillingInfoDao.selectById(param.getId());
        if (ObjectUtils.isEmpty(info)) {
            throw new BizException(ErrorCodeEnum.ERROR);
        }
        /*
        * 判断当前选择的计费模板是否在当前电站存在，存在不允许添加
        */
        OperEvChargingStationBillingInfo o = operEvChargingStationBillingInfoDao.existFromStation(param.getChargingStationId(), param.getBillingTmplId());
        if (ObjectUtils.isNotEmpty(o)) {
            if (!info.getBillingTmplId().equals(param.getBillingTmplId())) {
                throw new BizException(ErrorCodeEnum.BILLING_SCHEME_ID_ERROR);
            }
        }

        /*
            判断当前计费方案是否有被修改，没有则不修改
         */
        if (info.getBillingTmplId().equals(param.getBillingTmplId())
                && info.getStationBillingDesc().equals(param.getStationBillingDesc())
                && CollectionUtils.isEmpty(param.getRepetitionUsers())
                && CollectionUtils.isEmpty(param.getUniquenessUsers())
                && CollectionUtils.isEmpty(param.getRepetitionCars())
                && CollectionUtils.isEmpty(param.getUniquenessCars())) {
            return;
        }

        //生成计费方案用户id
        Long chargingUserId = null;
        //生成计费方案车辆id
        Long chargingVinId = null;

        //2 - 更新
        if (Objects.equals(param.getUpdateOrInsert(), 2)) {
            if (CollectionUtils.isNotEmpty(param.getRepetitionUsers())) {
                //校验手机号
                for (String phone : param.getRepetitionUsers()) {
                    if (phone.length() != 11) {
                        throw new BizException(ErrorCodeEnum.BILLING_SCHEME_FORMAT_USER_ERROR);
                    }
                }
                if (ObjectUtils.isEmpty(chargingUserId)) {
                    chargingUserId = idGenerator.nextId();
                }
                for (String phone : param.getRepetitionUsers()) {
                    operEvChargingStationBillingUserListDao.deleteChargingStationUser(param.getChargingStationId(), phone);
                }
                for (String phone : param.getRepetitionUsers()) {
                    OperEvChargingStationBillingUserList user = OperEvChargingStationBillingUserList.builder()
                        .id(chargingUserId)
                        .chargingUserMobile(phone)
                        .creator(param.getModifier())
                        .gmtCreate(System.currentTimeMillis())
                        .version(1)
                        .build();
                    ConvertUtils.toEmptyDefaultValue(user);
                    operEvChargingStationBillingUserListDao.insert(user);
                }
            }
            if (CollectionUtils.isNotEmpty(param.getRepetitionCars())) {
                if (ObjectUtils.isEmpty(chargingVinId)) {
                    chargingVinId = idGenerator.nextId();
                }
                for (String vin : param.getRepetitionCars()) {
                    operEvChargingStationBillingEvcarListDao.deleteChargingStationVin(param.getChargingStationId(), vin);
                }
                for (String vin : param.getRepetitionCars()) {
                    OperEvChargingStationBillingEvcarList car = OperEvChargingStationBillingEvcarList.builder()
                        .id(chargingVinId)
                        .evcarVinCode(vin)
                        .creator(param.getModifier())
                        .gmtCreate(System.currentTimeMillis())
                        .version(1)
                        .build();
                    ConvertUtils.toEmptyDefaultValue(car);
                    operEvChargingStationBillingEvcarListDao.insert(car);
                }
            }
        }

        //添加用户列表
        if (CollectionUtils.isNotEmpty(param.getUniquenessUsers())) {
            //校验手机号
            for (String phone : param.getUniquenessUsers()) {
                if (phone.length() != 11) {
                    throw new BizException(ErrorCodeEnum.BILLING_SCHEME_FORMAT_USER_ERROR);
                }
            }
            if (ObjectUtils.isEmpty(chargingUserId)) {
                chargingUserId = idGenerator.nextId();
            }
            for (String phone : param.getUniquenessUsers()) {
                OperEvChargingStationBillingUserList user = OperEvChargingStationBillingUserList.builder()
                    .id(chargingUserId)
                    .chargingUserMobile(phone)
                    .creator(param.getModifier())
                    .gmtCreate(System.currentTimeMillis())
                    .version(1)
                    .build();
                ConvertUtils.toEmptyDefaultValue(user);
                operEvChargingStationBillingUserListDao.insert(user);
            }
        }
        //添加汽车列表
        if (CollectionUtils.isNotEmpty(param.getUniquenessCars())) {
            if (ObjectUtils.isEmpty(chargingVinId)) {
                chargingVinId = idGenerator.nextId();
            }
            for (String vin : param.getUniquenessCars()) {
                OperEvChargingStationBillingEvcarList car = OperEvChargingStationBillingEvcarList.builder()
                    .id(chargingVinId)
                    .evcarVinCode(vin)
                    .creator(param.getModifier())
                    .gmtCreate(System.currentTimeMillis())
                    .version(1)
                    .build();
                ConvertUtils.toEmptyDefaultValue(car);
                operEvChargingStationBillingEvcarListDao.insert(car);
            }
        }

        info.setModifier(param.getModifier());
        info.setGmtModified(System.currentTimeMillis());
        info.setStationBillingDesc(param.getStationBillingDesc());

        //判断当前电站是否有收益共享人
        int count = operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(param.getChargingStationId());
        if (count > 0) {
            //有收益收益共享人，状态为修改待确认
            info.setStationBillingStatus(3);
            info.setNewBillingTmplId(param.getBillingTmplId());
            info.setNewStationBillingWhiteUserlistId(chargingUserId);
            info.setNewStationBillingWhiteEvcarlistId(chargingVinId);
        } else {
            //没有则状态为 生效
            info.setStationBillingStatus(1);
            info.setEffTime(new Date());
            info.setBillingTmplId(param.getBillingTmplId());
            info.setStationBillingWhiteUserlistId(chargingUserId);
            info.setStationBillingWhiteEvcarlistId(chargingVinId);
        }
        operEvChargingStationBillingInfoDao.updateById(info);

        //查找当前电站所有的收益共享人
        Map<String, Object> dictParam = new HashMap<>(2);
        dictParam.put("orgNo", param.getOrgNo());
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);

        if (CollectionUtils.isNotEmpty(dictList)) {
            //向计费方案新增待确认表中添加待确认信息 方便共享人以后确认
            for (OperEvChargingStationStakeholderDistInfo info1 : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder()
                    .id(idGenerator.nextId())
                    .primaryOrgNo(param.getOrgNo())
                    .orgNo(param.getOrgNo())
                    .confirmStatus(0)
                    .stationBillingInfoId(info1.getId())
                    .stakeholderOrgNo(info1.getStakeholderOrgNo())
                    .version(1).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
        }

        //添加操作日志
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
            .id(idGenerator.nextId())
            .primaryOrgNo(param.getOrgNo())
            .orgNo(param.getOrgNo())
            .stationBillingInfoId(info.getId())
            .logType(20)
            .stationBillingStatus(3)
            .creator(param.getModifier())
            .gmtCreate(System.currentTimeMillis())
            .version(1).build();
        ConvertUtils.toEmptyDefaultValue(log);
        operEvChargingStationBillingInfoLogDao.insert(log);

        if (count > 0) {
            throw new BizException(SuccessCodeEnum.BILLING_SCHEME_ADD_SHARE_SUCCESS);
        } else {
            throw new BizException(SuccessCodeEnum.BILLING_SCHEME_ID_SUCCESS);
        }
    }

    @Override
    public int stopBillingScheme(Long id, String orgNo, String userNo) {
        //查找当前计费方案
        OperEvChargingStationBillingInfo info = operEvChargingStationBillingInfoDao.selectById(id);
        if (ObjectUtils.isEmpty(info)) {
            return 400;
        }
        //查找当前电站下有几个已生效计费方案
        int schemeCount = operEvChargingStationBillingInfoDao.countSchemeByStationId(info.getChargingStationId());
        if (schemeCount <= 1) {
            //只有存在一个以上生效的计费方案才可以进行 终止/禁用 操作
            return 400001;
        }
        //查找当前电站是否有收益共享人
        int personCount = operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(info.getChargingStationId());
        if (personCount > 0) {
            info.setStationBillingStatus(4);
        } else {
            info.setStationBillingStatus(9);
            info.setInvalidTime(new Date());
        }
        operEvChargingStationBillingInfoDao.updateById(info);

        //查找当前电站所有的收益共享人
        Map<String, Object> dictParam = new HashMap<>(2);
        dictParam.put("orgNo", orgNo);
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);

        if (CollectionUtils.isNotEmpty(dictList)) {
            //向计费方案新增待确认表中添加待确认信息 方便共享人以后确认
            for (OperEvChargingStationStakeholderDistInfo vo : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder()
                    .id(idGenerator.nextId())
                    .primaryOrgNo(orgNo)
                    .orgNo(orgNo)
                    .confirmStatus(0)
                    .stationBillingInfoId(info.getId())
                    .stakeholderOrgNo(vo.getStakeholderOrgNo())
                    .version(1).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
            //添加操作日志，有收益共享人状态为终止待确认
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
                .id(idGenerator.nextId())
                .primaryOrgNo(orgNo)
                .orgNo(orgNo)
                .stationBillingInfoId(info.getId())
                .logType(30)
                .stationBillingStatus(4)
                .creator(userNo)
                .gmtCreate(System.currentTimeMillis())
                .version(1).build();
            ConvertUtils.toEmptyDefaultValue(log);
            operEvChargingStationBillingInfoLogDao.insert(log);
        } else {
            //添加操作日志，没有收益共享人状态为失效
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
                .id(idGenerator.nextId())
                .primaryOrgNo(orgNo)
                .orgNo(orgNo)
                .stationBillingInfoId(info.getId())
                .logType(30)
                .stationBillingStatus(9)
                .creator(userNo)
                .gmtCreate(System.currentTimeMillis())
                .version(1).build();
            ConvertUtils.toEmptyDefaultValue(log);
            operEvChargingStationBillingInfoLogDao.insert(log);
        }
        if (personCount > 0) {
            return 201;
        } else {
            return 200;
        }
    }

    @Override
    public List<ListSelfSupportChargeStationBillingInfoVO> listSelfSupportChargeStationBillingInfo(Long chargingStationId) {
        List<ListSelfSupportChargeStationBillingInfoVO> list = operEvChargingStationBillingInfoDao.listSelfSupportChargeStationBillingInfo(chargingStationId);
        list.forEach(vo -> {
            StringBuilder stringBuilder = new StringBuilder();
            String string = vo.getBillingDetail();
            JSONObject json = JSONUtil.parseObj(string);

            //计费类型
            String priceRateType = json.getStr("price_rate_type");
            //单一电价
            if ("single".equals(priceRateType)) {
                stringBuilder
                    .append("电度电费").append(json.getStr("price_total")).append("元/kwh")
                    .append("，抄表间隔").append(10).append("分钟");
            }
            //时段电价
            if ("multi".equals(priceRateType) && "1".equals(json.getStr("rate_period_type"))) {
                stringBuilder
                    .append("尖电价").append(json.getStr("price_rate01")).append("元/kwh")
                    .append("，峰电价").append(json.getStr("price_rate02")).append("元/kwh")
                    .append("，平电价").append(json.getStr("price_rate03")).append("元/kwh")
                    .append("，谷电价").append(json.getStr("price_rate04")).append("元/kwh")
                    .append("，服务费").append(json.getStr("price_service")).append("元/kwh")
                    .append("，抄表间隔").append(10).append("分钟");
            }
            //自定义时段电价
            if ("multi".equals(priceRateType) && "2".equals(json.getStr("rate_period_type"))) {
                for (int i = 1; i <= 10; i++) {
                    String index = String.format("%02d", i);
                    String indexOne = String.format("%02d", i + 1);

                    stringBuilder
                        .append(json.getStr("start_value_rate_period" + index)).append("-");

                    //当下一个存在时
                    if (StringUtils.isNotBlank(json.getStr("start_value_rate_period" + indexOne))) {
                        stringBuilder
                            .append(json.getStr("start_value_rate_period" + indexOne));
                    }
                    if (StringUtils.isBlank(json.getStr("start_value_rate_period" + indexOne))) {
                        stringBuilder
                            .append("24:00");
                        stringBuilder
                            .append(" ").append(json.getStr("price_rate" + index)).append("元/kwh ");
                        break;
                    }

                    stringBuilder
                        .append(" ").append(json.getStr("price_rate" + index)).append("元/kwh ");
                }
                stringBuilder
                    .append("，服务费").append(json.getStr("price_service")).append("元/kwh")
                    .append("，抄表间隔").append(10).append("分钟");
            }
            vo.setBillingDetail(stringBuilder.toString());
        });
        return list;
    }

    @Override
    public PageResponse listChargingStationBillingUser(Long id, Pager pager) {
        List<Map<String, Object>> list = operEvChargingStationBillingInfoDao.listChargingStationBillingUser(id, pager);
        if (CollectionUtils.isNotEmpty(list)) {
            if (ObjectUtils.isEmpty(list.get(0))) {
                list.remove(0);
            }
        }
        long total = operEvChargingStationBillingInfoDao.countChargingStationBillingUserTotal(id);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public PageResponse listChargingStationBillingUserAfter(Long id, Pager pager) {
        List<Map<String, Object>> list = operEvChargingStationBillingInfoDao.listChargingStationBillingUserAfter(id, pager);
        if (CollectionUtils.isNotEmpty(list)) {
            if (ObjectUtils.isEmpty(list.get(0))) {
                list.remove(0);
            }
        }
        long total = operEvChargingStationBillingInfoDao.countChargingStationBillingUserAfterTotal(id);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public PageResponse listChargingStationBillingCar(Long id, Pager pager) {
        List<Map<String, Object>> list = operEvChargingStationBillingInfoDao.listChargingStationBillingCar(id, pager);
        if (CollectionUtils.isNotEmpty(list)) {
            if (ObjectUtils.isEmpty(list.get(0))) {
                list.remove(0);
            }
        }
        long total = operEvChargingStationBillingInfoDao.countChargingStationBillingCarTotal(id);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public PageResponse listChargingStationBillingCarAfter(Long id, Pager pager) {
        List<Map<String, Object>> list = operEvChargingStationBillingInfoDao.listChargingStationBillingCarAfter(id, pager);
        if (CollectionUtils.isNotEmpty(list)) {
            if (ObjectUtils.isEmpty(list.get(0))) {
                list.remove(0);
            }
        }
        long total = operEvChargingStationBillingInfoDao.countChargingStationBillingCarAfterTotal(id);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public PageResponse<ListChargingStationBillingInfoLogVO> listChargingStationBillingInfoLog(Long stationBillingInfoId, Pager pager) {
        List<ListChargingStationBillingInfoLogVO> list = operEvChargingStationBillingInfoLogDao.listChargingStationBillingInfoLog(stationBillingInfoId, pager);
        long total = operEvChargingStationBillingInfoLogDao.countChargingStationBillingInfoLogTotal(stationBillingInfoId);
        return PageResponse.of(list, pager.getPageNumber(), pager.getPageSize(), total);
    }

    @Override
    public void isAgreeBillingScheme(IsAgreeBillingSchemeParam param) {
        OperEvChargingStationBillingInfo info = operEvChargingStationBillingInfoDao.selectById(param.getStationBillingInfoId());
        param.setGmtModified(System.currentTimeMillis());
        param.setConfirmTime(new Date());
        //更新计费方案待确认信息状态（利益相关方）
        int count = operEvChargingStationBillingInfoTbcDao.isAgreeBillingScheme(param);
        if (count <= 0) {
            return;
        }
        //日志类型
        Integer logType = null;
        /*
        * 新增一条操作日志
        */
        //2 - 新增待确认
        if (Integer.valueOf(2).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 11 : 12;
        }
        //3 - 修改待确认
        if (Integer.valueOf(3).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 21 : 22;
        }
        //4 - 终止待确认
        if (Integer.valueOf(4).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 31 : 32;
        }
        //5 - 恢复待确认
        if (Integer.valueOf(5).equals(info.getStationBillingStatus())) {
            logType = Integer.valueOf(1).equals(param.getConfirmStatus()) ? 41 : 42;
        }
        OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
            .id(idGenerator.nextId())
            .primaryOrgNo(param.getStakeholderOrgNo())
            .orgNo(param.getStakeholderOrgNo())
            .stationBillingInfoId(param.getStationBillingInfoId())
            .logType(logType)
            .stationBillingStatus(1)
            .creator(param.getUserNo())
            .gmtCreate(System.currentTimeMillis())
            .version(1).build();
        ConvertUtils.toEmptyDefaultValue(log);
        operEvChargingStationBillingInfoLogDao.insert(log);

        boolean flag = true;
        //待确认
        boolean toBeConfirmed = false;
        //查找所有的收益共享人是否确认信息
        List<OperEvChargingStationBillingInfoTbc> tbcList = operEvChargingStationBillingInfoTbcDao.selectList(param.getStationBillingInfoId());
        if (CollectionUtils.isNotEmpty(tbcList)) {
            for (OperEvChargingStationBillingInfoTbc tbc : tbcList) {
                if (Integer.valueOf(0).equals(tbc.getConfirmStatus())) {
                    flag = false;
                    toBeConfirmed = true;
                }
                if (Integer.valueOf(2).equals(tbc.getConfirmStatus())) {
                    flag = false;
                }
            }
        }

        //通过
        if (flag) {
            info.setStationBillingStatus(1);
            info.setEffTime(new Date());
            //3 - 修改待确认
            if (Integer.valueOf(3).equals(info.getStationBillingStatus())) {
                info.setBillingTmplId(info.getNewBillingTmplId());
                info.setNewBillingTmplId(null);
                info.setStationBillingWhiteUserlistId(info.getNewStationBillingWhiteUserlistId());
                info.setNewStationBillingWhiteUserlistId(null);
                info.setStationBillingWhiteEvcarlistId(info.getNewStationBillingWhiteEvcarlistId());
                info.setNewStationBillingWhiteEvcarlistId(null);
            }
            operEvChargingStationBillingInfoDao.updateById(info);
        }

        //不通过，如果有不通过将设置失效
        if (!flag && !toBeConfirmed) {
            info.setStationBillingStatus(9);
            info.setInvalidTime(new Date());
            operEvChargingStationBillingInfoDao.updateById(info);
        }
    }

    @Override
    public int liftABanBillingScheme(Long id, String orgNo, String userNo) {
        //查找当前计费方案
        OperEvChargingStationBillingInfo info = operEvChargingStationBillingInfoDao.selectById(id);
        if (ObjectUtils.isEmpty(info)) {
            return 400;
        }
        //查找当前电站是否有收益共享人
        int personCount = operEvChargingStationStakeholderDistInfoDao.countEarningsSharePersonByStationId(info.getChargingStationId());
        if (personCount > 0) {
            info.setStationBillingStatus(5);
        } else {
            info.setStationBillingStatus(1);
            info.setEffTime(new Date());
        }
        operEvChargingStationBillingInfoDao.updateById(info);

        //查找当前电站所有的收益共享人
        Map<String, Object> dictParam = new HashMap<>(2);
        dictParam.put("orgNo", orgNo);
        dictParam.put("chargingStationId", info.getChargingStationId());
        List<OperEvChargingStationStakeholderDistInfo> dictList = operEvChargingStationStakeholderDistInfoDao.selectList(dictParam);

        if (CollectionUtils.isNotEmpty(dictList)) {
            //向计费方案新增待确认表中添加待确认信息 方便共享人以后确认
            for (OperEvChargingStationStakeholderDistInfo vo : dictList) {
                OperEvChargingStationBillingInfoTbc tbc = OperEvChargingStationBillingInfoTbc.builder()
                    .id(idGenerator.nextId())
                    .primaryOrgNo(orgNo)
                    .orgNo(orgNo)
                    .confirmStatus(0)
                    .stationBillingInfoId(info.getId())
                    .stakeholderOrgNo(vo.getStakeholderOrgNo())
                    .version(1).build();
                ConvertUtils.toEmptyDefaultValue(tbc);
                operEvChargingStationBillingInfoTbcDao.insert(tbc);
            }
            //添加操作日志，有收益共享人状态为终止待确认
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
                .id(idGenerator.nextId())
                .primaryOrgNo(orgNo)
                .orgNo(orgNo)
                .stationBillingInfoId(info.getId())
                .logType(40)
                .stationBillingStatus(5)
                .creator(userNo)
                .gmtCreate(System.currentTimeMillis())
                .version(1).build();
            ConvertUtils.toEmptyDefaultValue(log);
            operEvChargingStationBillingInfoLogDao.insert(log);
        } else {
            //添加操作日志，没有收益共享人状态为失效
            OperEvChargingStationBillingInfoLog log = OperEvChargingStationBillingInfoLog.builder()
                .id(idGenerator.nextId())
                .primaryOrgNo(orgNo)
                .orgNo(orgNo)
                .stationBillingInfoId(info.getId())
                .logType(40)
                .stationBillingStatus(1)
                .creator(userNo)
                .gmtCreate(System.currentTimeMillis())
                .version(1).build();
            ConvertUtils.toEmptyDefaultValue(log);
            operEvChargingStationBillingInfoLogDao.insert(log);
        }
        if (personCount > 0) {
            return 201;
        } else {
            return 200;
        }
    }

}
