package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ebike.openservices.oprmgmt.dao.CarRegisterCheckServiceDao;
import com.ebike.openservices.oprmgmt.entity.CarRegisterExamineVo;
import com.ebike.openservices.oprmgmt.entity.OpenIdVo;
import com.ebike.openservices.oprmgmt.service.CarRegisterCheckService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author liumu
 * @date 2021/4/16 16:22
 * 汽车充电桩-运营商注册审核
 */
@Service
public class CarRegisterCheckServiceImpl implements CarRegisterCheckService {

    @Resource
    private CarRegisterCheckServiceDao carRegisterCheckServiceDao;

    @Override
    public List<OpenIdVo> queryOpenidByPhone(String phone) {
        return carRegisterCheckServiceDao.selectOpenidByPhone(phone);
    }

    @Override
    public String queryOpenIdNameByOpenId(String openId) {
        return carRegisterCheckServiceDao.selectOpenIdNameByOpenId(openId);
    }

//    @Override
//    @Transactional(rollbackFor = {RuntimeException.class, Error.class})
//    public void examineRegister(CarRegisterExamineVo bean) {
//        if("S".equals(bean.getVerifyResult())){
//            //审核通过，添加运营商档案
//            carRegisterCheckServiceDao.insertEbikeOrgopr(bean);
//        }
//        //修改运营商注册信息的审核状态和运营商编号
//        carRegisterCheckServiceDao.updateEbikeOrgoprReginfo(
//            bean.getVerifyResult(),
//            bean.getExplain(),
//            bean.getOrgoprNo(),
//            bean.getVerifier(),
//            bean.getOrgoprRegId());
//    }

    @Override
    public void updateOpenId(String id, String isWx,String openId,String openIdName) {
        //取出openId（Json）
        String jsonStr = carRegisterCheckServiceDao.selectOpenId(id);
        if("Y".equals(isWx)){
            jsonStr = JSONUtil.parseObj(jsonStr).set("openId",openId).set("openIdName",openIdName).toString();
        }else{
            //删除openId和openIdName
            JSONObject jsonObject = new JSONObject(jsonStr);
            jsonObject.remove("openId");
            jsonObject.remove("openIdName");
            jsonStr = jsonObject.toString();
        }
        carRegisterCheckServiceDao.updateOpenId(id,jsonStr);
    }

}
