package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.lang.Dict;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.dao.CardAuditDao;
import com.ebike.openservices.oprmgmt.entity.po.CardCustomPurchaseApplyRelacs;
import com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo;
import com.ebike.openservices.oprmgmt.request.CardAuditRequest;
import com.ebike.openservices.oprmgmt.service.CardAuditService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * @param
 * @ClassName CardAuditServiceImpl
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/7/14 16:34
 * @Version 1.0
 **/
@Service
public class CardAuditServiceImpl implements CardAuditService {

    @Resource
    private CardAuditDao cardAuditDao;
    /***
     * @Description TODO  充电卡审核查询
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo>
     * @data 2021/7/14
     * @param request
     */
    @Override
    public Map<String,Object> listCard(CardAuditRequest request) {
        Sorter sorter = new Sorter();
        Pager pager = new Pager();
        pager.setPageNumber(request.getCurrent());
        pager.setPageSize(10);
        Integer totalPage = cardAuditDao.getTotalPage(request);
        List<CardAuditVo> auditVoList = cardAuditDao.listCard(request,sorter,pager);
        // 判断  如果充电卡审核状态是 待审核  则去编码表取工本费  审核状态;0 - 待审核；1 - 审核通过；2 - 审核退回；3 - 审核拒绝；
        auditVoList.forEach(cardAuditVo -> {
            if(cardAuditVo.getAuditStatus()==0){
                cardAuditVo.setOperation("审核");
                //工本费
                BigDecimal purchaseApplyCardCost = cardAuditDao.getPurchaseApplyCardCost();
                cardAuditVo.setPurchaseApplyCardCost(purchaseApplyCardCost);
                //购卡数量
                BigDecimal purchaseApplyCardCount = new BigDecimal(Integer.parseInt(cardAuditVo.getPurchaseApplyCardCount().toString()));
                //计算总价
                BigDecimal purchaseApplyTotalMoney = purchaseApplyCardCost.multiply(purchaseApplyCardCount);
                cardAuditVo.setPurchaseApplyTotalMoney(purchaseApplyTotalMoney);
                cardAuditDao.updateCard(purchaseApplyCardCost,purchaseApplyTotalMoney,cardAuditVo.getId());
            }else {
                cardAuditVo.setOperation("查看");
            }
        });
        Map<String,Object> map = Dict.create()
            .set("auditVoList",auditVoList)
            .set("totalPage",totalPage);
        return map;
    }

    /***
     * @Description TODO  根据id查询充电卡
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.CardAuditVo
     * @data 2021/7/14
     * @param id
     */
    @Override
    public CardAuditVo getCardById(Long id) {
        return cardAuditDao.getCardById(id);
    }

    /***
     * @Description TODO  更新审核状态
     * @author zhouyi
     * @return int
     * @data 2021/7/15
     * @param auditStatus
     * @param auditDesc
     * @param id
     */
    @Override
    public String updateAuditStatus(Integer auditStatus, String auditDesc, Long id) {
        int count = cardAuditDao.updateAuditStatus(auditStatus,auditDesc,id);
        String msg = null;
        if(count > 0){
            msg = "更新成功";
        }else {
            msg = "更新失败";
        }
        return msg;
    }

}
