package com.ebike.openservices.oprmgmt.service.impl;

import com.ebike.openservices.oprmgmt.dao.CardDao;
import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyEntity;
import com.ebike.openservices.oprmgmt.entity.CardAcctWithdrawApplyVo;
import com.ebike.openservices.oprmgmt.entity.CardServiceRateDto;
import com.ebike.openservices.oprmgmt.entity.CardServiceRateVo;
import com.ebike.openservices.oprmgmt.service.CardService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author liumu
 * @date 2021-07-15 10:41
 */
@Service
public class CardServiceImpl implements CardService {

    @Resource
    private CardDao cardDao;


    @Override
    public List<CardAcctWithdrawApplyVo> queryWithApply(String orgNo,
                                                        String cardId,
                                                        String phone,
                                                        String startDate,
                                                        String endDate,
                                                        Integer page,
                                                        Integer size) {
        //前端只传页码翻页，计算limit x,y的x和y值
        page = (page == null) ? 0 : page - 1;//x,前端页码从1开始
        size = (size == null) ? 10 : size; //y
        page = page * size; // x
        return cardDao.selectWithApply(orgNo,cardId, phone,startDate, endDate, page, size);
    }

    @Override
    public Integer queryWithApplyCount(String orgNo,String cardId, String phone,String startDate, String endDate) {
        return cardDao.selectWithApplyCount(orgNo,cardId, phone,startDate, endDate);
    }

    @Override
    public CardAcctWithdrawApplyEntity queryWithdrawApplyById(Long id) {
        return cardDao.selectWithdrawApplyById(id);
    }

    @Override
    public void updateWithdrawStatus(CardAcctWithdrawApplyEntity bean) {
        cardDao.updateWithdrawStatus(bean);
    }

    @Override
    public List<CardServiceRateVo> queryCardServiceRate(String subburo,Integer page,Integer size) {
        //前端只传页码翻页，计算limit x,y的x和y值
        page = (page == null) ? 0 : page - 1;//x,前端页码从1开始
        size = (size == null) ? 10 : size; //y
        page = page * size; // x
        List<CardServiceRateVo> rateList = cardDao.selectCardServiceRate(subburo,page,size);
        return  rateList;
    }

    @Override
    public Integer queryCardServiceRateCount() {
        return cardDao.selectCardServiceRateCount();
    }

    @Override
    public void updateCardServiceRate(CardServiceRateDto param) {
        List<String> subburoList = param.getSubburoList();
        String rate = param.getRate();
        subburoList.forEach(subburo ->{
            cardDao.updateCardServiceRate(subburo,rate);
        });
    }

}
