package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.oprmgmt.jdbcdao.ChargeRevDao;
import com.ebike.openservices.oprmgmt.jdbcdao.InShareDao;
import com.ebike.openservices.oprmgmt.service.ChargeBikeRevenueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class ChargeBikeRevenueServiceImpl implements ChargeBikeRevenueService {



	private final ChargeRevDao revdao;

	@Autowired
	public ChargeBikeRevenueServiceImpl(ChargeRevDao revdao) {
		this.revdao = revdao;
	}
	@Override
	public List<Map<String,String>> getstakeholderList(String subbro){
		return revdao.getstakeholderList(subbro);
	}

	@Override
	public List<Map<String,Object>> getRevenueInMeter(String subbro,Map<String,String> map )
	{
		return revdao.getRevenueInMeter(subbro, map);
	}
	@Override
	public int getRevenueCount(String subbro,Map<String,String> map)
	{
		return revdao.getRevenueCount(subbro, map);
	}

	@Override
	public List<Map<String,Object>> queryShareData(String subbro,Map<String,String> map )
	{
		return revdao.queryShareData(subbro, map);
	}

	@Override
	public int queryShareCount(String subbro,Map<String,String> map)
	{
		return revdao.queryShareCount(subbro, map);
	}

	@Override
	public Map<String, Object> getAccount(String subbro, Map<String, String> map)
	{
		return revdao.getAccount(subbro,map);

	}
	@Override
	public Map<String, Object> getSumInfo(String subbro, Map<String, String> map)
    {
		return revdao.getSumInfo(subbro, map);
	}
	@Override
	public Map<String, Object> getShareProfit(String subbro, Map<String, String> map)
	{
		return revdao.getShareProfit(subbro, map);
	}
	@Override
	public List<Map<String,Object>> queryRefundData(String subburo,Map<String,String> map)
	{
		return revdao.queryRefundData(subburo, map);
	}
	@Override
	public int queryRefundCount(String subburo,Map<String,String> map)
	{
		return revdao.queryRefundCount(subburo, map);
	}

	@Override
	public List<Map<String,Object>> queryShareRefundData(String subburo,Map<String,String> map)
	{
		return revdao.queryShareRefundData(subburo, map);
	}
	@Override
	public int queryShareRefundCount(String subburo,Map<String,String> map)
	{
		return revdao.queryShareRefundCount(subburo, map);
	}
	@Override
	public Map<String,Object> getRefundTotal(String subburo,Map<String,String> map)
	{
		return revdao.getRefundTotal(subburo, map);
	}
	@Override
	public Map<String,Object> getShareRefundTotal(String subburo,Map<String,String> map)
	{
		return revdao.getShareRefundTotal(subburo, map);
	}
	@Override
	public Map<String,Object> getShareAccount(String subburo,Map<String,String> map)
	{
		return revdao.getShareAccount(subburo, map);
	}

	//营收统计初始化
	@Override
	public List<Map<String,Object>> queryRevenueCountInMeter(String subbro,Map<String,String> map )
	{
		return revdao.queryRevenueCountInMeter(subbro, map);
	}
	//营收统计初始化
	@Override
	public int getQueryRevenueCount(String subbro,Map<String,String> map)
	{
		return revdao.getQueryRevenueCount(subbro, map);
	}
	//分享营收统计初始化
	@Override
	public List<Map<String,Object>> queryShareStatistics(String subbro,Map<String,String> map )
	{
		return revdao.queryShareStatistics(subbro, map);
	}
	//fenxiang 营收统计初始化
	@Override
	public int queryShareStatisticsCount(String subbro,Map<String,String> map)
	{
		return revdao.queryShareStatisticsCount(subbro, map);
	}
	@Override
	public List<Map<String,Object>> queryDeviceRevenue(String subburo,Map<String,String> map)
	{
		return revdao.queryDeviceRevenue(subburo, map);
	}
	@Override
	public List<Map<String,Object>> queryShareDeviceRevenue(String subburo,Map<String,String> map)
	{
		return revdao.queryShareDeviceRevenue(subburo, map);
	}
	@Override
	public List<Map<String,Object>> stationTrend(String id,String dateFlag,String startDay,String endDay)
	{
		return revdao.stationTrend(id, dateFlag, startDay, endDay);
	}
	@Override
	public List<Map<String,Object>> devTrend(String id,String dateFlag,String startDay,String endDay)
	{
		return revdao.devTrend(id, dateFlag, startDay, endDay);
	}
	//退款统计初始化
	@Override
	public List<Map<String,Object>> queryRefundSticInit(String subbro,Map<String,String> map )
	{
		return revdao.queryRefundSticInit(subbro, map);
	}
	//退款统计初始化
	@Override
	public int queryRefundSticInitCount(String subbro,Map<String,String> map)
	{
		return revdao.queryRefundSticInitCount(subbro, map);
	}
    //分享电站
	@Override
	public List<Map<String,Object>> queryShareRefundStic(String subbro,Map<String,String> map )
	{
		return revdao.queryShareRefundStic(subbro, map);
	}
	//分享电站
	@Override
	public int shareRefundSticCount(String subbro,Map<String,String> map)
	{
		return revdao.shareRefundSticCount(subbro, map);
	}
}
