package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.oprmgmt.jdbcdao.ChargeBikePileDao;
import com.ebike.openservices.oprmgmt.service.ChargePileMtcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class ChargePileMtcServiceImpl implements ChargePileMtcService {



	private final ChargeBikePileDao chargeBikePileDao;

	@Autowired
	public ChargePileMtcServiceImpl(ChargeBikePileDao chargeBikePileDao) {
		this.chargeBikePileDao = chargeBikePileDao;
	}
	@Override
	public String topOrgToEmpty(String orgNo){
		return chargeBikePileDao.topOrgToEmpty(orgNo);
	}
	@Override
	public List<Map<String,Object>> getChargePileData(String subburo, Map<String,String> map, int start, int limit)
	{
		return chargeBikePileDao.getChargePileData(subburo, map, start, limit);
	}
	@Override
	public int  getChargePileCount(String subburo, Map<String,String> map)
	{
		return chargeBikePileDao.getChargePileCount(subburo, map);
	}
	@Override
	public List<Map<String,Object>> getOppersonList(Map<String,String> map, int start, int limit)
	{
		return chargeBikePileDao.getOppersonList(map, start, limit);

	}
	@Override
	public int  getChargeOppersonCount( Map<String,String> map){
		return chargeBikePileDao.getChargeOppersonCount(map);

	}
	@Override
	public boolean checkOppersonExist(String oppersonMobile){
		return chargeBikePileDao.checkOppersonExist(oppersonMobile);

	}
	@Override
	public boolean saveChargeOpperson(String uuid,String subburo,String oppersonName, String oppersonMobile,String name)
	{

		return chargeBikePileDao.saveChargeOpperson(uuid, subburo,oppersonName, oppersonMobile,name);
	}
	@Override
	public boolean updateOpperson(String oppserId,String subburo,String oppersonName, String oppersonMobile,String name)
	{

		return chargeBikePileDao.updateOpperson(oppserId, subburo,oppersonName, oppersonMobile,name);
	}
	@Override
	public boolean checkOppersonById(String ids)
	{
		return chargeBikePileDao.checkOppersonById(ids);
	}
	@Override
	public boolean delOpperson(String ids)
	{
		return chargeBikePileDao.delOpperson(ids);
	}

}
