package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import com.ebike.openservices.oprmgmt.dao.PowerStationSafeguardDao;
import com.ebike.openservices.oprmgmt.dao.EbikeStationDao;
import com.ebike.openservices.oprmgmt.entity.StationEntity;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeBikeStationDao;
import com.ebike.openservices.oprmgmt.service.ChargeStationMtcService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


@Service
public class ChargeStationMtcServiceImpl implements ChargeStationMtcService {


    private final ChargeBikeStationDao csDao;

    private final EbikeStationDao esDao;

    @Autowired
    public ChargeStationMtcServiceImpl(ChargeBikeStationDao csDao, EbikeStationDao esDao) {
        this.csDao = csDao;
        this.esDao = esDao;
    }

    @Override
    public List<Map<String, Object>> queryStation(String subbro, Map<String, String> map, int start) {

        return csDao.queryStation(subbro, map, start);
    }

    @Override
    public int getChargeStationCount(String subburoNo, Map<String, String> map) {
        return csDao.getChargeStationCount(subburoNo, map);
    }

    @Override
    public boolean deleteStation(Long id) {
        return esDao.deleteStation(id);
    }

    @Override
    public boolean checkStationNoExist(String stationNo, String subburoNo) {
        return csDao.checkStationNoExist(stationNo, subburoNo);
    }

    @Override
    public boolean checkResult(String id) {
        return csDao.checkResult(id);
    }

    @Override
    public boolean deleteRela(String ids) {
        return csDao.deleteRela(ids);
    }

    @Override
    public Map<String, Object> getSchemeNameById(String id) {
        return csDao.getSchemeNameById(id);
    }

    @Override
    public List<Map<String, Object>> getStationFwfData(Map<String, String> map) {
        return csDao.getStationFwfData(map);
    }

    @Override
    public int getStationFwfCount(Map<String, String> map) {
        return csDao.getStationFwfCount(map);
    }

    @Override
    public boolean fwfAdd(String stationId, String stationfwf, String minServiceMoney) {
        return csDao.fwfAdd(stationId, stationfwf, minServiceMoney);

    }

    @Override
    public List<Map<String, Object>> getOrgList() {
        return csDao.getOrgList();
    }


    @Override
    public boolean addStation(StationEntity stationEntity) {
        return esDao.addStation(stationEntity);
    }

    @Override
    public boolean addPowerSystem(StationEntity stationEntity) {
        return esDao.addPowerSystem(stationEntity);
    }


    @Override
    public boolean modifyStation(StationEntity stationEntity) {
        return esDao.modifyStation(stationEntity);
    }

    @Override
    public boolean modifyPowerSystem(StationEntity stationEntity) {
        return esDao.modifyPowerSystem(stationEntity);
    }

    @Override
    public Map<String, Object> getStationInfoById(Long id) {
        return esDao.getStationInfoById(id);
    }

}
