package com.ebike.openservices.oprmgmt.service.impl;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeTrendDao;
import com.ebike.openservices.oprmgmt.service.ChargeTrendService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;


@Service
public class ChargeTrendServiceImpl extends AbstractEbikeBaseService implements ChargeTrendService {

    private final  ChargeTrendDao trendDao;

    @Autowired
    public ChargeTrendServiceImpl(ChargeTrendDao trendDao) {
        this.trendDao = trendDao;
    }
     @Override
     public List<Map<String,Object>> getTrendData(String subburo, String dateFlag,String startDay,String endDay,String sRange,String flag)
     {
    	 return trendDao.getTrendData(subburo,dateFlag, startDay, endDay, sRange,flag);
     }
     @Override
     public List<Map<String,Object>> getStationInfo(String subburo,String stationNo,String stationName,String devNo,String flag)
     {
    	 return trendDao.getStationInfo(subburo, stationNo, stationName, devNo,flag);
     }
     @Override
     public int getStationCount(String subburo,String stationNo,String stationName,String devNo)
     {
    	 return trendDao.getStationCount(subburo, stationNo, stationName, devNo);
     }
     @Override
     public List<Map<String,Object>> getDeviceInfo(String id)
     {
    	 return trendDao.getDeviceInfo(id);
     }


     public List<Map<String,Object>> stationTrend(String id,String dateFlag,String startDay,String endDay)
     {
    	 return trendDao.stationTrend(id, dateFlag, startDay, endDay);
     }
    @Override
     public List<Map<String,Object>> devTrend(String id,String dateFlag,String startDay,String endDay)
     {
    	 return trendDao.devTrend(id, dateFlag, startDay, endDay);
     }
     @Override
     public List<Map<String,Object>> getChargePrinceList(String subburo,String flag)
     {
    	 return trendDao.getChargePrinceList(subburo, flag);
     }
     @Override
     public List<Map<String,Object>> getCityList(int level, String parentid,String flag,String subburo)
 	 {
 		return trendDao.getCityList(level, parentid,flag,subburo);
 	 }

    @Override
    public List<Map<String, Object>> getCountyList(int level, String parentid, String flag, String subburo) {
        return trendDao.getCountyList(level, parentid,flag,subburo);
    }
}
