package com.ebike.openservices.oprmgmt.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.oprmgmt.jdbcdao.ChargeFlszDao;
import com.ebike.openservices.oprmgmt.service.ChargeflszService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;



@Service
public class ChargeflszServiceImpl implements ChargeflszService {


	private final ChargeFlszDao flszDao;

	@Autowired
	public ChargeflszServiceImpl(ChargeFlszDao flszDao) {
		this.flszDao = flszDao;
	}
	@Override
	public List<Map<String,Object>> querySchemInfo(String subburo, Map<String,String> map, int start )
	{
		return flszDao.querySchemInfo(subburo, map, start);
	}
	@Override
	public int  querySchemCount(String subburo, Map<String,String> map){

		return flszDao.querySchemCount(subburo, map);
	}
	@Override
	public List<Map<String,Object>> selectSchemInfo(String subburo, Map<String,String> map, int start )
	{
		return flszDao.selectSchemInfo(subburo, map, start);
	}
	@Override
	public int  selectSchemCount(String subburo, Map<String,String> map){

		return flszDao.selectSchemCount(subburo, map);
	}

	@Override
	public List<Map<String,Object>> queryBathInfos(String subburo, Map<String,String> map, int start )
	{
		return flszDao.queryBathInfos(subburo, map, start);
	}
   /***
    * @Description TODO 汽车批量方案设置查询
    * @author zhouyi
    * @return java.util.List<java.util.Map<java.lang.String,java.lang.Object>>
    * @data 2021/8/3
    * @param subburo
    * @param map
    * @param start
    */
    @Override
    public List<Map<String, Object>> queryBathCarInfos(String subburo, Map<String, String> map, int start) {
        return flszDao.queryBathCarInfos(subburo, map, start);
    }

    @Override
	public int  queryBathCount(String subburo, Map<String,String> map){

		return flszDao.queryBathCount(subburo, map);
	}

    @Override
    public int queryBathCarCount(String subburo, Map<String, String> map) {
        return flszDao.queryBathCarCount(subburo, map);
    }

    @Override
	public boolean deleteflMode(String ids)
	{
		return flszDao.deleteflMode(ids);
	}
	@Override
	public Map<String,Object> getflModeDataById(String id)
	{
		return flszDao.getflModeDataById(id);
	}

	@Override
	public boolean modifyScheme(Map<String,String> map,String subburo,String orgName)
	{
		return flszDao.modifyScheme(map,subburo,orgName);
	}
	@Override
	public boolean addScheme(Map<String,String> map,String subburo,String orgName)
	{
		return flszDao.addScheme(map,subburo,orgName);
	}
	@Override
	public boolean updateFl(String id,String schemeNo,String subburo,String schemeName,String schemeType,String isReturn,double unitPrice1,double unitPrice2,double unitPrice3,double dj,double minimumCharge,String name)
	{
		return flszDao.updateFl(id, schemeNo, subburo, schemeName, schemeType,isReturn, unitPrice1, unitPrice2, unitPrice3, dj, minimumCharge,name);
	}

	//电站费率维护列表
	@Override
	public List<Map<String,Object>> queryStationflList(String subburo, Map<String,String> map, int start, int limit )
	{
		return flszDao.queryStationflList(subburo, map, start, limit);
	}
	//电站维护数量
	@Override
	public int  getChargeStationflCount(String subburo, Map<String,String> map){

		return flszDao.getChargeStationflCount(subburo, map);
	}
	@Override
	public String getbh(String subburo, String schemeType){
		return flszDao.getbh(subburo, schemeType);
	}
	@Override
	public boolean addflsz(String schemeId,String stationId)
	{

		return flszDao.addflsz( schemeId, stationId);
	}

	@Override
	public boolean checkSchemeId(String schemeId)
	{
		return flszDao.checkSchemeId(schemeId);
	}
	@Override
	public List<Map<String,Object>> queryChargeflList(String subburo, Map<String,String> map, int start, int limit )
	{
		return flszDao.queryChargeflList(subburo, map, start, limit);
	}
	@Override
    public int  getflCount(String subburo, Map<String,String> map){

		return flszDao.getflCount(subburo, map);
	}
    //电价成本设置
//    public List<Map<String,String>> getChargeCostList(String subbro)
//    {
//    	return flszDao.getChargeCostList(subbro);
//    }
    //电站电价成本列表
	@Override
    public List<Map<String,Object>> queryStationCostList(String subburo, Map<String,String> map, int start, int limit)
    {
    	return flszDao.queryStationCostList(subburo, map, start, limit);
    }
    //电价成本条数
	@Override
    public int getStationCostCount(String subburo, Map<String,String> map)
    {
    	return flszDao.getStationCostCount(subburo, map);
    }

	@Override
    public List<Map<String,Object>> queryCostList(String subburo, Map<String,String> map)
    {
    	return flszDao.queryCostList(subburo, map);
    }
    //电价成本条数
	@Override
    public int getCostCount(String subburo, Map<String,String> map)
    {
    	return flszDao.getCostCount(subburo, map);
    }
    //电价成本编号
	@Override
    public String getCostbh(String subburo){
		return flszDao.getCostbh(subburo);
	}

    //像电站添加点击成本模板
	@Override
    public boolean addStationCost(String costSchemeId,String stationId)
	{

		return flszDao.addStationCost( costSchemeId, stationId);
	}
	@Override
    public boolean updateCost(String id,String costSchemeNo,String subburo,String costSchemeName,double costUnitPrice,String name)
	{
		return flszDao.updateCost(id, costSchemeNo, subburo, costSchemeName, costUnitPrice, name);
	}
	@Override
	public boolean insertCost(String id,String costSchemeNo,String subburo,String costSchemeName,double costUnitPrice,String name)
	{
		return flszDao.insertCost(id, costSchemeNo, subburo, costSchemeName, costUnitPrice, name);
	}
	@Override
	public boolean checkCostExist(String costSchemeId){
		return flszDao.checkCostExist(costSchemeId);
	}
	@Override
	public boolean delCost(String costSchemeId){
		return flszDao.delCost(costSchemeId);
	}

	//像电站添加计费模板时 先删除
	@Override
	public boolean deleteflById(String ids)
	{
		return flszDao.deleteflById(ids);
	}
	@Override
	public boolean checkNoExist(String schNo,String subburo)
	{
		return flszDao.checkNoExist(schNo,subburo);
	}
	@Override
	public boolean checkCostNoExist(String costNo,String subburo)
	{
		return flszDao.checkCostNoExist(costNo,subburo);
	}

	@Override
	public boolean  addCost(String uuid,String stationId,String orgName)
	{
		return flszDao.addCost(uuid, stationId,orgName);
	}
	@Override
	public boolean addCsbsInfo(String uuid,String schemeId,String stationId,String orgName)
	{
		return flszDao.addCsbsInfo(uuid, schemeId, stationId,orgName);
	}
	@Override
	public Map<String,Object> getSchemeInfoById(String id)
	{
		return flszDao.getSchemeInfoById(id);
	}

	@Override
	public int modifyStationScheme(String schemeId,String stationIds)
	{
		return flszDao.modifyStationScheme(schemeId,stationIds);
	}

    @Override
    public int modifyCarStationScheme(String schemeId, String stationIds) {
        return flszDao.modifyCarStationScheme(schemeId,stationIds);
    }

    @Override
	public int updateScheInfo(String schemeId,String stationIds)
	{
		return flszDao.updateScheInfo(schemeId,stationIds);
	}
}
