package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.ebike.openservices.base.service.util.CurveUtil;
import com.ebike.openservices.oprmgmt.dao.ChargingTrendAnalysisCarDao;
import com.ebike.openservices.oprmgmt.entity.vo.ChargingTrendAnalysisCarVo;
import com.ebike.openservices.oprmgmt.request.ChargingTrendAnalysisCarRequest;
import com.ebike.openservices.oprmgmt.service.ChargingTrendAnalysisCarService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ChargingTrendAnalysisCarServiceImpl implements ChargingTrendAnalysisCarService {

    @Resource
    private ChargingTrendAnalysisCarDao chargingTrendAnalysisCarDao;

    @Override
    public List<ChargingTrendAnalysisCarVo> getChargingStationNameList(ChargingTrendAnalysisCarRequest request) {
        String adCode = request.getAdcode();
        if (StrUtil.isNotBlank(adCode)) {
            while (adCode.endsWith("0")) {
                adCode = adCode.substring(0, adCode.length() - 1);
            }
        }
        request.setAdcode(adCode);
        return chargingTrendAnalysisCarDao.getChargingStationNameList(request);
    }

    /**
     * 获取有电站的汽车省份
     */
    @Override
    public List<Map<String, Object>> getChargePrinceCarList(String orgNo) {
        List<Map<String, Object>> resultList = Lists.newArrayList();
        List<Map<String, Object>> nameList = chargingTrendAnalysisCarDao.getChargePrinceCarList(orgNo);
        Map<String, Object> map;
        for (Map<String, Object> objectMap : nameList) {
            map = Maps.newHashMap();
            map.put("id", objectMap.get("id").toString());
            map.put("name", objectMap.get("name").toString());
            resultList.add(map);
        }
        return resultList;
    }

    @Override
    public Map<String, Object> getChargingTrendAnalysisCarCure(ChargingTrendAnalysisCarRequest request) {
        String dateType = request.getDateType();
        Map<String, Object> result = Maps.newHashMap();
        switch (dateType) {
            case "0":
                List<ChargingTrendAnalysisCarVo> listCure = chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureDayAndMonth(request);
                DateTime startTime = DateUtil.parse(request.getStartTime());
                DateTime endTime = DateUtil.parse(request.getEndTime());
                List<String> labels = CurveUtil.getDatesBetweenTwoDateFormat(startTime, endTime);
                result = getChargingTrendAnalysisCarDay(listCure, labels);
                result.put("labels", labels);
                return result;
            case "1":
                List<ChargingTrendAnalysisCarVo> monthList = chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureDayAndMonth(request);
                int year = Integer.parseInt(request.getDateStat().substring(0, 4));
                int month = Integer.parseInt(request.getDateStat().substring(5, 7));
                List<String> monthLabels = CurveUtil.getMonthFullDay(year, month);
                result = getChargingTrendAnalysisCarDay(monthList, monthLabels);
                result.put("labels", CurveUtil.getMonthFullDayForDay(year, month));
                return result;
            case "2":
                List<ChargingTrendAnalysisCarVo> yearList = chargingTrendAnalysisCarDao.getChargingTrendAnalysisCarCureYear(request);
                int yearDate = Integer.parseInt(request.getDateStat());
                List<String> yearLabels = CurveUtil.getMonthsByYear(yearDate);
                result = getChargingTrendAnalysisCarDay(yearList, yearLabels);
                result.put("labels", CurveUtil.getMonthsByYearForMonth(yearDate));
                return result;
        }
        return result;
    }

    private static Map<String, Object> getChargingTrendAnalysisCarDay(List<ChargingTrendAnalysisCarVo> list, List<String> labels) {
        try {
            Map<String, Object> map = new HashMap<>();
            //充电次数
            List<Integer> chargeCntList = new ArrayList<>();
            //充电收入
            List<String> chargeIncomeList = new ArrayList<>();
            //充电枪个数
            List<Integer> plugPtsCntList = new ArrayList<>();
            //利用率
            List<String> chargeUseRatioList = new ArrayList<>();

            if (list != null) {
                if (list.size() > 0) {
                    int index = 0;
                    for (int k = 0; k < labels.size(); k++) {
                        if (!list.get(index).getDateStat().equals(labels.get(k))) {
                            chargeCntList.add(null);
                            chargeIncomeList.add(null);
                            plugPtsCntList.add(null);
                            chargeUseRatioList.add(null);
                        } else {
                            chargeCntList.add(list.get(index).getChargeCnt());
                            chargeIncomeList.add(list.get(index).getChargeIncome());
                            plugPtsCntList.add(list.get(index).getPlugPtsCnt());
                            chargeUseRatioList.add(list.get(index).getChargeUseRatio());
                            index++;
                        }
                        //下标如果和list大小相等时，break，否则数组越界
                        if (index == list.size()) {
                            break;
                        }
                    }
                    int differenceDays = labels.size() - chargeCntList.size();
                    int chargeIncomeDays = labels.size() - chargeIncomeList.size();
                    int plugPtsCntDays = labels.size() - plugPtsCntList.size();
                    int chargeUseRatioDays = labels.size() - chargeUseRatioList.size();
                    for (int j = 0; j < differenceDays; j++) {
                        chargeCntList.add(null);
                    }
                    for (int a = 0; a < chargeIncomeDays; a++) {
                        chargeIncomeList.add(null);
                    }
                    for (int b = 0; b < plugPtsCntDays; b++) {
                        plugPtsCntList.add(null);
                    }
                    for (int a = 0; a < chargeUseRatioDays; a++) {
                        chargeUseRatioList.add(null);
                    }
                }
            }
            map.put("chargeCntList", chargeCntList);
            map.put("chargeIncomeList", chargeIncomeList);
            map.put("plugPtsCntList", plugPtsCntList);
            map.put("chargeUseRatioList", chargeUseRatioList);
            return map;
        } catch (Exception e) {
            e.printStackTrace();
        }

        return null;
    }
}
