package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.dao.DisasterPreventionDao;
import com.ebike.openservices.oprmgmt.dao.EbikeChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.dao.EbikeLogChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.entity.DisasterPreventionVo;
import com.ebike.openservices.oprmgmt.entity.EbikeChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.entity.EbikeLogChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.request.DisasterSetUpRequest;
import com.ebike.openservices.oprmgmt.service.DisasterPreventionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 防灾应急
 * @author liu
 */
@Service
public class DisasterPreventionServiceImpl implements DisasterPreventionService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final DisasterPreventionDao disasterPreventionDao;
    private final EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao;
    private final EbikeLogChargeDeviceExtparamDao ebikeLogChargeDeviceExtparamDao;

    @Autowired
    public DisasterPreventionServiceImpl(DisasterPreventionDao disasterPreventionDao, EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao, EbikeLogChargeDeviceExtparamDao ebikeLogChargeDeviceExtparamDao) {
        this.disasterPreventionDao = disasterPreventionDao;
        this.ebikeChargeDeviceExtparamDao = ebikeChargeDeviceExtparamDao;
        this.ebikeLogChargeDeviceExtparamDao = ebikeLogChargeDeviceExtparamDao;
    }

    @Override
    public List<DisasterPreventionVo> getDisasterPreventionList(Map params, Sorter sorter, Pager pager) {
        if(logger.isDebugEnabled()) {
            logger.debug("params00 : " + params);
        }
        return disasterPreventionDao.getList(params,sorter,pager);
    }

    @Override
    public int getDisasterPreventionCount(Map params) {
        if(logger.isDebugEnabled()) {
            logger.debug("params01 : " + params);
        }
        return disasterPreventionDao.getCount(params);
    }

    @Override
    public List<EbikeLogChargeDeviceExtparamDo> getLogList(Map params, Sorter sorter, Pager pager) {
        return ebikeLogChargeDeviceExtparamDao.getList(params, sorter, pager);
    }

    @Override
    public int getLogCount(Map params) {
        return ebikeLogChargeDeviceExtparamDao.getCount(params);
    }

    @Override
    public int setUpDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequestList) {
        int result = 0;
        for(DisasterSetUpRequest disasterSetUpRequest : disasterSetUpRequestList) {
            Long chargedeviceId = Long.parseLong(disasterSetUpRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            EbikeLogChargeDeviceExtparamDo ebikeLogChargeDeviceExtparamDo = new EbikeLogChargeDeviceExtparamDo();
            ebikeLogChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeLogChargeDeviceExtparamDo.setLogType("100");
            ebikeLogChargeDeviceExtparamDo.setLogRemark(disasterSetUpRequest.getLogRemark());
            ebikeLogChargeDeviceExtparamDo.setOperator(disasterSetUpRequest.getOperator());
            ebikeLogChargeDeviceExtparamDo.setOperatorMobile(disasterSetUpRequest.getOperatorMobile());
            ebikeLogChargeDeviceExtparamDo.setOperateTime(DateConvertUtils.convertToString(new Date(), "yyyy-MM-dd HH:mm:ss"));
            if(logger.isDebugEnabled()) {
                logger.debug("ebikeLogChargeDeviceExtparamDos : " + ebikeLogChargeDeviceExtparamDo);
            }
            ebikeLogChargeDeviceExtparamDao.insert(ebikeLogChargeDeviceExtparamDo);

            if(ebikeChargeDeviceExtparamDo != null && ebikeChargeDeviceExtparamDo.getChargedeviceId() > 0L) {
                // 更新
                ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setEmerExecDesc(disasterSetUpRequest.getEmerExecDesc());
                ebikeChargeDeviceExtparamDo.setEmerExecTime(new Date());
                ebikeChargeDeviceExtparamDo.setEmerExecutor(disasterSetUpRequest.getEmerExecutor());
                ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
            }else {
                // 新增
                ebikeChargeDeviceExtparamDo = new EbikeChargeDeviceExtparamDo();
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
                ebikeChargeDeviceExtparamDo.setEmerExecDesc(disasterSetUpRequest.getEmerExecDesc());
                ebikeChargeDeviceExtparamDo.setEmerExecTime(new Date());
                ebikeChargeDeviceExtparamDo.setEmerExecutor(disasterSetUpRequest.getEmerExecutor());
                ebikeChargeDeviceExtparamDo.setLampStatus("00");
                ebikeChargeDeviceExtparamDao.insert(ebikeChargeDeviceExtparamDo);
            }
        }

        return result;
    }

    @Override
    public int removeDisasterPrevention(List<DisasterSetUpRequest> disasterSetUpRequestList) {
        int result = 0;
        for(DisasterSetUpRequest disasterSetUpRequest : disasterSetUpRequestList) {
            Long chargedeviceId = Long.parseLong(disasterSetUpRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            if(logger.isDebugEnabled()) {
                logger.debug("ebikeChargeDeviceExtparamDo0    : " + ebikeChargeDeviceExtparamDo);
            }
            //EbikeLogChargeDeviceExtparamDo ebikeLogChargeDeviceExtparamDo = ebikeLogChargeDeviceExtparamDao.get(chargedeviceId);
            EbikeLogChargeDeviceExtparamDo ebikeLogChargeDeviceExtparamDo = new EbikeLogChargeDeviceExtparamDo();
            ebikeLogChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
            ebikeLogChargeDeviceExtparamDo.setLogType("101");
            ebikeLogChargeDeviceExtparamDo.setLogRemark(disasterSetUpRequest.getLogRemark());
            ebikeLogChargeDeviceExtparamDo.setOperator(disasterSetUpRequest.getOperator());
            ebikeLogChargeDeviceExtparamDo.setOperatorMobile(disasterSetUpRequest.getOperatorMobile());
            ebikeLogChargeDeviceExtparamDo.setOperateTime(DateConvertUtils.convertToString(new Date(), "yyyy-MM-dd HH:mm:ss"));
            if(logger.isDebugEnabled()) {
                logger.debug("ebikeLogChargeDeviceExtparamDo1 : " + ebikeLogChargeDeviceExtparamDo);
            }
            ebikeLogChargeDeviceExtparamDao.insert(ebikeLogChargeDeviceExtparamDo);
            if(ebikeChargeDeviceExtparamDo != null && ebikeChargeDeviceExtparamDo.getChargedeviceId() > 0L) {
                // 更新
                ebikeChargeDeviceExtparamDo.setEmerStatus(disasterSetUpRequest.getEmerStatus());
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setEmerRemover(disasterSetUpRequest.getEmerRemover());
                ebikeChargeDeviceExtparamDo.setEmerStatus("00");
                ebikeChargeDeviceExtparamDo.setEmerRemoveTime(new Date());
                ebikeChargeDeviceExtparamDo.setEmerRemoveDesc(disasterSetUpRequest.getEmerRemoveDesc());
                ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
            }
        }
        return result;
    }

    @Override
    public int getChangeOrderCount(String stationId) {
        return disasterPreventionDao.getChangeOrderCount(stationId);
    }

    @Override
    public int getCheckCode(String codeValue, String userMobile) {
        if(logger.isDebugEnabled()) {
            logger.debug("getcodeValueService : " + codeValue);
            logger.debug("getCheckCodeService : " + userMobile);
        }
        return disasterPreventionDao.getCheckCode(codeValue, userMobile);
    }

    @Override
    public int updateCodeStatus(String codeValue) {
        return disasterPreventionDao.updateCodeStatus(codeValue);
    }

    @Override
    public int insertSms(Map<String, String> map) {
        return disasterPreventionDao.insertSms(map);
    }

    @Override
    public Map<String, Object> getUserMobileByUserNo(String userNo) {
        return disasterPreventionDao.getUserMobileByUserNo(userNo);
    }

    @Override
    public List<Map<String, Object>> getProvinceList() {
        return disasterPreventionDao.getProvinceList();
    }

    @Override
    public List<Map<String, Object>> getCityList(String level, String parentid) {
        return disasterPreventionDao.getCityList(level, parentid);
    }

    @Override
    public List<Map<String, Object>> getDistrictList(String level, String parentid) {
        return disasterPreventionDao.getDistrictList(level, parentid);
    }


}
