package com.ebike.openservices.oprmgmt.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.dao.EbikeMainDao;
import com.ebike.openservices.oprmgmt.entity.ModalVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgDayVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgMonthVo;
import com.ebike.openservices.oprmgmt.entity.StatPowerOrgYear;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainChargingPileInfoVo;
import com.ebike.openservices.oprmgmt.entity.vo.EbikeMainOrderInfoVo;
import com.ebike.openservices.oprmgmt.service.EbikeMainService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author Liu
 * @date 2019-04-22
 */
@Service
public class EbikeMainServiceImpl extends AbstractEbikeBaseService implements EbikeMainService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final EbikeMainDao ebikeMainDao;

    @Autowired
    public EbikeMainServiceImpl(EbikeMainDao ebikeMainDao) {
        this.ebikeMainDao = ebikeMainDao;
    }

    @Override
    public List<Map<String, Object>> getDqcdjl(Map<String, Object> params) {
        return ebikeMainDao.getDqcdjl(params);
    }

    @Override
    public Map<String, Object> getChargeOrderInfo(Map<String, Object> params) {
        Map<String, Object> result = Maps.newHashMap();
        //今日充电中的次数（自行车）
        Integer chargingCount = ebikeMainDao.getChargingCount(params);
        //今日充电中的次数（汽车）
        Integer chargingCarCount = ebikeMainDao.getChargingCarCount(params);
        //今日已完成的次数（自行车）
        Integer finishCount = ebikeMainDao.getFinishCount(params);
        //今日已完成的次数（汽车）
        Integer finishCarCount = ebikeMainDao.getFinishCarCount(params);
        List<EbikeMainOrderInfoVo> dqcdjl2 = ebikeMainDao.getDqcdjl2(params);
        result.put("chargingCount", chargingCount);
        result.put("chargingCarCount", chargingCarCount);
        result.put("finishCount", finishCount);
        result.put("finishCarCount", finishCarCount);
        result.put("list", dqcdjl2);
        return result;
    }

    @Override
    public Map<String, Object> getZs(Map<String, Object> params) {
        if (logger.isDebugEnabled()) {
            logger.debug("getZs : ", ebikeMainDao.getZs(params));
        }
        return ebikeMainDao.getZs(params);
    }

    @Override
    public List<Map<String, Object>> getYs(Map<String, Object> params) {
        if (logger.isDebugEnabled()) {
            logger.debug("getYs : ", ebikeMainDao.getYs(params));
        }
        return ebikeMainDao.getYs(params);
    }

    @Override
    public Map<String, String> getQgCdzb(Map<String, Object> m) {
        Map<String, String> re = Maps.newHashMap();
        List<Map<String, String>> zblist = ebikeMainDao.getQgCdzb(m);
        if (zblist.size() != 0) {
            for (Map<String, String> zb : zblist) {
                re.put(zb.get("code"), zb.get("zbz"));
            }
        }
        return re;
    }

    @Override
    public Map<String, Object> getCdqs(Map<String, Object> m, int[] x, String type) {
        Map<String, Object> reM = Maps.newHashMap();
        String year = DateConvertUtils.convertToString(DateUtils.addDays(new Date(), -1), DateConvertUtils.PATTERN_YEAR);
        m.put("year", year);
        List<Map<String, Object>> relist = ebikeMainDao.getCdqs(m);
        List<Map<String, Object>> relist1 = ebikeMainDao.getCdqsCar(m);

        Calendar cal = Calendar.getInstance();

        int month = cal.get(Calendar.MONTH) + 1;
        int day = cal.get(Calendar.DATE);
        //数据处理（自行车）
        String[] cdcs = new String[x.length];
        String[] cdys = new String[x.length];
        //数据处理（汽车）
        String[] cdcsCar = new String[x.length];
        String[] cdysCar = new String[x.length];
        for (int k = 0; k < cdcs.length; k++) {
            if ("month".equals(type)) {
                if ((k + 1) > day) {
                    cdcs[k] = "";
                    cdys[k] = "";
                } else {
                    cdcs[k] = "0";
                    cdys[k] = "0";
                }
            } else {
                if ((k + 1) > month) {
                    cdcs[k] = "";
                    cdys[k] = "";
                } else {
                    cdcs[k] = "0";
                    cdys[k] = "0";
                }
            }
        }
        for (Map<String, Object> re : relist) {
            String dayF = String.valueOf(re.get("dayF"));

            int xnum = 0;
            // 把日期或者月份前的0去除
            if ("0".equals(dayF.substring(0, 1))) {
                xnum = Integer.parseInt(dayF.substring(1, 2));
            } else {
                xnum = Integer.parseInt(dayF);
            }

            for (int xx : x) {
                if (xx == xnum) {
                    if (re.get("cdcs") == null) {
                        cdcs[xx - 1] = "0";
                    } else {
                        cdcs[xx - 1] = String.valueOf(re.get("cdcs"));
                    }

                    if (re.get("cdsr") == null) {
                        cdys[xx - 1] = "0";
                    } else {
                        cdys[xx - 1] = re.get("cdsr").toString();
                    }

                    break;
                }
            }
        }


        for (int k = 0; k < cdcsCar.length; k++) {
            if ("month".equals(type)) {
                if ((k + 1) > day) {
                    cdcsCar[k] = "";
                    cdysCar[k] = "";
                } else {
                    cdcsCar[k] = "0";
                    cdysCar[k] = "0";
                }
            } else {
                if ((k + 1) > month) {
                    cdcsCar[k] = "";
                    cdysCar[k] = "";
                } else {
                    cdcsCar[k] = "0";
                    cdysCar[k] = "0";
                }
            }
        }
        for (Map<String, Object> re : relist1) {
            String dayF = String.valueOf(re.get("dayF"));

            int xnum = 0;
            // 把日期或者月份前的0去除
            if ("0".equals(dayF.substring(0, 1))) {
                xnum = Integer.parseInt(dayF.substring(1, 2));
            } else {
                xnum = Integer.parseInt(dayF);
            }

            for (int xx : x) {
                if (xx == xnum) {
                    if (re.get("cdcs") == null) {
                        cdcsCar[xx - 1] = "0";
                    } else {
                        cdcsCar[xx - 1] = String.valueOf(re.get("cdcs"));
                    }

                    if (re.get("cdsr") == null) {
                        cdysCar[xx - 1] = "0";
                    } else {
                        cdysCar[xx - 1] = re.get("cdsr").toString();
                    }

                    break;
                }
            }
        }

        reM.put("cdcs", cdcs);
        reM.put("cdys", cdys);
        reM.put("cdcsCar", cdcsCar);
        reM.put("cdysCar", cdysCar);
        return reM;
    }

    @Override
    public List<Map<String, Object>> getJkInfo(Map<String, Object> m) {
        return ebikeMainDao.getJkInfo(m);
    }

    @Override
    public Map<String, Object> getDevInfo(Map<String, Object> m) {
        return ebikeMainDao.getDevInfo(m);
    }

    @Override
    public List<Map<String, Object>> getPlugInfo(Map<String, Object> m) {
        return ebikeMainDao.getPlugInfo(m);
    }

    @Override
    public List<Map<String, String>> getDqcdzList(Map<String, Object> m) {
        return ebikeMainDao.getDqcdzList(m);
    }


    /**
     * @Description: 以下是新增的代码
     * @Param: [param]
     * @returns: java.util.List<java.util.Map < java.lang.String, java.lang.Object>>
     * @Author: 杨德志
     * @Date: 2020/7/1 16:16
     */

    @Override
    public Map<String, String> getChargingRevenue(Map<String, Object> param) {
        Map<String, String> re = Maps.newHashMap();
        List<Map<String, String>> zblist = ebikeMainDao.getChargingRevenue(param);
        if (zblist.size() != 0) {
            for (Map<String, String> zb : zblist) {
                re.put(zb.get("code"), zb.get("codeValue"));
            }
        }
        return re;
    }

    //设备异常等数量
    @Override
    public List<ModalVo> getDeviceAbnormal(Map<String, Object> param) {

        return ebikeMainDao.getDeviceAbnormal(param);
    }


    //负荷特性的曲线 日月年
    @Override
    public List<StatPowerOrgDayVo> getPowerOrgDay(Map<String, Object> param) {
        return ebikeMainDao.getPowerOrgDay(param);
    }

    @Override
    public List<StatPowerOrgMonthVo> getPowerOrgMonth(Map<String, Object> param) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        //表示你需要减少的年数
        Date y = c.getTime();
        String dataTime = format.format(y);
        return ebikeMainDao.getPowerOrgMonth(dataTime, (String) param.get("orgNo"));
    }

    @Override
    public List<StatPowerOrgYear> getPowerOrg(Map<String, Object> param) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        //表示你需要减少的年数
        Date y = c.getTime();
        String dataTime = format.format(y);
        return ebikeMainDao.getPowerOrg(dataTime, (String) param.get("orgNo"));
    }

    @Override
    public List<StatPowerOrgDayVo> getPowerOrgDayVo(Map<String, Object> param) {
        return ebikeMainDao.getPowerOrgDayVo(param);
    }

    @Override
    public List<StatPowerOrgMonthVo> getPowerOrgMonthVo(Map<String, Object> param) {
        return ebikeMainDao.getPowerOrgMonthVo(param);
    }

    @Override
    public List<StatPowerOrgYear> getPowerOrgYear(Map<String, Object> param) {
        String dataTime = null;
        if (param.get("type").equals(1)) {
            //获取当年的年份
            Calendar date = Calendar.getInstance();
            dataTime = String.valueOf(date.get(Calendar.YEAR));
        } else {
            SimpleDateFormat format = new SimpleDateFormat("yyyy");
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            //表示你需要减少的年数
            c.add(Calendar.YEAR, -1);
            Date y = c.getTime();
            dataTime = format.format(y);
        }
        return ebikeMainDao.getPowerOrgYear(dataTime, (String) param.get("orgNo"));
    }

    @Override
    public Map<String, Object> getChargingPileInfo(String chargingPileNo) {
        Map<String, Object> result = Maps.newHashMap();
        EbikeMainChargingPileInfoVo chargingPileInfo = ebikeMainDao.getChargingPileInfo(chargingPileNo);

        if(ObjectUtil.isNotEmpty(chargingPileInfo)) {
            if (Objects.equals(chargingPileInfo.getPriceRateTypeNo(), 3)) {
                //自定义时间段
                List<String> timeList = Lists.newArrayList();
                // 计费参数
                JSONObject billingParamsJsonObject = JSONUtil.parseObj(chargingPileInfo.getBillingParams());
                //自定义时间段对应的电价值
                List<BigDecimal> priceDetailList = Lists.newArrayList();
                for (int i = 1; i <= 10; i++) {
                    String startIndex = String.format("%02d", i);
                    String endIndex = String.format("%02d", i + 1);
                    // 累加时段电价
                    BigDecimal priceRate = billingParamsJsonObject.getBigDecimal("price_rate" + startIndex);
                    if (ObjectUtil.isNotEmpty(priceRate)) {
                        priceDetailList.add(priceRate);
                    }
                    // 设置时间段
                    String startTime = billingParamsJsonObject.getStr("start_value_rate_period" + startIndex);
                    String endTime = billingParamsJsonObject.getStr("start_value_rate_period" + endIndex);
                    if (StringUtils.isNotBlank(endTime)) {
                        timeList.add(startTime + "-" + endTime);
                    } else {
                        timeList.add(startTime + "-23:59");
                        break;
                    }
                }
                chargingPileInfo.setTimeList(timeList);
                chargingPileInfo.setPriceRateList(priceDetailList);
            }
        }

        List<EbikeMainChargingPileInfoVo> chargingGunList = null;
        if (ObjectUtil.isNotEmpty(chargingPileInfo)) {
            chargingGunList = ebikeMainDao.getChargingGunList(chargingPileInfo.getChargingPileId());
        }
        result.put("chargingPileInfo", chargingPileInfo);
        result.put("chargingGunList", chargingGunList);
        return result;
    }
}
