package com.ebike.openservices.oprmgmt.service.impl;

import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.jdbcdao.ChargeTrendDao;
import com.ebike.openservices.oprmgmt.jdbcdao.InShareDao;
import com.ebike.openservices.oprmgmt.service.InShareService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;



@Service
public class InShareServiceImpl extends AbstractEbikeBaseService implements InShareService {

    private final InShareDao shareDao;

    @Autowired
    public InShareServiceImpl(InShareDao shareDao) {
        this.shareDao = shareDao;
    }


	@Override
    public List<Map<String,Object>> partnerQuery(String stationId)
    {
	   return shareDao.partnerQuery(stationId);
    }
    @Override
    public List<Map<String,Object>> incomeStation(String subburo,Map<String,String> map)
    {
  	  return shareDao.incomeStation(subburo, map);
    }
    @Override
    public int queryIncomeCount(String subburo,Map<String,String> map)
    {
  	  return shareDao.queryIncomeCount(subburo, map);
    }

    @Override
    public int queryIncomeCountForCar(String subburo, Map<String, String> map) {
        return shareDao.queryIncomeCountForCar(subburo,map);
    }

    @Override
    public String checkYysExist(String orgoprType,String orgoprName,String orgoprCredNo)
    {
    	 return shareDao.checkYysExist(orgoprType,orgoprName,orgoprCredNo);
    }
    @Override
    public int checkSameName(String stationId,String stakeholderOrgNo)
    {
    	return shareDao.checkSameName(stationId,stakeholderOrgNo);
    }
    @Override
    public int profitAdd(Map<String,String> map)
    {
    	return shareDao.profitAdd(map);
    }
    @Override
    public Map<String,Object> checkIncome(String stationId)
    {
    	return shareDao.checkIncome(stationId);
    }
    @Override
    public Map<String,Object> checkCost(String stationId)
    {
    	return shareDao.checkCost(stationId);
    }
    @Override
    public int profitModify(Map<String,String> map)
    {
    	return shareDao.profitModify(map);
    }
    @Override
    public boolean stopProfit(Map<String,String> map)
    {
    	return shareDao.stopProfit(map);
    }
    @Override
    public List<Map<String,Object>> queryOperationInfo(String csshDistSchemeId)
    {
  	  return shareDao.queryOperationInfo(csshDistSchemeId);
    }
    @Override
    public int operationCount(String csshDistSchemeId)
    {
  	  return shareDao.operationCount(csshDistSchemeId);
    }
    @Override
    public List<Map<String,Object>> queryIShareStation(String subburo,Map<String,String> map)
    {
  	  return shareDao.queryIShareStation(subburo, map);
    }
    @Override
    public int queryPrifitCount(String subburo,Map<String,String> map)
    {
  	  return shareDao.queryPrifitCount(subburo, map);
    }

    @Override
    public int queryPrifitCountForCar(String subburo, Map<String, String> map) {
        return shareDao.queryPrifitCountForCar(subburo,map);
    }

    @Override
    public boolean incomeOp(Map<String,String> map)
    {
    	return shareDao.incomeOp(map);
    }
}
