package com.ebike.openservices.oprmgmt.service.impl;

import com.ebike.openservices.base.service.AbstractEbikeBaseService;
import com.ebike.openservices.oprmgmt.entity.EbikeOrgopr;
import com.ebike.openservices.oprmgmt.entity.EbikeOrgoprVo;
import com.ebike.openservices.oprmgmt.entity.ModalVo;
import com.ebike.openservices.oprmgmt.service.OperatorsAndMerchantsService;
import org.springframework.stereotype.Service;
import com.ebike.openservices.oprmgmt.dao.OperatorsAndMerchantsDao;
import javax.annotation.Resource;
import java.util.List;

@Service
public class OperatorsAndMerchantsImpl extends AbstractEbikeBaseService implements OperatorsAndMerchantsService {
    @Resource
    private OperatorsAndMerchantsDao dao;


    @Override
    public List<EbikeOrgoprVo> findList(EbikeOrgoprVo ebikeOrgoprVo) {
        return dao.findList(ebikeOrgoprVo);
    }

    @Override
    public Integer editList(EbikeOrgoprVo ebikeOrgoprVo) {
        return dao.editList(ebikeOrgoprVo);
    }

    @Override
    public Integer delList(String[] ids) {
        return dao.delList(ids);
    }

    @Override
    public List<EbikeOrgoprVo> findCommOperator(Integer type) {
        return dao.findCommOperator(type);
    }

    @Override
    public Integer editCssrConfig(EbikeOrgopr ebikeOrgopr) {
        return dao.editCssrConfig(ebikeOrgopr);
    }

    @Override
    public List<EbikeOrgopr> findEbikeOrgopr(String orgNo) {
        return dao.findEbikoeOrgopr(orgNo);
    }

    @Override
    public Integer editEbikeOrgopr(EbikeOrgopr ebikeOrgopr) {
            dao.editEbikeOrg(ebikeOrgopr);
        return dao.editEbikeOrgopr(ebikeOrgopr);
    }
}
