package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.easesource.data.bean.Sorter;
import com.ebike.openservices.oprmgmt.dao.EbikeChargeDeviceExtparamDao;
import com.ebike.openservices.oprmgmt.dao.PanelLightControlDao;
import com.ebike.openservices.oprmgmt.entity.EbikeChargeDeviceExtparamDo;
import com.ebike.openservices.oprmgmt.entity.PanelLightControlVo;
import com.ebike.openservices.oprmgmt.request.PanelLightUpdateDateByIdRequest;
import com.ebike.openservices.oprmgmt.service.PanelLightControlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class PanelLightControlServiceImpl implements PanelLightControlService {
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final PanelLightControlDao panelLightControlDao;
    private final EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao;

    public PanelLightControlServiceImpl(PanelLightControlDao panelLightControlDao, EbikeChargeDeviceExtparamDao ebikeChargeDeviceExtparamDao) {
        this.panelLightControlDao = panelLightControlDao;
        this.ebikeChargeDeviceExtparamDao = ebikeChargeDeviceExtparamDao;
    }

    @Override
    public List<PanelLightControlVo> getPanelLightControlList(Map params, Sorter sorter, Pager pager) {
        if(logger.isDebugEnabled()) {
            logger.debug("params00P : " + params);
        }
        return panelLightControlDao.getList(params,sorter,pager);
    }

    @Override
    public int getPanelLightControlCount(Map params) {
        if(logger.isDebugEnabled()) {
            logger.debug("params01P : " + params);
        }
        return panelLightControlDao.getCount(params);
    }

    @Override
    public List<Map<String, Object>> getProvinceList() {
        return panelLightControlDao.getProvinceList();
    }

    @Override
    public List<Map<String, Object>> getCityList(String level, String parentid) {
        return panelLightControlDao.getCityList(level, parentid);
    }

    @Override
    public List<Map<String, Object>> getDistrictList(String level, String parentid) {
        return panelLightControlDao.getDistrictList(level, parentid);
    }

    @Override
    public int updateDateById(List<PanelLightUpdateDateByIdRequest> dateByIdRequestList) {
        int result = 0;
        for(PanelLightUpdateDateByIdRequest dateByIdRequest : dateByIdRequestList) {
            Long chargedeviceId = Long.parseLong(dateByIdRequest.getChargedeviceId());
            EbikeChargeDeviceExtparamDo ebikeChargeDeviceExtparamDo = ebikeChargeDeviceExtparamDao.get(chargedeviceId);
            if(ebikeChargeDeviceExtparamDo != null && ebikeChargeDeviceExtparamDo.getChargedeviceId() > 0L) {
                //更新
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setLampOpenTimemark(dateByIdRequest.getLampOpenTimemark());
                ebikeChargeDeviceExtparamDo.setLampCloseTimemark(dateByIdRequest.getLampCloseTimemark());
                ebikeChargeDeviceExtparamDao.update(ebikeChargeDeviceExtparamDo);
            }else {
                //新增
                ebikeChargeDeviceExtparamDo = new EbikeChargeDeviceExtparamDo();
                ebikeChargeDeviceExtparamDo.setChargedeviceId(chargedeviceId);
                ebikeChargeDeviceExtparamDo.setLampOpenTimemark(dateByIdRequest.getLampOpenTimemark());
                ebikeChargeDeviceExtparamDo.setLampCloseTimemark(dateByIdRequest.getLampCloseTimemark());
                ebikeChargeDeviceExtparamDo.setEmerStatus("00");
                ebikeChargeDeviceExtparamDo.setLampStatus("00");
                ebikeChargeDeviceExtparamDao.insert(ebikeChargeDeviceExtparamDo);
            }
            if(logger.isDebugEnabled()) {
                logger.debug("ebikeChargeDeviceExtparamDo : " + ebikeChargeDeviceExtparamDo);
                logger.debug("result : " + result);
            }
        }
        return result;
    }
}
