package com.ebike.openservices.oprmgmt.service.impl;

import com.ebike.openservices.oprmgmt.dao.PowerChargeDao;
import com.ebike.openservices.oprmgmt.request.PowerChargeListParam;
import com.ebike.openservices.oprmgmt.request.PowerChargeStatRequest;
import com.ebike.openservices.oprmgmt.response.PowerChargeResponse;
import com.ebike.openservices.oprmgmt.response.PowerChargeStatResponse;
import com.ebike.openservices.oprmgmt.service.PowerChargeService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author wuyuxuan
 * @version 1.0.0
 * @since 2021/8/3
 */
@Service
public class PowerChargeServiceImpl implements PowerChargeService {

    @Resource
    private PowerChargeDao powerChargeDao;

    @Override
    public List<PowerChargeResponse> listStation(PowerChargeListParam param, Boolean isPage) {
        return powerChargeDao.listStation(param, isPage);
    }

    @Override
    public long listStationTotal(PowerChargeListParam param) {
        return powerChargeDao.listStationTotal(param);
    }

    @Override
    public PowerChargeStatResponse getPowerChargeStat(PowerChargeStatRequest param) {
        return powerChargeDao.getPowerChargeStat(param);
    }

    @Override
    public List<String> listChargeEconsDetailByStationId(Long stationId) {
        return powerChargeDao.listChargeEconsDetailByStationId(stationId);
    }
}
