package com.ebike.openservices.oprmgmt.service.impl;

import com.easesource.data.bean.Pager;
import com.ebike.openservices.oprmgmt.dao.PowerStationDao;
import com.ebike.openservices.oprmgmt.entity.vo.*;
import com.ebike.openservices.oprmgmt.request.PowerStationRequestParam;
import com.ebike.openservices.oprmgmt.service.PowerStationService;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/**
 * @param
 * @ClassName PowerStationServiceImpl
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/4/15 19:03
 * @Version 1.0
 **/
@Service
public class PowerStationServiceImpl implements PowerStationService {


    private static final org.slf4j.Logger LOGGER= LoggerFactory.getLogger(PowerStationServiceImpl.class);

    @Resource
    private PowerStationDao powerStationDao;
    /**
     * 功能描述  电站信息列表查询
     * @author zhouyi
     * @return java.util.Map<java.lang.String,java.lang.Object>
     * @data 2021/4/15
     * @param param
     */
    @Override
    public Map<String, Object> getPowerStation(PowerStationRequestParam param) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("电站信息列表查询请求参数：{}", param);
        }
        Pager pager = new Pager();
        /**
         * 修改：liumu
         * 时间：2021-07-27
         * 修改点：1.给当前页赋默认值，避免空指针异常；2.修改页数据条数固定值为前端可传参，service对应更新；
         */
        //当前页
        Integer current = (param.getCurrent() == null) ? 1 : param.getCurrent();
        pager.setPageNumber(current);
        //页数据条数
        Integer pageSize = (param.getPageSize() == null) ? 10 : param.getPageSize();
        pager.setPageSize(pageSize);
        List<PowerStationVo> list = powerStationDao.getPowerStation(param, pager);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                list.get(i).setType(1);
                List<ChargingPileVo> chargPiles = list.get(i).getChargingPileVos();
                if (chargPiles.size() > 0) {
                    for (int j = 0; j < chargPiles.size(); j++) {
                        chargPiles.get(j).setType(2);
                    }
                }
                Integer chargingPileNum = powerStationDao.getChargingPileTotal(list.get(i).getId());
                list.get(i).setChargingNum(chargingPileNum);
            }
        }
        //数据总数
        Integer total = powerStationDao.getPowerStationTotal(param);
        Map<String, Object> map = new HashMap<>();
        map.put("list", list);
        map.put("total", total);
        return map;
    }

    /**
     * 功能描述  充电站统一视图——基本信息
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationEssentialInformationVo
     * @data 2021/4/16
     * @param id
     */
    @Override
    public Map<String,Object> getPowerStationEssentialInformation(Long id,Integer current) {
        Pager pager = new Pager();
        pager.setPageNumber(current);
        pager.setPageSize(10);
        List<PowerStationEssentialInformationVo> essentialInformationVos=powerStationDao.getPowerStationEssentialInformation(id,pager);
        Integer total=powerStationDao.getPowerStationEssentialInformationToTal(id);
        Map<String,Object> map=new HashMap<>(2);
        map.put("essentialInformationVos",essentialInformationVos);
        map.put("total",total);
        return map;
    }

    /**
     * 功能描述  充电站统一视图——收益分配
     * @author zhouyi
     * @return com.ebike.openservices.oprmgmt.entity.vo.PowerStationIncomeDistributionVo
     * @data 2021/4/16
     * @param id
     */
    @Override
    public Map<String,Object> getPowerStationIncomeDistribution(Long id,Integer current) {
        Pager pager = new Pager();
        pager.setPageNumber(current);
        pager.setPageSize(10);
        List<PowerStationIncomeDistributionVo> distributionVos= powerStationDao.getPowerStationIncomeDistribution(id,pager);
        Integer total=powerStationDao.getPowerStationIncomeDistributionTotal(id);
        Map<String,Object> map=new HashMap<>(2);
        if(null==distributionVos){
            map.put("msg","暂无信息");
        }else {
            map.put("distributionVos", distributionVos);
            map.put("total", total);
        }
        return map;
    }

    /**
     * 功能描述 充电站统一视图——电桩详情
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingPileInformationVo>
     * @data 2021/4/22
     * @param id
     */
    @Override
    public List<ChargingPileInformationVo> getChargingPileInformation(Long id) {
        return powerStationDao.getChargingPileInformation(id);
    }

    /**
     * 功能描述 充电站统一视图——电枪列表
     * @author zhouyi
     * @return java.util.List<com.ebike.openservices.oprmgmt.entity.vo.ChargingGunInformationVo>
     * @data 2021/4/22
     * @param id
     */
    @Override
    public List<ChargingGunInformationVo> getChargingGunInformation(Long id) {
        return powerStationDao.getChargingGunInformation(id);
    }
}
